/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="UserController")
@RestController
@RequestMapping(value={"/v1/nebula/users"})
public class UserController
extends BaseController {
    @Autowired
    private UserService userService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserController.class);

    @ApiOperation(value="\u6dfb\u52a0\u4e00\u4e2a\u65b0\u7684\u7528\u6237\u4fe1\u606f\uff08\u540e\u53f0\u7ba1\u7406\u4eba\u5458\uff0c\u4e1a\u52a1\u529f\u80fd\u64cd\u4f5c\u8005\uff09", notes="")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@ApiParam(name="user", value="\u7528\u6237\u5bf9\u8c61\u4fe1\u606f", required=true) @RequestBody UserVo user) {
        try {
            UserVo currentPoliceMan = this.userService.create(user);
            return this.buildHttpResultW(currentPoliceMan, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u4e00\u4e2a\u5df2\u7ecf\u5b58\u5728\u7684\u7528\u6237\u4fe1\u606f", notes="\u53ef\u4ee5\u4fee\u6539\u7684\u5305\u62ec\u5c5e\u6027\u6709\uff1a<br>\u7528\u6237\u59d3\u540d\u3001\u6027\u522b.0\u4fdd\u5bc6\uff0c1\u7537  2\u5973 \u4fe1\u606f")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel update(@ApiParam(name="user", value="\u4ee5\u5bf9\u8c61\u65b9\u5f0f\u4f20\u5165\u7684\u9700\u8981\u4fee\u6539\u7684\u5c5e\u6027\uff0c\u4e0d\u80fd\u4fee\u6539\u7684\u5c5e\u6027\u5373\u4f7f\u4f20\u5165\u8be5\u5c5e\u6027\u4e5f\u4e0d\u4f1a\u53d1\u751f\u53d8\u5316", required=true) @RequestBody UserVo user) {
        try {
            UserVo currentUser = this.userService.update(user);
            return this.buildHttpResultW(currentUser, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u91cd\u7f6e\u6307\u5b9a\u7528\u6237\u7684\u5bc6\u7801\u4fe1\u606f")
    @RequestMapping(value={"/updatePassword"}, method={RequestMethod.PATCH})
    public ResponseModel updatePassword(@ApiParam(name="userId", value="\u6307\u5b9a\u7684\u7528\u6237", required=true) String userId, @ApiParam(name="oldPassword", value="\u539f\u59cb\u5bc6\u7801\uff08\u6ca1\u6709\u52a0\u5bc6\u7684\uff09", required=true) String oldPassword, @ApiParam(name="newPassword", value="\u65b0\u7684\u5bc6\u7801\uff08\u6ca1\u6709\u52a0\u5bc6\u7684\uff09", required=true) String newPassword) {
        try {
            UserVo currentUser = this.userService.updatePassword(userId, newPassword, oldPassword);
            return this.buildHttpResultW(currentUser, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u91cd\u7f6e\u6307\u5b9a\u7528\u6237\u7684\u5bc6\u7801\u4fe1\u606f\uff08\u5ffd\u7565\u539f\u59cb\u5bc6\u7801\uff0c\u8be5\u65b9\u6cd5\u4e00\u822c\u7531\u7ba1\u7406\u5458\u4f7f\u7528\uff09")
    @RequestMapping(value={"/updatePasswordIgnoreOld"}, method={RequestMethod.PATCH})
    public ResponseModel updatePasswordIgnoreOld(@ApiParam(name="userId", value="\u6307\u5b9a\u7684\u7528\u6237", required=true) String userId, @ApiParam(name="newPassword", value="\u65b0\u7684\u5bc6\u7801\uff08\u6ca1\u6709\u52a0\u5bc6\u7684\uff09", required=true) String newPassword) {
        try {
            UserVo currentUser = this.userService.updatePassword(userId, newPassword);
            return this.buildHttpResultW(currentUser, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6307\u5b9a\u7684\u7528\u6237\u4fe1\u606f\u7684\u72b6\u6001\uff0c\u5305\u62ec\u53ef\u7528\u72b6\u6001\u548c\u4e0d\u53ef\u7528\u72b6\u6001")
    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.PATCH})
    public ResponseModel updateStatus(@ApiParam(name="account", value="\u6307\u5b9a\u7684\u65b0\u7684\u7528\u6237\u8d26\u53f7", required=true) String account, @ApiParam(name="flag", value="\u6307\u5b9a\u7684\u65b0\u7684\u72b6\u6001", required=true) boolean flag) {
        try {
            if (flag) {
                this.userService.enabled(account);
            } else {
                this.userService.disable(account);
            }
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u4e14\u5305\u62ec\u5f53\u524d\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\uff08\u5305\u62ec\u95f4\u63a5\u7ed1\u5b9a\uff09\u7684\u89d2\u8272\u4fe1\u606f\u3001\u7528\u6237\u7ec4\u3001\u7ec4\u7ec7\u673a\u6784\u548c\u5c97\u4f4d")
    @RequestMapping(value={"/{userId}"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@ApiParam(name="userId", value="\u6307\u5b9a\u7684\u7528\u6237\u7f16\u53f7", required=true) @PathVariable(value="userId") String userId) {
        try {
            UserVo currentUser = this.userService.findDetailsById(userId);
            return this.buildHttpResultW(currentUser, "roles", "positions", "groups", "orgs");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u4fe1\u606f(\u6309\u7167\u7528\u6237\u8d26\u53f7\u67e5\u8be2)\uff0c\u4e0d\u5305\u62ec\u5f53\u524d\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\uff08\u5305\u62ec\u95f4\u63a5\u7ed1\u5b9a\uff09\u7684\u89d2\u8272\u4fe1\u606f\u3001\u7528\u6237\u7ec4\u3001\u7ec4\u7ec7\u673a\u6784\u548c\u5c97\u4f4d")
    @RequestMapping(value={"/findByAccount"}, method={RequestMethod.GET})
    public ResponseModel findByAccount(@ApiParam(name="account", value="\u6307\u5b9a\u7684\u7528\u6237\u8d26\u6237\uff08\u80af\u5b9a\u662f\u552f\u4e00\u7684\uff09") @RequestParam(value="account") String account) {
        try {
            UserVo currentUser = this.userService.findByAccount(account);
            return this.buildHttpResultW(currentUser, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u5df2\u767b\u5f55\u7684\u64cd\u4f5c\u8005\u4fe1\u606f(\u6309\u7167\u7528\u6237\u8d26\u53f7\u67e5\u8be2)\uff0c\u4e0d\u5305\u62ec\u5f53\u524d\u64cd\u4f5c\u8005\u5df2\u7ecf\u7ed1\u5b9a\uff08\u5305\u62ec\u95f4\u63a5\u7ed1\u5b9a\uff09\u7684\u89d2\u8272\u4fe1\u606f\u3001\u7528\u6237\u7ec4\u3001\u7ec4\u7ec7\u673a\u6784\u548c\u5c97\u4f4d")
    @RequestMapping(value={"/findByPrincipal"}, method={RequestMethod.GET})
    public ResponseModel findByPrincipal() {
        try {
            Principal op = this.getPrincipal();
            UserVo currentUser = this.userService.findByAccount(op.getName());
            return this.buildHttpResultW(currentUser, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u9884\u5236\u63a7\u4ef6\u67e5\u8be2\uff0c\u6682\u65f6\u67e5\u8be2\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u57fa\u7840\u4fe1\u606f")
    @RequestMapping(value={"/findByUserId"}, method={RequestMethod.GET})
    public ResponseModel findByUserId(@ApiParam(name="userId", value="\u6307\u5b9a\u7684\u7528\u6237id\u4fe1\u606f") @RequestParam(value="userId") String userId) {
        try {
            UserVo creator = this.userService.findByUserId(userId);
            return this.buildHttpResultW(creator, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6761\u4ef6\u641c\u7d22\u7528\u6237\uff0c\u4e0d\u652f\u6301\u6a21\u7cca\u67e5\u8be2")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@ApiParam(name="userName", value="\u7528\u6237\u59d3\u540d") String userName, @ApiParam(name="account", value="\u7528\u6237\u8d26\u6237") String account, @ApiParam(name="useStatus", value="\u7528\u6237\u72b6\u6001") Integer useStatus, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page page = this.userService.findByConditions(userName, account, useStatus, pageable);
            return this.buildHttpResultW(page, "roles");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u591a\u4e2a\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/findByIds"}, method={RequestMethod.POST})
    public ResponseModel findByIds(@RequestBody List<String> ids) {
        try {
            Set users = this.userService.findByIds(ids);
            return this.buildHttpResultW(users, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

