/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.rbac.server.service.UserGroupService;
import com.bizunited.platform.rbac.server.vo.UserGroupVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="UserGroupController")
@RestController
@RequestMapping(value={"/v1/nebula/userGroups"})
public class UserGroupController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserGroupController.class);
    @Autowired
    private UserGroupService userGroupService;

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u7528\u6237\u7ec4\u540d\u79f0\u3001\u72b6\u6001\u67e5\u8be2")
    @RequestMapping(value={"/findByCondition"}, method={RequestMethod.GET})
    public ResponseModel findByCondition(@ApiParam(name="groupName", value="\u53ef\u80fd\u7684\u7528\u6237\u7ec4\u540d\u79f0\u67e5\u8be2\u6761\u4ef6", required=false) @RequestParam(required=false, name="groupName") String groupName, @ApiParam(name="status", value="\u53ef\u80fd\u7684\u7528\u6237\u7ec4\u72b6\u6001\u67e5\u8be2\u6761\u4ef6", required=false) @RequestParam(required=false, name="status") Integer status, @ApiParam(name="pageable", value="\u5206\u9875\u53c2\u6570\uff0c\u5f53\u6307\u5b9apage\u65f6\u4e3a\u67e5\u8be2\u5f53\u524d\u9875\u7801\uff08\u9875\u7801\u4ece0\u5f00\u59cb\uff09\uff1b\u5f53\u6307\u5b9asize\u65f6\uff0c\u4e3a\u6307\u5b9a\u6bcf\u9875\u5927\u5c0f\uff0c\u9ed8\u8ba4\u4e3a50") @PageableDefault(value=50) Pageable pageable) {
        try {
            Page userGroup = this.userGroupService.findByCondition(groupName, status, pageable);
            return this.buildHttpResultW(userGroup, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u65b0\u589e\u7528\u6237\u7ec4")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@ApiParam(name="userGroup") @RequestBody UserGroupVo userGroup) {
        try {
            UserGroupVo group = this.userGroupService.create(userGroup);
            return this.buildHttpResultW(group, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u7ec4", notes="\u53ea\u80fd\u4fee\u6539\u7528\u6237\u7ec4\u63cf\u8ff0")
    @RequestMapping(value={"/update"}, method={RequestMethod.PATCH})
    public ResponseModel update(@ApiParam(name="\u7528\u6237\u7ec4\u76f8\u5173\u4fe1\u606f") @RequestBody UserGroupVo userGroupVo) {
        try {
            UserGroupVo userGroup = this.userGroupService.update(userGroupVo);
            return this.buildHttpResultW(userGroup, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u7ec4\u72b6\u6001")
    @RequestMapping(value={"/updateStatus/{groupId}"}, method={RequestMethod.PATCH})
    public ResponseModel updateStatus(@PathVariable(value="groupId") String groupId) {
        try {
            UserGroupVo userGroup = this.userGroupService.updateStatus(groupId);
            return this.buildHttpResultW(userGroup, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7528\u6237\u4e0e\u7528\u6237\u7ec4\u7ed1\u5b9a", notes="\u53ef\u4ee5\u7ed1\u5b9a\u591a\u4e2a\u7528\u6237id\uff0c\u4e0d\u8fc7\u53ea\u8981\u6709\u4e00\u4e2a\u7528\u6237id\u7ed1\u5b9a\u9519\u8bef\uff0c\u5219\u6574\u4e2a\u7ed1\u5b9a\u8fc7\u7a0b\u5931\u8d25")
    @RequestMapping(value={"/bindUser"}, method={RequestMethod.PATCH})
    public ResponseModel bindUser(@ApiParam(name="groupId", value="\u7528\u6237\u7ec4id") @RequestParam(value="groupId") String groupId, @ApiParam(name="userIds", value="\u7528\u6237id(\u53ef\u4ee5\u662f\u591a\u4e2a)") @RequestParam(value="userIds") String[] userIds) {
        try {
            this.userGroupService.bindUser(groupId, userIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7528\u6237\u4e0e\u7528\u6237\u7ec4\u89e3\u9664\u7ed1\u5b9a", notes="\u53ef\u4ee5\u89e3\u7ed1\u591a\u4e2a\u7528\u6237id\uff0c\u4e0d\u8fc7\u53ea\u8981\u6709\u4e00\u4e2a\u7528\u6237id\u7ed1\u5b9a\u9519\u8bef\uff0c\u5219\u6574\u4e2a\u7ed1\u5b9a\u8fc7\u7a0b\u5931\u8d25")
    @RequestMapping(value={"/unBindUser"}, method={RequestMethod.PATCH})
    public ResponseModel unBindUser(@ApiParam(name="groupId", value="\u7528\u6237\u7ec4id") @RequestParam(value="groupId") String groupId, @ApiParam(name="userIds", value="\u7528\u6237id") @RequestParam(value="userIds") String[] userIds) {
        try {
            this.userGroupService.unBindUser(groupId, userIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7528\u6237\u7ec4\u4e0e\u89d2\u8272\u7ed1\u5b9a", notes="\u53ef\u4ee5\u7ed1\u5b9a\u591a\u4e2a\u89d2\u8272id\uff0c\u4e0d\u8fc7\u53ea\u8981\u6709\u4e00\u4e2a\u89d2\u8272id\u7ed1\u5b9a\u9519\u8bef\uff0c\u5219\u6574\u4e2a\u7ed1\u5b9a\u8fc7\u7a0b\u5931\u8d25")
    @RequestMapping(value={"/bindRole"}, method={RequestMethod.PATCH})
    public ResponseModel bindRole(@ApiParam(name="groupId", value="\u7528\u6237\u7ec4id") @RequestParam(value="groupId") String groupId, @ApiParam(name="roleIds", value="\u89d2\u8272id") @RequestParam(value="roleIds") String[] roleIds) {
        try {
            this.userGroupService.bindRole(groupId, roleIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7528\u6237\u7ec4\u4e0e\u89d2\u8272\u89e3\u9664\u7ed1\u5b9a", notes="\u53ef\u4ee5\u89e3\u7ed1\u591a\u4e2a\u89d2\u8272id\uff0c\u4e0d\u8fc7\u53ea\u8981\u6709\u4e00\u4e2a\u89d2\u8272id\u89e3\u7ed1\u9519\u8bef\uff0c\u5219\u6574\u4e2a\u7ed1\u5b9a\u8fc7\u7a0b\u5931\u8d25")
    @RequestMapping(value={"/unBindRole"}, method={RequestMethod.PATCH})
    public ResponseModel unBindRole(@ApiParam(name="groupId", value="\u7528\u6237\u7ec4id") @RequestParam(value="groupId") String groupId, @ApiParam(name="roleIds", value="\u89d2\u8272id") @RequestParam(value="roleIds") String[] roleIds) {
        try {
            this.userGroupService.unBindRole(groupId, roleIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u7528\u6237\u7ec4\u7684\u57fa\u672c\u8be6\u60c5")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@ApiParam(name="id", value="\u7528\u6237\u7ec4id") @RequestParam(value="id") String id) {
        LOGGER.debug("\u7528\u6237\u7ec4:{}", (Object)id);
        try {
            Set userGroupDetail = this.userGroupService.findDetailsById(id);
            return this.buildHttpResultW(userGroupDetail, new String[]{"users", "roles"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u591a\u4e2a\u7528\u6237\u7ec4\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"/findByIds"}, method={RequestMethod.POST})
    public ResponseModel findByIds(@RequestBody List<String> ids) {
        LOGGER.debug("\u7528\u6237\u7ec4:{}", ids);
        try {
            Set userGroups = this.userGroupService.findByIds(ids);
            return this.buildHttpResultW(userGroups, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

