/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller.dataview;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.invoke.model.InvokeOperations;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import com.bizunited.platform.core.vo.dataview.DataviewExportExcelFieldVo;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/dataViews"})
public class DataViewController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewController.class);
    private static final Integer TIME_OUT = 10;
    private static final String PAGE_PARAM_NAME = "page";
    private static final String VIEW_PARAM_NAME = "dataView";
    private static final String INPUT_PARAM_NAME = "inputParams";
    private static final String KUIPER_PARAM_NAME = "kuiperInvokeParams";
    private static final String DATASOURCE_PARAM_NAME = "dataSource";
    private static final String GROUP_PARAM_NAME = "dataViewGroup";
    private static final String FIELDS_PARAM_NAME = "fields";
    private static final String FILTERS_PARAM_NAME = "filters";
    private static final String SYSTEM_PARAM_NAME = "systemFilters";
    private static final String[] FIELD_FILTERS = new String[]{"dataSource", "dataViewGroup", "fields", "filters", "systemFilters"};
    private static final String[] FIELD_FILTERS_F = new String[]{"dataSource", "dataViewGroup", "fields", "filters", "filters.field", "systemFilters"};
    @Autowired
    private DataViewService dataViewEntityService;

    @ApiOperation(value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efadataViewEntity\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9dataViewEntity\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684dataViewEntityJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09")
    @PostMapping(value={""})
    public ResponseModel create(@RequestBody @ApiParam(name="dataViewEntity", value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efadataViewEntity\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9dataViewEntity\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684dataViewEntityJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09") DataViewEntity dataViewEntity) {
        try {
            DataViewEntity current = this.dataViewEntityService.create(dataViewEntity, false);
            return this.buildHttpResultW(current, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u66f4\u65b0\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u66f4\u65b0\u8fc7\u7a0b\u53ea\u4f1a\u66f4\u65b0\u5728\u6a21\u578b\u5c42\u88ab\u6807\u8bb0\u4e3a\u4e86updateable\u7684\u5c5e\u6027\uff0c\u5305\u62ec\u4e00\u822c\u5c5e\u6027\u3001ManyToOne\u548cOneToOne\u6027\u8d28\u7684\u5173\u8054\u5c5e\u6027\uff0c\u800cManyToMany\u3001OneToMany\u7684\u5173\u8054\u5c5e\u6027\uff0c\u867d\u7136\u4e5f\u4f1a\u4f20\u5165\uff0c\u4f46\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5728Service\u5c42\u5b8c\u5584\u5176\u66f4\u65b0\u8fc7\u7a0b\u6ce8\u610f\uff1a\u4fee\u6539\u64cd\u4f5c\u4f20\u5165\u7684dataViewEntityJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u9a8c\u8bc1\u8fd9\u4e2a\u4e3b\u952e\u503c\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09")
    @PatchMapping(value={""})
    public ResponseModel update(@RequestBody @ApiParam(name="dataViewEntity", value="\u76f8\u5173\u7684\u66f4\u65b0\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u66f4\u65b0\u8fc7\u7a0b\u53ea\u4f1a\u66f4\u65b0\u5728\u6a21\u578b\u5c42\u88ab\u6807\u8bb0\u4e3a\u4e86updateable\u7684\u5c5e\u6027\uff0c\u5305\u62ec\u4e00\u822c\u5c5e\u6027\u3001ManyToOne\u548cOneToOne\u6027\u8d28\u7684\u5173\u8054\u5c5e\u6027\uff0c\u800cManyToMany\u3001OneToMany\u7684\u5173\u8054\u5c5e\u6027\uff0c\u867d\u7136\u4e5f\u4f1a\u4f20\u5165\uff0c\u4f46\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5728Service\u5c42\u5b8c\u5584\u5176\u66f4\u65b0\u8fc7\u7a0b\u6ce8\u610f\uff1a\u4fee\u6539\u64cd\u4f5c\u4f20\u5165\u7684dataViewEntityJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u9a8c\u8bc1\u8fd9\u4e2a\u4e3b\u952e\u503c\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09") DataViewEntity dataViewEntity) {
        try {
            DataViewEntity current = this.dataViewEntityService.update(dataViewEntity);
            return this.buildHttpResultW(current, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6570\u636e\u6e90code\u67e5\u8be2DataViewEntity")
    @ApiImplicitParam(name="dataSourceCode", value="\u6309\u7167\u6570\u636e\u6e90ID\u67e5\u8be2DataViewEntity", required=true)
    @RequestMapping(value={"/findByDataSourceCode"}, method={RequestMethod.GET})
    public ResponseModel findByDataSourceCode(@RequestParam(required=false) @ApiParam(value="\u6570\u636e\u6e90code") String dataSourceCode) {
        try {
            JSONArray jsonArr = this.dataViewEntityService.findByDataSourceCode(dataSourceCode);
            return this.buildHttpResultW(jsonArr, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6570\u636e\u6e90ID\u67e5\u8be2DataViewEntity")
    @ApiImplicitParam(name="dataSourceId", value="\u6309\u7167\u6570\u636e\u6e90ID\u67e5\u8be2DataViewEntity", required=true)
    @RequestMapping(value={"/findByDataSource"}, method={RequestMethod.GET})
    public ResponseModel findByDataSource(@RequestParam(value="dataSourceId") @ApiParam(value="\u6570\u636e\u6e90ID") String dataSourceId) {
        try {
            List<DataViewEntity> result = this.dataViewEntityService.findByDataSource(dataSourceId);
            return this.buildHttpResultW(result, new String[]{DATASOURCE_PARAM_NAME});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6570\u636e\u5e93\u5206\u7ec4\u67e5\u8be2DataViewEntity")
    @ApiImplicitParam(name="dataViewGroupId", value="\u6309\u7167\u6570\u636e\u5e93\u5206\u7ec4\u67e5\u8be2DataViewEntity", required=true)
    @RequestMapping(value={"/findByDataViewGroup"}, method={RequestMethod.GET})
    public ResponseModel findByDataViewGroup(@RequestParam(value="dataViewGroupId") @ApiParam(value="\u6570\u636e\u5e93\u5206\u7ec4") String dataViewGroupId) {
        try {
            List<DataViewEntity> result = this.dataViewEntityService.findByDataViewGroup(dataViewGroupId);
            return this.buildHttpResultW(result, new String[]{GROUP_PARAM_NAME});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u7ed3\u6784\u5b57\u6bb5\u67e5\u8be2DataViewEntity")
    @ApiImplicitParam(name="filtersId", value="\u6309\u7167\u7ed3\u6784\u5b57\u6bb5\u67e5\u8be2DataViewEntity", required=true)
    @RequestMapping(value={"/findByFields"}, method={RequestMethod.GET})
    public ResponseModel findByFields(@RequestParam(value="fieldsId") @ApiParam(value="\u7ed3\u6784\u5b57\u6bb5") String fieldsId) {
        try {
            DataViewEntity result = this.dataViewEntityService.findByFields(fieldsId);
            return this.buildHttpResultW(result, FIELDS_PARAM_NAME);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u8fc7\u6ee4\u7b5b\u9009\u5b57\u6bb5\u67e5\u8be2DataViewEntity")
    @ApiImplicitParam(name="filtersId", value="\u6309\u7167\u8fc7\u6ee4\u7b5b\u9009\u5b57\u6bb5\u67e5\u8be2DataViewEntity", required=true)
    @RequestMapping(value={"/findByFilters"}, method={RequestMethod.GET})
    public ResponseModel findByFilters(@RequestParam(value="filtersId") @ApiParam(value="\u8fc7\u6ee4\u7b5b\u9009\u5b57\u6bb5") String filtersId) {
        try {
            DataViewEntity result = this.dataViewEntityService.findByFilters(filtersId);
            return this.buildHttpResultW(result, FILTERS_PARAM_NAME);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u7cfb\u7edf\u67e5\u8be2\u5b57\u6bb5\u67e5\u8be2DataViewEntity")
    @ApiImplicitParam(name="systemFiltersId", value="\u6309\u7167\u7cfb\u7edf\u67e5\u8be2\u5b57\u6bb5\u67e5\u8be2DataViewEntity", required=true)
    @RequestMapping(value={"/findBySystemFilters"}, method={RequestMethod.GET})
    public ResponseModel findBySystemFilters(@RequestParam(value="systemFiltersId") @ApiParam(value="\u7cfb\u7edf\u67e5\u8be2\u5b57\u6bb5") String systemFiltersId) {
        try {
            DataViewEntity result = this.dataViewEntityService.findBySystemFilters(systemFiltersId);
            return this.buildHttpResultW(result, SYSTEM_PARAM_NAME);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6570\u636e\u89c6\u56fe\u7684\u552f\u4e00\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\u8fdb\u884c\u8be6\u60c5\u67e5\u8be2\uff08\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff09")
    @RequestMapping(value={"/findDetailsByCode"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByCode(@RequestParam(value="code") @ApiParam(value="\u6570\u636e\u89c6\u56fe\u7684\u552f\u4e00\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f") String code) {
        try {
            DataViewEntity result = this.dataViewEntityService.findDetailsByCode(code);
            return this.buildHttpResultW(result, FIELD_FILTERS_F);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4f7f\u7528\u6307\u5b9a\u7684\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\uff0c\u8fdb\u884c\u6b63\u5f0f\u7684\u67e5\u8be2SQL\u6267\u884c\uff0c\u4f46\u662f\u6700\u591a\u53ea\u8fd4\u56de\u4e00\u6761\u8bb0\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceCode", value="\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u7f16\u7801", required=true), @ApiImplicitParam(name="json", value="\u7b2c\u4e09\u65b9\u6570\u636e\u89c6\u56fedataView\u548c\u6267\u884c\u53c2\u6570inputParams", required=true)})
    @RequestMapping(value={"/executeTop1"}, method={RequestMethod.POST})
    public ResponseModel executeTop1(@RequestParam(value="dataSourceCode") String dataSourceCode, @RequestBody JSONObject json) {
        try {
            Principal principal = this.getPrincipal();
            DataViewEntity dataView = this.resolveDataView(json);
            InvokeParams inputParams = this.resolveKuiperInvokeParams(json);
            Future<?> futrue = this.dataViewEntityService.executeTop1(dataSourceCode, dataView, inputParams, principal);
            Object result = futrue.get(TIME_OUT.intValue(), TimeUnit.SECONDS);
            if (result instanceof Exception) {
                throw new IllegalArgumentException((Exception)result);
            }
            JSONArray jsonArr = (JSONArray)result;
            return this.buildHttpResultW(jsonArr, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4f7f\u7528\u4e3b\u6570\u636e\u6e90\uff0c\u8fdb\u884c\u6b63\u5f0f\u7684\u67e5\u8be2SQL\u6267\u884c\uff0c\u4f46\u662f\u6700\u591a\u53ea\u8fd4\u56de\u4e00\u6761\u8bb0\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="json", value="\u4e3b\u6570\u636e\u6e90\u6570\u636e\u89c6\u56fedataView\u548c\u6267\u884c\u53c2\u6570inputParams", required=true)})
    @RequestMapping(value={"/mainExecuteTop1"}, method={RequestMethod.POST})
    public ResponseModel executeTop1(@RequestBody JSONObject json) {
        try {
            Principal principal = this.getPrincipal();
            DataViewEntity dataView = this.resolveDataView(json);
            InvokeParams inputParams = this.resolveKuiperInvokeParams(json);
            JSONArray jsonArr = this.dataViewEntityService.executeTop1(dataView, inputParams, principal);
            return this.buildHttpResultW(jsonArr, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4f7f\u7528\u6307\u5b9a\u7684\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\uff0c\u8fdb\u884c\u6b63\u5f0f\u7684\u5206\u9875SQL\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceCode", value="\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u7f16\u7801", required=true), @ApiImplicitParam(name="json", value="\u7b2c\u4e09\u65b9\u6570\u636e\u89c6\u56fedataView\u548c\u6267\u884c\u53c2\u6570inputParams", required=true)})
    @RequestMapping(value={"/executeByPage"}, method={RequestMethod.POST})
    public ResponseModel executeByPage(@RequestParam(value="dataSourceCode") String dataSourceCode, @RequestBody JSONObject json) {
        try {
            Principal principal = this.getPrincipal();
            Pageable pageable = this.resolvePageable(json);
            DataViewEntity dataView = this.resolveDataView(json);
            InvokeParams inputParams = this.resolveKuiperInvokeParams(json);
            Future<?> futrue = this.dataViewEntityService.execute(dataSourceCode, dataView, inputParams, pageable, principal);
            Object result = futrue.get(TIME_OUT.intValue(), TimeUnit.SECONDS);
            if (result instanceof Exception) {
                throw new IllegalArgumentException((Exception)result);
            }
            Page page = (Page)result;
            return this.buildHttpResultW(page, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4f7f\u7528\u4e3b\u6570\u636e\u6e90\uff0c\u8fdb\u884c\u6b63\u5f0f\u7684\u67e5\u8be2SQL\u6267\u884c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="json", value="\u4e3b\u6570\u636e\u6e90\u6570\u636e\u89c6\u56fedataView\u548c\u6267\u884c\u53c2\u6570inputParams", required=true)})
    @RequestMapping(value={"/mainExecuteByPage"}, method={RequestMethod.POST})
    public ResponseModel mainExecuteByPage(@RequestBody JSONObject json) {
        try {
            Principal principal = this.getPrincipal();
            Pageable pageable = this.resolvePageable(json);
            DataViewEntity dataView = this.resolveDataView(json);
            InvokeParams inputParams = this.resolveKuiperInvokeParams(json);
            Page<JSONObject> page = this.dataViewEntityService.execute(dataView, inputParams, pageable, principal);
            return this.buildHttpResultW(page, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4f7f\u7528\u6307\u5b9a\u7684\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\uff0c\u8fdb\u884c\u6b63\u5f0f\u7684\u67e5\u8be2SQL\u6267\u884c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceCode", value="\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u7f16\u7801", required=true), @ApiImplicitParam(name="json", value="\u7b2c\u4e09\u65b9\u6570\u636e\u89c6\u56fedataView\u548c\u6267\u884c\u53c2\u6570inputParams", required=true)})
    @RequestMapping(value={"/execute"}, method={RequestMethod.POST})
    public ResponseModel execute(@RequestParam(value="dataSourceCode") String dataSourceCode, @RequestBody JSONObject json) {
        try {
            Principal principal = this.getPrincipal();
            DataViewEntity dataView = this.resolveDataView(json);
            InvokeParams inputParams = this.resolveKuiperInvokeParams(json);
            Future<?> futrue = this.dataViewEntityService.execute(dataSourceCode, dataView, inputParams, principal);
            Object result = futrue.get(TIME_OUT.intValue(), TimeUnit.SECONDS);
            if (result instanceof Exception) {
                throw new IllegalArgumentException((Exception)result);
            }
            JSONArray jsonArr = (JSONArray)result;
            return this.buildHttpResultW(jsonArr, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4f7f\u7528\u4e3b\u6570\u636e\u6e90\uff0c\u8fdb\u884c\u6b63\u5f0f\u7684\u67e5\u8be2SQL\u6267\u884c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="json", value="\u4e3b\u6570\u636e\u6e90\u6570\u636e\u89c6\u56fedataView\u548c\u6267\u884c\u53c2\u6570inputParams", required=true)})
    @RequestMapping(value={"/mainExecute"}, method={RequestMethod.POST})
    public ResponseModel mainExecute(@RequestBody JSONObject json) {
        try {
            Principal principal = this.getPrincipal();
            DataViewEntity dataView = this.resolveDataView(json);
            InvokeParams inputParams = this.resolveKuiperInvokeParams(json);
            JSONArray jsonArr = this.dataViewEntityService.execute(dataView, inputParams, principal);
            return this.buildHttpResultW(jsonArr, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"exportExcel"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u5230excel")
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, @ApiParam(value="\u6570\u636e\u6e90\u7f16\u7801") String dataSourceCode, @RequestParam(value="dataView") String dataViewJson, @RequestParam(value="inputParams", required=false) String inputParamsJson, @RequestParam(value="exportExcelParams") String exportExcelParamsJson) {
        try {
            Principal principal = this.getPrincipal();
            DataViewEntity dataView = null;
            if (StringUtils.isNotBlank((CharSequence)dataViewJson)) {
                dataView = (DataViewEntity)JSONObject.parseObject((String)dataViewJson).toJavaObject(DataViewEntity.class);
            }
            InvokeParams inputParams = null;
            if (StringUtils.isNotBlank((CharSequence)inputParamsJson)) {
                inputParams = this.resolveInvokeParams(JSONObject.parseObject((String)inputParamsJson));
            }
            List excelFields = JSONArray.parseArray((String)exportExcelParamsJson).toJavaList(DataviewExportExcelFieldVo.class);
            byte[] bytes = this.dataViewEntityService.exportExcel(dataSourceCode, dataView, inputParams, principal, excelFields);
            super.writeResponseFile(request, response, bytes, "\u5217\u8868\u5bfc\u51fa.xlsx");
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u5df2\u6709\u7684\u89c6\u56feID\u4ee5\u53ca\u7cfb\u7edf\u53c2\u6570\u4fe1\u606f\uff08json\u683c\u5f0f\uff09\uff0c\u67e5\u627e\u5df2\u6709\u7684\u6570\u636e\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="json", value="\u6570\u636e\u6e90\u6570\u636e\u89c6\u56fedataView\u548c\u6267\u884c\u53c2\u6570inputParams", required=true)})
    @RequestMapping(value={"/findByViewAndDataKey"}, method={RequestMethod.POST})
    public ResponseModel findByViewAndDataKey(@RequestBody JSONObject json) {
        try {
            Principal principal = this.getPrincipal();
            DataViewEntity dataView = this.resolveDataView(json);
            InvokeParams inputParams = this.resolveKuiperInvokeParams(json);
            String primaryKey = json.getString("primaryKey");
            JSONArray primaryValue = json.getJSONArray("primaryValue");
            JSONArray jsonArr = this.dataViewEntityService.findByViewAndDataKey(dataView, inputParams, principal, primaryKey, primaryValue);
            return this.buildHttpResultW(jsonArr, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u8bed\u53e5\u8f93\u51fa\u5206\u6790")
    @RequestMapping(value={"/sqlAnalysis"}, method={RequestMethod.PATCH})
    public ResponseModel sqlAnalysis(@RequestParam(value="dataSourceCode") @ApiParam(value="\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u7f16\u7801") String dataSourceCode, @RequestBody @ApiParam DataViewEntity dataView) {
        try {
            DataViewEntity result = this.dataViewEntityService.executeResource(dataSourceCode, dataView);
            return this.buildHttpResultW(result, FIELD_FILTERS);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4e3b\u6570\u636e\u6e90\u8bed\u53e5\u8f93\u51fa\u5206\u6790")
    @RequestMapping(value={"/mainSqlAnalysis"}, method={RequestMethod.PATCH})
    public ResponseModel mainSqlAnalysis(@RequestBody @ApiParam DataViewEntity dataView) {
        try {
            DataViewEntity result = this.dataViewEntityService.executeResource(dataView);
            return this.buildHttpResultW(result, FIELD_FILTERS);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    private DataViewEntity resolveDataView(JSONObject json) {
        JSONObject jsonDataView = json.getJSONObject(VIEW_PARAM_NAME);
        DataViewEntity dataView = jsonDataView == null ? null : (DataViewEntity)JSONObject.toJavaObject((JSON)jsonDataView, DataViewEntity.class);
        return dataView;
    }

    private InvokeParams resolveKuiperInvokeParams(JSONObject json) {
        JSONObject jsonInputParams = json.getJSONObject(INPUT_PARAM_NAME);
        return this.resolveInvokeParams(jsonInputParams);
    }

    private InvokeParams resolveInvokeParams(JSONObject jsonInputParams) {
        InvokeParams inputParams = new InvokeParams();
        if (jsonInputParams != null) {
            JSONObject models = jsonInputParams.getJSONObject(KUIPER_PARAM_NAME);
            for (String e : models.keySet()) {
                inputParams.add(e, (InvokeOperations)models.getObject(e, InvokeOperations.class), false);
            }
        }
        return inputParams;
    }

    private Pageable resolvePageable(JSONObject json) {
        JSONObject jsonPage = json.getJSONObject(PAGE_PARAM_NAME);
        PageRequest pageable = null;
        pageable = jsonPage != null && jsonPage.getInteger(PAGE_PARAM_NAME) != null && jsonPage.getInteger("size") != null ? PageRequest.of((int)jsonPage.getIntValue(PAGE_PARAM_NAME), (int)jsonPage.getIntValue("size")) : PageRequest.of((int)0, (int)50);
        return pageable;
    }
}

