/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller.vcode;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.rbac.server.service.ccode.CheckCodeService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/checkCodes"})
public class CheckCodeController
extends BaseController {
    @Autowired
    private CheckCodeService checkCodeService;
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckCodeController.class);

    @ApiOperation(value="\u4e3a\u5f53\u524d\u6307\u5b9a\u7528\u6237\u6807\u8bc6\u7684\u767b\u5f55\u64cd\u4f5c\uff0c\u751f\u6210\u4e00\u4e2a\u65b0\u7684\u6821\u9a8c\u7801\uff0c\u5e76\u5c06\u6821\u9a8c\u7801\u56fe\u7247\u8fdb\u884c\u8fd4\u56de\uff08png\u683c\u5f0f\uff09", notes="\u6821\u9a8c\u7801\u5145\u6700\u540e\u4e00\u6b21\u8c03\u7528\u8be5\u65b9\u6cd5\u751f\u6210\u5f00\u59cb\u8ba1\u7b97\u67095\u5206\u949f\u8d85\u65f6\u65f6\u95f4")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public void generate(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="width", required=false) @ApiParam(name="width", required=false, value="\u9a8c\u8bc1\u7801\u56fe\u7247\u7684\u5bbd\u5ea6\uff08\u5355\u4f4d\u50cf\u7d20\uff09") Integer width, @RequestParam(name="height", required=false) @ApiParam(name="height", required=false, value="\u9a8c\u8bc1\u7801\u56fe\u7247\u7684\u9ad8\u5ea6\uff08\u5355\u4f4d\u50cf\u7d20\uff09") Integer height) {
        int currentWidth = width == null || width <= 0 ? 150 : width;
        int currentHeight = height == null || height <= 0 ? 50 : height;
        try {
            HttpSession session = request.getSession();
            String userid = session.getId();
            LOGGER.info("\u5f53\u524dsession id = " + userid);
            byte[] contents = this.checkCodeService.generate(userid, 4, currentWidth, currentHeight);
            this.writeResponseFile(response, 1, contents);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

