/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.OrganizationEntity;
import com.bizunited.platform.core.entity.PositionEntity;
import com.bizunited.platform.core.repository.internal.PositionRepositoryCustom;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="PositionRepository")
public interface PositionRepository
extends JpaRepository<PositionEntity, String>,
JpaSpecificationExecutor<PositionEntity>,
PositionRepositoryCustom {
    public PositionEntity findByCode(@Param(value="code") String var1);

    public List<PositionEntity> findByName(@Param(value="name") String var1);

    @Query(value="select distinct position from PositionEntity position left join fetch position.organization left join fetch position.roles left join fetch position.users where position.id = :id")
    public PositionEntity findDetailsById(@Param(value="id") String var1);

    @Query(value="select distinct position from PositionEntity position left join fetch position.organization left join fetch position.roles left join fetch position.users where position.code = :code")
    public PositionEntity findDetailsByCode(@Param(value="code") String var1);

    public List<PositionEntity> findALlByOrAndOrganization(OrganizationEntity var1);

    @Query(value="SELECT COUNT(*) FROM engine_position_role_mapping WHERE role_id = :roleId AND position_id = :positionId", nativeQuery=true)
    public int countByRoleAndPosition(@Param(value="roleId") String var1, @Param(value="positionId") String var2);

    @Modifying
    @Query(value="insert into engine_position_role_mapping(role_id,position_id) values (:roleId,:positionId)", nativeQuery=true)
    public void bindRole(@Param(value="roleId") String var1, @Param(value="positionId") String var2);

    @Modifying
    @Query(value="delete from engine_position_role_mapping where role_id = :roleId and position_id = :positionId", nativeQuery=true)
    public void unbindRole(@Param(value="roleId") String var1, @Param(value="positionId") String var2);

    @Modifying
    @Query(value="delete from engine_position_role_mapping where role_id = :roleId", nativeQuery=true)
    public void unbindRoles(@Param(value="roleId") String var1);

    @Query(value="SELECT COUNT(*) FROM engine_position_user_mapping WHERE user_id = :userId AND position_id = :positionId", nativeQuery=true)
    public int countByUserAndPosition(@Param(value="userId") String var1, @Param(value="positionId") String var2);

    @Modifying
    @Query(value="insert into engine_position_user_mapping(user_id,position_id) values (:userId,:positionId)", nativeQuery=true)
    public void binduser(@Param(value="userId") String var1, @Param(value="positionId") String var2);

    @Modifying
    @Query(value="delete from engine_position_user_mapping where user_id = :userId and position_id = :positionId", nativeQuery=true)
    public void unbinduser(@Param(value="userId") String var1, @Param(value="positionId") String var2);

    @Modifying
    @Query(value="delete from engine_position_user_mapping where user_id = :userId", nativeQuery=true)
    public void unbindusers(@Param(value="userId") String var1);

    @Query(value="from PositionEntity m where m.id in :ids")
    public Set<PositionEntity> findByIds(@Param(value="ids") List<String> var1);

    @Query(value="select p from PositionEntity p inner join fetch p.roles r inner join fetch p.users u where u.id = :userId")
    public Set<PositionEntity> findDetailsByUserId(@Param(value="userId") String var1);
}

