/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.UserGroupEntity;
import com.bizunited.platform.core.repository.internal.UserGroupRepositoryCustom;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="UserGroupRepository")
public interface UserGroupRepository
extends JpaRepository<UserGroupEntity, String>,
JpaSpecificationExecutor<UserGroupEntity>,
UserGroupRepositoryCustom {
    @Modifying
    @Query(value="INSERT INTO engine_group_user_mapping (group_id,user_id) VALUES (:groupId,:userId)", nativeQuery=true)
    public int bindUser(@Param(value="groupId") String var1, @Param(value="userId") String var2);

    @Modifying
    @Query(value="DELETE FROM engine_group_user_mapping WHERE group_id = :groupId AND user_id = :userId", nativeQuery=true)
    public int unBindUser(@Param(value="groupId") String var1, @Param(value="userId") String var2);

    @Modifying
    @Query(value="INSERT INTO engine_group_role_mapping (group_id,role_id) VALUES (:groupId,:roleId)", nativeQuery=true)
    public int bindRole(@Param(value="groupId") String var1, @Param(value="roleId") String var2);

    @Modifying
    @Query(value="DELETE FROM engine_group_role_mapping WHERE group_id = :groupId AND role_id = :roleId", nativeQuery=true)
    public int unBindRole(@Param(value="groupId") String var1, @Param(value="roleId") String var2);

    @Query(value="SELECT COUNT(*) FROM engine_group_user_mapping WHERE group_id = :groupId AND user_id = :userId", nativeQuery=true)
    public int countUserGroup(@Param(value="groupId") String var1, @Param(value="userId") String var2);

    @Query(value="SELECT COUNT(*) FROM engine_group_role_mapping WHERE group_id = :groupId AND role_id = :roleId", nativeQuery=true)
    public int countRoleGroup(@Param(value="groupId") String var1, @Param(value="roleId") String var2);

    @Query(value="select ug from UserGroupEntity ug where ug.groupName = :groupName")
    public UserGroupEntity findByGroupName(@Param(value="groupName") String var1);

    @Query(value="select ug from UserGroupEntity ug left join fetch ug.users u left join fetch ug.roles r where ug.id = :id")
    public Set<UserGroupEntity> findDetailsById(@Param(value="id") String var1);

    @Query(value="select distinct ug from UserGroupEntity ug left join fetch ug.users users left join fetch ug.roles where users.id = :userId")
    public Set<UserGroupEntity> findByUserId(@Param(value="userId") String var1);

    @Query(value="from UserGroupEntity m where m.id in :ids")
    public Set<UserGroupEntity> findByIds(@Param(value="ids") List<String> var1);
}

