/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.repository.dataview.DataViewThirdDataSourceRepository;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="DataViewThirdDataSourceRepositoryImpl")
public class DataViewThirdDataSourceRepositoryImpl
implements DataViewThirdDataSourceRepository {
    private static Logger LOGGER = LoggerFactory.getLogger(DataViewThirdDataSourceRepositoryImpl.class);
    @Autowired
    private DynamicDataSourceManager dynamicDataSourceManager;
    private static final String ERROR_SESSION_FACTORY = "\u672a\u80fd\u83b7\u53d6\u5230\u7b2c\u4e09\u65b9\u7684sessionFactory\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!";
    private static final String ERROR_SQL = "SQL\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5!!\u8be6\u60c5\uff1a";
    private static final String SYSTEM_PARAMS_PATTERN = "\\{\\:[a-zA-Z]{1}\\w*\\}";

    @Override
    public JSONArray executeSQLTop1(String dataSourceCode, String sql) {
        SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
        Validate.notNull((Object)sessionFactory, (String)ERROR_SESSION_FACTORY, (Object[])new Object[0]);
        JSONArray jsonArr = new JSONArray();
        try (Connection conn = SessionFactoryUtils.getDataSource((SessionFactory)sessionFactory).getConnection();
             Statement st = conn.createStatement();
             ResultSet results = st.executeQuery(sql);){
            ResultSetMetaData meta = null;
            if (results.first()) {
                meta = results.getMetaData();
                JSONObject jsonObj = new JSONObject();
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    jsonObj.put(meta.getColumnName(i), results.getObject(i));
                }
                jsonArr.add((Object)jsonObj);
                LOGGER.debug("sql\u6267\u884c\u7ed3\u679cjsonArr = " + jsonArr.toJSONString());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ERROR_SQL + e.getMessage());
        }
        return jsonArr;
    }

    @Override
    public JSONArray executeSQL(String dataSourceCode, String sql) {
        SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
        Validate.notNull((Object)sessionFactory, (String)ERROR_SESSION_FACTORY, (Object[])new Object[0]);
        JSONArray jsonArr = new JSONArray();
        try (Connection conn = SessionFactoryUtils.getDataSource((SessionFactory)sessionFactory).getConnection();
             Statement st = conn.createStatement();
             ResultSet results = st.executeQuery(sql);){
            ResultSetMetaData meta = null;
            while (results.next()) {
                meta = results.getMetaData();
                JSONObject jsonObj = new JSONObject();
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    jsonObj.put(meta.getColumnName(i), results.getObject(i));
                }
                jsonArr.add((Object)jsonObj);
            }
            LOGGER.debug("sql\u6267\u884c\u7ed3\u679cjsonArr = " + jsonArr.toJSONString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ERROR_SQL + e.getMessage());
        }
        return jsonArr;
    }

    @Override
    public DataViewEntity executeResource(String dataSourceCode, DataViewEntity dataView) {
        Validate.notNull((Object)dataView, (String)"\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataView.getSourceSql(), (String)"\u539f\u59cbSQL\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
        Validate.notNull((Object)sessionFactory, (String)"\u672a\u627e\u5230\u8be5\u6570\u636e\u6e90\uff01", (Object[])new Object[0]);
        String sourceSql = dataView.getSourceSql();
        LinkedHashSet<DataViewFieldEntity> fields = new LinkedHashSet<DataViewFieldEntity>();
        DataSource dataSource = SessionFactoryUtils.getDataSource((SessionFactory)sessionFactory);
        DataViewEntity currentDataView = this.replaceSysParam(dataView);
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet result = statement.executeQuery(currentDataView.getSourceSql());){
            ResultSetMetaData metaData = result.getMetaData();
            HashSet<Object> fieldNames = new HashSet<Object>();
            Set sysParamsStrs = currentDataView.getSystemFilters().stream().map(o -> o.getParamName()).collect(Collectors.toSet());
            fieldNames.addAll(sysParamsStrs);
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                DataViewFieldEntity field = new DataViewFieldEntity();
                field.setFieldName(metaData.getColumnLabel(i));
                Validate.isTrue((boolean)fieldNames.add(metaData.getColumnLabel(i)), (String)"\u8fd4\u56de\u5b57\u6bb5\u96c6\u6216\u4e0e\u7cfb\u7edf\u53c2\u6570\u4e2d\u542b\u6709\u76f8\u540c\u5b57\u6bb5\u540d\uff1a%s,\u8bf7\u4e3a\u5176\u53d6\u522b\u540d\uff0c\u6216\u505a\u5176\u4ed6\u8c03\u6574\u3002", (Object[])new Object[]{metaData.getColumnLabel(i)});
                field.setFieldType(metaData.getColumnClassName(i));
                field.setPhysical(!StringUtils.isEmpty((CharSequence)metaData.getTableName(i)));
                field.setSchemaName(metaData.getSchemaName(i));
                field.setTargetTable(metaData.getTableName(i));
                field.setTargetField(metaData.getColumnName(i));
                field.setSortIndex(i);
                fields.add(field);
            }
            fieldNames.clear();
            currentDataView.setFields(fields);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(ERROR_SQL + e.getMessage());
        }
        currentDataView.setSourceSql(sourceSql);
        return currentDataView;
    }

    private DataViewEntity replaceSysParam(DataViewEntity dataView) {
        Validate.notNull((Object)dataView, (String)"\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataView.getSourceSql(), (String)"\u539f\u59cbSQL\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String sql = dataView.getSourceSql();
        LinkedHashSet<DataViewSystemEntity> systemEntities = new LinkedHashSet<DataViewSystemEntity>();
        Set<String> sysParams = this.extractMessageByRegular(sql);
        if (!CollectionUtils.isEmpty(sysParams)) {
            for (String param : sysParams) {
                DataViewSystemEntity dataViewSystem = new DataViewSystemEntity();
                dataViewSystem.setParamName(param);
                systemEntities.add(dataViewSystem);
                String replaceStr = "{:" + param + "}";
                sql = sql.replace(replaceStr, "''");
            }
        }
        dataView.setSystemFilters(systemEntities);
        dataView.setSourceSql(sql);
        return dataView;
    }

    private Set<String> extractMessageByRegular(String msg) {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        Pattern p = Pattern.compile(SYSTEM_PARAMS_PATTERN);
        Matcher m = p.matcher(msg);
        while (m.find()) {
            list.add(m.group().substring(2, m.group().length() - 1));
        }
        return list;
    }

    @Override
    public Page<JSONObject> executeSQLPageAble(String dataSourceCode, String sql, Pageable pageable) {
        SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
        Validate.notNull((Object)sessionFactory, (String)ERROR_SESSION_FACTORY, (Object[])new Object[0]);
        PageImpl page = null;
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        try (Connection conn = SessionFactoryUtils.getDataSource((SessionFactory)sessionFactory).getConnection();
             Statement st = conn.createStatement();
             ResultSet results = st.executeQuery(sql);){
            ResultSetMetaData meta = null;
            while (results.next()) {
                meta = results.getMetaData();
                JSONObject jsonObj = new JSONObject();
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    jsonObj.put(meta.getColumnName(i), results.getObject(i));
                }
                list.add(jsonObj);
            }
            page = new PageImpl(list, pageable, (long)list.size());
            LOGGER.debug("sql\u6267\u884c\u7ed3\u679cpage = " + JSONObject.toJSONString((Object)page));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ERROR_SQL + e.getMessage());
        }
        return page;
    }

    @Override
    public void checkTable(String dataSourceCode, String tableName) {
        Validate.notBlank((CharSequence)tableName, (String)"\u8f93\u5165\u6570\u636e\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataSourceCode, (String)"\u8f93\u5165\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
        try (Connection connection = SessionFactoryUtils.getDataSource((SessionFactory)sessionFactory).getConnection();){
            DatabaseMetaData md = connection.getMetaData();
            try (ResultSet rs = md.getTables(null, null, tableName, null);){
                Validate.isTrue((boolean)rs.next(), (String)"\u6240\u8bbe\u7f6e\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u4e2d\u57fa\u7840\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ERROR_SQL + e.getMessage());
        }
    }
}

