/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import com.bizunited.platform.core.common.utils.ParamsAnalysisUtil;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.repository.dataview.analysis.AbstractSqlAnalysis;
import com.bizunited.platform.core.service.dataview.model.SQLParamModel;
import com.bizunited.platform.core.service.invoke.model.InvokeOperations;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.util.CollectionUtils;

class SQLConditionFilterAnalysis {
    private SQLConditionFilterAnalysis() {
    }

    static Map<SQLCorrelationEnum, Object> buildSQLConditions(Set<DataViewFilterEntity> filters, Map<SQLCorrelationEnum, Object> map, InvokeParams params, AbstractSqlAnalysis sqlAnalysis) {
        Validate.isTrue((!CollectionUtils.isEmpty(map) ? 1 : 0) != 0, (String)"SQL\u5206\u6790\u65f6\uff0c\u4e0a\u4e0b\u6587\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(filters)) {
            return map;
        }
        Set conditionSets = filters.stream().filter(e -> params.containsKey(e.getField().getFieldName())).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(conditionSets)) {
            return map;
        }
        for (DataViewFilterEntity filter : conditionSets) {
            String fieldName = filter.getField().getFieldName();
            InvokeOperations model = params.get(fieldName);
            model.setOprtType(filter.getOpType());
            model.setParamName(fieldName);
            SQLConditionFilterAnalysis.analysisConditions(model, map, sqlAnalysis);
        }
        return map;
    }

    private static void analysisConditions(InvokeOperations model, Map<SQLCorrelationEnum, Object> map, AbstractSqlAnalysis sqlAnalysis) {
        Object compareValue = model.getCompareValue();
        Validate.isTrue((compareValue != null || !StringUtils.isBlank((CharSequence)model.getOprtType()) ? 1 : 0) != 0, (String)"%s\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e0d\u662f\u6392\u5e8f\u5b57\u6bb5", (Object[])new Object[]{model.getParamName()});
        if (compareValue == null) {
            return;
        }
        if (InvokeOperations.isLikeOprt(model.getOprtType())) {
            SQLConditionFilterAnalysis.analysisLikeConditions(model, map, sqlAnalysis);
        } else if (InvokeOperations.isBetweenOprt(model.getOprtType())) {
            SQLConditionFilterAnalysis.analysisBetweenConditions(model, map);
        } else if (InvokeOperations.isInOprt(model.getOprtType())) {
            SQLConditionFilterAnalysis.analysisInConditions(model, map);
        } else if (InvokeOperations.nullOprt(model.getOprtType())) {
            SQLConditionFilterAnalysis.analysisNullConditions(model, map);
        } else if (InvokeOperations.isRegionOprt(model.getOprtType())) {
            SQLConditionFilterAnalysis.analysisRegionConditions(model, map);
        } else {
            SQLConditionFilterAnalysis.analysisOtherConditions(model, map);
        }
    }

    private static void addConditionValue(InvokeOperations model, Map<SQLCorrelationEnum, Object> map) {
        LinkedHashSet values = (LinkedHashSet)map.get((Object)SQLCorrelationEnum.CONDITION_VALUES);
        SQLParamModel spm = new SQLParamModel();
        spm.setParamName(model.getParamName());
        spm.setValue(model.getCompareValue());
        spm.setMappingType(model.getMappingType());
        spm.setTransferType(1);
        SQLConditionFilterAnalysis.setCouter(spm, map);
        values.add(spm);
    }

    private static void setCouter(SQLParamModel spm, Map<SQLCorrelationEnum, Object> map) {
        int count = (Integer)map.remove((Object)SQLCorrelationEnum.COUNTER);
        spm.setIndex(count++);
        map.put(SQLCorrelationEnum.COUNTER, count);
    }

    private static void addConditionSQL(String conditionSQL, Map<SQLCorrelationEnum, Object> map) {
        String oldVal = map.remove((Object)SQLCorrelationEnum.RESULT_SQL).toString();
        String newVal = oldVal + conditionSQL;
        map.put(SQLCorrelationEnum.RESULT_SQL, newVal);
    }

    private static void analysisLikeConditions(InvokeOperations model, Map<SQLCorrelationEnum, Object> map, AbstractSqlAnalysis sqlAnalysis) {
        String sql = "";
        switch (model.getOprtType()) {
            case "LIKE": {
                String likeCondition = sqlAnalysis.concatSql("'%%'", "?", "'%%'");
                sql = String.format(" and %s.%s like %s", "s01y01s01", model.getParamName(), likeCondition);
                break;
            }
            case "LLIKE": {
                String likeCondition = sqlAnalysis.concatSql("'%%'", "?");
                sql = String.format(" and %s.%s like %s", "s01y01s01", model.getParamName(), likeCondition);
                break;
            }
            case "RLIKE": {
                String likeCondition = sqlAnalysis.concatSql("?", "'%%'");
                sql = String.format(" and %s.%s like %s", "s01y01s01", model.getParamName(), likeCondition);
                break;
            }
        }
        SQLConditionFilterAnalysis.addConditionSQL(sql, map);
        SQLConditionFilterAnalysis.addConditionValue(model, map);
    }

    private static void analysisInConditions(InvokeOperations model, Map<SQLCorrelationEnum, Object> map) {
        List list = (List)model.getCompareValue();
        Validate.notNull((Object)list, (String)"\u524d\u7aef\u4f20\u5165\u7684\u6570\u7ec4\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((list.size() >= 1 ? 1 : 0) != 0, (String)"\u524d\u7aef\u4f20\u5165\u7684\u6570\u7ec4\u503c\u6709\u8bef", (Object[])new Object[0]);
        StringBuilder inPatternBuilder = new StringBuilder("");
        for (int i = 0; i < list.size(); ++i) {
            inPatternBuilder.append("?,");
        }
        String inPattern = inPatternBuilder.toString();
        String sql = " and s01y01s01." + model.getParamName() + " " + SQLConditionFilterAnalysis.getOprtTypeValue(model.getOprtType()) + "(" + StringUtils.left((String)inPattern, (int)(inPattern.length() - 1)) + ")";
        SQLConditionFilterAnalysis.addConditionSQL(sql, map);
        SQLConditionFilterAnalysis.addConditionArray(model, map, list.size());
    }

    private static void analysisBetweenConditions(InvokeOperations model, Map<SQLCorrelationEnum, Object> map) {
        String sql = String.format(" and %s.%s between %s and %s", "s01y01s01", model.getParamName(), "?", "?");
        SQLConditionFilterAnalysis.addConditionSQL(sql, map);
        SQLConditionFilterAnalysis.addConditionArray(model, map, 2);
    }

    private static void analysisNullConditions(InvokeOperations model, Map<SQLCorrelationEnum, Object> map) {
        String sql = String.format(" and %s.%s %s", "s01y01s01", model.getParamName(), SQLConditionFilterAnalysis.getOprtTypeValue(model.getOprtType()));
        SQLConditionFilterAnalysis.addConditionSQL(sql, map);
    }

    private static void analysisRegionConditions(InvokeOperations model, Map<SQLCorrelationEnum, Object> map) {
        String sql = "";
        switch (model.getOprtType()) {
            case "LC_RC": {
                sql = String.format(" and %s.%s >= %s and %s.%s <= %s", "s01y01s01", model.getParamName(), "?", "s01y01s01", model.getParamName(), "?");
                break;
            }
            case "LO_RO": {
                sql = String.format(" and %s.%s > %s and %s.%s < %s", "s01y01s01", model.getParamName(), "?", "s01y01s01", model.getParamName(), "?");
                break;
            }
            case "LC_RO": {
                sql = String.format(" and %s.%s >= %s and %s.%s < %s", "s01y01s01", model.getParamName(), "?", "s01y01s01", model.getParamName(), "?");
                break;
            }
            case "LO_RC": {
                sql = String.format(" and %s.%s > %s and %s.%s <= %s", "s01y01s01", model.getParamName(), "?", "s01y01s01", model.getParamName(), "?");
                break;
            }
        }
        SQLConditionFilterAnalysis.addConditionSQL(sql, map);
        SQLConditionFilterAnalysis.addConditionArray(model, map, 2);
    }

    private static void analysisOtherConditions(InvokeOperations model, Map<SQLCorrelationEnum, Object> map) {
        String sql = String.format(" and %s.%s %s %s", "s01y01s01", model.getParamName(), SQLConditionFilterAnalysis.getOprtTypeValue(model.getOprtType()), "?");
        SQLConditionFilterAnalysis.addConditionSQL(sql, map);
        SQLConditionFilterAnalysis.addConditionValue(model, map);
    }

    private static void addConditionArray(InvokeOperations model, Map<SQLCorrelationEnum, Object> map, int arrLength) {
        Validate.isTrue((boolean)SQLParamModel.isSupportBaseClassType(model.getMappingType()), (String)"%s\u4f20\u5165\u7684mappingType\u503c\u4e0d\u662fNebula\u652f\u6301\u7684\u7c7b\u578b", (Object[])new Object[]{model.getMappingType()});
        List list = (List)model.getCompareValue();
        Validate.notNull((Object)list, (String)"\u4f20\u5165\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((list.size() == arrLength ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u6570\u7ec4\u503c\u6709\u9519\u8bef", (Object[])new Object[0]);
        for (int index = 0; index < list.size(); ++index) {
            InvokeOperations kipm = new InvokeOperations();
            BeanCopier b = BeanCopier.create(InvokeOperations.class, InvokeOperations.class, (boolean)false);
            b.copy((Object)model, (Object)kipm, null);
            kipm.setCompareValue(list.get(index));
            SQLConditionFilterAnalysis.matchBetween(kipm, index);
            SQLConditionFilterAnalysis.addConditionValue(kipm, map);
        }
    }

    private static String getOprtTypeValue(String oprtType) {
        return InvokeParams.OprtCharType.getOprtValue(oprtType);
    }

    private static void matchBetween(InvokeOperations model, int index) {
        if (!InvokeOperations.isBetweenOprt(model.getOprtType())) {
            return;
        }
        String value = ParamsAnalysisUtil.doTrans(model.getCompareValue(), model.getMappingType()).toString();
        if (model.getMappingType().equals("java.util.Date")) {
            value = index == 0 ? value + " 00:00:00" : value + " 23:59:59";
            model.setMappingType("java.lang.String");
        } else {
            model.setMappingType(model.getMappingType());
        }
        model.setCompareValue(value);
    }
}

