/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.repository.dataview.analysis.Constants;
import com.bizunited.platform.rbac.server.service.OrganizationService;
import com.bizunited.platform.rbac.server.service.PositionService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.UserGroupService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.OrganizationVo;
import com.bizunited.platform.rbac.server.vo.PositionVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.rbac.server.vo.UserGroupVo;
import com.bizunited.platform.rbac.server.vo.UserVo;
import java.security.Principal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="SQLPresetValueAnalysis")
public class SQLPresetValueAnalysis {
    @Autowired
    private UserService userService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private RoleService roleService;
    private static final String ANALYSIS_ERROR = "\u7cfb\u7edf\u53c2\u6570\u5206\u6790\u65f6\uff0cPrincipal\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!";
    private static final String ANALYSIS_H_ERROR = "\u6a2a\u5411\u6743\u9650\u5206\u6790\u65f6\uff0cPrincipal\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!";
    private static final String ANALYSIS_V_ERROR = "\u7eb5\u5411\u6743\u9650\u5206\u6790\u65f6\uff0cPrincipal\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!";
    private static final String ANALYSIS_P_ERROR = "\u9884\u7f6e\u4fe1\u606f\u5206\u6790\u65f6\uff0cPrincipal\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!";

    public Map<String, Object> systemPresetValues(Set<DataViewSystemEntity> systems, Principal principal) {
        if (CollectionUtils.isEmpty(systems)) {
            return null;
        }
        Validate.notNull((Object)principal, (String)ANALYSIS_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)principal.getName(), (String)ANALYSIS_ERROR, (Object[])new Object[0]);
        HashMap<String, Object> presets = new HashMap<String, Object>();
        Set presetSystems = systems.stream().filter(e -> e.getParamSourceType() == 3).collect(Collectors.toSet());
        for (DataViewSystemEntity element : presetSystems) {
            Object o = this.getPresetValueByParamKey(element.getParamValue(), principal);
            String key = element.getParamName() + "|DataViewSystemEntity";
            presets.put(key, o);
        }
        return presets;
    }

    public Map<String, Object> authHorizontalPresetValues(Set<DataViewAuthHorizontalEntity> authHorizontals, Principal principal) {
        if (CollectionUtils.isEmpty(authHorizontals)) {
            return null;
        }
        Validate.notNull((Object)principal, (String)ANALYSIS_H_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)principal.getName(), (String)ANALYSIS_H_ERROR, (Object[])new Object[0]);
        HashMap<String, Object> presets = new HashMap<String, Object>();
        Set presetAuths = authHorizontals.stream().filter(e -> e.getParamSourceType() == 3).collect(Collectors.toSet());
        for (DataViewAuthHorizontalEntity auth : presetAuths) {
            if (auth.getParamSourceType() != 3) continue;
            Object o = this.getPresetValueByParamKey(auth.getParamKey(), principal);
            String key = auth.getField().getFieldName() + "|DataViewAuthHorizontalEntity";
            presets.put(key, o);
        }
        return presets;
    }

    public Map<Integer, Object> authVerticalPresetValues(Set<DataViewAuthVerticalEntity> authVerticals, Principal principal) {
        if (CollectionUtils.isEmpty(authVerticals)) {
            return null;
        }
        Validate.notNull((Object)principal, (String)ANALYSIS_V_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)principal.getName(), (String)ANALYSIS_V_ERROR, (Object[])new Object[0]);
        HashMap<Integer, Object> presets = new HashMap<Integer, Object>();
        for (int i = 1; i <= Constants.AUTH_TYPE_COUNT; ++i) {
            Integer authType = i;
            Set sameAuths = authVerticals.stream().filter(e -> authType.compareTo(e.getAuthType()) == 0).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(sameAuths)) continue;
            Integer key = i;
            Object value = this.getPresetValueByAuthType(principal, i);
            presets.put(key, value);
        }
        return presets;
    }

    private Object getPresetValueByAuthType(Principal principal, int authType) {
        Validate.notNull((Object)principal, (String)ANALYSIS_P_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)principal.getName(), (String)ANALYSIS_P_ERROR, (Object[])new Object[0]);
        String account = principal.getName();
        Validate.notBlank((CharSequence)account, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u7684\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        UserVo currentUser = this.userService.findByAccount(account);
        Validate.notNull((Object)currentUser, (String)"\u975e\u6cd5\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        switch (authType) {
            case 1: {
                return currentUser.getId();
            }
            case 2: {
                List roles = this.roleService.findAllByUserId(currentUser.getId());
                Validate.isTrue((!CollectionUtils.isEmpty((Collection)roles) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u89d2\u8272\u4fe1\u606f\uff01\uff01", (Object[])new Object[0]);
                return new HashSet(roles);
            }
            case 3: {
                PositionVo p1 = this.positionService.findByUserId(currentUser.getId());
                Validate.isTrue((p1 != null ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5c97\u4f4d\u4fe1\u606f\uff01\uff01", (Object[])new Object[0]);
                return p1.getId();
            }
            case 4: {
                Set groups = this.userGroupService.findByUserId(currentUser.getId());
                Validate.isTrue((!CollectionUtils.isEmpty((Collection)groups) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7528\u6237\u7ec4\u4fe1\u606f\uff01\uff01", (Object[])new Object[0]);
                return groups;
            }
            case 5: {
                OrganizationVo o1 = this.organizationService.findOrgByUserId(currentUser.getId());
                Validate.isTrue((o1 != null ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff01\uff01", (Object[])new Object[0]);
                return o1.getId();
            }
        }
        return null;
    }

    private Object getPresetValueByParamKey(String paramKey, Principal principal) {
        Validate.notNull((Object)principal, (String)ANALYSIS_P_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)principal.getName(), (String)ANALYSIS_P_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)paramKey, (String)"\u9884\u7f6e\u63a7\u4ef6\u4e2d\uff0c\u672a\u80fd\u53d1\u73b0\u9884\u7f6e\u503c\u6807\u8bc6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String account = principal.getName();
        Validate.notBlank((CharSequence)account, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u7684\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        UserVo currentUser = this.userService.findByAccount(account);
        Validate.notNull((Object)currentUser, (String)"\u975e\u6cd5\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Object result = null;
        switch (paramKey) {
            case "userId": {
                result = currentUser.getId();
                break;
            }
            case "userName": {
                result = currentUser.getUserName();
                break;
            }
            case "userAccount": {
                result = currentUser.getAccount();
                break;
            }
            case "userCode": {
                result = currentUser.getId();
                break;
            }
            case "userPhone": {
                result = currentUser.getPhone();
                break;
            }
            case "userStatus": {
                result = currentUser.getUseStatus();
                break;
            }
            case "userIdcard": {
                result = currentUser.getIdcard();
                break;
            }
            case "userPositionId": 
            case "userPosition": 
            case "userPositionCode": 
            case "userPositionStatus": {
                Map<String, Object> res = this.getPositionInfoByUserId(currentUser.getId());
                Validate.notEmpty(res, (String)"\u9884\u5236\u4fe1\u606f\u5904\u7406\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u5c97\u4f4d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                result = res.get(paramKey);
                break;
            }
            case "userOrgId": 
            case "userOrg": 
            case "userOrgType": 
            case "userOrgDesc": 
            case "userOrgStatus": {
                Map<String, Object> res2 = this.getOrgInfoByUserId(currentUser.getId());
                Validate.notEmpty(res2, (String)"\u9884\u5236\u4fe1\u606f\u5904\u7406\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u7ec4\u7ec7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                result = res2.get(paramKey);
                break;
            }
            case "userGroup": {
                Set groups = this.userGroupService.findByUserId(currentUser.getId());
                result = CollectionUtils.isEmpty((Collection)groups) ? null : StringUtils.join((Iterable)groups.stream().map(UserGroupVo::getGroupName).collect(Collectors.toList()), (String)",");
                break;
            }
            case "userRole": {
                List roles = this.roleService.findAllByUserId(currentUser.getId());
                result = CollectionUtils.isEmpty((Collection)roles) ? null : StringUtils.join((Iterable)roles.stream().map(RoleVo::getRoleName).collect(Collectors.toList()), (String)",");
                break;
            }
            case "currentUserLogOutTime": {
                result = currentUser.getLastloginTime();
                break;
            }
            case "currentUserLoginTime": {
                result = currentUser.getEntryTime();
                break;
            }
            case "nowDateMonth": 
            case "nowDateDay": 
            case "nowDateMinute": 
            case "nowDateSecond": {
                result = new Date();
                break;
            }
        }
        return result;
    }

    private Map<String, Object> getPositionInfoByUserId(String id) {
        Validate.notBlank((CharSequence)"\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u65f6\uff0c\u4f20\u5165\u7684\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!");
        PositionVo p1 = this.positionService.findByUserId(id);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("userPositionId", p1 == null ? null : p1.getId());
        result.put("userPosition", p1 == null ? null : p1.getName());
        result.put("userPositionCode", p1 == null ? null : p1.getCode());
        result.put("userPositionStatus", p1 == null ? null : p1.getTstatus());
        return result;
    }

    private Map<String, Object> getOrgInfoByUserId(String id) {
        Validate.notBlank((CharSequence)"\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u65f6\uff0c\u4f20\u5165\u7684\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!");
        OrganizationVo o1 = this.organizationService.findOrgByUserId(id);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("userOrgId", o1 == null ? null : o1.getId());
        result.put("userOrg", o1 == null ? null : o1.getOrgName());
        result.put("userOrgType", o1 == null ? null : o1.getType());
        result.put("userOrgDesc", o1 == null ? null : o1.getDescription());
        result.put("userPositionCode", o1 == null ? null : o1.getCode());
        result.put("userPositionStatus", o1 == null ? null : o1.getTstatus());
        return result;
    }
}

