/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dynamic;

import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DynamicDataSourceTaskAspect {
    @Autowired
    private DynamicDataSourceManager dynamicDataSourceManager;
    private static final String ERROR_MESS = "\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u8c03\u7528\u65f6\uff0c\u81f3\u5c11\u9700\u8981\u4f20\u5165dataSourceCode(java.lang.String)\u53c2\u6570\u503c!!";
    private static final String ERROR_MESS_CODE = "\u672a\u53d1\u73b0\u6307\u5b9adataSourceCode(%s)\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u4fe1\u606f,\u8bf7\u68c0\u67e5";
    private static Logger LOGGER = LoggerFactory.getLogger(DynamicDataSourceTaskAspect.class);

    @Pointcut(value="@annotation(org.springframework.scheduling.annotation.Async)")
    public void aspectHandle() {
    }

    @Before(value="aspectHandle() && @annotation(async)", argNames="async")
    public void before(JoinPoint point, Async async) {
        if (!this.checkAsync(async)) {
            return;
        }
        MethodInvocationProceedingJoinPoint methodJoinPoint = (MethodInvocationProceedingJoinPoint)point;
        Object[] args = methodJoinPoint.getArgs();
        Validate.isTrue((args != null && args.length > 0 ? 1 : 0) != 0, (String)ERROR_MESS, (Object[])new Object[0]);
        List notNullArgs = Arrays.stream(args).filter(item -> item != null).collect(Collectors.toList());
        List notNullArgsClasses = notNullArgs.stream().map(Object::getClass).collect(Collectors.toList());
        Validate.isTrue((!notNullArgsClasses.isEmpty() ? 1 : 0) != 0, (String)ERROR_MESS, (Object[])new Object[0]);
        LinkedList<Integer> stringClassIndexs = new LinkedList<Integer>();
        for (int index = 0; index < notNullArgsClasses.size(); ++index) {
            Class notNullArgsClass = (Class)notNullArgsClasses.get(index);
            if (notNullArgsClass != String.class) continue;
            stringClassIndexs.add(index);
        }
        Validate.isTrue((!stringClassIndexs.isEmpty() ? 1 : 0) != 0, (String)ERROR_MESS, (Object[])new Object[0]);
        String dataSourceCode = null;
        if (stringClassIndexs.size() != 1) {
            throw new IllegalArgumentException("\u76ee\u524d\u7248\u672c\u652f\u6301\u7684\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u8c03\u7528\u65f6\uff0c\u53ea\u652f\u6301\u4f20\u5165\u4e00\u4e2a\u5b57\u7b26\u4e32\u7c7b\u578b\u7684\u53c2\u6570dataSourceCode(java.lang.String)!!");
        }
        dataSourceCode = notNullArgs.get((Integer)stringClassIndexs.get(0)).toString();
        SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
        Validate.notNull((Object)sessionFactory, (String)ERROR_MESS_CODE, (Object[])new Object[]{dataSourceCode});
        Session currentSession = sessionFactory.getCurrentSession();
        if (currentSession == null || !currentSession.isOpen()) {
            currentSession = sessionFactory.openSession();
        }
        currentSession.beginTransaction();
        LOGGER.debug("before()");
    }

    private boolean checkAsync(Async async) {
        if (async == null) {
            return false;
        }
        String asyncValue = async.value();
        return !StringUtils.isBlank((CharSequence)asyncValue) && StringUtils.equals((CharSequence)asyncValue, (CharSequence)"dynamicExecutor");
    }

    @AfterReturning(value="aspectHandle() && @annotation(async)", argNames="async")
    public void afterReturning(JoinPoint point, Async async) {
        if (!this.checkAsync(async)) {
            return;
        }
        String dataSourceCode = this.getDataSourceCode(point);
        SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
        Validate.notNull((Object)sessionFactory, (String)ERROR_MESS_CODE, (Object[])new Object[]{dataSourceCode});
        Session currentSession = sessionFactory.getCurrentSession();
        if (currentSession == null || !currentSession.isOpen()) {
            currentSession = sessionFactory.openSession();
        }
        if (!currentSession.isOpen()) {
            return;
        }
        Transaction transaction = currentSession.getTransaction();
        if (transaction.getStatus() == TransactionStatus.ACTIVE) {
            transaction.commit();
        } else {
            currentSession.close();
        }
        LOGGER.debug("afterReturning()");
    }

    @AfterThrowing(value="aspectHandle() && @annotation(async)", argNames="async")
    public void afterThrowing(JoinPoint point, Async async) {
        if (!this.checkAsync(async)) {
            return;
        }
        String dataSourceCode = this.getDataSourceCode(point);
        SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
        Validate.notNull((Object)sessionFactory, (String)ERROR_MESS_CODE, (Object[])new Object[]{dataSourceCode});
        Session currentSession = sessionFactory.getCurrentSession();
        if (currentSession == null || !currentSession.isOpen()) {
            currentSession = sessionFactory.openSession();
        }
        if (!currentSession.isOpen()) {
            return;
        }
        Transaction transaction = currentSession.getTransaction();
        if (transaction.getStatus() == TransactionStatus.ACTIVE) {
            transaction.rollback();
        } else {
            currentSession.close();
        }
        LOGGER.debug("afterThrowing()");
    }

    private String getDataSourceCode(JoinPoint point) {
        MethodInvocationProceedingJoinPoint methodJoinPoint = (MethodInvocationProceedingJoinPoint)point;
        Object[] args = methodJoinPoint.getArgs();
        List notNullArgs = Arrays.stream(args).filter(item -> item != null).collect(Collectors.toList());
        List notNullArgsClasses = notNullArgs.stream().map(Object::getClass).collect(Collectors.toList());
        String dataSourceCode = null;
        for (int index = 0; index < notNullArgsClasses.size(); ++index) {
            Class notNullArgsClass = (Class)notNullArgsClasses.get(index);
            if (notNullArgsClass != String.class) continue;
            dataSourceCode = notNullArgs.get(index).toString();
            break;
        }
        return dataSourceCode;
    }
}

