/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.repository.internal.UserRepositoryCustom;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="UserRepositoryImpl")
public class UserRepositoryImpl
implements UserRepositoryCustom {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    private static final String USER_NAME = "userName";
    private static final String ACCOUNT = "account";
    private static final String USE_STATUS = "useStatus";

    @Override
    public Page<UserEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
        Object useStatus;
        Object account;
        String hql = "from UserEntity u left join fetch u.roles where 1 = 1";
        String countHql = "select count(*) from UserEntity u where 1 = 1";
        Object userName = conditions.get(USER_NAME);
        if (userName != null) {
            hql = hql + " AND u.userName = :userName ";
            countHql = countHql + " AND u.userName = :userName ";
        }
        if ((account = conditions.get(ACCOUNT)) != null) {
            hql = hql + " AND u.account = :account ";
            countHql = countHql + " AND u.account = :account ";
        }
        if ((useStatus = conditions.get(USE_STATUS)) != null) {
            hql = hql + " AND u.useStatus = :useStatus ";
            countHql = countHql + " AND u.useStatus = :useStatus ";
        }
        hql = hql + " order by u.createTime desc ";
        Query query = this.entityManager.createQuery(hql);
        Query countQuery = this.entityManager.createQuery(countHql);
        if (userName != null) {
            query.setParameter(USER_NAME, userName);
            countQuery.setParameter(USER_NAME, userName);
        }
        if (account != null) {
            query.setParameter(ACCOUNT, account);
            countQuery.setParameter(ACCOUNT, account);
        }
        if (useStatus != null) {
            query.setParameter(USE_STATUS, useStatus);
            countQuery.setParameter(USE_STATUS, useStatus);
        }
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List resutls = query.getResultList();
        long count = (Long)countQuery.getResultList().get(0);
        PageImpl currentPage = new PageImpl(resutls, pageable, count);
        return currentPage;
    }
}

