/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.migrate;

import com.bizunited.platform.core.entity.MigrateImportEntity;
import com.bizunited.platform.core.repository.migrate.MigrateImportRepositoryCustom;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="MigrateImportRepositoryImpl")
public class MigrateImportRepositoryImpl
implements MigrateImportRepositoryCustom {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    private static final String MESS_FILE_TYPE = "fileType";
    private static final String MESS_CODE = "code";
    private static final String MESS_EXECUTED = "executed";

    @Override
    public Page<MigrateImportEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
        Object executed;
        Object code;
        String hql = "from MigrateImportEntity u where 1 = 1";
        String countHql = "select count(*) from MigrateImportEntity u where 1 = 1 ";
        Object fileType = conditions.get(MESS_FILE_TYPE);
        if (fileType != null) {
            hql = hql + " AND u.fileType = :fileType ";
            countHql = countHql + " AND u.fileType = :fileType ";
        }
        if ((code = conditions.get(MESS_CODE)) != null) {
            hql = hql + " AND u.code = :code ";
            countHql = countHql + " AND u.code = :code ";
        }
        if ((executed = conditions.get(MESS_EXECUTED)) != null) {
            hql = hql + " AND u.executed = :executed ";
            countHql = countHql + " AND u.executed = :executed ";
        }
        hql = hql + " order by u.createTime desc ";
        Query query = this.entityManager.createQuery(hql);
        Query countQuery = this.entityManager.createQuery(countHql);
        if (fileType != null) {
            query.setParameter(MESS_FILE_TYPE, fileType);
            countQuery.setParameter(MESS_FILE_TYPE, fileType);
        }
        if (code != null) {
            query.setParameter(MESS_CODE, code);
            countQuery.setParameter(MESS_CODE, code);
        }
        if (executed != null) {
            query.setParameter(MESS_EXECUTED, executed);
            countQuery.setParameter(MESS_EXECUTED, executed);
        }
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List results = query.getResultList();
        long count = (Long)countQuery.getResultList().get(0);
        PageImpl currentPage = new PageImpl(results, pageable, count);
        return currentPage;
    }
}

