/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.image;

import com.bizunited.platform.core.entity.OrdinaryFileEntity;
import com.bizunited.platform.core.repository.OrdinaryFileRepository;
import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.core.service.image.FileUpdateService;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="ImageUpdateServiceImpl")
public class FileUpdateServiceImpl
implements FileUpdateService {
    private final Logger LOGGER = LoggerFactory.getLogger(FileUpdateServiceImpl.class);
    @Value(value="${kuiper.file.maxFileSize}")
    private Integer maxFileSize;
    @Value(value="${kuiper.file.whitePrefixs}")
    private String[] whitePrefixs;
    @Autowired
    private NebulaFileService nebulaFileService;
    @Autowired
    private OrdinaryFileRepository ordinaryFileRepository;

    @Override
    @Transactional
    public List<OrdinaryFileEntity> fileUpload(String subSystem, String creator, Integer effective, MultipartFile[] files) throws IllegalArgumentException {
        Validate.notNull((Object)(files != null && files.length > 0 ? 1 : 0), (String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4fe1\u606f\u81f3\u5c11\u6709\u4e00\u4e2a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)creator, (String)"\u9644\u4ef6\u7684\u63d0\u4ea4\u4eba\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedList<OrdinaryFileEntity> ordinaryFileEntitys = new LinkedList<OrdinaryFileEntity>();
        for (MultipartFile file : files) {
            byte[] fileContext = null;
            try {
                fileContext = file.getBytes();
            }
            catch (Exception e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e);
            }
            String originalFilename = file.getOriginalFilename();
            int prefixIndex = originalFilename.lastIndexOf(46);
            OrdinaryFileEntity result = this.saveOrdinaryFile(prefixIndex, originalFilename, subSystem, effective, creator, fileContext);
            ordinaryFileEntitys.add(result);
        }
        this.ordinaryFileRepository.saveAll(ordinaryFileEntitys);
        return ordinaryFileEntitys;
    }

    private OrdinaryFileEntity saveOrdinaryFile(int prefixIndex, String originalFilename, String subSystem, Integer effective, String creator, byte[] fileContext) {
        String prefix = null;
        if (prefixIndex != -1) {
            prefix = originalFilename.substring(prefixIndex + 1);
            prefix = prefix.toLowerCase();
        }
        Date nowDate = new Date();
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String renameImage = UUID.randomUUID().toString();
        String relativePath = null;
        relativePath = !StringUtils.isBlank((CharSequence)subSystem) ? StringUtils.join((Object[])new Serializable[]{"/", subSystem, "/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)}) : StringUtils.join((Object[])new Serializable[]{"/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        String fileRename = StringUtils.join((Object[])new String[]{renameImage, ".", prefix});
        OrdinaryFileEntity result = this.fileUpload(relativePath, originalFilename, fileRename, prefix, effective, creator, fileContext);
        return result;
    }

    @Override
    @Transactional
    public List<OrdinaryFileEntity> fileUpload(String subSystem, String creator, Integer effective, String[] fileNanmes, String[] base64Contents) {
        Validate.notBlank((CharSequence)creator, (String)"\u6587\u4ef6\u7684\u63d0\u4ea4\u4eba\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (base64Contents == null || base64Contents.length == 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684base64\u7f16\u7801\u6587\u4ef6\u5185\u5bb9!!");
        }
        if (fileNanmes == null || fileNanmes.length == 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u6587\u4ef6\u540d\u6570\u91cf\u4fe1\u606f!!");
        }
        Validate.isTrue((fileNanmes.length == base64Contents.length ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5185\u5bb9\u6570\u91cf\u548c\u6587\u4ef6\u540d\u6570\u91cf\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedList<OrdinaryFileEntity> ordinaryFileEntitys = new LinkedList<OrdinaryFileEntity>();
        for (int index = 0; index < fileNanmes.length; ++index) {
            String originalFilename = fileNanmes[index];
            String base64Content = base64Contents[index];
            byte[] fileContext = Base64Utils.decodeFromString((String)base64Content);
            int prefixIndex = originalFilename.lastIndexOf(46);
            OrdinaryFileEntity result = this.saveOrdinaryFile(prefixIndex, originalFilename, subSystem, effective, creator, fileContext);
            ordinaryFileEntitys.add(result);
        }
        this.ordinaryFileRepository.saveAll(ordinaryFileEntitys);
        return ordinaryFileEntitys;
    }

    private OrdinaryFileEntity fileUpload(String relativePath, String originalFilename, String fileRename, String prefix, Integer effective, String creator, byte[] fileContext) {
        this.nebulaFileService.saveFile(relativePath, originalFilename, fileRename, fileContext);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date effectiveDate = null;
        try {
            effectiveDate = simpleDateFormat.parse("3999-01-01 00:00:00");
        }
        catch (ParseException e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        if (effective != null) {
            Validate.isTrue((effective > 0 ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u6709\u6548\u671f\u65f6\u957f\uff08\u5355\u4f4d\u201c\u5929\u201d\uff09, \u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, effective);
            effectiveDate = calendar.getTime();
        }
        OrdinaryFileEntity result = new OrdinaryFileEntity();
        result.setCommitUser(creator);
        result.setRelativeLocal(relativePath);
        result.setFileName(fileRename);
        result.setEffectiveDate(effectiveDate);
        result.setCreateDate(new Date());
        result.setOriginalFileName(originalFilename);
        result.setPrefix(prefix);
        return result;
    }

    @Override
    @Transactional
    public List<OrdinaryFileEntity> fileImageUpload(String subsystem, String creator, Integer effective, MultipartFile[] files) throws IllegalArgumentException {
        Validate.notNull((Object)(files != null && files.length > 0 ? 1 : 0), (String)"\u4e0a\u4f20\u7684\u56fe\u7247\u6587\u4ef6\u4fe1\u606f\u81f3\u5c11\u6709\u4e00\u4e2a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)creator, (String)"\u56fe\u7247\u6587\u4ef6\u7684\u63d0\u4ea4\u4eba\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (MultipartFile file : files) {
            String originalFilename = file.getOriginalFilename();
            String prefix = null;
            int prefixIndex = originalFilename.lastIndexOf(46);
            if (prefixIndex != -1) {
                prefix = originalFilename.substring(prefixIndex + 1);
                prefix = prefix.toLowerCase();
            }
            if (!StringUtils.isBlank(prefix) && (StringUtils.equals((CharSequence)prefix, (CharSequence)"png") || StringUtils.equals((CharSequence)prefix, (CharSequence)"gif") || StringUtils.equals((CharSequence)prefix, (CharSequence)"jpg") || StringUtils.equals((CharSequence)prefix, (CharSequence)"jpeg") || StringUtils.equals((CharSequence)prefix, (CharSequence)"bmp") || StringUtils.equalsAnyIgnoreCase((CharSequence)prefix, (CharSequence[])this.whitePrefixs))) continue;
            throw new IllegalArgumentException("file prefix not be support it(bmp/jpg/png/gif/white prefixs)!");
        }
        return this.fileUpload(subsystem, creator, effective, files);
    }

    @Override
    public List<OrdinaryFileEntity> fileImageUpload(String subsystem, String creator, Integer effective, String[] fileNanmes, String[] base64Contents) {
        Validate.notBlank((CharSequence)creator, (String)"\u56fe\u7247\u6587\u4ef6\u7684\u63d0\u4ea4\u4eba\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (base64Contents == null || base64Contents.length == 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684base64\u7f16\u7801\u6587\u4ef6\u5185\u5bb9!!");
        }
        if (fileNanmes == null || fileNanmes.length == 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u6587\u4ef6\u540d\u6570\u91cf\u4fe1\u606f!!");
        }
        Validate.isTrue((fileNanmes.length == base64Contents.length ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5185\u5bb9\u6570\u91cf\u548c\u6587\u4ef6\u540d\u6570\u91cf\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (int index = 0; index < fileNanmes.length; ++index) {
            String originalFilename = fileNanmes[index];
            String prefix = null;
            int prefixIndex = originalFilename.lastIndexOf(46);
            if (prefixIndex != -1) {
                prefix = originalFilename.substring(prefixIndex + 1);
                prefix = prefix.toLowerCase();
            }
            if (!StringUtils.isBlank(prefix) && (StringUtils.equals((CharSequence)prefix, (CharSequence)"png") || StringUtils.equals((CharSequence)prefix, (CharSequence)"gif") || StringUtils.equals((CharSequence)prefix, (CharSequence)"jpg") || StringUtils.equals((CharSequence)prefix, (CharSequence)"jpeg") || StringUtils.equals((CharSequence)prefix, (CharSequence)"bmp") || StringUtils.equalsAnyIgnoreCase((CharSequence)prefix, (CharSequence[])this.whitePrefixs))) continue;
            throw new IllegalArgumentException("file prefix not be support it(bmp/jpg/png/gif/white prefixs)!");
        }
        return this.fileUpload(subsystem, creator, effective, fileNanmes, base64Contents);
    }

    @Override
    public List<OrdinaryFileEntity> findByEffectiveDate(Date currentDate) {
        if (currentDate == null) {
            return null;
        }
        return this.ordinaryFileRepository.findByEffectiveDate(currentDate);
    }

    @Override
    @Transactional
    public void updateEffective(String[] fileReNames) {
        if (fileReNames == null || fileReNames.length == 0) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date effectiveDate = null;
        try {
            effectiveDate = simpleDateFormat.parse("3999-01-01 00:00:00");
        }
        catch (ParseException e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        for (int index = 0; index < fileReNames.length; ++index) {
            String relativeLocal;
            String fileReNameItem = fileReNames[index];
            int targetIndex = fileReNameItem.lastIndexOf(47);
            String fileReName = fileReNameItem.substring(targetIndex + 1);
            OrdinaryFileEntity currentOrdinaryFile = this.ordinaryFileRepository.findByFileNameAndRelativeLocal(fileReName, relativeLocal = fileReNameItem.substring(0, targetIndex));
            if (currentOrdinaryFile == null) continue;
            currentOrdinaryFile.setEffectiveDate(effectiveDate);
            this.ordinaryFileRepository.save(currentOrdinaryFile);
        }
    }

    @Override
    @Transactional
    public void deleteFiles(String[] fileIds) {
        Validate.notNull((Object)fileIds, (String)"\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u6587\u4ef6\u7684\u6570\u636e\u5e93\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((fileIds.length > 0 ? 1 : 0) != 0, (String)"\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u6587\u4ef6\u7684\u6570\u636e\u5e93\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        for (int index = 0; index < fileIds.length; ++index) {
            String fileId = fileIds[index];
            Optional op = this.ordinaryFileRepository.findById(fileId);
            OrdinaryFileEntity currentOrdinaryFile = op.orElse(null);
            if (currentOrdinaryFile == null) continue;
            this.nebulaFileService.deleteFile(currentOrdinaryFile.getRelativeLocal(), currentOrdinaryFile.getOriginalFileName(), currentOrdinaryFile.getFileName());
            this.ordinaryFileRepository.deleteById(fileId);
        }
    }

    @Override
    @Transactional
    public void deleteFile(String filePath, String fileName) {
        Validate.notNull((Object)filePath, (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileName, (String)"\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrdinaryFileEntity file = this.ordinaryFileRepository.findByFileNameAndRelativeLocal(fileName, StringUtils.trim((String)filePath));
        Validate.notNull((Object)file, (String)"\u5220\u9664\u7684\u6587\u4ef6\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.nebulaFileService.deleteFile(file.getRelativeLocal(), file.getOriginalFileName(), file.getFileName());
        this.ordinaryFileRepository.delete(file);
    }
}

