/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.init;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.entity.CompetenceEntity;
import com.bizunited.platform.core.repository.CompetenceRepository;
import com.bizunited.platform.core.service.init.InitProcessService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCompetenceInitProcess
implements InitProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCompetenceInitProcess.class);
    @Autowired
    private CompetenceRepository competenceRepository;

    @Override
    public int sort() {
        return 0;
    }

    protected void initCompetences(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line = bufferedReader.readLine();
            while (StringUtils.isNotBlank((CharSequence)line)) {
                sb.append(line);
                line = bufferedReader.readLine();
            }
        }
        String json = sb.toString();
        if (StringUtils.isBlank((CharSequence)json)) {
            LOGGER.warn("\u521d\u59cb\u5316\u83dc\u5355json\u4e3a\u7a7a\uff01\uff01");
            return;
        }
        JSONArray competences = JSONArray.parseArray((String)json);
        this.initCompetences(null, competences);
    }

    protected void initCompetences(CompetenceEntity parent, JSONArray competences) {
        if (competences == null || competences.isEmpty()) {
            return;
        }
        for (Object object : competences) {
            JSONObject competenceJson = JSONObject.parseObject((String)object.toString());
            CompetenceEntity competence = (CompetenceEntity)JSONObject.parseObject((String)competenceJson.toJSONString(), CompetenceEntity.class);
            CompetenceEntity oldCompetence = this.competenceRepository.findByComment(competence.getComment());
            if (oldCompetence == null) {
                competence.setCreateDate(new Date());
                competence.setModifyDate(new Date());
                competence.setTstatus(1);
                competence.setParent(parent);
                this.competenceRepository.save(competence);
                oldCompetence = competence;
            }
            if (!competenceJson.containsKey((Object)"competences")) continue;
            this.initCompetences(oldCompetence, competenceJson.getJSONArray("competences"));
        }
    }
}

