/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.init;

import com.bizunited.platform.core.entity.CompetenceEntity;
import com.bizunited.platform.core.entity.RoleEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.repository.CompetenceRepository;
import com.bizunited.platform.core.repository.RoleRepository;
import com.bizunited.platform.core.repository.UserRepository;
import com.bizunited.platform.core.service.init.InitProcessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="rbacInitProcess")
public class RbacInitProcess
implements InitProcessService {
    private static final String ADMIN_NAME = "admin";
    private static final String ADMIN_ROLE_NAME = "ADMIN";
    private static final String BASEROLE_NAME = "BASEROLE";
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private CompetenceRepository competenceRepository;
    @Autowired
    @Qualifier(value="passwordEncoder")
    @Lazy
    private PasswordEncoder passwordEncoder;

    @Override
    public boolean doProcess() {
        return this.roleRepository.findByRoleName(ADMIN_ROLE_NAME) == null || this.roleRepository.findByRoleName(ADMIN_NAME) == null;
    }

    @Override
    public int sort() {
        return 1;
    }

    @Override
    public boolean stopOnException() {
        return true;
    }

    @Override
    public void init() {
        if (this.roleRepository.findByRoleName(BASEROLE_NAME) == null) {
            this.initBaseRole();
            this.initBaseRoleCompetence();
        }
        if (this.roleRepository.findByRoleName(ADMIN_ROLE_NAME) == null) {
            this.initAdminRole();
        }
        if (this.userRepository.findByAccount(ADMIN_NAME) == null) {
            this.initAdmin();
        }
    }

    private void initBaseRole() {
        RoleEntity role = new RoleEntity();
        role.setComment("\u7528\u6237\u57fa\u7840\u89d2\u8272");
        role.setCreateDate(new Date());
        role.setRoleName(BASEROLE_NAME);
        role.setRoleCode(BASEROLE_NAME);
        role.setTstatus(1);
        role.setIsDeny(true);
        this.roleRepository.saveAndFlush(role);
    }

    private void initBaseRoleCompetence() {
        RoleEntity baserole = this.roleRepository.findByRoleName(BASEROLE_NAME);
        Validate.notNull((Object)baserole, (String)"\u521d\u59cb\u5316\u7528\u6237\u57fa\u7840\u89d2\u8272\u65f6\u672a\u627e\u5230\u57fa\u7840\u89d2\u8272!", (Object[])new Object[0]);
        ArrayList<String> resources = new ArrayList<String>();
        resources.add("/v1/rbac/login");
        resources.add("/v1/nebula/files/{subsystem}/fileImageUpload");
        resources.add("/v1/nebula/files/{subsystem}/fileUpload");
        resources.add("/v1/nebula/files/{subsystem}/fileUploadBase64");
        resources.add("/v1/nebula/competences/findByCurrentUser");
        resources.add("/v1/nebula/competences/findByUrlResource");
        resources.add("/v1/nebula/orgs/findOrgByUserId");
        resources.add("/v1/nebula/position/findByUserId");
        resources.add("/v1/nebula/users/findByUserId");
        resources.add("/v1/nebula/environmentVariables/findByKey");
        resources.add("/v1/nebula/users/findByPrincipal");
        resources.add("/v1/nebula/theme/findTheme");
        resources.add("/v1/kuiper/templates/findByConditions");
        resources.add("/v1/kuiper/templates/maintainer/loadAuthorProps");
        resources.add("/v1/kuiper/templates/findDetailsById");
        resources.add("/v1/kuiper/templateLayouts/findDetailsByTemplateId");
        resources.add("/v1/kuiper/templateEvents/findByTemplateId");
        resources.add("/v1/kuiper/templatevisibilities/findDetailsByTemplateId");
        resources.add("/v1/kuiper/templateStyles/findAll");
        resources.add("/v1/kuiper/listTemplates/findByConditions");
        resources.add("/v1/kuiper/listTemplates/findDetailsById");
        resources.add("/v1/kuiper/listTemplates/findConentById");
        resources.add("/v1/kuiper/dataViews/mainExecuteByPage");
        resources.add("/v1/titan/templates/findByConditions");
        resources.add("/v1/titan/templates/findDetailsById");
        resources.add("/v1/titan/listeners/findByConditions");
        resources.add("/v1/titan/template/node/permissions/findByConditions");
        resources.add("/v1/titan/template/node/permissions");
        resources.add("/v1/titan/templates/findStartableByConditions");
        resources.add("/v1/titan/instances/startProcess");
        resources.add("/v1/titan/instances/findDetailsByProcessInstanceId");
        resources.add("/v1/titan/tasks/findTaskInfoByInstanceIdAndTaskKey");
        resources.add("/v1/titan/instance/msgs/findByProcessInstanceId");
        resources.add("/v1/titan/instances/findImageInfoByProcessInstanceId");
        resources.add("/v1/titan/instances/findByConditions");
        resources.add("/v1/titan/tasks/findDoneByConditions");
        resources.add("/v1/titan/tasks/findMyTasksByConditions");
        resources.add("/v1/titan/carbonCopies/findMyByConditions");
        resources.add("/v1/kuiper/templates");
        resources.add("/template");
        resources.add("/listTemplate");
        resources.add("/flowcontrol");
        resources.add("/monitor");
        resources.add("/operation");
        resources.add("/flowInstance/useableFlowTemp");
        resources.add("/flowInstance/launchBySelf");
        resources.add("/flowInstance/done");
        resources.add("/flowInstance/waiting");
        resources.add("/flowInstance/copy");
        resources.add("/flowInstance/list");
        resources.add("/v1/kuiper/dataViews/mainExecute");
        resources.add("/v1/kuiper/frontFiles/findByConditions");
        resources.add("/v1/kuiper/instances/findByConditions");
        for (String resource : resources) {
            List<CompetenceEntity> competenceEntities = this.competenceRepository.findByResource(resource);
            if (CollectionUtils.isEmpty(competenceEntities)) continue;
            List ids = competenceEntities.stream().map(p -> p.getId()).collect(Collectors.toList());
            for (String id : ids) {
                if (this.competenceRepository.countByRoleIdAndCompetenceId(baserole.getId(), id) != 0) continue;
                this.competenceRepository.bindCompetence(baserole.getId(), id);
            }
        }
    }

    private void initAdminRole() {
        RoleEntity role = new RoleEntity();
        role.setComment("\u7ba1\u7406\u5458\u89d2\u8272");
        role.setCreateDate(new Date());
        role.setRoleName(ADMIN_ROLE_NAME);
        role.setRoleCode(ADMIN_ROLE_NAME);
        role.setTstatus(1);
        role.setIsDeny(true);
        this.roleRepository.saveAndFlush(role);
    }

    private void initAdmin() {
        UserEntity admin = new UserEntity();
        admin.setAccount(ADMIN_NAME);
        admin.setGender(0);
        admin.setPassword(this.passwordEncoder.encode((CharSequence)"12345678"));
        admin.setPhone("12345678");
        admin.setUserName("\u540e\u53f0\u8d85\u7ea7\u7ba1\u7406\u5458");
        admin.setUseStatus(1);
        this.userRepository.saveAndFlush(admin);
        RoleEntity adminRole = this.roleRepository.findByRoleName(ADMIN_ROLE_NAME);
        this.roleRepository.bindUser(admin.getId(), adminRole.getId());
    }
}

