/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.init;

import com.bizunited.platform.core.annotations.NebulaService;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.common.constant.ParamClassTypeConst;
import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.entity.ServicableMethodPropertyEntity;
import com.bizunited.platform.core.service.NebulaStaticPersistentService;
import com.bizunited.platform.core.service.init.InitProcessService;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.SpringProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;

@Component(value="ServicableMethodInitProcess")
public class ServicableMethodInitProcess
implements InitProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicableMethodInitProcess.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private NebulaStaticPersistentService nebulaStaticPersistentService;
    @Autowired
    private ServicableMethodService servicableMethodService;
    private ClassPool pool = ClassPool.getDefault();

    @Override
    public boolean doProcess() {
        return true;
    }

    @Override
    public int sort() {
        return 5;
    }

    @Override
    public boolean stopOnException() {
        return true;
    }

    @Override
    public void init() {
        try {
            this.initServicableMethod();
        }
        catch (ClassNotFoundException | NotFoundException e) {
            LOGGER.error(e.getMessage(), e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private void initServicableMethod() throws NotFoundException, ClassNotFoundException {
        LOGGER.info("\u542f\u52a8\u5668\u6b63\u5728\u8fdb\u884c\u521d\u59cb\u5316\u670d\u52a1\u65b9\u6cd5\u626b\u63cf.......");
        Map beanMapping = this.applicationContext.getBeansWithAnnotation(NebulaService.class);
        Collection mappingAnnotations = beanMapping.values();
        this.servicableMethodService.deleteServiceMethodAndProperties();
        if (mappingAnnotations == null || mappingAnnotations.isEmpty()) {
            return;
        }
        ArrayList serviceMethods = new ArrayList();
        for (Object mappingAnnotationItem : mappingAnnotations) {
            Class<?> targetClass = mappingAnnotationItem.getClass();
            LinkedHashSet currentInterfaces = new LinkedHashSet();
            this.recursionFindInterface(targetClass, currentInterfaces);
            if (currentInterfaces.isEmpty()) continue;
            LinkedList<CtClass> implInterfaceClasses = new LinkedList<CtClass>();
            for (Class clazz : currentInterfaces) {
                implInterfaceClasses.add(this.pool.getCtClass(clazz.getName()));
            }
            implInterfaceClasses.stream().map(CtClass::getDeclaredMethods).forEach(arrayItems -> Arrays.stream(arrayItems).filter(item -> item.hasAnnotation(NebulaServiceMethod.class)).forEach(item -> serviceMethods.add(item)));
        }
        ArrayList<ServicableMethodEntity> serviceMethodReops = new ArrayList<ServicableMethodEntity>();
        for (CtMethod ctMethod : serviceMethods) {
            ServicableMethodEntity serviceMethodReop = new ServicableMethodEntity();
            NebulaServiceMethod serviceMethodAnno = (NebulaServiceMethod)ctMethod.getAnnotation(NebulaServiceMethod.class);
            String serviceMethodAnnoName = serviceMethodAnno.name();
            if (StringUtils.isBlank((CharSequence)serviceMethodAnnoName)) {
                LOGGER.warn("\u6307\u5b9a\u7684kuiperServiceMethodAnno[" + serviceMethodAnnoName + "]\u6ca1\u6709\u8bbe\u5b9aname\uff0c\u8bf7\u68c0\u67e5!!");
                continue;
            }
            String string = serviceMethodAnno.desc();
            if (StringUtils.isBlank((CharSequence)string)) {
                LOGGER.warn("\u6307\u5b9a\u7684kuiperServiceMethodAnno[" + serviceMethodAnnoName + "]\u6ca1\u6709\u8bbe\u5b9adesc\uff0c\u8bf7\u68c0\u67e5!!");
                continue;
            }
            String returnPropertiesFilter = serviceMethodAnno.returnPropertiesFilter();
            String methodSimpleName = ctMethod.getName();
            String className = ctMethod.getDeclaringClass().getName();
            Validate.isTrue((!serviceMethodReops.stream().map(ServicableMethodEntity::getName).filter(item -> StringUtils.equals((CharSequence)item, (CharSequence)serviceMethodAnnoName)).findAny().isPresent() ? 1 : 0) != 0, (String)("\u5728\u8fdb\u884c\u670d\u52a1\u66b4\u9732\u5b9a\u4e49\u5206\u6790\u65f6\uff0c\u53d1\u73b0\u6709\u91cd\u590d\u7684name[" + serviceMethodAnnoName + "]\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            this.analysisWriteMethodAnno(serviceMethodAnno, serviceMethodReop, ctMethod);
            serviceMethodReop.setUsedScope(serviceMethodAnno.scope().name());
            serviceMethodReop.setDescription(string);
            serviceMethodReop.setInterfaceName(className);
            String methodName = StringUtils.join((Object[])new String[]{className, ".", methodSimpleName});
            serviceMethodReop.setMethodName(methodName);
            serviceMethodReop.setName(serviceMethodAnnoName);
            serviceMethodReop.setSimpleMethodName(methodSimpleName);
            serviceMethodReop.setReturnPropertiesFilter(returnPropertiesFilter);
            this.analysisMethodParameters(serviceMethodReop, ctMethod);
            this.analysisMethodReturnParameter(serviceMethodReop, ctMethod);
            serviceMethodReops.add(serviceMethodReop);
            this.servicableMethodService.create(serviceMethodReop);
        }
    }

    private void analysisWriteMethodAnno(NebulaServiceMethod serviceMethodAnno, ServicableMethodEntity serviceMethodReop, CtMethod ctMethod) throws ClassNotFoundException, NotFoundException {
        if (serviceMethodAnno.scope() != NebulaServiceMethod.ScopeType.WRITE) {
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)serviceMethodAnno.recordQuery()), (String)"%s\u7c7b%s\u65b9\u6cd5\u662fREAD\u6027\u8d28\u7684\u64cd\u4f5c\uff0c\u4e0d\u80fd\u542b\u6709recordQuery\u6ce8\u91ca\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{ctMethod.getDeclaringClass().getSimpleName(), ctMethod.getName()});
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)serviceMethodAnno.recoveryService()), (String)"%s\u7c7b%s\u65b9\u6cd5\u662fREAD\u6027\u8d28\u7684\u64cd\u4f5c\uff0c\u4e0d\u80fd\u542b\u6709recordUpdate\u6ce8\u91ca\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{ctMethod.getDeclaringClass().getSimpleName(), ctMethod.getName()});
            return;
        }
        if (StringUtils.isBlank((CharSequence)serviceMethodAnno.recordQuery())) {
            serviceMethodReop.setRecordQuery(StringUtils.join((Object[])new String[]{StringUtils.substringAfterLast((String)ctMethod.getDeclaringClass().getName(), (String)"."), ".findDetailsByFormInstanceId"}));
        } else {
            this.checkMethodExist(serviceMethodAnno.recordQuery(), ctMethod, serviceMethodAnno.scope());
            serviceMethodReop.setRecordQuery(serviceMethodAnno.recordQuery());
        }
        if (StringUtils.isNotBlank((CharSequence)serviceMethodAnno.recoveryService())) {
            this.checkMethodExist(serviceMethodAnno.recoveryService(), ctMethod, serviceMethodAnno.scope());
            serviceMethodReop.setRecordUpdate(serviceMethodAnno.recoveryService());
        } else {
            serviceMethodReop.setRecordUpdate(serviceMethodAnno.name());
        }
    }

    private void checkMethodExist(String specityMethodName, CtMethod ctMethod, NebulaServiceMethod.ScopeType type) throws ClassNotFoundException, NotFoundException {
        String className = ctMethod.getDeclaringClass().getName();
        String[] specityMethodNames = StringUtils.split((String)specityMethodName, (String)".");
        Validate.isTrue((specityMethodNames.length == 2 ? 1 : 0) != 0, (String)"%s\u7c7b\u7684\u81ea\u5b9a\u4e49\u65e5\u5fd7\u670d\u52a1\u65b9\u6cd5\u540d\u79f0\u4e0d\u7b26\u5408\u89c4\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{className});
        String simpleClassName = StringUtils.substringAfterLast((String)className, (String)".");
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)specityMethodNames[0], (CharSequence)simpleClassName), (String)"%s\u7c7b\u7684\u81ea\u5b9a\u4e49\u65e5\u5fd7\u670d\u52a1\u65b9\u6cd5\u540d\u79f0\u4e0d\u7b26\u5408\u89c4\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{className});
        Class<?> clazz = Class.forName(className);
        Object[] methods = clazz.getMethods();
        Validate.notEmpty((Object[])methods, (String)"\u6839\u636e%s\u7c7b\u672a\u80fd\u83b7\u53d6\u5230\u4efb\u4f55\u7684\u65b9\u6cd5\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{className});
        boolean methodExist = false;
        int count = 0;
        int paramCount = 0;
        for (Object method : methods) {
            if (!StringUtils.equals((CharSequence)(simpleClassName + "." + ((Method)method).getName()), (CharSequence)specityMethodName)) continue;
            methodExist = true;
            ++count;
            paramCount = ((Method)method).getParameterCount();
        }
        Validate.isTrue((boolean)methodExist, (String)"%s\u7c7b\u672a\u80fd\u83b7\u53d6\u5230%s\u65b9\u6cd5\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{simpleClassName, specityMethodName});
        Validate.isTrue((count == 1 ? 1 : 0) != 0, (String)"%s\u7c7b%s\u65b9\u6cd5\uff0c\u83b7\u53d6\u5230\u591a\u4e2a\u540c\u540d\u65b9\u6cd5\u5b9a\u4e49\uff0c\u8bf7\u53d8\u66f4\u65b9\u6cd5\u540d!!", (Object[])new Object[]{simpleClassName, specityMethodName});
        if (type == NebulaServiceMethod.ScopeType.READ) {
            Validate.isTrue((paramCount == 1 ? 1 : 0) != 0, (String)"%s\u7c7b%s\u65b9\u6cd5\u53c2\u6570\u53ea\u80fd\u4e3a\u4e00\u4e2a\uff0c\u8bf7\u53d8\u66f4\u65b9\u6cd5\u53c2\u6570!!", (Object[])new Object[]{simpleClassName, specityMethodName});
        }
    }

    private void recursionFindInterface(Class<?> targetClass, Set<Class<?>> currentInterfaces) {
        Class<?>[] interfaces;
        if (SpringProxy.class.isAssignableFrom(targetClass)) {
            String cglibClassName = targetClass.getName();
            String realClassName = cglibClassName.split("\\$\\$")[0];
            Class<?> realClass = null;
            try {
                realClass = Class.forName(realClassName);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn(e.getMessage());
            }
            if (realClass != null) {
                this.recursionFindInterface(realClass, currentInterfaces);
            }
            return;
        }
        if (targetClass.isInterface()) {
            currentInterfaces.add(targetClass);
        }
        if ((interfaces = targetClass.getInterfaces()) != null && interfaces.length > 0) {
            for (Class<?> interfaceItem : interfaces) {
                this.recursionFindInterface(interfaceItem, currentInterfaces);
            }
        }
    }

    private void analysisMethodParameters(ServicableMethodEntity serviceMethodReop, CtMethod ctMethod) throws NotFoundException, ClassNotFoundException {
        ServicableMethodPropertyEntity methodPropertyEntity;
        String className = ctMethod.getDeclaringClass().getName();
        String methodName = ctMethod.getName();
        LinkedHashSet<ServicableMethodPropertyEntity> serviceMethodProperties = new LinkedHashSet<ServicableMethodPropertyEntity>();
        CtClass[] parameterTypes = ctMethod.getParameterTypes();
        if (parameterTypes == null || parameterTypes.length == 0) {
            return;
        }
        HashMap baseParameters = new HashMap();
        HashMap<Integer, CtClass> objectParameters = new HashMap<Integer, CtClass>();
        HashMap<Integer, CtClass> pageParameters = new HashMap<Integer, CtClass>();
        HashMap<Integer, CtClass> principalParameters = new HashMap<Integer, CtClass>();
        HashMap<Integer, CtClass> mapParameters = new HashMap<Integer, CtClass>();
        Object[][] paramAnno = ctMethod.getParameterAnnotations();
        for (int index = 0; index < parameterTypes.length; ++index) {
            CtClass parameterTypeItem = parameterTypes[index];
            boolean flag = false;
            HashMap<Integer, CtClass> maps = baseParameters.get(parameterTypeItem.getName()) == null ? new HashMap<Integer, CtClass>() : (Map)baseParameters.get(parameterTypeItem.getName());
            String baseParamName = parameterTypeItem.getName().replaceAll("\\[\\]", "");
            if (ParamClassTypeConst.getBaseParamClassTypeList().contains(baseParamName) || ParamClassTypeConst.getBaseParamSpecialTypeList().contains(baseParamName)) {
                maps.put(index, parameterTypeItem);
                baseParameters.put(parameterTypeItem.getName(), maps);
                continue;
            }
            for (String specialType : ParamClassTypeConst.getBaseParamSpecialTypeList()) {
                if (!this.pool.getCtClass(baseParamName).subtypeOf(this.pool.getCtClass(specialType))) continue;
                maps.put(index, parameterTypeItem);
                baseParameters.put(parameterTypeItem.getName(), maps);
                flag = true;
                break;
            }
            if (flag) continue;
            if (parameterTypeItem.subtypeOf(this.pool.getCtClass(InvokeParams.class.getName()))) {
                mapParameters.put(index, parameterTypeItem);
                continue;
            }
            if (parameterTypeItem.subtypeOf(this.pool.getCtClass("java.security.Principal"))) {
                principalParameters.put(index, parameterTypeItem);
                continue;
            }
            if (parameterTypeItem.subtypeOf(this.pool.getCtClass("org.springframework.data.domain.Pageable"))) {
                pageParameters.put(index, parameterTypeItem);
                continue;
            }
            String parameterClaaName = parameterTypeItem.getName();
            Validate.isTrue((this.nebulaStaticPersistentService.findByPersistentClass(parameterClaaName) != null ? 1 : 0) != 0, (String)("\u5728\u626b\u63cf\u670d\u52a1\u66b4\u9732[" + className + ":" + methodName + "]\u65f6\uff0c\u53d1\u73b0\u6709\u4e0d\u80fd\u8bc6\u522b\u7684\u53c2\u6570\u5bf9\u8c61\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            objectParameters.put(index, parameterTypeItem);
        }
        CtClass parameterTypeItem = null;
        Integer parameterAnnoIndex = null;
        if (baseParameters.size() == 1) {
            Map map = (Map)baseParameters.values().iterator().next();
            for (Map.Entry entry : map.entrySet()) {
                parameterTypeItem = (CtClass)entry.getValue();
                parameterAnnoIndex = (Integer)entry.getKey();
                Validate.isTrue((boolean)Arrays.stream(paramAnno[parameterAnnoIndex]).findAny().filter(e -> e instanceof ServiceMethodParam).isPresent(), (String)("\u5728\u626b\u63cf\u670d\u52a1\u66b4\u9732[" + className + ":" + methodName + "]\u65f6\uff0c\u89c4\u5b9a\u7684\u57fa\u672c\u7c7b\u578b\u53c2\u6570\u4e0a\u5e76\u6ca1\u6709\u53d1\u73b0ServiceMethodParam\u6ce8\u89e3\u6807\u6ce8\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
                methodPropertyEntity = this.buildMethodPropertyEntity(parameterTypeItem.getName(), 1, parameterAnnoIndex, null, serviceMethodReop, paramAnno);
                serviceMethodProperties.add(methodPropertyEntity);
            }
        } else if (baseParameters.size() > 1) {
            Set paramClassTypes = baseParameters.keySet();
            for (String v : paramClassTypes) {
                Map sameBaseParamsMap = (Map)baseParameters.get(v);
                if (sameBaseParamsMap.size() == 1) {
                    Validate.isTrue((boolean)Arrays.stream(paramAnno[(Integer)sameBaseParamsMap.keySet().iterator().next()]).findAny().filter(e -> e instanceof ServiceMethodParam).isPresent(), (String)("\u5728\u626b\u63cf\u670d\u52a1\u66b4\u9732[" + className + ":" + methodName + "]\u65f6\uff0c\u89c4\u5b9a\u7684\u57fa\u672c\u7c7b\u578b\u53c2\u6570\u4e0a\u5e76\u6ca1\u6709\u53d1\u73b0ServiceMethodParam\u6ce8\u89e3\u6807\u6ce8\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
                    ServicableMethodPropertyEntity methodPropertyEntity2 = this.buildMethodPropertyEntity(((CtClass)sameBaseParamsMap.values().iterator().next()).getName(), 1, (Integer)sameBaseParamsMap.keySet().iterator().next(), null, serviceMethodReop, paramAnno);
                    serviceMethodProperties.add(methodPropertyEntity2);
                    continue;
                }
                Set indexSet = sameBaseParamsMap.keySet();
                for (Integer index : indexSet) {
                    Validate.isTrue((boolean)Arrays.stream(paramAnno[index]).findAny().filter(item -> item instanceof ServiceMethodParam).isPresent(), (String)("\u5728\u626b\u63cf\u670d\u52a1\u66b4\u9732[" + className + ":" + methodName + "]\u65f6\uff0c\u89c4\u5b9a\u7684\u57fa\u672c\u7c7b\u578b\u53c2\u6570\u4e0a\u5e76\u6ca1\u6709\u53d1\u73b0ServiceMethodParam\u6ce8\u89e3\u6807\u6ce8\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
                    ServicableMethodPropertyEntity methodPropertyEntity3 = this.buildMethodPropertyEntity(((CtClass)sameBaseParamsMap.get(index)).getName(), 1, index, null, serviceMethodReop, paramAnno);
                    serviceMethodProperties.add(methodPropertyEntity3);
                }
            }
        }
        parameterTypeItem = null;
        parameterAnnoIndex = null;
        if (principalParameters.size() > 0) {
            Set parameterIndexs = principalParameters.keySet();
            for (Integer parameterIndex : parameterIndexs) {
                parameterTypeItem = (CtClass)principalParameters.get(parameterIndex);
                parameterAnnoIndex = parameterIndex;
                methodPropertyEntity = this.buildMethodPropertyEntity(parameterTypeItem.getName(), 2, parameterAnnoIndex, null, serviceMethodReop, paramAnno);
                serviceMethodProperties.add(methodPropertyEntity);
            }
        }
        parameterTypeItem = null;
        parameterAnnoIndex = null;
        Validate.isTrue((pageParameters.size() <= 1 ? 1 : 0) != 0, (String)("\u5728\u626b\u63cf\u670d\u52a1\u66b4\u9732[" + className + ":" + methodName + "]\u65f6\uff0c\u53d1\u73b0\u591a\u4e2aPageable\u7c7b\u578b\u53c2\u6570\uff0c\u81f3\u591a\u53ea\u5141\u8bb8\u4e00\u4e2a\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        if (pageParameters.size() == 1) {
            parameterTypeItem = (CtClass)pageParameters.get(pageParameters.keySet().iterator().next());
            parameterAnnoIndex = (Integer)pageParameters.keySet().iterator().next();
            serviceMethodProperties.add(this.buildMethodPropertyEntity(parameterTypeItem.getName(), 3, parameterAnnoIndex, null, serviceMethodReop, paramAnno));
        }
        parameterTypeItem = null;
        parameterAnnoIndex = null;
        Validate.isTrue((objectParameters.size() <= 1 ? 1 : 0) != 0, (String)("\u5728\u626b\u63cf\u670d\u52a1\u66b4\u9732[" + className + ":" + methodName + "]\u65f6\uff0c\u53d1\u73b0\u591a\u4e2a\u7b26\u5408Kuiper\u9759\u6001\u6a21\u578b\u7684\u5bf9\u8c61\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        if (objectParameters.size() == 1) {
            parameterTypeItem = (CtClass)objectParameters.values().iterator().next();
            parameterAnnoIndex = (Integer)objectParameters.keySet().iterator().next();
            String objectClassName = parameterTypeItem.getName();
            serviceMethodProperties.add(this.buildMethodPropertyEntity(parameterTypeItem.getName(), 4, parameterAnnoIndex, objectClassName, serviceMethodReop, paramAnno));
        }
        parameterTypeItem = null;
        parameterAnnoIndex = null;
        Validate.isTrue((mapParameters.size() <= 1 ? 1 : 0) != 0, (String)("\u5728\u626b\u63cf\u670d\u52a1\u66b4\u9732[" + className + ":" + methodName + "]\u65f6\uff0c\u53d1\u73b0\u591a\u4e2aKuiperInvokeParams\u7c7b\u578b\u53c2\u6570\uff0c\u81f3\u591a\u53ea\u5141\u8bb8\u4e00\u4e2a\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        if (mapParameters.size() == 1) {
            parameterTypeItem = (CtClass)mapParameters.get(mapParameters.keySet().iterator().next());
            parameterAnnoIndex = (Integer)mapParameters.keySet().iterator().next();
            serviceMethodProperties.add(this.buildMethodPropertyEntity(parameterTypeItem.getName(), 5, parameterAnnoIndex, null, serviceMethodReop, paramAnno));
        }
        HashSet<String> annonIsRepeat = new HashSet<String>();
        for (ServicableMethodPropertyEntity e2 : serviceMethodProperties) {
            Validate.isTrue((!StringUtils.isNotBlank((CharSequence)e2.getAnnonQualifiedName()) || annonIsRepeat.add(e2.getAnnonQualifiedName()) ? 1 : 0) != 0, (String)("\u5728\u626b\u63cf\u670d\u52a1\u66b4\u9732[" + className + ":" + methodName + "]\u65f6\uff0c\u53d1\u73b0\u591a\u4e2a\u6709\u6ce8\u89e3\u7684\u53c2\u6570\u9650\u5b9a\u540d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        }
        serviceMethodReop.setProperties(serviceMethodProperties);
    }

    private void analysisMethodReturnParameter(ServicableMethodEntity serviceMethodReop, CtMethod ctMethod) throws NotFoundException, ClassNotFoundException {
        CtClass returnClass = null;
        CtClass collectionClass = null;
        Boolean isCollectionInterface = false;
        String className = ctMethod.getDeclaringClass().getName();
        String methodName = ctMethod.getName();
        Class<?> javaClass = Class.forName(className);
        LinkedList parametersClasses = new LinkedList();
        TreeSet<ServicableMethodPropertyEntity> properties = new TreeSet<ServicableMethodPropertyEntity>((e1, e2) -> e1.getPropertyIndex() - e2.getPropertyIndex());
        if (serviceMethodReop.getProperties() != null && serviceMethodReop.getProperties().size() > 0) {
            properties.addAll(serviceMethodReop.getProperties());
        }
        for (ServicableMethodPropertyEntity parametersCtClassItem : properties) {
            String parametersClassName = parametersCtClassItem.getParamClass();
            if (parametersCtClassItem.getParamType() == 1 && ParamClassTypeConst.getBaseClass(parametersClassName) != null) {
                parametersClasses.add(ParamClassTypeConst.getBaseClass(parametersClassName));
                continue;
            }
            parametersClasses.add(Class.forName(parametersClassName));
        }
        Method javaMethod = null;
        try {
            javaMethod = javaClass.getDeclaredMethod(methodName, parametersClasses.toArray(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u65b9\u6cd5" + className + ":" + methodName + "\uff0c\u8bf7\u68c0\u67e5!!");
        }
        try {
            returnClass = ctMethod.getReturnType();
            collectionClass = this.pool.get("java.util.Collection");
            if (returnClass == null || StringUtils.equals((CharSequence)returnClass.getName(), (CharSequence)"void")) {
                returnClass = this.pool.get("java.lang.Void");
            }
            isCollectionInterface = returnClass.subtypeOf(collectionClass) || returnClass.subtypeOf(this.pool.get(Page.class.getName()));
        }
        catch (NotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        if (isCollectionInterface.booleanValue()) {
            String fieldTypeName = null;
            Type genericType = javaMethod.getGenericReturnType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Class genericClazz = (Class)pt.getActualTypeArguments()[0];
                fieldTypeName = genericClazz.getName();
            }
            serviceMethodReop.setReturnCollection(true);
            serviceMethodReop.setReturnClassName(fieldTypeName);
        } else if (StringUtils.equals((CharSequence)returnClass.getName(), (CharSequence)"void")) {
            Validate.isTrue((!NebulaServiceMethod.ScopeType.READ.name().equalsIgnoreCase(serviceMethodReop.getUsedScope()) ? 1 : 0) != 0, (String)("\u9519\u8bef\u7684\u65b9\u6cd5\u6807\u6ce8" + className + ":" + methodName + "\u662f\u67e5\u8be2\u65b9\u6cd5\uff0c\u4f46\u8fd4\u56de\u503c\u7c7b\u578b\u4e3avoid\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            serviceMethodReop.setReturnCollection(false);
            serviceMethodReop.setReturnClassName("java.lang.Void");
        } else {
            serviceMethodReop.setReturnCollection(false);
            serviceMethodReop.setReturnClassName(returnClass.getName());
        }
    }

    private String getAnnonQualifiedName(int index, Object[][] paramAnno) {
        if (paramAnno == null || paramAnno.length == 0) {
            return null;
        }
        for (Object annon : paramAnno[index]) {
            if (!(annon instanceof ServiceMethodParam)) continue;
            ServiceMethodParam smp = (ServiceMethodParam)annon;
            return smp.name();
        }
        return null;
    }

    private ServicableMethodPropertyEntity buildMethodPropertyEntity(String paramClass, int paramType, int index, String modelType, ServicableMethodEntity serviceMethodEntity, Object[][] paramAnno) {
        ServicableMethodPropertyEntity serviceMethodProperty = new ServicableMethodPropertyEntity();
        if (paramType == 1) {
            if (paramClass.contains(".") && paramClass.contains("[]")) {
                int num = this.count(paramClass, "[]");
                Validate.isTrue((num <= 2 ? 1 : 0) != 0, (String)("\u5728\u626b\u63cf\u670d\u52a1\u66b4\u9732[" + serviceMethodEntity.getInterfaceName() + ":" + serviceMethodEntity.getSimpleMethodName() + "]\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u6570\u7ec4\u7c7b\u578b\uff0c\u76ee\u524d\u53ea\u652f\u6301\u5230\u4e8c\u7ef4\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
                String str = "";
                do {
                    str = str + "[";
                } while (--num > 0);
                paramClass = paramClass.replaceAll("\\[\\]", "");
                paramClass = str + "L" + paramClass + ";";
            } else if (!paramClass.contains(".") && paramClass.contains("[]")) {
                paramClass = ParamClassTypeConst.getJavassistBaseClass(paramClass);
            }
        }
        serviceMethodProperty.setParamClass(paramClass);
        serviceMethodProperty.setAnnonQualifiedName(this.getAnnonQualifiedName(index, paramAnno));
        serviceMethodProperty.setParamType(paramType);
        serviceMethodProperty.setPropertyIndex(index);
        serviceMethodProperty.setModelType(modelType);
        serviceMethodProperty.setServiceMethod(serviceMethodEntity);
        return serviceMethodProperty;
    }

    private int count(String source, String reg) {
        int n = 0;
        int index = 0;
        index = source.indexOf(reg);
        while (index != -1) {
            ++n;
            index = source.indexOf(reg, index + 1);
        }
        return n;
    }
}

