/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.core.common.utils.ChineseCharUtil;
import com.bizunited.platform.core.entity.CodeRuleEntity;
import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.repository.CodeRuleRepository;
import com.bizunited.platform.core.service.CodeRuleService;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service(value="CodeRuleServiceImpl")
public class CodeRuleServiceImpl
implements CodeRuleService {
    @Autowired
    private CodeRuleRepository codeRuleRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private ScriptService scriptService;

    @Override
    @Transactional
    public CodeRuleEntity create(CodeRuleEntity entity) {
        this.validEntity(entity, true);
        UserEntity userEntity = this.getAccount();
        entity.setCreateUser(userEntity);
        entity.setModifyUser(userEntity);
        entity.setCreateTime(new Date());
        entity.setModifyTime(new Date());
        return (CodeRuleEntity)this.codeRuleRepository.save(entity);
    }

    @Override
    @Transactional
    public CodeRuleEntity update(CodeRuleEntity entity) {
        this.validEntity(entity, false);
        UserEntity userEntity = this.getAccount();
        Validate.notBlank((CharSequence)entity.getId(), (String)"\u5f53\u524d\u4e1a\u52a1\u7f16\u7801\u89c4\u5219\u7684ID\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Optional exsit = this.codeRuleRepository.findById(entity.getId());
        Validate.isTrue((boolean)exsit.isPresent(), (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u672a\u67e5\u8be2\u5230\uff01", (Object[])new Object[0]);
        CodeRuleEntity current = exsit.orElse(null);
        current.setDescription(entity.getDescription());
        current.setLanguage(entity.getLanguage());
        current.setRuleType(entity.getRuleType());
        current.setRuleName(entity.getRuleName());
        current.setModifyUser(userEntity);
        current.setModifyTime(new Date());
        return (CodeRuleEntity)this.codeRuleRepository.save(current);
    }

    @Override
    @Transactional
    public CodeRuleEntity updateContent(String ruleId, String content) {
        Validate.notBlank((CharSequence)ruleId, (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)content, (String)"\u811a\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional exsit = this.codeRuleRepository.findById(ruleId);
        Validate.isTrue((boolean)exsit.isPresent(), (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u672a\u67e5\u8be2\u5230\uff01", (Object[])new Object[0]);
        CodeRuleEntity entity = (CodeRuleEntity)exsit.get();
        ScriptEntity scriptEntity = entity.getScript();
        if (null == scriptEntity) {
            ScriptEntity script = new ScriptEntity();
            script.setLanguage(entity.getLanguage());
            script.setName(String.format("%s%s", "cgr", entity.getRuleCode()));
            script = this.scriptService.create(script, content);
            entity.setScript(script);
        } else {
            scriptEntity = this.scriptService.update(scriptEntity, content);
            entity.setScript(scriptEntity);
        }
        return (CodeRuleEntity)this.codeRuleRepository.save(entity);
    }

    @Override
    public String invoke(String ruleCode) {
        Validate.notBlank((CharSequence)ruleCode, (String)"\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CodeRuleEntity codeRuleEntity = this.codeRuleRepository.findDetailByCode(ruleCode);
        Validate.notNull((Object)codeRuleEntity, (String)"\u672a\u6839\u636e\u8be5\u7f16\u7801\u67e5\u8be2\u5230\u7f16\u7801\u89c4\u5219\uff01", (Object[])new Object[0]);
        ScriptEntity scriptEntity = codeRuleEntity.getScript();
        Validate.notNull((Object)scriptEntity, (String)"\u672a\u67e5\u8be2\u5230\u8be5\u89c4\u5219\u7ed1\u5b9a\u7684\u811a\u672c\u4fe1\u606f\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptEntity.getId(), (String)"\u811a\u672cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        try {
            Map<String, Object> result = this.scriptService.invoke(scriptEntity.getId(), new HashMap<String, Object>());
            String resultStr = String.valueOf(result.get("resultKey"));
            return resultStr;
        }
        catch (InvokeProxyException e) {
            throw new IllegalArgumentException("\u6267\u884c\u751f\u6210\u7f16\u7801\u811a\u672c\u9519\u8bef\uff01");
        }
    }

    private void validEntity(CodeRuleEntity entity, Boolean isCreate) {
        Validate.notNull((Object)entity, (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u57fa\u7840\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRuleName(), (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRuleCode(), (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.isTrue((!ChineseCharUtil.hasChinese(entity.getRuleCode()) ? 1 : 0) != 0, (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff01", (Object[])new Object[0]);
        CodeRuleEntity existName = this.codeRuleRepository.findByRuleName(entity.getRuleName());
        CodeRuleEntity existCode = this.codeRuleRepository.findByRuleCode(entity.getRuleCode());
        if (isCreate.booleanValue()) {
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u65b0\u589e\u65f6ID\u5fc5\u987b\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((null == existName ? 1 : 0) != 0, (String)"\u7f16\u7801\u89c4\u5219\u540d\u79f0\u5df2\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            Validate.isTrue((null == existCode ? 1 : 0) != 0, (String)"\u7f16\u7801\u89c4\u5219\u7f16\u7801\u5df2\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        } else {
            Validate.notBlank((CharSequence)entity.getId(), (String)"\u4fee\u6539\u65f6id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Optional op = this.codeRuleRepository.findById(entity.getId());
            CodeRuleEntity oldEntity = op.orElse(null);
            Validate.notNull((Object)oldEntity, (String)"\u672a\u6839\u636eID\u67e5\u8be2\u5230\u7f16\u7801\u751f\u6210\u89c4\u5219\u5b9e\u4f53\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)entity.getRuleCode(), (CharSequence)oldEntity.getRuleCode()), (String)"\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4fee\u6539\uff01", (Object[])new Object[0]);
            long count = this.codeRuleRepository.countByRuleNameWithoutId(entity.getRuleName(), entity.getId());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u7f16\u7801\u89c4\u5219\u540d\u79f0\u5df2\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        }
    }

    private UserEntity getAccount() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Validate.notNull((Object)securityContext, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7528\u6237\u6743\u9650\u4fe1\u606f!!", (Object[])new Object[0]);
        Authentication authentication = securityContext.getAuthentication();
        Validate.notNull((Object)authentication, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7528\u6237\u767b\u5f55\u4fe1\u606f!!", (Object[])new Object[0]);
        UserVo userVo = this.userService.findByAccount(authentication.getName());
        Validate.notNull((Object)userVo, (String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u8d26\u53f7\uff01", (Object[])new Object[0]);
        UserEntity userEntity = new UserEntity();
        userEntity.setId(userVo.getId());
        return userEntity;
    }

    @Override
    public String findContentByCode(String code) {
        Validate.notBlank((CharSequence)code, (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u7684\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CodeRuleEntity entity = this.codeRuleRepository.findDetailByCode(code);
        if (entity.getScript() == null) {
            return null;
        }
        String scriptId = entity.getScript().getId();
        String content = this.scriptService.findContentById(scriptId);
        return content;
    }

    @Override
    public Page<CodeRuleEntity> findByConditions(Pageable pageable, String ruleName, String ruleCode, String ruleType, String language) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)ruleName)) {
            params.put("ruleName", ruleName);
        }
        if (StringUtils.isNotEmpty((CharSequence)ruleCode)) {
            params.put("ruleCode", ruleCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)ruleType)) {
            params.put("ruleType", ruleType);
        }
        if (StringUtils.isNotEmpty((CharSequence)language)) {
            params.put("language", language);
        }
        if (null == pageable) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        return this.codeRuleRepository.findByConditions(pageable, params);
    }

    @Override
    public Set<CodeRuleEntity> findDetailsByIds(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return Sets.newHashSet();
        }
        return this.codeRuleRepository.findDetailsByIds(ids);
    }

    @Override
    public int countByIds(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return 0;
        }
        return this.codeRuleRepository.countByIds(ids);
    }

    @Override
    public CodeRuleEntity findByRuleCode(String ruleCode) {
        if (StringUtils.isBlank((CharSequence)ruleCode)) {
            return null;
        }
        return this.codeRuleRepository.findByRuleCode(ruleCode);
    }

    @Override
    public CodeRuleEntity findByRuleName(String ruleName) {
        if (StringUtils.isBlank((CharSequence)ruleName)) {
            return null;
        }
        return this.codeRuleRepository.findByRuleName(ruleName);
    }
}

