/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.core.common.utils.ChineseCharUtil;
import com.bizunited.platform.core.entity.EnvironmentVariableEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.repository.EnvironmentVariableRepository;
import com.bizunited.platform.core.service.EnvironmentVariableService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service(value="EnvironmentVariableServiceImpl")
public class EnvironmentVariableServiceImpl
implements EnvironmentVariableService {
    @Autowired
    private EnvironmentVariableRepository environmentVariableRepository;
    @Autowired
    private UserService userService;

    @Override
    public List<EnvironmentVariableEntity> findAll() {
        return this.environmentVariableRepository.findAll();
    }

    @Override
    public Page<EnvironmentVariableEntity> findByConditions(String paramCode, String paramKey, String paramValue, String paramType, Integer paramStatus, Pageable pageable) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)paramCode)) {
            conditions.put("paramCode", paramCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramKey)) {
            conditions.put("paramKey", paramKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramValue)) {
            conditions.put("paramValue", paramValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramType)) {
            conditions.put("paramType", paramType);
        }
        if (null != paramStatus) {
            conditions.put("paramStatus", paramStatus);
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        return this.environmentVariableRepository.queryPage(pageable, conditions);
    }

    @Override
    public EnvironmentVariableEntity findByKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        return this.environmentVariableRepository.findByParamKey(key);
    }

    @Override
    public EnvironmentVariableEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.environmentVariableRepository.findByParamCode(code);
    }

    @Override
    public Set<EnvironmentVariableEntity> findDetailsByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return Sets.newHashSet();
        }
        return this.environmentVariableRepository.findDetailsByIds(ids);
    }

    @Override
    @Transactional
    public EnvironmentVariableEntity enable(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u542f\u7528\u65f6\u5fc5\u987b\u4f20\u5165ID", (Object[])new Object[0]);
        Optional op = this.environmentVariableRepository.findById(id);
        EnvironmentVariableEntity entity = op.orElse(null);
        Validate.notNull((Object)entity, (String)"\u672a\u627e\u5230\u8be5\u53c2\u6570\uff01", (Object[])new Object[0]);
        entity.setParamStatus(1);
        return (EnvironmentVariableEntity)this.environmentVariableRepository.save(entity);
    }

    @Override
    @Transactional
    public EnvironmentVariableEntity disable(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u7981\u7528\u65f6\u5fc5\u987b\u4f20\u5165ID", (Object[])new Object[0]);
        Optional op = this.environmentVariableRepository.findById(id);
        EnvironmentVariableEntity entity = op.orElse(null);
        Validate.notNull((Object)entity, (String)"\u672a\u627e\u5230\u8be5\u53c2\u6570\uff01", (Object[])new Object[0]);
        entity.setParamStatus(0);
        return (EnvironmentVariableEntity)this.environmentVariableRepository.save(entity);
    }

    @Override
    @Transactional
    public EnvironmentVariableEntity save(EnvironmentVariableEntity entity) {
        Validate.notNull((Object)entity, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getParamKey(), (String)"\u53c2\u6570\u7684\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getParamValue(), (String)"\u53c2\u6570\u7684\u503c\u4e0d\u80fd\u4e3aNull\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getParamCode(), (String)"\u53c2\u6570\u7684\u7f16\u7801\u4e0d\u80fd\u4e3aNull\uff01", (Object[])new Object[0]);
        Validate.isTrue((!ChineseCharUtil.hasChinese(entity.getParamKey()) ? 1 : 0) != 0, (String)"\u53c2\u6570\u952e\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getParamType(), (String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getParamStatus(), (String)"\u53c2\u6570\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        UserEntity userEntity = this.getAccount();
        if (StringUtils.isEmpty((CharSequence)entity.getId())) {
            long existByKey = this.environmentVariableRepository.countByParamKey(entity.getParamKey());
            long existByCode = this.environmentVariableRepository.countByParamCode(entity.getParamCode());
            Validate.isTrue((existByCode < 1L ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u53c2\u6570\u7684\u53c2\u6570\u540d\u79f0\u5df2\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            Validate.isTrue((existByKey < 1L ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u53c2\u6570\u7684\u952e\u5df2\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            entity.setCreateDate(new Date());
            entity.setModifyDate(new Date());
            entity.setCreateUser(userEntity);
            entity.setModifyUser(userEntity);
            return (EnvironmentVariableEntity)this.environmentVariableRepository.save(entity);
        }
        Optional op = this.environmentVariableRepository.findById(entity.getId());
        EnvironmentVariableEntity exist = op.orElse(null);
        Validate.notNull((Object)exist, (String)"\u6839\u636eID\u672a\u83b7\u53d6\u5230\u8be5\u53c2\u6570\uff01", (Object[])new Object[0]);
        EnvironmentVariableEntity existCode = this.environmentVariableRepository.findByParamCode(entity.getParamCode());
        Boolean notSameCode = null == existCode || exist.getParamCode().equals(existCode.getParamCode());
        Validate.isTrue((boolean)notSameCode, (String)"\u4fee\u6539\u540e\u7684\u53c2\u6570\u7f16\u7801\u5df2\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        EnvironmentVariableEntity existKey = this.environmentVariableRepository.findByParamKey(entity.getParamKey());
        Boolean notSameKey = null == existKey || exist.getParamKey().equals(existKey.getParamKey());
        Validate.isTrue((boolean)notSameKey, (String)"\u4fee\u6539\u540e\u7684\u53c2\u6570\u952e\u5df2\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        exist.setParamCode(entity.getParamCode());
        exist.setParamKey(entity.getParamKey());
        exist.setParamValue(entity.getParamValue());
        exist.setParamType(entity.getParamType());
        exist.setParamDesc(entity.getParamDesc());
        exist.setModifyUser(userEntity);
        exist.setModifyDate(new Date());
        return (EnvironmentVariableEntity)this.environmentVariableRepository.save(exist);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void delete(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5220\u9664\u53c2\u6570ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.environmentVariableRepository.findById(id);
        EnvironmentVariableEntity exist = op.orElse(null);
        Validate.notNull((Object)exist, (String)"\u672a\u627e\u5230\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        this.environmentVariableRepository.delete(exist);
    }

    private UserEntity getAccount() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Validate.notNull((Object)securityContext, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7528\u6237\u6743\u9650\u4fe1\u606f!!", (Object[])new Object[0]);
        Authentication authentication = securityContext.getAuthentication();
        Validate.notNull((Object)authentication, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7528\u6237\u767b\u5f55\u4fe1\u606f!!", (Object[])new Object[0]);
        UserVo userVo = this.userService.findByAccount(authentication.getName());
        Validate.notNull((Object)userVo, (String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u8d26\u53f7\uff01", (Object[])new Object[0]);
        UserEntity userEntity = new UserEntity();
        userEntity.setId(userVo.getId());
        return userEntity;
    }

    @Override
    public int countByIds(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return 0;
        }
        return this.environmentVariableRepository.countByIds(ids);
    }
}

