/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.core.service.NebulaStaticPersistentService;
import com.bizunited.platform.saturn.context.SaturnContext;
import com.bizunited.platform.saturn.context.service.PersistentClassService;
import com.bizunited.platform.saturn.context.service.PersistentPropertyService;
import com.bizunited.platform.saturn.context.service.PersistentRelationService;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentProperty;
import com.bizunited.platform.saturn.model.PersistentRelation;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="KuiperStaticPersistentServiceImpl")
public class NebulaStaticPersistentServiceImpl
implements NebulaStaticPersistentService {
    @Autowired
    private SaturnContext saturnContext;

    @Override
    public List<PersistentClass> findAllPersistentClasses() {
        PersistentClassService persistentClassService = this.saturnContext.getPersistentClassService();
        return persistentClassService.queryAllClasses();
    }

    @Override
    public List<PersistentClass> findAllMainPersistentClasses() {
        PersistentClassService persistentClassService = this.saturnContext.getPersistentClassService();
        List<PersistentClass> persistentClasses = persistentClassService.queryAllClasses();
        if (persistentClasses == null || persistentClasses.isEmpty()) {
            return null;
        }
        persistentClasses = persistentClasses.stream().filter(item -> {
            List persistentProperties = item.getProperties();
            if (persistentProperties == null || persistentProperties.isEmpty()) {
                return false;
            }
            for (PersistentProperty persistentProperty : persistentProperties) {
                if (!StringUtils.equals((CharSequence)persistentProperty.getPropertyName(), (CharSequence)"formInstanceId")) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        return persistentClasses;
    }

    @Override
    public PersistentClass findByPersistentClass(String className) {
        PersistentClassService persistentClassService = this.saturnContext.getPersistentClassService();
        return persistentClassService.queryByClassName(className);
    }

    @Override
    public PersistentProperty findPkPropertyByClass(String className) {
        PersistentPropertyService persistentPropertyService = this.saturnContext.getPersistentPropertyService();
        PersistentProperty pkProperty = persistentPropertyService.findPrimaryKey(className);
        return pkProperty;
    }

    @Override
    public PersistentRelation findByTargetPropertyName(String className, String propertyName) {
        PersistentRelationService persistentRelationService = this.saturnContext.getPersistentRelationService();
        PersistentRelation persistentRelation = persistentRelationService.findByTargetPropertyName(className, propertyName);
        return persistentRelation;
    }
}

