/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.entity.OrdinaryFileEntity;
import com.bizunited.platform.core.entity.SystemThemeEntity;
import com.bizunited.platform.core.repository.SystemThemeRepository;
import com.bizunited.platform.core.service.SystemThemeService;
import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.core.service.image.FileUpdateService;
import java.nio.charset.Charset;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="SystemThemeServiceImpl")
public class SystemThemeServiceImpl
implements SystemThemeService {
    private static final String THEME_FILE_NAME = "theme.json";
    private static final String MESS_FIELD_NAME = "fileName";
    private static final String MESS_RELATIVE_LOCAL = "relativeLocal";
    private static final String MESS_THEME = "theme";
    @Autowired
    private FileUpdateService fileUpdateService;
    @Autowired
    private NebulaFileService nebulaFileService;
    @Autowired
    private SystemThemeRepository systemThemeRepository;

    @Override
    @Transactional
    public OrdinaryFileEntity uploadLogo(MultipartFile file, Principal principal) {
        String account = this.validatePrincipal(principal);
        Validate.notNull((Object)file, (String)"logo\u56fe\u7247\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        List<OrdinaryFileEntity> logos = this.fileUpdateService.fileImageUpload("logo", account, null, new MultipartFile[]{file});
        Validate.notEmpty(logos, (String)"logo\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((logos.size() > 0 ? 1 : 0) != 0, (String)"logo\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return logos.get(0);
    }

    @Override
    @Transactional
    public SystemThemeEntity save(JSONObject theme, Principal principal) {
        String account = this.validatePrincipal(principal);
        Validate.notEmpty((Map)theme, (String)"\u7cfb\u7edf\u4e3b\u9898\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        List themes = this.systemThemeRepository.findAll();
        Validate.isTrue((themes == null || themes.size() <= 1 ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u4e3b\u9898\u4fe1\u606f\u6709\u591a\u6761\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Map<String, String> themePath = this.resolveThemePath(theme);
        Validate.notNull(themePath, (String)"\u89e3\u6790\u524d\u7aef\u4f20\u5165\u7684json\u6587\u4ef6\u8def\u5f84\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SystemThemeEntity entity = null;
        Date now = new Date();
        if (themes == null || themes.size() == 0) {
            Map<String, String> themePathMap = this.saveThemeFile(null, theme);
            Validate.notEmpty(themePathMap, (String)"\u4e3b\u9898json\u6587\u4ef6\u4fdd\u5b58\u6210\u529f\uff0c\u4f46\u672a\u80fd\u83b7\u53d6\u5230json\u6587\u4ef6\u7684\u8def\u5f84\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            entity = new SystemThemeEntity();
            entity.setCommitUser(account);
            entity.setUpdateUser(account);
            entity.setCreateTime(now);
            entity.setUpdateTime(now);
            entity.setFileName(themePathMap.get(MESS_FIELD_NAME));
            entity.setOriginalName(THEME_FILE_NAME);
            entity.setRelativeLocal(themePathMap.get(MESS_RELATIVE_LOCAL));
        } else {
            entity = (SystemThemeEntity)themes.get(0);
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)entity.getFileName(), (CharSequence)themePath.get(MESS_FIELD_NAME)), (String)"theme\u4f20\u5165\u7684fileName\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)entity.getRelativeLocal(), (CharSequence)themePath.get(MESS_RELATIVE_LOCAL)), (String)"theme\u4f20\u5165\u7684relativeLocal\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.notNull((Object)entity, (String)"\u6839\u636e\u4e3b\u9898\u4fe1\u606f\uff0c\u672a\u80fd\u67e5\u8be2\u5230\u4e3b\u9898\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            entity.setUpdateTime(now);
            entity.setUpdateUser(account);
            Map<String, String> themePathMap = this.saveThemeFile(entity, theme);
            Validate.notEmpty(themePathMap, (String)"\u4e3b\u9898json\u6587\u4ef6\u4fdd\u5b58\u6210\u529f\uff0c\u4f46\u672a\u80fd\u83b7\u53d6\u5230json\u6587\u4ef6\u7684\u8def\u5f84\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        this.systemThemeRepository.save(entity);
        return entity;
    }

    @Override
    public JSONObject findTheme() {
        List themes = this.systemThemeRepository.findAll();
        if (themes == null || themes.isEmpty()) {
            return null;
        }
        Validate.isTrue((themes.size() <= 1 ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u4e3b\u9898\u4fe1\u606f\u6709\u591a\u6761\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SystemThemeEntity theme = (SystemThemeEntity)themes.get(0);
        byte[] content = this.nebulaFileService.readFileContent(theme.getRelativeLocal(), theme.getFileName());
        Validate.notNull((Object)content, (String)"\u672a\u80fd\u8bfb\u53d6\u5230\u7cfb\u7edf\u4e3b\u9898\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((content.length > 0 ? 1 : 0) != 0, (String)"\u672a\u80fd\u53d1\u73b0\u7cfb\u7edf\u4e3b\u9898\u4fe1\u606f\u6570\u636e\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String jsonStr = new String(content, Charset.forName("utf-8"));
        return JSONObject.parseObject((String)jsonStr);
    }

    private String validatePrincipal(Principal principal) {
        Validate.notNull((Object)principal, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String account = principal.getName();
        Validate.notBlank((CharSequence)account, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return account;
    }

    private Map<String, String> resolveThemePath(JSONObject theme) {
        Validate.notNull((Object)theme, (String)"\u7cfb\u7edf\u4e3b\u9898\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        HashMap<String, String> themePathMap = new HashMap<String, String>();
        JSONObject themeJson = theme.getJSONObject(MESS_THEME);
        if (themeJson == null || themeJson.size() == 0) {
            return themePathMap;
        }
        String relativeLocal = themeJson.getString(MESS_RELATIVE_LOCAL);
        String fileName = themeJson.getString(MESS_FIELD_NAME);
        Validate.notBlank((CharSequence)relativeLocal, (String)"\u7cfb\u7edf\u4e3b\u9898\u4e2d\uff0c\u7ed9\u5b9a\u7684\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileName, (String)"\u7cfb\u7edf\u4e3b\u9898\u4e2d\uff0c\u7ed9\u5b9a\u7684\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        themePathMap.put(MESS_FIELD_NAME, fileName);
        themePathMap.put(MESS_RELATIVE_LOCAL, relativeLocal);
        return themePathMap;
    }

    private Map<String, String> saveThemeFile(SystemThemeEntity themeEntity, JSONObject theme) {
        Validate.notEmpty((Map)theme, (String)"\u4f20\u5165\u7684\u4e3b\u9898json\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        byte[] content = null;
        String folderName = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String relativePath = null;
        String renameFile = null;
        if (themeEntity == null) {
            relativePath = "/theme/" + folderName;
            renameFile = UUID.randomUUID().toString() + ".json";
        } else {
            relativePath = themeEntity.getRelativeLocal();
            renameFile = themeEntity.getFileName();
        }
        JSONObject themeJson = theme.getJSONObject(MESS_THEME);
        if (themeJson == null || themeJson.size() == 0) {
            themeJson = new JSONObject();
        }
        themeJson.put(MESS_FIELD_NAME, (Object)renameFile);
        themeJson.put(MESS_RELATIVE_LOCAL, (Object)relativePath);
        theme.put(MESS_THEME, (Object)themeJson);
        try {
            content = theme.toJSONString().getBytes("utf-8");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u7cfb\u7edf\u4e3b\u9898\u6570\u636e\u8f6c\u7801\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5!");
        }
        this.nebulaFileService.saveFile(relativePath, THEME_FILE_NAME, renameFile, content);
        HashMap<String, String> themePathMap = new HashMap<String, String>();
        themePathMap.put(MESS_RELATIVE_LOCAL, relativePath);
        themePathMap.put(MESS_FIELD_NAME, renameFile);
        return themePathMap;
    }
}

