/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.invoke;

import com.bizunited.platform.core.service.invoke.DefaultHandleChain;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class InvokeProxy
implements HandleChain {
    private HandleChain targetHandleChain;
    private InvokeProxyContext invokeProxyContext;

    public Object doHandle(Map<String, Object> params) throws InvokeProxyException {
        Validate.notNull((Object)this.targetHandleChain, (String)"\u9519\u8bef\u7684\u4ee3\u7406\u76ee\u6807\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)this.invokeProxyContext, (String)"\u9519\u8bef\u7684\u4e0a\u4e0b\u6587\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.invokeProxyContext.setChainParams(params);
        this.targetHandleChain.doHandle(this.invokeProxyContext, HandleChain.ChainLogic.CONTINUE);
        return this.invokeProxyContext.getResult();
    }

    @Override
    public void doHandle(InvokeProxyContext context, HandleChain.ChainLogic chainLogic) throws InvokeProxyException {
        throw new IllegalArgumentException("\u4e0d\u5141\u8bb8\u5728\u670d\u52a1\u8fc7\u7a0b\u4ee3\u7406\u5668\u4e2d\u76f4\u63a5\u8c03\u7528doHandle(invokeProxyContext, ChainLogic)\u65b9\u6cd5;");
    }

    public static class Build {
        private List<InvokeRequestHandle> invokeRequestHandles = new LinkedList<InvokeRequestHandle>();
        private List<InvokeResponseHandle> invokeResponseHandles = new LinkedList<InvokeResponseHandle>();
        private Class<? extends HandleChain> targetChainType;
        private ClassLoader classLoader;
        private Map<String, Object> params = new HashMap<String, Object>();

        public InvokeProxy build() {
            Validate.isTrue((this.invokeRequestHandles != null && !this.invokeRequestHandles.isEmpty() ? 1 : 0) != 0, (String)"\u8c03\u7528\u5668\u6784\u5efa\u65f6\uff0c\u81f3\u5c11\u8981\u6709\u4e00\u4e2a\u8bf7\u6c42\u5904\u7406\u8282\u70b9\uff08InvokeRequestFilter\uff09", (Object[])new Object[0]);
            Validate.isTrue((this.invokeResponseHandles != null && !this.invokeResponseHandles.isEmpty() ? 1 : 0) != 0, (String)"\u8c03\u7528\u5668\u6784\u5efa\u65f6\uff0c\u81f3\u5c11\u8981\u6709\u4e00\u4e2a\u54cd\u5e94\u5904\u7406\u8282\u70b9\uff08InvokeResponseFilter\uff09", (Object[])new Object[0]);
            Validate.notNull((Object)this.classLoader, (String)"\u8c03\u7528\u5668\u6784\u5efa\u65f6\uff0c\u9700\u8981\u6307\u5b9a\u5904\u7406\u5668\u5185\u90e8\u52a0\u8f7dclass\u65f6\uff0c\u4f7f\u7528\u7684\u7c7b\u52a0\u8f7d\u5668", (Object[])new Object[0]);
            if (this.targetChainType == null) {
                this.targetChainType = DefaultHandleChain.class;
            }
            Validate.isTrue((this.targetChainType != InvokeProxy.class ? 1 : 0) != 0, (String)"\u5177\u4f53\u5904\u7406\u94fe\u7ba1\u7406\u5668\u4e0d\u80fd\u6307\u5b9a\u4e3aInvokeProxy.class", (Object[])new Object[0]);
            DefaultHandleChain handleChain = null;
            InvokeProxyContext invokeProxyContext = null;
            if (this.targetChainType == DefaultHandleChain.class) {
                DefaultHandleChain defaultHandleChain = new DefaultHandleChain();
                defaultHandleChain.setInvokeRequestHandles(this.invokeRequestHandles);
                defaultHandleChain.setInvokeResponseHandles(this.invokeResponseHandles);
                invokeProxyContext = new InvokeProxyContext();
                invokeProxyContext.setClassLoader(this.classLoader);
                if (this.params != null && !this.params.isEmpty()) {
                    invokeProxyContext.setChainParams(this.params);
                }
                defaultHandleChain.setInvokeProxyContext(invokeProxyContext);
                handleChain = defaultHandleChain;
            }
            Validate.notNull(handleChain, (String)"\u672a\u5339\u914d\u7684HandleChain\u5b9e\u73b0\u7c7b", (Object[])new Object[0]);
            InvokeProxy invokeProxy = new InvokeProxy();
            invokeProxy.targetHandleChain = handleChain;
            invokeProxy.invokeProxyContext = invokeProxyContext;
            return invokeProxy;
        }

        public Build addClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Build addChainParam(String key, Object value) {
            if (StringUtils.isBlank((CharSequence)key) || value == null) {
                return this;
            }
            this.params.put(key, value);
            return this;
        }

        public Build addInvokeResponseFilter(InvokeResponseHandle ... responses) {
            Arrays.stream(responses).forEach(filter -> this.invokeResponseHandles.add((InvokeResponseHandle)filter));
            return this;
        }

        public Build addInvokeRequestFilter(InvokeRequestHandle ... requests) {
            Arrays.stream(requests).forEach(filter -> this.invokeRequestHandles.add((InvokeRequestHandle)filter));
            return this;
        }

        public Build setTargetHandleChain(Class<? extends HandleChain> targetChainType) {
            this.targetChainType = targetChainType;
            return this;
        }
    }
}

