/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.migrate.internal;

import com.bizunited.platform.core.entity.CodeRuleEntity;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewGroupEntity;
import com.bizunited.platform.core.entity.DictCategoryEntity;
import com.bizunited.platform.core.entity.DictEntity;
import com.bizunited.platform.core.entity.EnvironmentVariableEntity;
import com.bizunited.platform.core.entity.RemoteServiceAddressEntity;
import com.bizunited.platform.core.entity.RemoteServiceEntity;
import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.service.CodeRuleService;
import com.bizunited.platform.core.service.DictCategoryService;
import com.bizunited.platform.core.service.DictService;
import com.bizunited.platform.core.service.EnvironmentVariableService;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.core.service.RemoteServiceService;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalService;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalService;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.core.service.migrate.MigrateExportService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="migrateExportService")
public class MigrateExportServiceImpl
implements MigrateExportService {
    @Autowired
    private DataViewService dataViewService;
    @Autowired
    private DataViewAuthHorizontalService dataViewAuthHorizontalService;
    @Autowired
    private DataViewAuthVerticalService dataViewAuthVerticalService;
    @Autowired
    private CodeRuleService codeRuleService;
    @Autowired
    private DictService dictService;
    @Autowired
    private DictCategoryService dictCategoryService;
    @Autowired
    private EnvironmentVariableService environmentVariableService;
    @Autowired
    private RemoteServiceService remoteServiceService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaFileService nebulaFileService;
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrateExportServiceImpl.class);

    @Override
    public byte[] export(String[] dataviewIds, String[] codeRuleIds, String[] dictIds, String[] envIds, String[] remoteServiceIds) {
        boolean hasDateView = false;
        boolean hasCodeRule = false;
        boolean hasDict = false;
        boolean hasEnv = false;
        boolean hasRemoteService = false;
        if (dataviewIds != null && dataviewIds.length > 0) {
            Validate.isTrue((this.dataViewService.countByIds(dataviewIds) == dataviewIds.length ? 1 : 0) != 0, (String)"\u6307\u5b9a\u5bfc\u51fa\u7684\u6570\u636e\u89c6\u56fe\u4fe1\u606f\u4e0e\u6570\u636e\u5e93\u5b58\u50a8\u7684\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            hasDateView = true;
        }
        if (codeRuleIds != null && codeRuleIds.length > 0) {
            Validate.isTrue((this.codeRuleService.countByIds(codeRuleIds) == codeRuleIds.length ? 1 : 0) != 0, (String)"\u6307\u5b9a\u5bfc\u51fa\u7684\u4e1a\u52a1\u7f16\u7801\u89c4\u5219\u4fe1\u606f\u4e0e\u6570\u636e\u5e93\u5b58\u50a8\u7684\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            hasCodeRule = true;
        }
        if (dictIds != null && dictIds.length > 0) {
            Validate.isTrue((this.dictService.countByIds(dictIds) == dictIds.length ? 1 : 0) != 0, (String)"\u6307\u5b9a\u5bfc\u51fa\u7684\u6570\u636e\u5b57\u5178\u4fe1\u606f\u4e0e\u6570\u636e\u5e93\u5b58\u50a8\u7684\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            hasDict = true;
        }
        if (envIds != null && envIds.length > 0) {
            Validate.isTrue((this.environmentVariableService.countByIds(envIds) == envIds.length ? 1 : 0) != 0, (String)"\u6307\u5b9a\u5bfc\u51fa\u7684\u73af\u5883\u53d8\u91cf\u4fe1\u606f\u4e0e\u6570\u636e\u5e93\u5b58\u50a8\u7684\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            hasEnv = true;
        }
        if (remoteServiceIds != null && remoteServiceIds.length > 0) {
            Validate.isTrue((this.remoteServiceService.countByIds(remoteServiceIds) == remoteServiceIds.length ? 1 : 0) != 0, (String)"\u6307\u5b9a\u5bfc\u51fa\u7684\u8fdc\u7aef\u670d\u52a1\u6e90\u4fe1\u606f\u4e0e\u6570\u636e\u5e93\u5b58\u50a8\u7684\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            hasRemoteService = true;
        }
        if (!(hasDateView || hasCodeRule || hasDict || hasEnv || hasRemoteService)) {
            throw new IllegalArgumentException("\u5728\u8fdb\u884c\u57fa\u672c\u6570\u636e\u5bfc\u51fa\u65f6\uff0c\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u79cd\u6570\u636e\u96c6\uff08\u6570\u636e\u89c6\u56fe\u3001\u4e1a\u52a1\u7f16\u7801\u89c4\u5219\u3001\u6570\u636e\u5b57\u5178\u3001\u5168\u5c40\u73af\u5883\u53d8\u91cf\u3001\u8fdc\u7aef\u65b9\u6cd5\u6e90\uff09");
        }
        byte[] fullZipBytes = null;
        try (ByteArrayOutputStream fullZipBis = new ByteArrayOutputStream();
             ZipOutputStream zipf = new ZipOutputStream(fullZipBis);){
            if (hasDateView) {
                this.handleDateView(zipf, dataviewIds);
            }
            if (hasCodeRule) {
                this.handleCodeRule(zipf, codeRuleIds);
            }
            if (hasDict) {
                this.handleDict(zipf, dictIds);
            }
            if (hasEnv) {
                this.handleEnv(zipf, envIds);
            }
            if (hasRemoteService) {
                this.handleRemoteService(zipf, remoteServiceIds);
            }
            zipf.finish();
            fullZipBytes = fullZipBis.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        return fullZipBytes;
    }

    private void handleDateView(ZipOutputStream zipf, String[] dataviewIds) {
        HashSet allJpaDataSources = Sets.newHashSet();
        HashSet allJpaDataViewGroups = Sets.newHashSet();
        Set<DataViewEntity> allJpaDataViews = this.dataViewService.findDetailsByIds(dataviewIds);
        Set<DataViewAuthHorizontalEntity> allDataViewAuthHs = this.dataViewAuthHorizontalService.findDetailsByDataViewIds(dataviewIds);
        Set<DataViewAuthVerticalEntity> allDataViewAuthVs = this.dataViewAuthVerticalService.findDetailsByDataViewIds(dataviewIds);
        for (DataViewEntity jpaDataViewItem : allJpaDataViews) {
            if (jpaDataViewItem.getDataSource() != null) {
                allJpaDataSources.add(jpaDataViewItem.getDataSource());
            }
            allJpaDataViewGroups.add(jpaDataViewItem.getDataViewGroup());
        }
        Collection<DataSourceEntity> allDataSources = this.nebulaToolkitService.copyCollectionByWhiteList(allJpaDataSources, DataSourceEntity.class, DataSourceEntity.class, HashSet.class, ArrayList.class, new String[0]);
        Collection<DataViewGroupEntity> allDataViewGroups = this.nebulaToolkitService.copyCollectionByWhiteList(allJpaDataViewGroups, DataViewGroupEntity.class, DataViewGroupEntity.class, HashSet.class, ArrayList.class, "dataSource");
        Collection<DataViewEntity> allDataViews = this.nebulaToolkitService.copyCollectionByWhiteList(allJpaDataViews, DataViewEntity.class, DataViewEntity.class, HashSet.class, ArrayList.class, "dataSource", "dataViewGroup", "fields", "filters", "filters.field", "systemFilters");
        int dataSourcesSize = allDataSources.size();
        int dataViewGroupsSize = allDataViewGroups.size();
        int dataViewsSize = allDataViews.size();
        int dataViewAuthHsSize = allDataViewAuthHs == null ? 0 : allDataViewAuthHs.size();
        int dataViewAuthVsSize = allDataViewAuthVs == null ? 0 : allDataViewAuthVs.size();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeInt(dataSourcesSize);
            oos.writeInt(dataViewGroupsSize);
            oos.writeInt(dataViewsSize);
            oos.writeInt(dataViewAuthHsSize);
            oos.writeInt(dataViewAuthVsSize);
            for (DataSourceEntity dataSourceItem : allDataSources) {
                oos.writeObject(dataSourceItem);
            }
            for (DataViewGroupEntity dataViewGroupItem : allDataViewGroups) {
                oos.writeObject(dataViewGroupItem);
            }
            for (DataViewEntity dataViewitem : allDataViews) {
                oos.writeObject(dataViewitem);
            }
            if (allDataViewAuthHs != null) {
                for (DataViewAuthHorizontalEntity hItem : allDataViewAuthHs) {
                    oos.writeObject(hItem);
                }
            }
            if (allDataViewAuthVs != null) {
                for (DataViewAuthVerticalEntity vItem : allDataViewAuthVs) {
                    oos.writeObject(vItem);
                }
            }
            String zipFileName = "dataview.in";
            byte[] bosBytes = bos.toByteArray();
            this.writeZipFile(zipf, zipFileName, bosBytes);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private void handleCodeRule(ZipOutputStream zipf, String[] codeRuleIds) {
        HashSet allJpaScripts = Sets.newHashSet();
        Set<CodeRuleEntity> allJpaCodeRules = this.codeRuleService.findDetailsByIds(codeRuleIds);
        for (CodeRuleEntity codeRuleItem : allJpaCodeRules) {
            ScriptEntity currentScript = codeRuleItem.getScript();
            Validate.notNull((Object)currentScript, (String)"\u5f53\u524d\u7f16\u7801\u811a\u672c\u5b58\u5728\u95ee\u9898\uff0c\u6ca1\u6709\u5173\u8054\u4efb\u4f55\u811a\u672c\u4fe1\u606f\uff0c\u4e0d\u80fd\u8fdb\u884c\u5bfc\u51fa", (Object[])new Object[0]);
            allJpaScripts.add(currentScript);
        }
        Collection<ScriptEntity> allScripts = this.nebulaToolkitService.copyCollectionByWhiteList(allJpaScripts, ScriptEntity.class, ScriptEntity.class, HashSet.class, ArrayList.class, new String[0]);
        Collection<CodeRuleEntity> allCodeRules = this.nebulaToolkitService.copyCollectionByWhiteList(allJpaCodeRules, CodeRuleEntity.class, CodeRuleEntity.class, HashSet.class, ArrayList.class, "script");
        int scriptsSize = allScripts.size();
        int codeRulesSize = allCodeRules.size();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeInt(scriptsSize);
            oos.writeInt(codeRulesSize);
            for (ScriptEntity scriptItem : allScripts) {
                oos.writeObject(scriptItem);
                String relativePath = scriptItem.getFileCode();
                String fileName = scriptItem.getFileName();
                this.writeZipFile(zipf, relativePath, fileName);
            }
            for (CodeRuleEntity codeRuleItem : allCodeRules) {
                oos.writeObject(codeRuleItem);
            }
            String zipFileName = "codeRule.in";
            byte[] bosBytes = bos.toByteArray();
            this.writeZipFile(zipf, zipFileName, bosBytes);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private void handleDict(ZipOutputStream zipf, String[] dictIds) {
        HashSet allJpaLeafDictCategorys = Sets.newHashSet();
        Set<DictEntity> allJpaDicts = this.dictService.findDetailsByIds(dictIds);
        for (DictEntity dictEntity : allJpaDicts) {
            allJpaLeafDictCategorys.add(dictEntity.getCategory());
        }
        Collection<DictCategoryEntity> allLeafDictCategorys = this.nebulaToolkitService.copyCollectionByWhiteList(allJpaLeafDictCategorys, DictCategoryEntity.class, DictCategoryEntity.class, HashSet.class, ArrayList.class, new String[0]);
        LinkedList allDictCategorys = Lists.newLinkedList();
        for (DictCategoryEntity leafDictCategoryItem : allLeafDictCategorys) {
            DictCategoryEntity parentDictCategory;
            LinkedList stackDictCategorys = Lists.newLinkedList();
            String leafDictId = leafDictCategoryItem.getId();
            DictCategoryEntity current = this.dictCategoryService.findDetailsById(leafDictId);
            current = this.nebulaToolkitService.copyObjectByWhiteList(current, DictCategoryEntity.class, HashSet.class, ArrayList.class, "parentCategory");
            stackDictCategorys.addFirst(current);
            if (parentDictCategory == null) continue;
            String parentDictCategoryIdf = parentDictCategory.getId();
            for (parentDictCategory = current.getParentCategory(); parentDictCategory != null && !allDictCategorys.stream().filter(item -> StringUtils.equals((CharSequence)item.getId(), (CharSequence)parentDictCategoryIdf)).findAny().isPresent(); parentDictCategory = parentDictCategory.getParentCategory()) {
                Iterator<DictEntity> parentDictCategoryId = parentDictCategory.getId();
                parentDictCategory = this.dictCategoryService.findDetailsById((String)((Object)parentDictCategoryId));
                parentDictCategory = this.nebulaToolkitService.copyObjectByWhiteList(parentDictCategory, DictCategoryEntity.class, HashSet.class, ArrayList.class, "parentCategory");
                stackDictCategorys.addFirst(parentDictCategory);
            }
            allDictCategorys.addAll(stackDictCategorys);
        }
        Collection<DictEntity> allDicts = this.nebulaToolkitService.copyCollectionByWhiteList(allJpaDicts, DictEntity.class, DictEntity.class, HashSet.class, ArrayList.class, "category", "dictItemEntities");
        int dictCategorysSize = allDictCategorys.size();
        int dictsSize = allDicts.size();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeInt(dictCategorysSize);
            oos.writeInt(dictsSize);
            for (DictCategoryEntity dictCategoryItem : allDictCategorys) {
                oos.writeObject(dictCategoryItem);
            }
            for (DictEntity dictItem : allDicts) {
                oos.writeObject(dictItem);
            }
            String zipFileName = "dict.in";
            byte[] bosBytes = bos.toByteArray();
            this.writeZipFile(zipf, zipFileName, bosBytes);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private void handleEnv(ZipOutputStream zipf, String[] envIds) {
        Set<EnvironmentVariableEntity> allJpaEnvs = this.environmentVariableService.findDetailsByIds(envIds);
        Collection<EnvironmentVariableEntity> allEnvs = this.nebulaToolkitService.copyCollectionByWhiteList(allJpaEnvs, EnvironmentVariableEntity.class, EnvironmentVariableEntity.class, HashSet.class, ArrayList.class, new String[0]);
        int envsSize = allEnvs.size();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeInt(envsSize);
            for (EnvironmentVariableEntity envItem : allEnvs) {
                oos.writeObject(envItem);
            }
            String zipFileName = "env.in";
            byte[] bosBytes = bos.toByteArray();
            this.writeZipFile(zipf, zipFileName, bosBytes);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private void handleRemoteService(ZipOutputStream zipf, String[] remoteServiceIds) {
        HashSet allJpaRemoteAddresses = Sets.newHashSet();
        Set<RemoteServiceEntity> allJpaRemoteServices = this.remoteServiceService.findDetailsByIds(remoteServiceIds);
        for (RemoteServiceEntity remoteServiceItem : allJpaRemoteServices) {
            allJpaRemoteAddresses.add(remoteServiceItem.getRemoteServiceAddress());
        }
        Collection<RemoteServiceAddressEntity> allRemoteAddresses = this.nebulaToolkitService.copyCollectionByWhiteList(allJpaRemoteAddresses, RemoteServiceAddressEntity.class, RemoteServiceAddressEntity.class, HashSet.class, ArrayList.class, new String[0]);
        Collection<RemoteServiceEntity> allRemoteServices = this.nebulaToolkitService.copyCollectionByWhiteList(allJpaRemoteServices, RemoteServiceEntity.class, RemoteServiceEntity.class, HashSet.class, ArrayList.class, "remoteServiceAddress");
        int remoteAddressSize = allRemoteAddresses.size();
        int remoteServicesSize = allRemoteServices.size();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeInt(remoteAddressSize);
            oos.writeInt(remoteServicesSize);
            for (RemoteServiceAddressEntity allRemoteAddressItem : allRemoteAddresses) {
                oos.writeObject(allRemoteAddressItem);
            }
            for (RemoteServiceEntity allRemoteServiceItem : allRemoteServices) {
                oos.writeObject(allRemoteServiceItem);
                String relativePath = allRemoteServiceItem.getJsonRelativePath();
                String jsonFileName = allRemoteServiceItem.getJsonName();
                Validate.isTrue((StringUtils.isNotBlank((CharSequence)relativePath) && StringUtils.isNotBlank((CharSequence)jsonFileName) ? 1 : 0) != 0, (String)"\u5728\u8fc1\u51fa\u8fdc\u7aef\u8c03\u7528\u670d\u52a1\u4fe1\u606f[%s]\u53d1\u73b0\u9519\u8bef\u7684\u9644\u4ef6\u63cf\u8ff0\u5730\u5740\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (Object[])new Object[]{allRemoteServiceItem.getId()});
                this.writeZipFile(zipf, relativePath, jsonFileName);
            }
            String zipFileName = "remote.in";
            byte[] bosBytes = bos.toByteArray();
            this.writeZipFile(zipf, zipFileName, bosBytes);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private void writeZipFile(ZipOutputStream zipf, String zipFileName, byte[] bosBytes) throws IOException {
        ZipEntry zipEntry = new ZipEntry(zipFileName);
        zipf.putNextEntry(zipEntry);
        int maxLen = 9060;
        byte[] fileContents = new byte[maxLen];
        int realLen = 0;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bosBytes);){
            while ((realLen = bis.read(fileContents, 0, maxLen)) != -1) {
                zipf.write(fileContents, 0, realLen);
            }
        }
    }

    private void writeZipFile(ZipOutputStream zipf, String relativePath, String fileName) throws IOException {
        byte[] templateLayoutContents = this.nebulaFileService.readFileContent(relativePath, fileName);
        String relativeFilePath = StringUtils.join((Object[])new String[]{relativePath, "/", fileName});
        if (relativeFilePath.indexOf(47) != -1 || relativeFilePath.indexOf(92) != -1) {
            relativeFilePath = relativeFilePath.substring(1, relativeFilePath.length());
        }
        try (ByteArrayInputStream layoutcis = new ByteArrayInputStream(templateLayoutContents);){
            ZipEntry zipEntry = new ZipEntry(relativeFilePath);
            zipf.putNextEntry(zipEntry);
            int maxLen = 9060;
            byte[] fileContents = new byte[maxLen];
            int realLen = 0;
            while ((realLen = ((InputStream)layoutcis).read(fileContents, 0, maxLen)) != -1) {
                zipf.write(fileContents, 0, realLen);
            }
        }
    }
}

