/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.migrate.internal;

import com.bizunited.platform.core.entity.CodeRuleEntity;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.entity.DataViewGroupEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.entity.DictCategoryEntity;
import com.bizunited.platform.core.entity.DictEntity;
import com.bizunited.platform.core.entity.DictItemEntity;
import com.bizunited.platform.core.entity.EnvironmentVariableEntity;
import com.bizunited.platform.core.entity.MigrateConfigAnalysisEntity;
import com.bizunited.platform.core.entity.MigrateImportEntity;
import com.bizunited.platform.core.entity.OrdinaryFileEntity;
import com.bizunited.platform.core.entity.RemoteServiceAddressEntity;
import com.bizunited.platform.core.entity.RemoteServiceEntity;
import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import com.bizunited.platform.core.repository.migrate.MigrateConfigAnalysisRepository;
import com.bizunited.platform.core.repository.migrate.MigrateImportRepository;
import com.bizunited.platform.core.service.CodeRuleService;
import com.bizunited.platform.core.service.DictCategoryService;
import com.bizunited.platform.core.service.DictItemService;
import com.bizunited.platform.core.service.DictService;
import com.bizunited.platform.core.service.EnvironmentVariableService;
import com.bizunited.platform.core.service.RemoteServiceAddressService;
import com.bizunited.platform.core.service.RemoteServiceService;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.dataview.DataSourceService;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalService;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalService;
import com.bizunited.platform.core.service.dataview.DataViewFieldService;
import com.bizunited.platform.core.service.dataview.DataViewGroupService;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.core.service.image.FileUpdateService;
import com.bizunited.platform.core.service.migrate.MigrateImportService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.Principal;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="MigrateImportService")
public class MigrateImportServiceImpl
implements MigrateImportService {
    @Value(value="${kuiper.file.fileRoot}")
    private String fileRoot;
    @Autowired
    private MigrateImportRepository migrateImportRepository;
    @Autowired
    private MigrateConfigAnalysisRepository migrateConfigAnalysisRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private FileUpdateService fileUpdateService;
    @Autowired
    private NebulaFileService nebulaFileService;
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private DynamicDataSourceManager dynamicDataSourceManager;
    @Autowired
    private DataViewService dataViewService;
    @Autowired
    private DataViewGroupService dataViewGroupService;
    @Autowired
    private DataViewAuthHorizontalService dataViewAuthHorizontalService;
    @Autowired
    private DataViewAuthVerticalService dataViewAuthVerticalService;
    @Autowired
    private DataViewFieldService dataViewFieldService;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private CodeRuleService codeRuleService;
    @Autowired
    private DictCategoryService dictCategoryService;
    @Autowired
    private DictService dictService;
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private EnvironmentVariableService environmentVariableService;
    @Autowired
    private RemoteServiceAddressService remoteServiceAddressService;
    @Autowired
    private RemoteServiceService remoteServiceService;
    private static final String DATA_VIEW_FILENAME = "dataview.in";
    private static final String CODE_RULE_FILENAME = "codeRule.in";
    private static final String DICT_FILENAME = "dict.in";
    private static final String ENV_FILENAME = "env.in";
    private static final String REMOTE_FILENAME = "remote.in";
    private static final String ERROR_MESS = "\u6570\u636e\u89c6\u56fe\u6a2a\u5411\u6743\u9650\u5173\u8054\u7684\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01";

    @Override
    public Page<MigrateImportEntity> findByCondition(Map<String, Object> conditions, Pageable pageable) {
        Validate.notNull(conditions, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)pageable, (String)"\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.migrateImportRepository.findByConditions(pageable, conditions);
    }

    @Override
    @Transactional
    public MigrateImportEntity upload(String code, String migrateDesc, Principal currentUser, MultipartFile file) {
        Validate.notNull((Object)file, (String)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)code, (String)"\u4e0a\u6b21\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)currentUser, (String)"\u5f53\u524d\u767b\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        MigrateImportEntity migrateImportEntity = new MigrateImportEntity();
        migrateImportEntity.setCode(code);
        migrateImportEntity.setCreateTime(new Date());
        migrateImportEntity.setExecuted(false);
        migrateImportEntity.setCreator(this.getCurrentUser(currentUser.getName()));
        migrateImportEntity.setOriginalFileName(file.getOriginalFilename());
        Object[] files = new MultipartFile[]{file};
        List<OrdinaryFileEntity> ordinaryFileEntities = this.fileUpdateService.fileUpload("migrate", currentUser.getName(), null, (MultipartFile[])files);
        Validate.notEmpty((Object[])files, (String)"\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        OrdinaryFileEntity fileEntity = ordinaryFileEntities.get(0);
        Validate.notNull((Object)fileEntity, (String)"\u4e0a\u6b21\u6587\u4ef6\u4fdd\u5b58\u8fd4\u56de\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        migrateImportEntity.setFileName(fileEntity.getFileName());
        migrateImportEntity.setRelativeLocal(fileEntity.getRelativeLocal());
        migrateImportEntity.setMigrateDesc(migrateDesc);
        return this.create(migrateImportEntity);
    }

    @Override
    @Transactional
    public MigrateImportEntity create(MigrateImportEntity migrateImportEntity) {
        Validate.notBlank((CharSequence)migrateImportEntity.getCode(), (String)"\u65b0\u589e\u8fc1\u5165\u6587\u4ef6\u7684\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        MigrateImportEntity existCode = this.migrateImportRepository.findByCode(migrateImportEntity.getCode());
        Validate.isTrue((null == existCode ? 1 : 0) != 0, (String)"\u8fc1\u5165\u6587\u4ef6\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)migrateImportEntity.getCreateTime(), (String)"\u4fdd\u5b58\u8bb0\u5f55\u65f6\uff0c\u5bfc\u5165\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)migrateImportEntity.getRelativeLocal(), (String)"\u8fc1\u5165\u6587\u4ef6\u5728\u672c\u5730\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)migrateImportEntity.getFileName(), (String)"\u8fc1\u5165\u6587\u4ef6\u91cd\u547d\u540d\u540e\u7684\u6587\u4ef6\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)migrateImportEntity.getCreator(), (String)"\u8fc1\u5165\u6587\u4ef6\u4e0a\u4f20\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)migrateImportEntity.getCreateTime(), (String)"\u8fc1\u5165\u6587\u4ef6\u4e0a\u4f20\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)migrateImportEntity.getExecuted(), (String)"\u8fc1\u5165\u6587\u4ef6\u4efb\u52a1\u662f\u5426\u88ab\u6267\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return (MigrateImportEntity)this.migrateImportRepository.save(migrateImportEntity);
    }

    @Override
    @Transactional
    public MigrateConfigAnalysisEntity analysisConfig(String migrateImportId, Principal currentUser) {
        Validate.notBlank((CharSequence)migrateImportId, (String)"\u8fc1\u5165\u4e0a\u4f20ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)migrateImportId, (String)"\u8fc1\u5165\u4e0a\u4f20ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional importEntityOp = this.migrateImportRepository.findById(migrateImportId);
        MigrateImportEntity importEntity = importEntityOp.orElse(null);
        Validate.notNull((Object)importEntity, (String)"\u4e0a\u4f20\u8bb0\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        MigrateConfigAnalysisEntity result = new MigrateConfigAnalysisEntity();
        String fileName = importEntity.getFileName();
        String relativeLocal = importEntity.getRelativeLocal();
        byte[] fileBytes = this.nebulaFileService.readFileContent(relativeLocal, fileName);
        File localFile = this.saveByteToLocalFile(fileBytes);
        try (ZipFile zipFile = new ZipFile(localFile);){
            this.analysisDataView(zipFile, result);
            this.analysisCodeRule(zipFile, result);
            this.analysisDict(zipFile, result);
            this.analysisEnv(zipFile, result);
            this.analysisRemote(zipFile, result);
            result.setMigrateImportEntity(importEntity);
            result.setCreateTime(new Date());
            result.setExecutor(this.getCurrentUser(currentUser.getName()));
            result = (MigrateConfigAnalysisEntity)this.migrateConfigAnalysisRepository.save(result);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException("\u89e3\u6790\u8fc1\u5165\u57fa\u7840\u914d\u7f6e\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        return result;
    }

    @Override
    @Transactional
    public MigrateImportEntity execute(String migrateImportId, Principal currentUser) {
        Validate.notBlank((CharSequence)migrateImportId, (String)"\u8fc1\u79fb\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional importEntityOp = this.migrateImportRepository.findById(migrateImportId);
        MigrateImportEntity importEntity = importEntityOp.orElse(null);
        Validate.notNull((Object)importEntity, (String)"\u4e0a\u4f20\u8bb0\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String fileName = importEntity.getFileName();
        String relativeLocal = importEntity.getRelativeLocal();
        byte[] fileBytes = this.nebulaFileService.readFileContent(relativeLocal, fileName);
        File localFile = this.saveByteToLocalFile(fileBytes);
        try (ZipFile zipFile = new ZipFile(localFile);){
            this.executeDataView(zipFile, currentUser);
            this.executeCodeRule(zipFile);
            this.executeDict(zipFile);
            this.executeEnv(zipFile, currentUser);
            this.executeRemoteService(zipFile);
            importEntity.setExecuted(true);
            importEntity.setExecutor(this.getCurrentUser(currentUser.getName()));
            importEntity.setExecuteTime(new Date());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException("\u6267\u884c\u8fc1\u5165\u57fa\u7840\u914d\u7f6e\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        return (MigrateImportEntity)this.migrateImportRepository.save(importEntity);
    }

    @Override
    public Set<MigrateConfigAnalysisEntity> findConfigAnalysisByImport(String importId) {
        if (StringUtils.isBlank((CharSequence)importId)) {
            return null;
        }
        return this.migrateConfigAnalysisRepository.findByImportId(importId);
    }

    private UserEntity getCurrentUser(String account) {
        UserVo userVo = this.userService.findByAccount(account);
        Validate.notNull((Object)userVo, (String)"\u4e0a\u4f20\u6a21\u677f\u4fe1\u606f\u65f6\u672a\u627e\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        UserEntity userEntity = new UserEntity();
        userEntity.setId(userVo.getId());
        return userEntity;
    }

    private void analysisDataView(ZipFile zipFile, MigrateConfigAnalysisEntity result) throws IOException, ClassNotFoundException {
        int i;
        ZipEntry dataViewEntry = zipFile.getEntry(DATA_VIEW_FILENAME);
        if (dataViewEntry == null) {
            return;
        }
        InputStream is = zipFile.getInputStream(dataViewEntry);
        ObjectInputStream ois = new ObjectInputStream(is);
        Integer dataSourceNum = ois.readInt();
        Integer dataGroupNum = ois.readInt();
        Integer dataViewNum = ois.readInt();
        Integer dataAuthHorNum = ois.readInt();
        Integer dataAuthVerNum = ois.readInt();
        result.setDataviewSourceNum(dataSourceNum);
        result.setDataviewGroupNum(dataGroupNum);
        result.setDataviewNum(dataViewNum);
        result.setDataviewAuthHorNum(dataAuthHorNum);
        result.setDataviewAuthVerNum(dataAuthVerNum);
        for (i = 0; dataSourceNum != null && i < dataSourceNum; ++i) {
            DataSourceEntity existSource;
            DataSourceEntity sourceEntity = (DataSourceEntity)ois.readObject();
            if (sourceEntity == null || (existSource = this.dataSourceService.findDetailsByCode(sourceEntity.getCode())) != null) continue;
            result.setDataviewSourceCreate(result.getDataviewSourceCreate() + 1);
        }
        for (i = 0; dataGroupNum != null && i < dataGroupNum; ++i) {
            DataViewGroupEntity existGroup;
            DataViewGroupEntity groupEntity = (DataViewGroupEntity)ois.readObject();
            if (groupEntity == null || (existGroup = this.dataViewGroupService.findByCode(groupEntity.getCode())) != null) continue;
            result.setDataviewGroupCreate(result.getDataviewGroupCreate() + 1);
        }
        for (i = 0; dataViewNum != null && i < dataViewNum; ++i) {
            DataViewEntity existDataview;
            DataViewEntity dataView = (DataViewEntity)ois.readObject();
            if (dataView == null || (existDataview = this.dataViewService.findByCode(dataView.getCode())) != null) continue;
            result.setDataviewCreate(result.getDataviewCreate() + 1);
        }
        for (i = 0; dataAuthHorNum != null && i < dataAuthHorNum; ++i) {
            DataViewAuthHorizontalEntity horizontalEntity = (DataViewAuthHorizontalEntity)ois.readObject();
            if (horizontalEntity == null) continue;
            result.setDataviewAuthHorCreate(result.getDataviewAuthHorCreate() + 1);
        }
        for (i = 0; dataAuthVerNum != null && i < dataAuthVerNum; ++i) {
            DataViewAuthVerticalEntity verticalEntity = (DataViewAuthVerticalEntity)ois.readObject();
            if (verticalEntity == null) continue;
            result.setDataviewAuthVerCreate(result.getDataviewAuthVerCreate() + 1);
        }
    }

    private void analysisCodeRule(ZipFile zipFile, MigrateConfigAnalysisEntity result) throws IOException, ClassNotFoundException {
        int i;
        ZipEntry codeRuleEntry = zipFile.getEntry(CODE_RULE_FILENAME);
        if (codeRuleEntry == null) {
            return;
        }
        InputStream is = zipFile.getInputStream(codeRuleEntry);
        ObjectInputStream ois = new ObjectInputStream(is);
        Integer scriptNum = ois.readInt();
        Integer codeRuleNum = ois.readInt();
        result.setScriptNum(scriptNum);
        result.setCodeRuleNum(codeRuleNum);
        for (i = 0; scriptNum != null && i < scriptNum; ++i) {
            ScriptEntity existName;
            ScriptEntity scriptEntity = (ScriptEntity)ois.readObject();
            if (scriptEntity == null || (existName = this.scriptService.findByName(scriptEntity.getName())) != null) continue;
            result.setScriptCreate(result.getScriptCreate() + 1);
        }
        for (i = 0; codeRuleNum != null && i < codeRuleNum; ++i) {
            CodeRuleEntity existCode;
            CodeRuleEntity codeRuleEntity = (CodeRuleEntity)ois.readObject();
            if (codeRuleEntity == null || (existCode = this.codeRuleService.findByRuleCode(codeRuleEntity.getRuleCode())) != null) continue;
            result.setCodeRuleCreate(result.getCodeRuleCreate() + 1);
        }
    }

    private void analysisDict(ZipFile zipFile, MigrateConfigAnalysisEntity result) throws IOException, ClassNotFoundException {
        int i;
        ZipEntry dictEntry = zipFile.getEntry(DICT_FILENAME);
        if (dictEntry == null) {
            return;
        }
        InputStream is = zipFile.getInputStream(dictEntry);
        ObjectInputStream ois = new ObjectInputStream(is);
        Integer dictCateNum = ois.readInt();
        Integer dictNum = ois.readInt();
        result.setDictCateNum(dictCateNum);
        result.setDictNum(dictNum);
        for (i = 0; dictCateNum != null && i < dictCateNum; ++i) {
            DictCategoryEntity existDictCategory;
            DictCategoryEntity dictCategory = (DictCategoryEntity)ois.readObject();
            if (dictCategory == null || (existDictCategory = this.dictCategoryService.findByCode(dictCategory.getCateCode())) != null) continue;
            result.setDictCateCreate(result.getDictCateCreate() + 1);
        }
        for (i = 0; dictNum != null && i < dictNum; ++i) {
            DictEntity existDictEntity;
            DictEntity dictEntity = (DictEntity)ois.readObject();
            if (dictEntity == null || (existDictEntity = this.dictService.findByDictCode(dictEntity.getDictCode())) != null) continue;
            result.setDictCreate(result.getDictCreate() + 1);
        }
    }

    private void analysisEnv(ZipFile zipFile, MigrateConfigAnalysisEntity result) throws IOException, ClassNotFoundException {
        ZipEntry envEntry = zipFile.getEntry(ENV_FILENAME);
        if (envEntry == null) {
            return;
        }
        InputStream is = zipFile.getInputStream(envEntry);
        ObjectInputStream ois = new ObjectInputStream(is);
        Integer envNum = ois.readInt();
        result.setEnvNum(envNum);
        for (int i = 0; envNum != null && i < envNum; ++i) {
            EnvironmentVariableEntity env = (EnvironmentVariableEntity)ois.readObject();
            if (env == null) continue;
            EnvironmentVariableEntity existCode = this.environmentVariableService.findByCode(env.getParamCode());
            EnvironmentVariableEntity existKey = this.environmentVariableService.findByKey(env.getParamKey());
            if (existCode != null || existKey != null) continue;
            result.setDictCreate(result.getDictCreate() + 1);
        }
    }

    private void analysisRemote(ZipFile zipFile, MigrateConfigAnalysisEntity result) throws IOException, ClassNotFoundException {
        int i;
        ZipEntry remoteEntry = zipFile.getEntry(REMOTE_FILENAME);
        if (remoteEntry == null) {
            return;
        }
        InputStream is = zipFile.getInputStream(remoteEntry);
        ObjectInputStream ois = new ObjectInputStream(is);
        Integer remoteAddressNum = ois.readInt();
        Integer remoteServiceNum = ois.readInt();
        result.setRemoteAddressNum(remoteAddressNum);
        result.setRemoteServiceNum(remoteServiceNum);
        for (i = 0; remoteAddressNum != null && i < remoteAddressNum; ++i) {
            RemoteServiceAddressEntity existAddress;
            RemoteServiceAddressEntity address = (RemoteServiceAddressEntity)ois.readObject();
            if (address == null || (existAddress = this.remoteServiceAddressService.findByCode(address.getCode())) != null) continue;
            result.setRemoteAddressCreate(result.getRemoteAddressCreate() + 1);
        }
        for (i = 0; remoteServiceNum != null && i < remoteServiceNum; ++i) {
            RemoteServiceEntity existService;
            RemoteServiceEntity service = (RemoteServiceEntity)ois.readObject();
            if (service == null || (existService = this.remoteServiceService.findByCode(service.getCode())) != null) continue;
            result.setRemoteServiceCreate(result.getRemoteServiceCreate() + 1);
        }
    }

    private void executeDataView(ZipFile zipFile, Principal currentUser) throws IOException, ClassNotFoundException {
        Set<UuidEntity> relations;
        DataViewFieldEntity newFieldEntity;
        DataViewFieldEntity oldFieldEntity;
        DataViewEntity newDataView;
        DataViewEntity oldDataView;
        int i;
        ZipEntry dataViewEntry = zipFile.getEntry(DATA_VIEW_FILENAME);
        if (dataViewEntry == null) {
            return;
        }
        HashMap<String, String> idmap = new HashMap<String, String>();
        InputStream is = zipFile.getInputStream(dataViewEntry);
        ObjectInputStream ois = new ObjectInputStream(is);
        Integer dataSourceNum = ois.readInt();
        Integer dataGroupNum = ois.readInt();
        Integer dataViewNum = ois.readInt();
        Integer dataAuthHorNum = ois.readInt();
        Integer dataAuthVerNum = ois.readInt();
        for (i = 0; dataSourceNum != null && i < dataSourceNum; ++i) {
            DataSourceEntity existSource;
            DataSourceEntity sourceEntity = (DataSourceEntity)ois.readObject();
            if (sourceEntity == null || (existSource = this.dataSourceService.findDetailsByCode(sourceEntity.getCode())) != null) continue;
            String oldSourceId = sourceEntity.getId();
            sourceEntity.setId(null);
            sourceEntity = this.dynamicDataSourceManager.create(sourceEntity);
            this.migrateImportRepository.flush();
            idmap.put(oldSourceId, sourceEntity.getId());
        }
        for (i = 0; dataGroupNum != null && i < dataGroupNum; ++i) {
            DataViewGroupEntity existGroup;
            DataViewGroupEntity groupEntity = (DataViewGroupEntity)ois.readObject();
            if (groupEntity == null || (existGroup = this.dataViewGroupService.findByCode(groupEntity.getCode())) != null) continue;
            String oldGroupId = groupEntity.getId();
            groupEntity.setId(null);
            DataSourceEntity oldSource = groupEntity.getDataSource();
            if (oldSource != null) {
                oldSource.setId((String)idmap.get(oldSource.getId()));
                groupEntity.setDataSource(oldSource);
            }
            groupEntity = this.dataViewGroupService.create(groupEntity, false);
            this.migrateImportRepository.flush();
            idmap.put(oldGroupId, groupEntity.getId());
        }
        for (i = 0; dataViewNum != null && i < dataViewNum; ++i) {
            DataViewGroupEntity dataViewGroup;
            DataViewEntity existDataView;
            DataViewEntity dataView = (DataViewEntity)ois.readObject();
            if (dataView == null || (existDataView = this.dataViewService.findByCode(dataView.getCode())) != null) continue;
            String oldDataViewId = dataView.getId();
            dataView.setId(null);
            DataSourceEntity dataSource = dataView.getDataSource();
            if (dataSource != null) {
                dataSource.setId((String)idmap.get(dataSource.getId()));
                dataView.setDataSource(dataSource);
            }
            if ((dataViewGroup = dataView.getDataViewGroup()) != null) {
                dataViewGroup.setId((String)idmap.get(dataViewGroup.getId()));
                dataView.setDataViewGroup(dataViewGroup);
            }
            this.removeDataViewItemId(dataView);
            dataView = this.dataViewService.create(dataView, true);
            this.migrateImportRepository.flush();
            idmap.put(oldDataViewId, dataView.getId());
        }
        for (i = 0; dataAuthHorNum != null && i < dataAuthHorNum; ++i) {
            DataViewAuthHorizontalEntity horizontalEntity = (DataViewAuthHorizontalEntity)ois.readObject();
            if (horizontalEntity == null) continue;
            oldDataView = horizontalEntity.getDataView();
            Validate.notNull((Object)oldDataView, (String)ERROR_MESS, (Object[])new Object[0]);
            newDataView = new DataViewEntity();
            newDataView.setId((String)idmap.get(oldDataView.getId()));
            horizontalEntity.setDataView(newDataView);
            oldFieldEntity = horizontalEntity.getField();
            Validate.notNull((Object)oldFieldEntity, (String)ERROR_MESS, (Object[])new Object[0]);
            newFieldEntity = this.dataViewFieldService.findByCode(oldFieldEntity.getCode());
            horizontalEntity.setField(newFieldEntity);
            relations = horizontalEntity.getAuthRelations();
            if (!CollectionUtils.isEmpty(relations)) {
                for (UuidEntity relation : relations) {
                    relation.setId(null);
                }
                horizontalEntity.setAuthRelations(relations);
            }
            HashSet<DataViewAuthHorizontalEntity> sets = new HashSet<DataViewAuthHorizontalEntity>();
            horizontalEntity.setId(null);
            sets.add(horizontalEntity);
            this.dataViewAuthHorizontalService.create((Set<DataViewAuthHorizontalEntity>)sets);
            this.migrateImportRepository.flush();
        }
        for (i = 0; dataAuthVerNum != null && i < dataAuthVerNum; ++i) {
            DataViewAuthVerticalEntity verticalEntity = (DataViewAuthVerticalEntity)ois.readObject();
            if (verticalEntity == null) continue;
            oldDataView = verticalEntity.getDataView();
            Validate.notNull((Object)oldDataView, (String)"\u6570\u636e\u89c6\u56fe\u7eb5\u5411\u6743\u9650\u5173\u8054\u7684\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            newDataView = new DataViewEntity();
            newDataView.setId((String)idmap.get(oldDataView.getId()));
            verticalEntity.setDataView(newDataView);
            oldFieldEntity = verticalEntity.getField();
            Validate.notNull((Object)oldFieldEntity, (String)ERROR_MESS, (Object[])new Object[0]);
            newFieldEntity = this.dataViewFieldService.findByCode(oldFieldEntity.getCode());
            Validate.notNull((Object)newFieldEntity, (String)"\u672a\u627e\u5230\u7eb5\u5411\u6570\u636e\u89c6\u56fe\u5173\u8054\u7684\u8f93\u51fa\u5b57\u6bb5\u4fe1\u606f\u5728\u65b0\u73af\u5883\u4e2d\u7684\u5b9e\u4f53\uff01", (Object[])new Object[0]);
            verticalEntity.setField(newFieldEntity);
            relations = verticalEntity.getAuthRelations();
            if (!CollectionUtils.isEmpty(relations)) {
                for (UuidEntity relation : relations) {
                    relation.setId(null);
                }
                verticalEntity.setAuthRelations(relations);
            }
            Set<DataViewFieldEntity> displayFields = verticalEntity.getDisplayFields();
            HashSet<DataViewFieldEntity> newDisplayFields = new HashSet<DataViewFieldEntity>();
            if (!CollectionUtils.isEmpty(displayFields)) {
                for (DataViewFieldEntity displayField : displayFields) {
                    DataViewFieldEntity newDisplayField = this.dataViewFieldService.findByCode(displayField.getCode());
                    Validate.notNull((Object)newDisplayField, (String)"\u672a\u627e\u5230\u7eb5\u5411\u6570\u636e\u89c6\u56fe\u5173\u8054\u7684displayFields\u5728\u65b0\u73af\u5883\u4e2d\u7684\u5b9e\u4f53!", (Object[])new Object[0]);
                    newDisplayFields.add(newDisplayField);
                }
                verticalEntity.setDisplayFields(newDisplayFields);
            }
            HashSet<DataViewAuthVerticalEntity> sets = new HashSet<DataViewAuthVerticalEntity>();
            verticalEntity.setId(null);
            sets.add(verticalEntity);
            this.dataViewAuthVerticalService.create(sets);
            this.migrateImportRepository.flush();
        }
    }

    private void removeDataViewItemId(DataViewEntity dataViewEntity) {
        Validate.notNull((Object)dataViewEntity, (String)"\u63d2\u5165\u7684\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(dataViewEntity.getFields())) {
            for (DataViewFieldEntity field : dataViewEntity.getFields()) {
                field.setId(null);
            }
        }
        if (!CollectionUtils.isEmpty(dataViewEntity.getFilters())) {
            for (DataViewFilterEntity filter : dataViewEntity.getFilters()) {
                filter.setId(null);
            }
        }
        if (!CollectionUtils.isEmpty(dataViewEntity.getSystemFilters())) {
            for (DataViewSystemEntity system : dataViewEntity.getSystemFilters()) {
                system.setId(null);
            }
        }
    }

    private void executeCodeRule(ZipFile zipFile) throws IOException, ClassNotFoundException {
        int i;
        ZipEntry codeRuleEntry = zipFile.getEntry(CODE_RULE_FILENAME);
        if (codeRuleEntry == null) {
            return;
        }
        HashMap<String, String> idmap = new HashMap<String, String>();
        InputStream is = zipFile.getInputStream(codeRuleEntry);
        ObjectInputStream ois = new ObjectInputStream(is);
        Integer scriptNum = ois.readInt();
        Integer codeRuleNum = ois.readInt();
        for (i = 0; scriptNum != null && i < scriptNum; ++i) {
            ScriptEntity existName;
            ScriptEntity scriptEntity = (ScriptEntity)ois.readObject();
            if (scriptEntity == null || (existName = this.scriptService.findByName(scriptEntity.getName())) != null) continue;
            Boolean startWith = StringUtils.startsWith((CharSequence)scriptEntity.getFileCode(), (CharSequence)"/") || StringUtils.startsWith((CharSequence)scriptEntity.getFileCode(), (CharSequence)"\\");
            String filePath = startWith != false ? scriptEntity.getFileCode().substring(1) : scriptEntity.getFileCode();
            String fullScriptFilePath = StringUtils.join((Object[])new String[]{filePath, "/", scriptEntity.getFileName()});
            ZipEntry scriptFile = zipFile.getEntry(fullScriptFilePath);
            InputStream inputStream = zipFile.getInputStream(scriptFile);
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            String base64 = Base64.getEncoder().encodeToString(bytes);
            String oldScriptId = scriptEntity.getId();
            scriptEntity.setId(null);
            scriptEntity = this.scriptService.create(scriptEntity, base64);
            this.migrateImportRepository.flush();
            idmap.put(oldScriptId, scriptEntity.getId());
        }
        for (i = 0; codeRuleNum != null && i < codeRuleNum; ++i) {
            CodeRuleEntity codeRuleEntity = (CodeRuleEntity)ois.readObject();
            if (codeRuleEntity == null) continue;
            CodeRuleEntity existCode = this.codeRuleService.findByRuleCode(codeRuleEntity.getRuleCode());
            CodeRuleEntity existName = this.codeRuleService.findByRuleName(codeRuleEntity.getRuleName());
            ScriptEntity script = codeRuleEntity.getScript();
            if (existCode != null || existName != null || script == null) continue;
            script = this.scriptService.findByName(script.getName());
            codeRuleEntity.setScript(script);
            codeRuleEntity.setId(null);
            this.codeRuleService.create(codeRuleEntity);
            this.migrateImportRepository.flush();
        }
    }

    private void executeDict(ZipFile zipFile) throws IOException, ClassNotFoundException {
        int i;
        ZipEntry dictEntry = zipFile.getEntry(DICT_FILENAME);
        if (dictEntry == null) {
            return;
        }
        HashMap<String, String> idMaps = new HashMap<String, String>();
        InputStream is = zipFile.getInputStream(dictEntry);
        ObjectInputStream ois = new ObjectInputStream(is);
        Integer dictCateNum = ois.readInt();
        Integer dictNum = ois.readInt();
        for (i = 0; dictCateNum != null && i < dictCateNum; ++i) {
            DictCategoryEntity existDictCategory;
            DictCategoryEntity dictCategory = (DictCategoryEntity)ois.readObject();
            if (dictCategory == null || (existDictCategory = this.dictCategoryService.findByCode(dictCategory.getCateCode())) != null) continue;
            String oldId = dictCategory.getId();
            DictCategoryEntity parentCate = dictCategory.getParentCategory();
            String parentId = null;
            if (parentCate != null) {
                parentId = (String)idMaps.get(parentCate.getId());
                Validate.notBlank((CharSequence)parentId, (String)"\u4fdd\u5b58\u5b57\u5178\u5206\u7ec4\u4e2d\uff0c\u672a\u627e\u5230\u5b57\u5178\u5206\u7ec4\u7684\u7236\u7ea7\u5206\u7ec4\u5728\u8fc1\u79fb\u540e\u73af\u5883\u4e2d\u7684ID", (Object[])new Object[0]);
            }
            dictCategory.setId(null);
            dictCategory = this.dictCategoryService.create(dictCategory, parentId);
            this.migrateImportRepository.flush();
            idMaps.put(oldId, dictCategory.getId());
        }
        for (i = 0; dictNum != null && i < dictNum; ++i) {
            DictEntity existDictEntity;
            DictEntity dictEntity = (DictEntity)ois.readObject();
            if (dictEntity == null || (existDictEntity = this.dictService.findByDictCode(dictEntity.getDictCode())) != null) continue;
            DictCategoryEntity dictCategory = dictEntity.getCategory();
            Validate.notNull((Object)dictCategory, (String)"\u8fc1\u79fb\u5b57\u5178\u4e2d\uff0c\u672a\u53d1\u73b0\u5b57\u5178\u7684\u76f8\u5173\u5206\u7ec4\u4fe1\u606f\uff01", (Object[])new Object[0]);
            String newParentId = (String)idMaps.get(dictCategory.getId());
            Validate.notBlank((CharSequence)newParentId, (String)"\u8fc1\u79fb\u5b57\u5178\u4e2d\uff0c\u672a\u53d1\u73b0\u5b57\u5178\u7684\u76f8\u5173\u5206\u7ec4ID\u4fe1\u606f\uff01", (Object[])new Object[0]);
            dictCategory.setId(newParentId);
            dictEntity.setCategory(dictCategory);
            dictEntity.setDictStatus(false);
            Set<DictItemEntity> dictItems = dictEntity.getDictItemEntities();
            dictEntity.setDictItemEntities(null);
            dictEntity = this.dictService.create(dictEntity, newParentId);
            this.migrateImportRepository.flush();
            if (CollectionUtils.isEmpty(dictItems)) continue;
            List<DictItemEntity> dictItemEntities = dictItems.stream().map(o -> {
                o.setId(null);
                return o;
            }).collect(Collectors.toList());
            this.dictItemService.updateItems(dictEntity.getDictCode(), dictItemEntities);
            this.migrateImportRepository.flush();
        }
    }

    private void executeEnv(ZipFile zipFile, Principal currentUser) throws IOException, ClassNotFoundException {
        ZipEntry envEntry = zipFile.getEntry(ENV_FILENAME);
        if (envEntry == null) {
            return;
        }
        InputStream is = zipFile.getInputStream(envEntry);
        ObjectInputStream ois = new ObjectInputStream(is);
        Integer envNum = ois.readInt();
        for (int i = 0; envNum != null && i < envNum; ++i) {
            EnvironmentVariableEntity env = (EnvironmentVariableEntity)ois.readObject();
            if (env == null) continue;
            EnvironmentVariableEntity existCode = this.environmentVariableService.findByCode(env.getParamCode());
            EnvironmentVariableEntity existKey = this.environmentVariableService.findByKey(env.getParamKey());
            if (existCode != null || existKey != null) continue;
            env.setId(null);
            env.setCreateUser(this.getCurrentUser(currentUser.getName()));
            env.setCreateDate(new Date());
            env.setModifyUser(this.getCurrentUser(currentUser.getName()));
            env.setModifyDate(new Date());
            this.environmentVariableService.save(env);
        }
    }

    private void executeRemoteService(ZipFile zipFile) throws IOException, ClassNotFoundException {
        int i;
        ZipEntry remoteEntry = zipFile.getEntry(REMOTE_FILENAME);
        if (remoteEntry == null) {
            return;
        }
        HashMap<String, String> idMaps = new HashMap<String, String>();
        InputStream is = zipFile.getInputStream(remoteEntry);
        ObjectInputStream ois = new ObjectInputStream(is);
        Integer remoteAddressNum = ois.readInt();
        Integer remoteServiceNum = ois.readInt();
        for (i = 0; remoteAddressNum != null && i < remoteAddressNum; ++i) {
            RemoteServiceAddressEntity existAddress;
            RemoteServiceAddressEntity address = (RemoteServiceAddressEntity)ois.readObject();
            if (address == null || (existAddress = this.remoteServiceAddressService.findByCode(address.getCode())) != null) continue;
            String oldId = address.getId();
            address.setId(null);
            address = this.remoteServiceAddressService.create(address);
            this.migrateImportRepository.flush();
            idMaps.put(oldId, address.getId());
        }
        for (i = 0; remoteServiceNum != null && i < remoteServiceNum; ++i) {
            RemoteServiceEntity existService;
            RemoteServiceEntity service = (RemoteServiceEntity)ois.readObject();
            if (service == null || (existService = this.remoteServiceService.findByCode(service.getCode())) != null) continue;
            service.setId(null);
            RemoteServiceAddressEntity address = service.getRemoteServiceAddress();
            Validate.notNull((Object)address, (String)"\u4fdd\u5b58\u670d\u52a1\u6e90\u65f6\uff0c\u76f8\u5173\u670d\u52a1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String newAddressId = (String)idMaps.get(address.getId());
            RemoteServiceAddressEntity newAddress = new RemoteServiceAddressEntity();
            newAddress.setId(newAddressId);
            service.setRemoteServiceAddress(newAddress);
            Boolean startWith = StringUtils.startsWith((CharSequence)service.getJsonRelativePath(), (CharSequence)"/") || StringUtils.startsWith((CharSequence)service.getJsonRelativePath(), (CharSequence)"\\");
            String filePath = startWith != false ? service.getJsonRelativePath().substring(1) : service.getJsonRelativePath();
            String fullScriptFilePath = StringUtils.join((Object[])new String[]{filePath, "/", service.getJsonName()});
            ZipEntry scriptFile = zipFile.getEntry(fullScriptFilePath);
            InputStream inputStream = zipFile.getInputStream(scriptFile);
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            this.nebulaFileService.saveFile(service.getJsonRelativePath(), service.getJsonName(), service.getJsonName(), bytes);
            this.remoteServiceService.create(service);
        }
    }

    private File saveByteToLocalFile(byte[] bytes) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        String uuid = UUID.randomUUID().toString();
        File localFile = new File(StringUtils.join((Object[])new String[]{this.fileRoot, "/migrateImportTemp/", uuid, ".zip"}));
        File parentFile = localFile.getParentFile();
        try {
            if (!parentFile.exists()) {
                Validate.isTrue((boolean)parentFile.mkdirs(), (String)"\u7cfb\u7edf\u521b\u5efa\u7236\u6587\u4ef6\u5939\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7cfb\u7edf\u8bbe\u5b9a!!", (Object[])new Object[0]);
            }
            if (!localFile.exists()) {
                Validate.isTrue((boolean)localFile.createNewFile(), (String)"\u7cfb\u7edf\u521b\u5efa\u6587\u4ef6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7cfb\u7edf\u8bbe\u5b9a!!", (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        try (FileOutputStream os = new FileOutputStream(localFile);){
            int realLen;
            int maxLen = 4096;
            byte[] contents = new byte[maxLen];
            while ((realLen = byteArrayInputStream.read(contents, 0, maxLen)) != -1) {
                os.write(contents, 0, realLen);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("\u89e3\u6790\u4e0a\u4f20\u6587\u4ef6\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        return localFile;
    }
}

