/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.scheduler;

import com.bizunited.platform.core.entity.DynamicTaskSchedulerEntity;
import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.repository.DynamicTaskSchedulerRepository;
import com.bizunited.platform.core.service.DynamicTaskSchedulerService;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.scheduler.DynamicTask;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DynamicTaskSchedulerServiceImpl")
public class DynamicTaskSchedulerServiceImpl
implements DynamicTaskSchedulerService {
    @Autowired
    @Qualifier(value="platform_dynamicTaskScheduler")
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;
    @Autowired
    private DynamicTaskSchedulerRepository dynamicTaskSchedulerRepository;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private UserService userService;
    private Map<String, ScheduledFuture<?>> taskMapping = new ConcurrentHashMap();
    private static final String ERROR_MESS = "\u5468\u671f\u6027\u4efb\u52a1\u6267\u884c\u8868\u5355\u5f0f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!";
    private static final String ERROR_MESS_CHARSET = "\u5468\u671f\u6027\u8868\u5355\u65f6\u7684\u4e2d\u6587,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!";

    @Override
    @Transactional
    public void interrupt(String taskCode) {
        Validate.notBlank((CharSequence)taskCode, (String)"\u505c\u6b62\u52a8\u6001\u4efb\u52a1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u4efb\u52a1\u7f16\u53f7", (Object[])new Object[0]);
        DynamicTaskSchedulerEntity current = this.dynamicTaskSchedulerRepository.findByTaskCode(taskCode);
        Validate.notNull((Object)current, (String)"\u672a\u53d1\u73b0\u4efb\u52a1\u7f16\u53f7\u5bf9\u5e94\u7684\u4efb\u52a1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        current.setWorkingStatus(1);
        this.dynamicTaskSchedulerRepository.save(current);
    }

    @Override
    @Transactional
    public void start(String taskCode) {
        Validate.notBlank((CharSequence)taskCode, (String)"\u505c\u6b62\u52a8\u6001\u4efb\u52a1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u4efb\u52a1\u7f16\u53f7", (Object[])new Object[0]);
        DynamicTaskSchedulerEntity current = this.dynamicTaskSchedulerRepository.findByTaskCode(taskCode);
        Validate.notNull((Object)current, (String)"\u672a\u53d1\u73b0\u4efb\u52a1\u7f16\u53f7\u5bf9\u5e94\u7684\u4efb\u52a1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        current.setWorkingStatus(0);
        current.setTstatus(1);
        this.dynamicTaskSchedulerRepository.save(current);
    }

    @Override
    @Transactional
    public void loading() {
        Set<DynamicTaskSchedulerEntity> invalidTasks;
        Set<DynamicTaskSchedulerEntity> statusTasks;
        ScheduledFuture<?> scheduledFuture;
        int[] workingStatuses = new int[]{0, 2};
        Set<DynamicTaskSchedulerEntity> tasks = this.dynamicTaskSchedulerRepository.findByTstatusAndWorkingStatus(1, workingStatuses);
        ArrayList<String> runningTaskCodes = new ArrayList<String>(100);
        ArrayList<String> invalidTaskCodes = new ArrayList<String>(100);
        if (!CollectionUtils.isEmpty(tasks)) {
            Date currentTime = new Date();
            for (DynamicTaskSchedulerEntity task : tasks) {
                ScheduledFuture scheduledFuture2;
                String taskCode = task.getTaskCode();
                Date validityTime = task.getValidityTime();
                if (validityTime != null && validityTime.getTime() < currentTime.getTime()) {
                    scheduledFuture = this.taskMapping.get(taskCode);
                    if (scheduledFuture != null) {
                        scheduledFuture.cancel(true);
                        this.taskMapping.remove(taskCode);
                    }
                    invalidTaskCodes.add(taskCode);
                    continue;
                }
                if (this.taskMapping.get(taskCode) != null) {
                    runningTaskCodes.add(taskCode);
                    continue;
                }
                DynamicTaskSchedulerEntity currentTask = this.nebulaToolkitService.copyObjectByWhiteList(task, DynamicTaskSchedulerEntity.class, LinkedHashSet.class, LinkedList.class, "script");
                DynamicTask dynamicTask = new DynamicTask(currentTask, this.applicationContext);
                if (task.getTaskType() == 1) {
                    Date executePoint = task.getExecutePoint();
                    String cornExpression = task.getExecuteExpression();
                    Validate.isTrue((executePoint != null || !StringUtils.isBlank((CharSequence)cornExpression) ? 1 : 0) != 0, (String)"\u6307\u5b9a\u4efb\u52a1[%s]\u662f\u4e00\u4e2a\u4e00\u6b21\u6027\u4efb\u52a1\uff0c\u4f46\u662f\u5374\u6ca1\u6709\u6307\u5b9a\u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{task.getTaskCode()});
                    scheduledFuture2 = null;
                    if (executePoint != null) {
                        scheduledFuture2 = this.threadPoolTaskScheduler.schedule((Runnable)dynamicTask, executePoint);
                    } else {
                        CronTrigger cronTrigger = new CronTrigger(cornExpression);
                        scheduledFuture2 = this.threadPoolTaskScheduler.schedule((Runnable)dynamicTask, (Trigger)cronTrigger);
                    }
                    this.taskMapping.put(taskCode, scheduledFuture2);
                    runningTaskCodes.add(taskCode);
                    continue;
                }
                if (task.getTaskType() == 2) {
                    String cornExpression = task.getExecuteExpression();
                    Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)cornExpression), (String)"\u6307\u5b9a\u52a8\u6001\u4efb\u52a1[%s]\u662f\u4e00\u4e2a\u5468\u671f\u6027\u4efb\u52a1\uff0c\u4f46\u662f\u5374\u6ca1\u6709\u6307\u5b9a\u6709\u6548\u7684corn\u8868\u8fbe\u5f0f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{task.getTaskCode()});
                    CronTrigger cronTrigger = new CronTrigger(cornExpression);
                    scheduledFuture2 = this.threadPoolTaskScheduler.schedule((Runnable)dynamicTask, (Trigger)cronTrigger);
                    this.taskMapping.put(taskCode, scheduledFuture2);
                    runningTaskCodes.add(taskCode);
                    continue;
                }
                throw new IllegalArgumentException("\u9519\u8bef\u7684\u52a8\u6001\u4efb\u52a1\u7c7b\u578b[" + task.getTaskCode() + "]\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        if (!invalidTaskCodes.isEmpty()) {
            this.dynamicTaskSchedulerRepository.updateInvalidByTaskCode(invalidTaskCodes.toArray(new String[0]));
        }
        if (!runningTaskCodes.isEmpty()) {
            this.dynamicTaskSchedulerRepository.updateRunningByTaskCode(runningTaskCodes.toArray(new String[0]));
        }
        if (CollectionUtils.isEmpty(statusTasks = this.dynamicTaskSchedulerRepository.findByTstatus(0))) {
            statusTasks = new HashSet<DynamicTaskSchedulerEntity>();
        }
        if (!CollectionUtils.isEmpty(invalidTasks = this.dynamicTaskSchedulerRepository.findByWorkingStatus(new int[]{1}))) {
            statusTasks.addAll(invalidTasks);
        }
        for (DynamicTaskSchedulerEntity statusTask : statusTasks) {
            String invalidTaskCode = statusTask.getTaskCode();
            scheduledFuture = this.taskMapping.remove(invalidTaskCode);
            if (scheduledFuture == null) continue;
            scheduledFuture.cancel(true);
        }
    }

    @Override
    public void unloading() {
        if (this.taskMapping.isEmpty()) {
            return;
        }
        Collection<ScheduledFuture<?>> tasks = this.taskMapping.values();
        for (ScheduledFuture<?> task : tasks) {
            task.cancel(true);
        }
    }

    @Override
    @Transactional
    public DynamicTaskSchedulerEntity create(DynamicTaskSchedulerEntity task, String scriptContent, Principal principal) {
        Validate.notNull((Object)task, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u52a8\u6001\u4efb\u52a1\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String userAccount = principal.getName();
        UserVo uservo = this.userService.findByAccount(userAccount);
        UserEntity user = new UserEntity();
        user.setId(uservo.getId());
        Date currentTime = new Date();
        task.setCreator(user);
        task.setCreateTime(currentTime);
        task.setModifier(user);
        task.setLastModifyTime(currentTime);
        task.setTstatus(1);
        task.setWorkingStatus(0);
        this.createValidation(task);
        ScriptEntity script = new ScriptEntity();
        script.setLanguage("groovy");
        script.setName("dynamicTask_" + task.getTaskCode());
        script = this.scriptService.create(script, scriptContent);
        task.setScript(script);
        this.dynamicTaskSchedulerRepository.save(task);
        return task;
    }

    private void createValidation(DynamicTaskSchedulerEntity dynamicTaskSchedulerEntity) {
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dynamicTaskSchedulerEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dynamicTaskSchedulerEntity.setId(null);
        Validate.notBlank((CharSequence)dynamicTaskSchedulerEntity.getTaskCode(), (String)"\u4efb\u52a1\u552f\u4e00\u7f16\u53f7\uff08\u53ea\u80fd\u7531\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u6760\u6784\u6210\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicTaskSchedulerEntity.getTaskDesc(), (String)"\u4efb\u52a1\u4e2d\u6587\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dynamicTaskSchedulerEntity.getTaskType(), (String)"\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dynamicTaskSchedulerEntity.getCreateTime(), (String)"\u521b\u5efa\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dynamicTaskSchedulerEntity.getLastModifyTime(), (String)"\u6700\u540e\u4fee\u6539\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dynamicTaskSchedulerEntity.getTaskCode() == null || dynamicTaskSchedulerEntity.getTaskCode().length() < 128 ? 1 : 0) != 0, (String)"\u4efb\u52a1\u552f\u4e00\u7f16\u53f7\uff08\u53ea\u80fd\u7531\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u6760\u6784\u6210\uff09,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dynamicTaskSchedulerEntity.getTaskDesc() == null || dynamicTaskSchedulerEntity.getTaskDesc().length() < 256 ? 1 : 0) != 0, (String)"\u4efb\u52a1\u4e2d\u6587\u8bf4\u660e,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Date currentTime = new Date();
        if (dynamicTaskSchedulerEntity.getTaskType() == 1) {
            Validate.notNull((Object)dynamicTaskSchedulerEntity.getExecutePoint(), (String)"\u4e00\u6b21\u6027\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
            Validate.isTrue((dynamicTaskSchedulerEntity.getExecutePoint().getTime() > currentTime.getTime() ? 1 : 0) != 0, (String)"\u4e00\u6b21\u6027\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\uff0c\u5fc5\u987b\u8bbe\u5b9a\u5728\u5f53\u524d\u65f6\u95f4\u70b9\u4ee5\u540e", (Object[])new Object[0]);
        } else if (dynamicTaskSchedulerEntity.getTaskType() == 2) {
            Validate.notBlank((CharSequence)dynamicTaskSchedulerEntity.getExecuteExpression(), (String)"\u5468\u671f\u6027\u4efb\u52a1\u5fc5\u987b\u7ed9\u5b9a\u6709\u6548\u7684corn\u8868\u8fbe\u5f0f!!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dynamicTaskSchedulerEntity.getExpressionDesc(), (String)"\u5468\u671f\u6027\u4efb\u52a1\u5fc5\u987b\u4f20\u5165corn\u8868\u8fbe\u5f0f\u7684\u4e2d\u6587\u63cf\u8ff0!!", (Object[])new Object[0]);
            Validate.isTrue((dynamicTaskSchedulerEntity.getExecuteExpression() == null || dynamicTaskSchedulerEntity.getExecuteExpression().length() < 32 ? 1 : 0) != 0, (String)ERROR_MESS, (Object[])new Object[0]);
            Validate.isTrue((dynamicTaskSchedulerEntity.getExpressionDesc() == null || dynamicTaskSchedulerEntity.getExpressionDesc().length() < 256 ? 1 : 0) != 0, (String)ERROR_MESS_CHARSET, (Object[])new Object[0]);
        } else {
            throw new IllegalArgumentException("\u52a8\u6001\u4efb\u52a1\u53ea\u80fd\u662f\u4e00\u6b21\u6027\u4efb\u52a1\u6216\u8005\u5468\u671f\u6027\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5!!");
        }
        DynamicTaskSchedulerEntity currentDynamicTaskSchedulerEntity = this.dynamicTaskSchedulerRepository.findByTaskCode(dynamicTaskSchedulerEntity.getTaskCode());
        Validate.isTrue((currentDynamicTaskSchedulerEntity == null ? 1 : 0) != 0, (String)"\u4efb\u52a1\u552f\u4e00\u7f16\u53f7\uff08\u53ea\u80fd\u7531\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u6760\u6784\u6210\uff09\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public DynamicTaskSchedulerEntity update(DynamicTaskSchedulerEntity task, String scriptContent, Principal principal) {
        Validate.notNull((Object)task, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u52a8\u6001\u4efb\u52a1\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String userAccount = principal.getName();
        UserVo uservo = this.userService.findByAccount(userAccount);
        UserEntity user = new UserEntity();
        user.setId(uservo.getId());
        Date currentTime = new Date();
        this.updateValidation(task);
        String currentId = task.getId();
        Optional op = this.dynamicTaskSchedulerRepository.findById(currentId);
        DynamicTaskSchedulerEntity currentTask = op.orElse(null);
        Validate.notNull((Object)currentTask, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        Validate.isTrue((currentTask.getTstatus() == 0 ? 1 : 0) != 0, (String)"\u53ea\u6709\u5728\u8c03\u5ea6\u4efb\u52a1\u88ab\u7981\u7528/\u65e0\u6548\u7684\u60c5\u51b5\u4e0b\uff08tstatus == 0\uff09,\u624d\u80fd\u8fdb\u884c\u4fee\u6539!!!", (Object[])new Object[0]);
        Validate.isTrue((currentTask.getWorkingStatus() == 1 ? 1 : 0) != 0, (String)"\u53ea\u6709\u9996\u5148\u505c\u6b62\u4efb\u52a1\u8fd0\u884c\uff08workingStatus == 1\uff09\uff0c\u624d\u80fd\u8fdb\u884c\u4fee\u6539!!", (Object[])new Object[0]);
        currentTask.setTaskDesc(task.getTaskDesc());
        currentTask.setExecutePoint(task.getExecutePoint());
        currentTask.setExecuteExpression(task.getExecuteExpression());
        currentTask.setExpressionDesc(task.getExpressionDesc());
        currentTask.setLastModifyTime(task.getLastModifyTime());
        currentTask.setValidityTime(task.getValidityTime());
        currentTask.setLastModifyTime(currentTime);
        currentTask.setModifier(user);
        ScriptEntity script = task.getScript();
        Validate.notNull((Object)script, (String)"\u8fdb\u884c\u66f4\u65b0\u65f6\uff0c\u811a\u672c\u5185\u5bb9\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        script = this.scriptService.update(script, scriptContent);
        task.setScript(script);
        this.dynamicTaskSchedulerRepository.saveAndFlush(currentTask);
        return currentTask;
    }

    private void updateValidation(DynamicTaskSchedulerEntity dynamicTaskSchedulerEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)dynamicTaskSchedulerEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicTaskSchedulerEntity.getTaskCode(), (String)"\u4efb\u52a1\u552f\u4e00\u7f16\u53f7\uff08\u53ea\u80fd\u7531\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u6760\u6784\u6210\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicTaskSchedulerEntity.getTaskDesc(), (String)"\u4efb\u52a1\u4e2d\u6587\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dynamicTaskSchedulerEntity.getTaskType(), (String)"\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Date currentTime = new Date();
        if (dynamicTaskSchedulerEntity.getTaskType() == 1) {
            Validate.notNull((Object)dynamicTaskSchedulerEntity.getExecutePoint(), (String)"\u4e00\u6b21\u6027\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
            Validate.isTrue((dynamicTaskSchedulerEntity.getExecutePoint().getTime() > currentTime.getTime() ? 1 : 0) != 0, (String)"\u4e00\u6b21\u6027\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\uff0c\u5fc5\u987b\u8bbe\u5b9a\u5728\u5f53\u524d\u65f6\u95f4\u70b9\u4ee5\u540e", (Object[])new Object[0]);
        } else if (dynamicTaskSchedulerEntity.getTaskType() == 2) {
            Validate.notBlank((CharSequence)dynamicTaskSchedulerEntity.getExecuteExpression(), (String)"\u5468\u671f\u6027\u4efb\u52a1\u5fc5\u987b\u7ed9\u5b9a\u6709\u6548\u7684corn\u8868\u8fbe\u5f0f!!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dynamicTaskSchedulerEntity.getExpressionDesc(), (String)"\u5468\u671f\u6027\u4efb\u52a1\u5fc5\u987b\u4f20\u5165corn\u8868\u8fbe\u5f0f\u7684\u4e2d\u6587\u63cf\u8ff0!!", (Object[])new Object[0]);
            Validate.isTrue((dynamicTaskSchedulerEntity.getExecuteExpression() == null || dynamicTaskSchedulerEntity.getExecuteExpression().length() < 32 ? 1 : 0) != 0, (String)ERROR_MESS, (Object[])new Object[0]);
            Validate.isTrue((dynamicTaskSchedulerEntity.getExpressionDesc() == null || dynamicTaskSchedulerEntity.getExpressionDesc().length() < 256 ? 1 : 0) != 0, (String)ERROR_MESS_CHARSET, (Object[])new Object[0]);
        } else {
            throw new IllegalArgumentException("\u52a8\u6001\u4efb\u52a1\u53ea\u80fd\u662f\u4e00\u6b21\u6027\u4efb\u52a1\u6216\u8005\u5468\u671f\u6027\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5!!");
        }
        DynamicTaskSchedulerEntity currentForTaskCode = this.dynamicTaskSchedulerRepository.findByTaskCode(dynamicTaskSchedulerEntity.getTaskCode());
        Validate.isTrue((currentForTaskCode == null || StringUtils.equals((CharSequence)currentForTaskCode.getId(), (CharSequence)dynamicTaskSchedulerEntity.getId()) ? 1 : 0) != 0, (String)"\u4efb\u52a1\u552f\u4e00\u7f16\u53f7\uff08\u53ea\u80fd\u7531\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u6760\u6784\u6210\uff09\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((dynamicTaskSchedulerEntity.getTaskCode() == null || dynamicTaskSchedulerEntity.getTaskCode().length() < 128 ? 1 : 0) != 0, (String)"\u4efb\u52a1\u552f\u4e00\u7f16\u53f7\uff08\u53ea\u80fd\u7531\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u6760\u6784\u6210\uff09,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dynamicTaskSchedulerEntity.getTaskDesc() == null || dynamicTaskSchedulerEntity.getTaskDesc().length() < 256 ? 1 : 0) != 0, (String)"\u4efb\u52a1\u4e2d\u6587\u8bf4\u660e,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dynamicTaskSchedulerEntity.getExecuteExpression() == null || dynamicTaskSchedulerEntity.getExecuteExpression().length() < 32 ? 1 : 0) != 0, (String)ERROR_MESS, (Object[])new Object[0]);
        Validate.isTrue((dynamicTaskSchedulerEntity.getExpressionDesc() == null || dynamicTaskSchedulerEntity.getExpressionDesc().length() < 256 ? 1 : 0) != 0, (String)ERROR_MESS_CHARSET, (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void updateInvalidByTaskCode(String[] taskCodes) {
        Validate.notNull((Object)taskCodes, (String)"\u5728\u8fdb\u884c\u5f3a\u5236\u505c\u6b62\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u7684\u7f16\u53f7code!!", (Object[])new Object[0]);
        Validate.isTrue((taskCodes.length > 0 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u5f3a\u5236\u505c\u6b62\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u7684\u7f16\u53f7code!!", (Object[])new Object[0]);
        this.dynamicTaskSchedulerRepository.updateInvalidByTaskCode(taskCodes);
    }

    @Override
    public Set<DynamicTaskSchedulerEntity> findAll() {
        Set<DynamicTaskSchedulerEntity> results = this.dynamicTaskSchedulerRepository.findAlls();
        return results;
    }

    @Override
    public DynamicTaskSchedulerEntity findDetailsByTaskCode(String taskCode) {
        if (StringUtils.isBlank((CharSequence)taskCode)) {
            return null;
        }
        DynamicTaskSchedulerEntity task = this.dynamicTaskSchedulerRepository.findDetailsByTaskCode(taskCode);
        return task;
    }

    @Override
    public DynamicTaskSchedulerEntity findByTaskCode(String taskCode) {
        if (StringUtils.isBlank((CharSequence)taskCode)) {
            return null;
        }
        DynamicTaskSchedulerEntity task = this.dynamicTaskSchedulerRepository.findByTaskCode(taskCode);
        return task;
    }

    @Override
    public Page<DynamicTaskSchedulerEntity> findByConditions(Pageable pageable, Integer taskType, String taskCode, Integer tstatus, Integer workingStatus, String taskDesc) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (taskType != null) {
            conditions.put("taskType", taskType);
        }
        if (StringUtils.isNotEmpty((CharSequence)taskCode)) {
            conditions.put("taskCode", taskCode);
        }
        if (tstatus != null) {
            conditions.put("tstatus", tstatus);
        }
        if (workingStatus != null) {
            conditions.put("workingStatus", workingStatus);
        }
        if (StringUtils.isNotEmpty((CharSequence)taskDesc)) {
            conditions.put("taskDesc", taskDesc);
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        return this.dynamicTaskSchedulerRepository.queryPage(pageable, conditions);
    }
}

