/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.security;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.entity.OrganizationEntity;
import com.bizunited.platform.core.entity.RoleEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.repository.OrganizationRepository;
import com.bizunited.platform.core.repository.RoleRepository;
import com.bizunited.platform.core.repository.UserRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.rbac.server.service.OrganizationService;
import com.bizunited.platform.rbac.server.vo.OrganizationVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.CollectionUtils;

public class OrganizationServiceImpl
implements OrganizationService {
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private OrganizationRepository organizationRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleRepository roleRepository;
    private static final String ERROR_MESS_OGS = "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784";
    private static final String MESS_ORG_NAME = "orgName";
    private static final Logger LOGGER = LoggerFactory.getLogger(OrganizationServiceImpl.class);

    @Transactional
    public OrganizationVo create(OrganizationVo organization) {
        Validate.notNull((Object)organization, (String)"\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)organization.getId()), (String)"\u6dfb\u52a0\u7ec4\u7ec7\u673a\u6784\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u7ec4\u7ec7\u673a\u6784id,\u8bf7\u91cd\u65b0\u6dfb\u52a0!!", (Object[])new Object[0]);
        String orgName = organization.getOrgName();
        Validate.notBlank((CharSequence)orgName, (String)"\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)organization.getDescription(), (String)"\u7ec4\u7ec7\u673a\u6784\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)organization.getType(), (String)"\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String code = organization.getCode();
        Validate.notNull((Object)code, (String)"\u7ec4\u7ec7\u673a\u6784\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrganizationEntity oldOrg = this.organizationRepository.findByCode(code);
        Validate.isTrue((null == oldOrg ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684code,\u8bf7\u91cd\u65b0\u8f93\u5165\u7ec4\u7ec7\u673a\u6784\u7f16\u7801!!", (Object[])new Object[0]);
        OrganizationEntity currentOrg = this.nebulaToolkitService.copyObjectByWhiteList(organization, OrganizationEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.organizationRepository.save(currentOrg);
        organization.setId(currentOrg.getId());
        return organization;
    }

    @Transactional
    public OrganizationVo update(OrganizationVo organization) {
        Validate.notNull((Object)organization, (String)"\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)organization.getId(), (String)"\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u6dfb\u52a0!!", (Object[])new Object[0]);
        Optional op = this.organizationRepository.findById(organization.getId());
        OrganizationEntity currentOrg = op.orElse(null);
        Validate.notNull((Object)currentOrg, (String)"\u672a\u5728\u6570\u636e\u5c42\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u7ed3\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        String orgName = organization.getOrgName();
        Validate.notBlank((CharSequence)orgName, (String)"\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)organization.getDescription(), (String)"\u7ec4\u7ec7\u673a\u6784\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)organization.getType())) {
            currentOrg.setType(organization.getType());
        }
        currentOrg.setOrgName(orgName);
        currentOrg.setDescription(organization.getDescription());
        this.organizationRepository.save(currentOrg);
        return this.nebulaToolkitService.copyObjectByWhiteList(currentOrg, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public OrganizationVo updateStatus(String orgId) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Optional op = this.organizationRepository.findById(orgId);
        OrganizationEntity organization = op.orElse(null);
        Validate.notNull((Object)organization, (String)"\u6ca1\u6709\u8be5\u7ec4\u7ec7\u673a\u6784\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Integer status = organization.getTstatus();
        status = status == 1 ? 0 : 1;
        organization.setTstatus(status);
        this.organizationRepository.save(organization);
        return this.nebulaToolkitService.copyObjectByWhiteList(organization, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void bindParent(String currentOrgId, String parentOrgId) {
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Optional op = this.organizationRepository.findById(currentOrgId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_MESS_OGS, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)parentOrgId, (String)"\u6307\u5b9a\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.equals((CharSequence)currentOrgId, (CharSequence)parentOrgId) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u4e0d\u80fd\u4e0e\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u91cd\u590d", (Object[])new Object[0]);
        Optional optional = this.organizationRepository.findById(parentOrgId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784!!", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.equals((CharSequence)currentOrgId, (CharSequence)parentOrgId) ? 1 : 0) != 0, (String)"\u7ed1\u5b9a\u7ec4\u7ec7\u673a\u6784\u662f\uff0c\u4e0d\u80fd\u81ea\u5df1\u7ed1\u5b9a\u81ea\u5df1!!", (Object[])new Object[0]);
        this.organizationRepository.bindParent(currentOrgId, parentOrgId);
    }

    @Transactional
    public void unbindParent(String currentOrgId) {
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u8fdb\u884c\u7ed1\u5b9a\u7ed3\u6784\u6d88\u9664\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.organizationRepository.findById(currentOrgId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_MESS_OGS, (Object[])new Object[0]);
        this.organizationRepository.unbindParent(currentOrgId);
    }

    @Transactional
    public void bindUsers(String currentOrgId, String[] userIds) {
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.organizationRepository.findById(currentOrgId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_MESS_OGS, (Object[])new Object[0]);
        Validate.isTrue((userIds != null && userIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u7ed1\u5b9a\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u4eba\u5458\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        for (String userId : userIds) {
            Optional optional = this.userRepository.findById(userId);
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u7ed1\u5b9a\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u4eba\u5458\u4fe1\u606f\u3010id=%s\u3011", (Object[])new Object[]{userId});
            UserEntity user = (UserEntity)optional.get();
            int count = this.organizationRepository.countByOrgIdAndUserId(currentOrgId, userId);
            Validate.isTrue((count == 0 ? 1 : 0) != 0, (String)("\u8be5\u4eba\u5458\uff1a" + user.getUserName() + "\u5df2\u548c\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\u8fdb\u884c\u4e86\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            this.organizationRepository.bindUsers(currentOrgId, userId);
        }
    }

    @Transactional
    public void unbindUser(String userId) {
        Validate.notBlank((CharSequence)userId, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u89e3\u7ed1\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u4eba\u5458\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.userRepository.findById(userId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u89e3\u7ed1\u7ed1\u5b9a\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u4eba\u5458\u4fe1\u606f\u3010id=%s\u3011", (Object[])new Object[]{userId});
        this.organizationRepository.unbindUser(userId);
    }

    @Transactional
    public void unbindUser(String currentOrgId, String[] userIds) {
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.organizationRepository.findById(currentOrgId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_MESS_OGS, (Object[])new Object[0]);
        Validate.notNull((Object)userIds, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u4eba\u5458\u4fe1\u606f!!", (Object[])new Object[0]);
        for (String userId : userIds) {
            Optional optional = this.userRepository.findById(userId);
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u4eba\u5458\u89e3\u7ed1\u7ed1\u5b9a\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u4eba\u5458\u4fe1\u606f\u3010id=%s\u3011", (Object[])new Object[]{userId});
            this.organizationRepository.unbindUser(currentOrgId, userId);
        }
    }

    @Transactional
    public void bindRoles(String currentOrgId, String[] roleIds) {
        Validate.notBlank((CharSequence)currentOrgId, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((roleIds != null && roleIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u89d2\u8272\u7ed1\u5b9a\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89d2\u8272\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.organizationRepository.findById(currentOrgId);
        Validate.isTrue((boolean)op.isPresent(), (String)ERROR_MESS_OGS, (Object[])new Object[0]);
        for (String roleId : roleIds) {
            Optional optional = this.roleRepository.findById(roleId);
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\u3010id=%s\u3011", (Object[])new Object[]{roleId});
            RoleEntity role = (RoleEntity)optional.get();
            int count = this.organizationRepository.countByOrgAndRoleId(currentOrgId, roleId);
            Validate.isTrue((count == 0 ? 1 : 0) != 0, (String)("\u8be5\u89d2\u8272\uff1a" + role.getRoleName() + "\u5df2\u7ed1\u5b9a,\u8bf7\u91cd\u65b0\u7ed1\u5b9a!!"), (Object[])new Object[0]);
            this.organizationRepository.bindRole(currentOrgId, roleId);
        }
    }

    @Transactional
    public void unbindRole(String[] roleIds) {
        Validate.notNull((Object)roleIds, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u89d2\u8272\u89e3\u7ed1\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u89d2\u8272\u4fe1\u606f!!", (Object[])new Object[0]);
        for (String roleId : roleIds) {
            Optional optional = this.roleRepository.findById(roleId);
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u89d2\u8272\u89e3\u7ed1\u7ed1\u5b9a\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\u3010id=%s\u3011", (Object[])new Object[]{roleId});
            this.organizationRepository.unbindRole(roleId);
        }
    }

    public List<OrganizationVo> findByNullParent() {
        List<OrganizationEntity> organizationEntitys = this.organizationRepository.findByNullParent();
        if (organizationEntitys == null || organizationEntitys.isEmpty()) {
            return Lists.newArrayList();
        }
        Collection<OrganizationVo> orgVos = this.nebulaToolkitService.copyCollectionByWhiteList(organizationEntitys, OrganizationEntity.class, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList(orgVos);
    }

    public List<OrganizationVo> findByParent(String parentId) {
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return Lists.newArrayList();
        }
        List<OrganizationEntity> organizationEntitys = this.organizationRepository.findByParent(parentId);
        if (organizationEntitys == null || organizationEntitys.isEmpty()) {
            return Lists.newArrayList();
        }
        Collection<OrganizationVo> orgVos = this.nebulaToolkitService.copyCollectionByWhiteList(organizationEntitys, OrganizationEntity.class, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList(orgVos);
    }

    public List<OrganizationVo> findByNullParentAndStatus(Integer status) {
        if (status == null) {
            return null;
        }
        List<OrganizationEntity> organizationEntitys = this.organizationRepository.findByNullParentAndStatus(status);
        if (organizationEntitys == null || organizationEntitys.isEmpty()) {
            return null;
        }
        Collection<OrganizationVo> orgVos = this.nebulaToolkitService.copyCollectionByWhiteList(organizationEntitys, OrganizationEntity.class, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList(orgVos);
    }

    public List<OrganizationVo> findByParentAndStatus(String parentId, Integer status) {
        if (StringUtils.isBlank((CharSequence)parentId) || status == null) {
            return Lists.newArrayList();
        }
        List<OrganizationEntity> organizationEntitys = this.organizationRepository.findByParentAndStatus(parentId, status);
        if (organizationEntitys == null || organizationEntitys.isEmpty()) {
            return Lists.newArrayList();
        }
        Collection<OrganizationVo> orgVos = this.nebulaToolkitService.copyCollectionByWhiteList(organizationEntitys, OrganizationEntity.class, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList(orgVos);
    }

    public JSONArray findByOrgName(String orgName) {
        if (StringUtils.isBlank((CharSequence)orgName)) {
            return null;
        }
        List<OrganizationEntity> currentOrgs = this.organizationRepository.findByOrgName(orgName);
        if (currentOrgs == null || currentOrgs.isEmpty()) {
            return null;
        }
        JSONArray jsonObjects = new JSONArray();
        for (OrganizationEntity orgItem : currentOrgs) {
            JSONObject jsonObject = this.recursiveFindParent(orgItem);
            if (jsonObject == null) continue;
            jsonObjects.add((Object)jsonObject);
        }
        return jsonObjects;
    }

    private JSONObject recursiveFindParent(OrganizationEntity currentOrg) {
        if (currentOrg == null || currentOrg.getTstatus() != 1) {
            return null;
        }
        JSONObject orgObject = new JSONObject();
        orgObject.put("id", (Object)currentOrg.getId());
        orgObject.put(MESS_ORG_NAME, (Object)currentOrg.getOrgName());
        orgObject.put("code", (Object)currentOrg.getCode());
        orgObject.put("createTime", (Object)currentOrg.getCreateTime());
        orgObject.put("sortIndex", (Object)currentOrg.getSortIndex());
        orgObject.put("status", (Object)currentOrg.getTstatus());
        orgObject.put("type", (Object)currentOrg.getType());
        Set<RoleEntity> roles = currentOrg.getRoles();
        JSONArray roleArray = new JSONArray();
        if (roles != null && !roles.isEmpty()) {
            for (RoleEntity role : roles) {
                JSONObject roleObject = new JSONObject();
                roleObject.put("id", (Object)role.getId());
                roleObject.put("comment", (Object)role.getComment());
                roleObject.put("createDate", (Object)role.getCreateDate());
                roleObject.put("isDeny", (Object)role.getIsDeny());
                roleObject.put("roleCode", (Object)role.getRoleCode());
                roleObject.put("roleName", (Object)role.getRoleName());
                roleObject.put("status", (Object)role.getTstatus());
                roleObject.put("roleType", (Object)role.getRoleType());
                roleArray.add((Object)roleObject);
            }
        }
        orgObject.put("roles", (Object)new JSONArray());
        OrganizationEntity parent = currentOrg.getParent();
        if (parent != null) {
            orgObject.put("parent", (Object)this.recursiveFindParent(parent));
        }
        return orgObject;
    }

    public OrganizationVo findDetailsById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u7ec4\u7ec7\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        OrganizationEntity currentOrg = this.organizationRepository.findDetailsById(id);
        return this.nebulaToolkitService.copyObjectByWhiteList(currentOrg, OrganizationVo.class, LinkedHashSet.class, ArrayList.class, "parent", "child", "roles", "users", "positions");
    }

    public JSONArray findByUserId(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return null;
        }
        Set<OrganizationEntity> currentOrgs = this.organizationRepository.findByUserId(userId);
        if (currentOrgs == null || currentOrgs.isEmpty()) {
            return null;
        }
        JSONArray jsonObjects = new JSONArray();
        for (OrganizationEntity orgItem : currentOrgs) {
            JSONObject jsonObject = this.recursiveFindParent(orgItem);
            if (jsonObject == null) continue;
            jsonObjects.add((Object)jsonObject);
        }
        return jsonObjects;
    }

    public Object[] findUnbindOrgById(String currentOrgId) {
        String parentOrgId;
        Optional optional;
        if (StringUtils.isBlank((CharSequence)currentOrgId)) {
            return null;
        }
        List<OrganizationEntity> allOrganizations = this.organizationRepository.findAllByStatus();
        JSONArray jsonArray = new JSONArray();
        if (null != allOrganizations && !allOrganizations.isEmpty()) {
            for (OrganizationEntity org : allOrganizations) {
                JSONObject orgAllObject = new JSONObject();
                orgAllObject.put("id", (Object)org.getId());
                orgAllObject.put(MESS_ORG_NAME, (Object)org.getOrgName());
                jsonArray.add((Object)orgAllObject);
            }
        }
        LOGGER.debug("\u6240\u6709\u7ec4\u7ec7\u673a\u6784\u8282\u70b9;" + JSON.toJSONString((Object)jsonArray));
        Optional op = this.organizationRepository.findById(currentOrgId);
        OrganizationEntity childOrg = op.orElse(null);
        if (childOrg == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u4efb\u4f55\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!");
        }
        JSONArray array = this.findChildOrgs(childOrg, new JSONArray());
        if (null != childOrg.getParent() && StringUtils.isNotBlank((CharSequence)childOrg.getParent().getId()) && (optional = this.organizationRepository.findById(parentOrgId = childOrg.getParent().getId())).isPresent()) {
            JSONObject jsonObject = new JSONObject();
            OrganizationEntity parentOrg = (OrganizationEntity)optional.get();
            jsonObject.put("id", (Object)parentOrg.getId());
            jsonObject.put(MESS_ORG_NAME, (Object)parentOrg.getOrgName());
            array.add((Object)jsonObject);
        }
        LOGGER.debug("\u4e0d\u53ef\u4ee5\u7ed1\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\u8282\u70b9(\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u4ee5\u53ca\u6240\u6709\u5b50\u7ea7\u7ec4\u7ec7\u673a\u6784);" + JSON.toJSONString((Object)array));
        if (null != array && !array.isEmpty()) {
            jsonArray.removeAll((Collection)array);
        }
        LOGGER.debug("\u53ef\u4ee5\u7ed1\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\u8282\u70b9;" + JSON.toJSONString((Object)jsonArray));
        return jsonArray.toArray();
    }

    private JSONArray findChildOrgs(OrganizationEntity currentOrg, JSONArray jsonArray) {
        if (currentOrg != null) {
            Optional op = this.organizationRepository.findById(currentOrg.getId());
            OrganizationEntity organization = op.orElse(null);
            Validate.notNull((Object)organization, (String)"\u6ca1\u6709\u53ef\u7528\u7684\u7ec4\u7ec7\u673a\u6784,\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            JSONObject orgObject = new JSONObject();
            orgObject.put("id", (Object)organization.getId());
            orgObject.put(MESS_ORG_NAME, (Object)organization.getOrgName());
            jsonArray.add((Object)orgObject);
            List<OrganizationEntity> childs = this.organizationRepository.findByParent(organization.getId());
            if (childs != null && !childs.isEmpty()) {
                for (OrganizationEntity child : childs) {
                    this.findChildOrgs(child, jsonArray);
                }
            }
        }
        return jsonArray;
    }

    public List<OrganizationVo> findAll() {
        Iterable orgs = this.organizationRepository.findAll();
        if (orgs == null) {
            return null;
        }
        Collection<OrganizationVo> result = this.nebulaToolkitService.copyCollectionByWhiteList(orgs, OrganizationEntity.class, OrganizationVo.class, LinkedHashSet.class, ArrayList.class, "parent");
        return new ArrayList<OrganizationVo>(result);
    }

    public OrganizationVo findOrgByUserId(String userId) {
        Validate.notBlank((CharSequence)userId, (String)"\u4f20\u5165\u7684\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        UserEntity user = this.userRepository.findDetailsById(userId);
        if (user == null) {
            return null;
        }
        if (!CollectionUtils.isEmpty(user.getOrgs())) {
            OrganizationEntity one = user.getOrgs().iterator().next();
            return this.nebulaToolkitService.copyObjectByWhiteList(one, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        return null;
    }

    public Set<OrganizationVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Sets.newHashSet();
        }
        Set<OrganizationEntity> orgs = this.organizationRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(orgs)) {
            return Sets.newHashSet();
        }
        Collection<OrganizationVo> ovos = this.nebulaToolkitService.copyCollectionByWhiteList(orgs, OrganizationEntity.class, OrganizationVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet(ovos);
    }
}

