/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.security;

import com.bizunited.platform.core.entity.OrganizationEntity;
import com.bizunited.platform.core.entity.PositionEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.repository.OrganizationRepository;
import com.bizunited.platform.core.repository.PositionRepository;
import com.bizunited.platform.core.repository.RoleRepository;
import com.bizunited.platform.core.repository.UserRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.rbac.server.service.PositionService;
import com.bizunited.platform.rbac.server.vo.PositionVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

public class PositionServiceImpl
implements PositionService {
    @Autowired
    private PositionRepository positionRepository;
    @Autowired
    private OrganizationRepository organizationRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    public PositionVo create(PositionVo positionVo) {
        Validate.notNull((Object)positionVo, (String)"\u5c97\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)positionVo.getId()), (String)"\u6dfb\u52a0\u5c97\u4f4d\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u5c97\u4f4did,\u8bf7\u91cd\u65b0\u6dfb\u52a0!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionVo.getName(), (String)"\u5c97\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)positionVo.getCode(), (String)"\u5c97\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        positionVo.setCreateTime(new Date());
        PositionEntity currentPosition = this.positionRepository.findByCode(positionVo.getCode());
        Validate.isTrue((null == currentPosition ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684code,\u8bf7\u91cd\u65b0\u8f93\u5165\u5c97\u4f4d\u7f16\u7801!!", (Object[])new Object[0]);
        PositionEntity positionEntity = this.nebulaToolkitService.copyObjectByWhiteList(positionVo, PositionEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.positionRepository.save(positionEntity);
        positionVo.setId(positionEntity.getId());
        return positionVo;
    }

    @Transactional
    public PositionVo update(PositionVo positionVo) {
        Validate.notNull((Object)positionVo, (String)"\u5c97\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.isBlank((CharSequence)positionVo.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u5c97\u4f4d\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u5c97\u4f4did,\u8bf7\u91cd\u65b0\u4fee\u6539!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionVo.getName(), (String)"\u5c97\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Optional op = this.positionRepository.findById(positionVo.getId());
        PositionEntity position = op.orElse(null);
        Validate.notNull((Object)position, (String)"\u672a\u5728\u6570\u636e\u5c42\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f", (Object[])new Object[0]);
        position.setName(positionVo.getName());
        this.positionRepository.save(position);
        return this.nebulaToolkitService.copyObjectByWhiteList(position, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public PositionVo updateStatus(String positionId) {
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4did\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Optional op = this.positionRepository.findById(positionId);
        PositionEntity position = op.orElse(null);
        Validate.notNull((Object)position, (String)"\u6ca1\u6709\u8be5\u5c97\u4f4d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Integer status = position.getTstatus();
        status = status == 1 ? 0 : 1;
        position.setTstatus(status);
        this.positionRepository.save(position);
        return this.nebulaToolkitService.copyObjectByWhiteList(position, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public PositionVo findDetailsById(String positionId) {
        if (StringUtils.isBlank((CharSequence)positionId)) {
            return null;
        }
        PositionEntity positionEntity = this.positionRepository.findDetailsById(positionId);
        Validate.notNull((Object)positionEntity, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2!!", (Object[])new Object[0]);
        return this.nebulaToolkitService.copyObjectByWhiteList(positionEntity, PositionVo.class, HashSet.class, ArrayList.class, "organization", "roles", "users");
    }

    @Transactional
    public void bindOrgAndPosition(String orgId, String positionId) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional optional = this.organizationRepository.findById(orgId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784!", (Object[])new Object[0]);
        OrganizationEntity organization = (OrganizationEntity)optional.get();
        Optional op = this.positionRepository.findById(positionId);
        PositionEntity position = op.orElse(null);
        Validate.notNull((Object)position, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        Validate.isTrue((null == position.getOrganization() ? 1 : 0) != 0, (String)"\u8be5\u5c97\u4f4d\u5df2\u7ed1\u5b9a\u6709\u7ec4\u7ec7\u673a\u6784\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        position.setOrganization(organization);
        this.positionRepository.saveAndFlush(position);
    }

    @Transactional
    public void unbindOrgAndPosition(String orgId, String positionId) {
        Validate.notBlank((CharSequence)orgId, (String)"\u7ec4\u7ec7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional optional = this.organizationRepository.findById(orgId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784!", (Object[])new Object[0]);
        OrganizationEntity organization = (OrganizationEntity)optional.get();
        Optional op = this.positionRepository.findById(positionId);
        PositionEntity position = op.orElse(null);
        Validate.notNull((Object)position, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        Validate.notNull((Object)position.getOrganization(), (String)"\u8be5\u5c97\u4f4d\u6ca1\u6709\u7ed1\u5b9a\u7684\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)organization.getId().equals(position.getOrganization().getId()), (String)"\u5f85\u89e3\u7ed1\u7684\u5c97\u4f4d\u4e0e\u7ec4\u7ec7\u673a\u6784\u6ca1\u6709\u7ed1\u5b9a\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        position.setOrganization(null);
        this.positionRepository.saveAndFlush(position);
    }

    @Transactional
    public void bindRoleAndPosition(String roleId, String positionId) {
        Validate.notBlank((CharSequence)roleId, (String)"\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional optional = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272!", (Object[])new Object[0]);
        Optional op = this.positionRepository.findById(positionId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        Validate.isTrue((0 == this.positionRepository.countByRoleAndPosition(roleId, positionId) ? 1 : 0) != 0, (String)"\u8be5\u89d2\u8272\u4e0e\u8be5\u5c97\u4f4d\u5df2\u6709\u7ed1\u5b9a\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        this.positionRepository.bindRole(roleId, positionId);
    }

    @Transactional
    public void bindRolesAndPosition(List<String> roleIds, String positionId) {
        Validate.isTrue((!CollectionUtils.isEmpty(roleIds) ? 1 : 0) != 0, (String)"\u89d2\u8272ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        roleIds.stream().forEach(o -> this.bindRoleAndPosition((String)o, positionId));
    }

    @Transactional
    public void unbindRoleAndPosition(String roleId, String positionId) {
        Validate.notBlank((CharSequence)roleId, (String)"\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional optional = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272!", (Object[])new Object[0]);
        Optional op = this.positionRepository.findById(positionId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        this.positionRepository.unbindRole(roleId, positionId);
    }

    @Transactional
    public void unbindRolesAndPosition(List<String> roleIds, String positionId) {
        Validate.isTrue((!CollectionUtils.isEmpty(roleIds) ? 1 : 0) != 0, (String)"\u89d2\u8272ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        roleIds.stream().forEach(o -> this.unbindRoleAndPosition((String)o, positionId));
    }

    @Transactional
    public void bindUsersAndPosition(List<String> userIds, String positionId) {
        Validate.isTrue((!CollectionUtils.isEmpty(userIds) ? 1 : 0) != 0, (String)"\u7528\u6237ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        userIds.stream().forEach(o -> this.bindUserAndPosition((String)o, positionId));
    }

    private void bindUserAndPosition(String userId, String positionId) {
        Validate.notBlank((CharSequence)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional op = this.userRepository.findById(userId);
        UserEntity userEntity = op.orElse(null);
        Validate.notNull((Object)userEntity, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7528\u6237!", (Object[])new Object[0]);
        Optional optional = this.positionRepository.findById(positionId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        String positionName = CollectionUtils.isEmpty(userEntity.getPositions()) ? "" : new ArrayList<PositionEntity>(userEntity.getPositions()).get(0).getName();
        Validate.isTrue((boolean)CollectionUtils.isEmpty(userEntity.getPositions()), (String)("\u8be5\u7528\u6237[" + userEntity.getUserName() + "]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5c97\u4f4d[" + positionName + "]\uff0c\u8bf7\u5148\u89e3\u7ed1\u518d\u7ed1\u5b9a\u65b0\u5c97\u4f4d!"), (Object[])new Object[0]);
        this.positionRepository.binduser(userId, positionId);
    }

    @Transactional
    public void unbindUsersAndPosition(List<String> userIds, String positionId) {
        Validate.isTrue((!CollectionUtils.isEmpty(userIds) ? 1 : 0) != 0, (String)"\u7528\u6237ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        userIds.stream().forEach(o -> this.unbindUserAndPosition((String)o, positionId));
    }

    private void unbindUserAndPosition(String userId, String positionId) {
        Validate.notBlank((CharSequence)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)positionId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional op = this.userRepository.findById(userId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7528\u6237!", (Object[])new Object[0]);
        Optional optional = this.positionRepository.findById(positionId);
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5c97\u4f4d!", (Object[])new Object[0]);
        Validate.isTrue((0 != this.positionRepository.countByUserAndPosition(userId, positionId) ? 1 : 0) != 0, (String)"\u8be5\u7528\u6237\u4e0e\u8be5\u5c97\u4f4d\u672a\u6709\u7ed1\u5b9a\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        this.positionRepository.unbinduser(userId, positionId);
    }

    public PositionVo findByUserId(String userId) {
        Validate.notBlank((CharSequence)userId, (String)"\u4f20\u5165\u7684\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        UserEntity user = this.userRepository.findDetailsById(userId);
        if (user == null) {
            return null;
        }
        if (!CollectionUtils.isEmpty(user.getPositions())) {
            PositionEntity onePosition = user.getPositions().iterator().next();
            return this.nebulaToolkitService.copyObjectByWhiteList(onePosition, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        return null;
    }

    public Set<PositionVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Sets.newHashSet();
        }
        Set<PositionEntity> pos = this.positionRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(pos)) {
            return Sets.newHashSet();
        }
        Collection<PositionVo> pvo = this.nebulaToolkitService.copyCollectionByWhiteList(pos, PositionEntity.class, PositionVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet(pvo);
    }

    public Page<PositionVo> findByConditions(String code, String name, Integer tstatus, Pageable pageable) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            conditions.put("code", code);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            conditions.put("name", name);
        }
        if (tstatus != null) {
            conditions.put("tstatus", tstatus);
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        Page positionEntityPage = this.positionRepository.queryPage(pageable, conditions);
        List positionEntitys = positionEntityPage.getContent();
        PageImpl positionVoPage = null;
        if (positionEntitys != null && !positionEntitys.isEmpty()) {
            Collection<PositionVo> positionVos = this.nebulaToolkitService.copyCollectionByWhiteList(positionEntitys, PositionEntity.class, PositionVo.class, LinkedHashSet.class, ArrayList.class, "users");
            positionVoPage = new PageImpl(new ArrayList<PositionVo>(positionVos), pageable, positionEntityPage.getTotalElements());
        } else {
            positionVoPage = new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return positionVoPage;
    }
}

