/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.security;

import com.bizunited.platform.core.entity.OrganizationEntity;
import com.bizunited.platform.core.entity.PositionEntity;
import com.bizunited.platform.core.entity.RoleEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UserGroupEntity;
import com.bizunited.platform.core.repository.OrganizationRepository;
import com.bizunited.platform.core.repository.PositionRepository;
import com.bizunited.platform.core.repository.RoleRepository;
import com.bizunited.platform.core.repository.UserGroupRepository;
import com.bizunited.platform.core.repository.UserRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.CollectionUtils;

public class RoleServiceImpl
implements RoleService {
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private PositionRepository positionRepository;
    @Autowired
    private UserGroupRepository userGroupRepository;
    @Autowired
    private OrganizationRepository organizationRepository;
    @Autowired
    private UserRepository userService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Value(value="${rbac.ignoreMethodCheckRoles}")
    private String[] ignoreMethodCheckRoles;
    @Value(value="${rbac.roles.deleteDeny}")
    private String[] deleteDenys;

    @Transactional
    public RoleVo create(RoleVo role) {
        this.validateRoleBeforeAdd(role);
        RoleEntity roleEntity = this.nebulaToolkitService.copyObjectByWhiteList(role, RoleEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.roleRepository.saveAndFlush(roleEntity);
        role.setId(roleEntity.getId());
        return role;
    }

    @Transactional
    public RoleVo update(RoleVo role) {
        Validate.notNull((Object)role, (String)"role mssage not null", (Object[])new Object[0]);
        String roleId = role.getId();
        String updateComment = role.getComment();
        Validate.notEmpty((CharSequence)roleId, (String)"role id not empty!", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)updateComment, (String)"role comment not empty!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"role not found", (Object[])new Object[0]);
        RoleEntity currentRole = (RoleEntity)op.get();
        String currentName = currentRole.getRoleName();
        for (String deleteDeny : this.deleteDenys) {
            if (!StringUtils.equals((CharSequence)currentName, (CharSequence)deleteDeny)) continue;
            throw new AccessDeniedException("\u8fd9\u4e2a\u89d2\u8272\u4e3a\u7cfb\u7edf\u7279\u5b9a\u9ed8\u8ba4\u89d2\u8272\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        currentRole.setComment(updateComment);
        this.roleRepository.save(currentRole);
        return role;
    }

    @Transactional
    public RoleVo disable(String roleId) {
        Validate.notEmpty((CharSequence)roleId, (String)"role id not be found!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        RoleEntity currentRole = (RoleEntity)op.get();
        for (String deleteDeny : this.deleteDenys) {
            if (!StringUtils.equals((CharSequence)currentRole.getRoleName(), (CharSequence)deleteDeny)) continue;
            throw new AccessDeniedException("the role not allow be disable\uff01");
        }
        currentRole.setTstatus(0);
        this.roleRepository.save(currentRole);
        RoleVo roleVo = this.nebulaToolkitService.copyObjectByWhiteList(currentRole, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
        return roleVo;
    }

    @Transactional
    public RoleVo enable(String roleId) {
        Validate.notEmpty((CharSequence)roleId, (String)"role id not be found!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        RoleEntity currentRole = (RoleEntity)op.get();
        currentRole.setTstatus(1);
        this.roleRepository.save(currentRole);
        RoleVo roleVo = this.nebulaToolkitService.copyObjectByWhiteList(currentRole, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
        return roleVo;
    }

    private void validateRoleBeforeAdd(RoleVo role) {
        Validate.notNull((Object)role, (String)"role input object not be null!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)role.getRoleName(), (String)"role name not be null!", (Object[])new Object[0]);
        role.setRoleName(role.getRoleName().toUpperCase());
        RoleEntity oldRole = this.roleRepository.findByRoleName(role.getRoleName());
        Validate.isTrue((oldRole == null ? 1 : 0) != 0, (String)"\u5f53\u524d\u8bbe\u5b9a\u7684\u89d2\u8272\u540d\u79f0\uff08role name\uff09\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u66f4\u6362!", (Object[])new Object[0]);
        oldRole = this.roleRepository.findByRoleCode(role.getRoleCode());
        Validate.isTrue((oldRole == null ? 1 : 0) != 0, (String)"\u5f53\u524d\u8bbe\u5b9a\u7684\u89d2\u8272\u7f16\u53f7\uff08role code\uff09\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u66f4\u6362!", (Object[])new Object[0]);
        Date currentTime = new Date();
        role.setCreateDate(currentTime);
        if (StringUtils.isBlank((CharSequence)role.getComment())) {
            role.setComment("[\u672a\u586b\u5199]");
        }
        role.setTstatus(Integer.valueOf(1));
    }

    @Transactional
    public void bindRoles(String userId, String[] roleNames) {
        Validate.notBlank((CharSequence)userId, (String)"\u7ed1\u5b9a\u6743\u9650\u65f6\uff0c\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserEntity user = this.userService.findDetailsById(userId);
        Validate.notNull((Object)user, (String)"\u7528\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((roleNames != null && roleNames.length > 0 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u8bf7\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89d2\u8272\u540d\u4fe1\u606f", (Object[])new Object[0]);
        HashSet<String> roleNameSet = new HashSet<String>();
        roleNameSet.addAll(Arrays.asList(roleNames));
        for (String roleName : roleNameSet) {
            RoleEntity currentRole = this.roleRepository.findByRoleName(roleName);
            Validate.notNull((Object)currentRole, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272!!", (Object[])new Object[0]);
            try {
                this.roleRepository.bindUser(userId, currentRole.getId());
                this.roleRepository.flush();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u9519\u8bef\u7684\u7ed1\u5b9a\u4fe1\u606f\uff0c\u8bf7\u68c0\u6d4b\u662f\u5426\u91cd\u590d\u7ed1\u5b9a\uff0c\u6216\u8005\u89d2\u8272\u4fe1\u606f\u672a\u4f20\u5165!");
            }
        }
    }

    @Transactional
    public void reBindRoles(String userId, String[] roleNames) {
        Validate.notBlank((CharSequence)userId, (String)"\u7ed1\u5b9a\u6743\u9650\u65f6\uff0c\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserEntity user = this.userService.findDetailsById(userId);
        Validate.notNull((Object)user, (String)"\u7528\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((roleNames != null && roleNames.length > 0 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u8bf7\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89d2\u8272\u540d\u4fe1\u606f", (Object[])new Object[0]);
        HashSet<String> roleNameSet = new HashSet<String>();
        roleNameSet.addAll(Arrays.asList(roleNames));
        this.roleRepository.deleteRoleByUserId(userId);
        for (String roleName : roleNameSet) {
            RoleEntity currentRole = this.roleRepository.findByRoleName(roleName);
            Validate.notNull((Object)currentRole, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272!!", (Object[])new Object[0]);
            try {
                this.roleRepository.bindUser(userId, currentRole.getId());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u9519\u8bef\u7684\u7ed1\u5b9a\u4fe1\u606f\uff0c\u8bf7\u68c0\u6d4b\u662f\u5426\u91cd\u590d\u7ed1\u5b9a\uff0c\u6216\u8005\u89d2\u8272\u4fe1\u606f\u672a\u4f20\u5165!");
            }
        }
    }

    public List<RoleVo> findAllByUserId(String userId) {
        Set<PositionEntity> positions;
        Set<OrganizationEntity> orgs;
        Set<UserGroupEntity> groups;
        if (StringUtils.isBlank((CharSequence)userId)) {
            return null;
        }
        HashSet<RoleEntity> resultRoles = new HashSet<RoleEntity>();
        List<RoleEntity> roles = this.roleRepository.findByUserId(userId);
        if (roles != null && !roles.isEmpty()) {
            resultRoles.addAll(roles);
        }
        if ((groups = this.userGroupRepository.findByUserId(userId)) != null && !groups.isEmpty()) {
            groups.stream().filter(item -> item.getRoles() != null && item.getTstatus() == 1).forEach(item -> resultRoles.addAll(item.getRoles()));
        }
        if ((orgs = this.organizationRepository.findByUserId(userId)) != null && !orgs.isEmpty()) {
            orgs.stream().filter(item -> item.getRoles() != null && item.getTstatus() == 1).forEach(item -> resultRoles.addAll(item.getRoles()));
        }
        if (!CollectionUtils.isEmpty(positions = this.positionRepository.findDetailsByUserId(userId))) {
            positions.stream().filter(p -> p.getRoles() != null && p.getTstatus() == 1).forEach(p -> resultRoles.addAll(p.getRoles()));
        }
        if (resultRoles.isEmpty()) {
            return null;
        }
        List roleEntitys = resultRoles.stream().filter(item -> item.getTstatus() == 1).collect(Collectors.toList());
        Collection<RoleVo> roleVos = this.nebulaToolkitService.copyCollectionByWhiteList(roleEntitys, RoleEntity.class, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList(roleVos);
    }

    public List<RoleVo> findByCompetenceId(String competenceId) {
        if (StringUtils.isBlank((CharSequence)competenceId)) {
            return null;
        }
        List<RoleEntity> roles = this.roleRepository.findByCompetenceId(competenceId);
        if (roles == null || roles.isEmpty()) {
            return null;
        }
        Collection<RoleVo> roleVos = this.nebulaToolkitService.copyCollectionByWhiteList(roles, RoleEntity.class, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList(roleVos);
    }

    public List<RoleVo> findByStatus(Integer useStatus) {
        if (useStatus == null) {
            return null;
        }
        List<RoleEntity> rolesList = this.roleRepository.findByTstatus(useStatus);
        if (rolesList == null || rolesList.size() == 0) {
            return null;
        }
        Collection<RoleVo> roleVos = this.nebulaToolkitService.copyCollectionByWhiteList(rolesList, RoleEntity.class, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList(roleVos);
    }

    public RoleVo findById(String roleId) {
        Validate.notNull((Object)roleId, (String)"role Id must not null!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        if (!op.isPresent()) {
            return null;
        }
        RoleVo roleVo = this.nebulaToolkitService.copyObjectByWhiteList(op.get(), RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
        return roleVo;
    }

    public List<RoleVo> findAll() {
        List rolesList = this.roleRepository.findAll();
        if (rolesList == null || rolesList.isEmpty()) {
            return null;
        }
        Collection<RoleVo> roleVos = this.nebulaToolkitService.copyCollectionByWhiteList(rolesList, RoleEntity.class, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList(roleVos);
    }

    public Set<RoleVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Sets.newHashSet();
        }
        Set<RoleEntity> roles = this.roleRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(roles)) {
            return Sets.newHashSet();
        }
        Collection<RoleVo> rvos = this.nebulaToolkitService.copyCollectionByWhiteList(roles, RoleEntity.class, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet(rvos);
    }
}

