/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.service.migrate.MigrateExportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="MigrateExportController")
@RestController
@RequestMapping(value={"/v1/nebula/migrateExports"})
public class MigrateExportController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrateExportController.class);
    @Autowired
    private MigrateExportService migrateExportService;

    @ApiOperation(value="\u5bfc\u51fa\u6307\u5b9a\u7f16\u53f7\u7684\u6570\u636e\u89c6\u56fe\u3001\u4e1a\u52a1\u7f16\u7801\u903b\u8f91\u3001\u5b57\u5178\u903b\u8f91\u3001\u5168\u5c40\u73af\u5883\u53d8\u91cf\u3001\u8fdc\u7aef\u670d\u52a1\u6e90\u4fe1\u606f\u3002\u5e76\u4ee5\u538b\u7f29\u6587\u4ef6\uff08zip\u6587\u4ef6\uff09\u4e0b\u8f7d\u7684\u5f62\u5f0f\u8fd4\u56de\u5185\u5bb9")
    @GetMapping(value={"/export"})
    public void export(@ApiParam(name="dataviewIds", value="\u6307\u5b9a\u5bfc\u51fa\u7684\u6570\u636e\u89c6\u56feID\u7f16\u53f7\u96c6\u5408\uff0c\u5982\u679c\u4e0d\u4f20\u5165\u4efb\u4f55\u7f16\u53f7\uff0c\u8bf4\u660e\u4e0d\u5bfc\u51fa", required=false) @RequestParam(name="dataviewIds", required=false) String[] dataviewIds, @ApiParam(name="codeRuleIds", value="\u6307\u5b9a\u5bfc\u51fa\u7684\u4e1a\u52a1\u7f16\u7801\u89c4\u5219ID\u96c6\u5408\uff0c\u5982\u679c\u4e0d\u4f20\u5165\u4efb\u4f55\u7f16\u53f7\uff0c\u8bf4\u660e\u4e0d\u5bfc\u51fa", required=false) @RequestParam(name="codeRuleIds", required=false) String[] codeRuleIds, @ApiParam(name="dictIds", value="\u6307\u5b9a\u5bfc\u51fa\u7684\u5b57\u5178\u4e1a\u52a1\u7f16\u7801\u89c4\u5219ID\u96c6\u5408\uff08\u4e0d\u9700\u8981\u4f20\u5165\u7236\u7ea7\u5b57\u5178\u5206\u7c7b\u7684\u7f16\u53f7\uff09\uff0c\u5982\u679c\u4e0d\u4f20\u5165\u4efb\u4f55\u7f16\u53f7\uff0c\u8bf4\u660e\u4e0d\u5bfc\u51fa", required=false) @RequestParam(name="dictIds", required=false) String[] dictIds, @ApiParam(name="envIds", value="\u6307\u5b9a\u5bfc\u51fa\u7684\u5168\u5c40\u73af\u5883\u53d8\u91cfID\u96c6\u5408\uff0c\u5982\u679c\u4e0d\u4f20\u5165\u4efb\u4f55\u7f16\u53f7\uff0c\u8bf4\u660e\u4e0d\u5bfc\u51fa", required=false) @RequestParam(name="envIds", required=false) String[] envIds, @ApiParam(name="remoteServiceIds", value="\u6307\u5b9a\u5bfc\u51fa\u7684\u8fdc\u7aef\u670d\u52a1\u7684ID\u96c6\u5408\uff0c\u5982\u679c\u4e0d\u4f20\u5165\u4efb\u4f55\u7f16\u53f7\uff0c\u8bf4\u660e\u4e0d\u5bfc\u51fa", required=false) @RequestParam(name="remoteServiceIds", required=false) String[] remoteServiceIds, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] result = this.migrateExportService.export(dataviewIds, codeRuleIds, dictIds, envIds, remoteServiceIds);
            if (result == null || result.length == 0) {
                throw new IllegalArgumentException("\u6ca1\u6709\u4efb\u4f55\u4e0b\u8f7d\u4fe1\u606f\uff0c\u5f88\u5927\u51e0\u7387\u539f\u56e0\u662f\u5bfc\u51fa\u903b\u8f91\u51fa\u73b0\u9519\u8bef!!");
            }
            String fileName = StringUtils.join((Object[])new String[]{UUID.randomUUID().toString(), ".zip"});
            this.writeResponseFile(request, response, result, fileName);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.printErrorMessage(this.buildHttpResultForException(e), response);
        }
    }

    private void printErrorMessage(ResponseModel errorMessage, HttpServletResponse response) {
        response.setContentType("application/json;charset=UTF-8");
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(JSON.toJSONString((Object)errorMessage).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

