/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.repository.dataview.analysis.Constants;
import com.bizunited.platform.rbac.server.service.OrganizationService;
import com.bizunited.platform.rbac.server.service.PositionService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.UserGroupService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.OrganizationVo;
import com.bizunited.platform.rbac.server.vo.PositionVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.rbac.server.vo.UserGroupVo;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="SQLPresetValueAnalysis")
public class SQLPresetValueAnalysis {
    @Autowired
    private UserService userService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private RoleService roleService;
    private static final String ANALYSIS_ERROR = "\u7cfb\u7edf\u53c2\u6570\u5206\u6790\u65f6\uff0cPrincipal\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!";
    private static final String ANALYSIS_H_ERROR = "\u6a2a\u5411\u6743\u9650\u5206\u6790\u65f6\uff0cPrincipal\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!";
    private static final String ANALYSIS_V_ERROR = "\u7eb5\u5411\u6743\u9650\u5206\u6790\u65f6\uff0cPrincipal\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!";
    private static final String ANALYSIS_P_ERROR = "\u9884\u7f6e\u4fe1\u606f\u5206\u6790\u65f6\uff0cPrincipal\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!";

    public Map<String, Object> systemPresetValues(Set<DataViewSystemEntity> systems, Principal principal) {
        if (CollectionUtils.isEmpty(systems)) {
            return null;
        }
        Validate.notNull((Object)principal, (String)ANALYSIS_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)principal.getName(), (String)ANALYSIS_ERROR, (Object[])new Object[0]);
        HashMap<String, Object> presets = new HashMap<String, Object>();
        Set presetSystems = systems.stream().filter(e -> e.getParamSourceType() == 3).collect(Collectors.toSet());
        for (DataViewSystemEntity element : presetSystems) {
            Object o = this.getPresetValueByParamKey(element.getParamValue(), principal);
            String key = element.getParamName() + "|DataViewSystemEntity";
            presets.put(key, o);
        }
        return presets;
    }

    public Map<String, Object> authHorizontalPresetValues(Set<DataViewAuthHorizontalEntity> authHorizontals, Principal principal) {
        if (CollectionUtils.isEmpty(authHorizontals)) {
            return null;
        }
        Validate.notNull((Object)principal, (String)ANALYSIS_H_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)principal.getName(), (String)ANALYSIS_H_ERROR, (Object[])new Object[0]);
        HashMap<String, Object> presets = new HashMap<String, Object>();
        Set presetAuths = authHorizontals.stream().filter(e -> e.getParamSourceType() == 3).collect(Collectors.toSet());
        for (DataViewAuthHorizontalEntity auth : presetAuths) {
            if (auth.getParamSourceType() != 3) continue;
            Object o = this.getPresetValueByParamKey(auth.getParamKey(), principal);
            String key = auth.getField().getFieldName() + "|DataViewAuthHorizontalEntity";
            presets.put(key, o);
        }
        return presets;
    }

    public Map<Integer, Object> authVerticalPresetValues(Set<DataViewAuthVerticalEntity> authVerticals, Principal principal) {
        if (CollectionUtils.isEmpty(authVerticals)) {
            return null;
        }
        Validate.notNull((Object)principal, (String)ANALYSIS_V_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)principal.getName(), (String)ANALYSIS_V_ERROR, (Object[])new Object[0]);
        HashMap<Integer, Object> presets = new HashMap<Integer, Object>();
        for (int i = 1; i <= Constants.AUTH_TYPE_COUNT; ++i) {
            Integer authType = i;
            Set sameAuths = authVerticals.stream().filter(e -> authType.compareTo(e.getAuthType()) == 0).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(sameAuths)) continue;
            Integer key = i;
            Object value = this.getPresetValueByAuthType(principal, i);
            presets.put(key, value);
        }
        return presets;
    }

    private Object getPresetValueByAuthType(Principal principal, int authType) {
        Validate.notNull((Object)principal, (String)ANALYSIS_P_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)principal.getName(), (String)ANALYSIS_P_ERROR, (Object[])new Object[0]);
        String account = principal.getName();
        Validate.notBlank((CharSequence)account, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u7684\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        UserVo currentUser = this.userService.findByAccount(account);
        Validate.notNull((Object)currentUser, (String)"\u975e\u6cd5\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        switch (authType) {
            case 1: {
                return currentUser;
            }
            case 2: {
                List roles = this.roleService.findAllByUserId(currentUser.getId(), Integer.valueOf(0));
                return roles;
            }
            case 3: {
                List positions = this.positionService.findByUserId(currentUser.getId());
                return positions;
            }
            case 4: {
                Set groups = this.userGroupService.findByUserId(currentUser.getId());
                return groups;
            }
            case 5: {
                Set orgs = this.organizationService.findOrgByUserId(currentUser.getId());
                return orgs;
            }
        }
        return null;
    }

    private Object getPresetValueByParamKey(String paramKey, Principal principal) {
        Validate.notNull((Object)principal, (String)ANALYSIS_P_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)principal.getName(), (String)ANALYSIS_P_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)paramKey, (String)"\u9884\u7f6e\u63a7\u4ef6\u4e2d\uff0c\u672a\u80fd\u53d1\u73b0\u9884\u7f6e\u503c\u6807\u8bc6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String account = principal.getName();
        Validate.notBlank((CharSequence)account, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u7684\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        UserVo currentUser = this.userService.findByAccount(account);
        Validate.notNull((Object)currentUser, (String)"\u975e\u6cd5\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        List<Object> result = null;
        switch (paramKey) {
            case "userId": {
                result = currentUser.getId();
                break;
            }
            case "userName": {
                result = currentUser.getUserName();
                break;
            }
            case "userAccount": {
                result = currentUser.getAccount();
                break;
            }
            case "userCode": {
                result = currentUser.getId();
                break;
            }
            case "userPhone": {
                result = currentUser.getPhone();
                break;
            }
            case "userStatus": {
                result = currentUser.getUseStatus();
                break;
            }
            case "userIdcard": {
                result = currentUser.getIdcard();
                break;
            }
            case "userPositionId": 
            case "userPosition": 
            case "userPositionCode": 
            case "userPositionStatus": {
                ArrayList res = this.getPositionByUserId(currentUser.getId());
                if (CollectionUtils.isEmpty(res)) {
                    res = Lists.newArrayList((Object[])new String[]{"-0101010101"});
                }
                result = res;
                break;
            }
            case "userOrgStatus": 
            case "userOrgDesc": 
            case "userOrgType": {
                List<Object> orgInfos;
                result = orgInfos = this.findOrgInfosByUserId(currentUser.getId(), paramKey);
                break;
            }
            case "userOrg": 
            case "userOrgId": 
            case "curOrgs": 
            case "parentOrgs": 
            case "parentAllOrgs": 
            case "childrenOrgs": 
            case "childrenAllOrgs": {
                ArrayList orgIds = this.findOrgsByUserId(currentUser.getId(), paramKey);
                if (CollectionUtils.isEmpty(orgIds)) {
                    orgIds = Lists.newArrayList((Object[])new String[]{"-0101010101"});
                }
                result = orgIds;
                break;
            }
            case "userGroup": {
                Set groups = this.userGroupService.findByUserId(currentUser.getId());
                ArrayList userGroups = groups.stream().map(UserGroupVo::getId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(userGroups)) {
                    userGroups = Lists.newArrayList((Object[])new String[]{"-0101010101"});
                }
                result = userGroups;
                break;
            }
            case "userRole": {
                List roles = this.roleService.findAllByUserId(currentUser.getId(), Integer.valueOf(0));
                ArrayList roleIds = roles.stream().map(RoleVo::getId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(roleIds)) {
                    roleIds = Lists.newArrayList((Object[])new String[]{"-0101010101"});
                }
                result = roleIds;
                break;
            }
            case "currentUserLogOutTime": {
                result = currentUser.getLastloginTime();
                break;
            }
            case "currentUserLoginTime": {
                result = currentUser.getEntryTime();
                break;
            }
            case "nowDateMonth": 
            case "nowDateDay": 
            case "nowDateMinute": 
            case "nowDateSecond": {
                result = new Date();
                break;
            }
        }
        return result;
    }

    private List<Object> findOrgInfosByUserId(String userId, String paramKey) {
        Set orgs = this.organizationService.findOrgByUserId(userId);
        List<Object> result = new ArrayList<Object>();
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return result;
        }
        switch (paramKey) {
            case "userOrgStatus": {
                result = orgs.stream().map(OrganizationVo::getTstatus).collect(Collectors.toList());
                break;
            }
            case "userOrgDesc": {
                result = orgs.stream().map(OrganizationVo::getDescription).collect(Collectors.toList());
                break;
            }
            case "userOrgType": {
                result = orgs.stream().map(OrganizationVo::getType).collect(Collectors.toList());
                break;
            }
        }
        return result;
    }

    private List<String> getPositionByUserId(String id) {
        Validate.notBlank((CharSequence)"\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u65f6\uff0c\u4f20\u5165\u7684\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!");
        PositionVo position = this.positionService.findMainPositionByUserId(id);
        Validate.notNull((Object)position, (String)"\u9884\u5236\u4fe1\u606f\u5904\u7406\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u5c97\u4f4d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return Lists.newArrayList((Object[])new String[]{position.getId()});
    }

    private List<String> findOrgsByUserId(String userId, String paramKey) {
        Set<Object> orgs;
        Validate.notBlank((CharSequence)"\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u65f6\uff0c\u4f20\u5165\u7684\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!");
        switch (paramKey) {
            case "curOrgs": 
            case "userOrg": 
            case "userOrgId": {
                orgs = this.organizationService.findOrgByUserId(userId);
                break;
            }
            case "parentOrgs": {
                orgs = this.findParentOrgsByUserId(userId);
                break;
            }
            case "parentAllOrgs": {
                orgs = this.findAllParentOrgsByUserId(userId);
                break;
            }
            case "childrenOrgs": {
                orgs = this.findChildrenOrgsByUserId(userId);
                break;
            }
            case "childrenAllOrgs": {
                orgs = this.findAllChildrenOrgsByUserId(userId);
                break;
            }
            default: {
                orgs = Sets.newHashSet();
            }
        }
        if (!CollectionUtils.isEmpty((Collection)orgs)) {
            return orgs.stream().map(OrganizationVo::getId).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private Set<OrganizationVo> findParentOrgsByUserId(String userId) {
        Set orgs = this.organizationService.findOrgByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return orgs;
        }
        HashSet<OrganizationVo> parents = new HashSet<OrganizationVo>(16);
        for (OrganizationVo org : orgs) {
            OrganizationVo parent = this.organizationService.findByChild(org.getId());
            if (parent == null) continue;
            parents.add(parent);
        }
        return parents;
    }

    private Set<OrganizationVo> findChildrenOrgsByUserId(String userId) {
        Set orgs = this.organizationService.findOrgByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return orgs;
        }
        HashSet<OrganizationVo> Sons = new HashSet<OrganizationVo>(16);
        for (OrganizationVo org : orgs) {
            List son = this.organizationService.findByParent(org.getId());
            if (CollectionUtils.isEmpty((Collection)son)) continue;
            Sons.addAll(son);
        }
        return Sons;
    }

    private Set<OrganizationVo> findAllParentOrgsByUserId(String userId) {
        Set orgs = this.organizationService.findOrgByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return orgs;
        }
        HashSet<OrganizationVo> parents = new HashSet<OrganizationVo>(16);
        for (OrganizationVo org : orgs) {
            this.findParentOrg(parents, org.getId());
        }
        return parents;
    }

    private Set<OrganizationVo> findAllChildrenOrgsByUserId(String userId) {
        Set orgs = this.organizationService.findOrgByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return orgs;
        }
        HashSet<OrganizationVo> Sons = new HashSet<OrganizationVo>(16);
        for (OrganizationVo org : orgs) {
            this.findChildrenOrgs(Sons, org.getId());
        }
        return Sons;
    }

    private void findParentOrg(Set<OrganizationVo> orgs, String childOrgId) {
        OrganizationVo parent = this.organizationService.findByChild(childOrgId);
        if (parent == null) {
            return;
        }
        orgs.add(parent);
        this.findParentOrg(orgs, parent.getId());
    }

    private void findChildrenOrgs(Set<OrganizationVo> orgs, String parentOrgId) {
        List children = this.organizationService.findByParent(parentOrgId);
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        orgs.addAll(children);
        for (OrganizationVo org : children) {
            this.findChildrenOrgs(orgs, org.getId());
        }
    }
}

