/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalRelationEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.OrganizationEntity;
import com.bizunited.platform.core.entity.PositionEntity;
import com.bizunited.platform.core.entity.RoleEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UserGroupEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.core.repository.dataview.DataViewAuthHorizontalRepository;
import com.bizunited.platform.core.repository.dataview.DataViewRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalRelationService;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalService;
import com.bizunited.platform.rbac.server.service.OrganizationService;
import com.bizunited.platform.rbac.server.service.PositionService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.UserGroupService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.OrganizationVo;
import com.bizunited.platform.rbac.server.vo.PositionVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.rbac.server.vo.UserGroupVo;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewAuthHorizontalServiceImpl")
public class DataViewAuthHorizontalServiceImpl
implements DataViewAuthHorizontalService {
    @Autowired
    private DataViewRepository dataViewRepository;
    @Autowired
    private DataViewAuthHorizontalRepository dataViewAuthHorizontalRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private DataViewAuthHorizontalRelationService dataViewAuthHorizontalRelationService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public Set<DataViewAuthHorizontalEntity> create(Set<DataViewAuthHorizontalEntity> authHorizontals) {
        Validate.notEmpty(authHorizontals, (String)"\u4f20\u5165\u7684\u6a2a\u5411\u6743\u9650\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (DataViewAuthHorizontalEntity e2 : authHorizontals) {
            this.createValidation(e2);
        }
        this.dataViewAuthHorizontalRepository.saveAll(authHorizontals);
        Set auths = authHorizontals.stream().filter(e -> e.getParamSourceType() == 2).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(auths)) {
            for (DataViewAuthHorizontalEntity e3 : auths) {
                Set<DataViewAuthHorizontalRelationEntity> needCreates = e3.getAuthRelations();
                this.dataViewAuthHorizontalRelationService.create(e3, needCreates);
            }
        }
        return authHorizontals;
    }

    @Override
    public void createValidation(DataViewAuthHorizontalEntity dataViewAuthHorizontalEntity) {
        Validate.notNull((Object)dataViewAuthHorizontalEntity, (String)"\u6a2a\u5411\u6570\u636e\u6743\u9650\u7684\u5bf9\u8c61\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataViewAuthHorizontalEntity.getId()), (String)"\u6dfb\u52a0\u6a2a\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dataViewAuthHorizontalEntity.setId(null);
        Validate.notNull((Object)dataViewAuthHorizontalEntity.getSortIndex(), (String)"\u6392\u5e8f\u503c\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthHorizontalEntity.getAuthType(), (String)"\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuthHorizontalEntity.getOprtType(), (String)"\u64cd\u4f5c\u7b26\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuthHorizontalEntity.getParamType(), (String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthHorizontalEntity.getParamSourceType(), (String)"\u53c2\u6570\u6765\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DataViewFieldEntity field = dataViewAuthHorizontalEntity.getField();
        Validate.notNull((Object)field, (String)"\u6dfb\u52a0\u6a2a\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u6743\u9650\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        DataViewEntity dataView = dataViewAuthHorizontalEntity.getDataView();
        Validate.notNull((Object)dataView, (String)"\u6dfb\u52a0\u6a2a\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((dataViewAuthHorizontalEntity.getOprtType() == null || dataViewAuthHorizontalEntity.getOprtType().length() <= 32 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u7b26\u7c7b\u578b,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewAuthHorizontalEntity.getParamType() == null || dataViewAuthHorizontalEntity.getParamType().length() <= 64 ? 1 : 0) != 0, (String)"\u53c2\u6570\u7c7b\u578b,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewAuthHorizontalEntity.getParamKey() == null || dataViewAuthHorizontalEntity.getParamKey().length() <= 64 ? 1 : 0) != 0, (String)"\u9884\u5236\u503c\u6807\u8bc6,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public Set<DataViewAuthHorizontalEntity> update(Set<DataViewAuthHorizontalEntity> authHorizontals, String dataViewId) {
        Validate.notBlank((CharSequence)dataViewId, (String)"\u4f20\u5165\u7684\u89c6\u56feID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional op = this.dataViewRepository.findById(dataViewId);
        DataViewEntity dataView = op.orElse(null);
        Validate.notNull((Object)dataView, (String)"\u6839\u636e\u89c6\u56feID\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u76f8\u5e94\u7684\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(authHorizontals)) {
            Set<DataViewAuthHorizontalEntity> authHors = this.dataViewAuthHorizontalRepository.findDetailsByDataViewCode(dataView.getCode());
            if (!CollectionUtils.isEmpty(authHors)) {
                for (DataViewAuthHorizontalEntity x : authHors) {
                    this.dataViewAuthHorizontalRelationService.deleteByAuthHorizontal(x.getId());
                }
                this.dataViewAuthHorizontalRepository.deleteByDataView(dataViewId);
            }
            return Sets.newHashSet();
        }
        Set<DataViewAuthHorizontalEntity> needInsertSets = authHorizontals.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toSet());
        Set needUpdateSets = authHorizontals.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getId())).collect(Collectors.toSet());
        Set<DataViewAuthHorizontalEntity> dbAuthHorizoncals = this.dataViewAuthHorizontalRepository.findDetailsByDataViewCode(dataView.getCode());
        Set<String> needDeleteFieldKeys = this.nebulaToolkitService.collectionDiffent(dbAuthHorizoncals, authHorizontals, UuidEntity::getId);
        if (!CollectionUtils.isEmpty(needInsertSets)) {
            needInsertSets.forEach(h -> h.setDataView(dataView));
            this.create(needInsertSets);
        }
        if (!CollectionUtils.isEmpty(needDeleteFieldKeys)) {
            for (String authHorizontalKey : needDeleteFieldKeys) {
                this.dataViewAuthHorizontalRelationService.deleteByAuthHorizontal(authHorizontalKey);
                this.dataViewAuthHorizontalRepository.deleteById(authHorizontalKey);
            }
        }
        if (CollectionUtils.isEmpty(needUpdateSets)) {
            return authHorizontals;
        }
        for (DataViewAuthHorizontalEntity e2 : needUpdateSets) {
            this.updateValidation(e2);
            String currentId = e2.getId();
            Optional opt = this.dataViewAuthHorizontalRepository.findById(currentId);
            DataViewAuthHorizontalEntity currentDataViewAuthHorizontalEntity = opt.orElse(null);
            Validate.notNull((Object)currentDataViewAuthHorizontalEntity, (String)"\u66f4\u65b0\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6a2a\u5411\u6743\u9650\u5bf9\u8c61\u4fe1\u606f", (Object[])new Object[0]);
            currentDataViewAuthHorizontalEntity.setAuthType(e2.getAuthType());
            currentDataViewAuthHorizontalEntity.setOprtType(e2.getOprtType());
            currentDataViewAuthHorizontalEntity.setParamSourceType(e2.getParamSourceType());
            currentDataViewAuthHorizontalEntity.setParamType(e2.getParamType());
            currentDataViewAuthHorizontalEntity.setParamKey(e2.getParamKey());
            currentDataViewAuthHorizontalEntity.setField(e2.getField());
            currentDataViewAuthHorizontalEntity.setDataView(dataView);
            currentDataViewAuthHorizontalEntity.setSortIndex(e2.getSortIndex());
            if (e2.getParamSourceType() != 2) {
                e2.setAuthRelations(null);
            }
            this.dataViewAuthHorizontalRepository.save(currentDataViewAuthHorizontalEntity);
            Set<DataViewAuthHorizontalRelationEntity> authRelations = e2.getAuthRelations();
            if (CollectionUtils.isEmpty(authRelations) && e2.getParamSourceType() == 3) continue;
            this.dataViewAuthHorizontalRelationService.save(currentDataViewAuthHorizontalEntity, authRelations);
        }
        return authHorizontals;
    }

    @Override
    public void updateValidation(DataViewAuthHorizontalEntity dataViewAuthHorizontalEntity) {
        Validate.notNull((Object)dataViewAuthHorizontalEntity, (String)"\u66f4\u65b0\u65f6\uff0c\u6a2a\u5411\u6743\u9650\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff01\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dataViewAuthHorizontalEntity.getId()), (String)"\u4fee\u6539\u6a2a\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthHorizontalEntity.getSortIndex(), (String)"\u6392\u5e8f\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthHorizontalEntity.getParamSourceType(), (String)"\u53c2\u6570\u6765\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthHorizontalEntity.getAuthType(), (String)"\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuthHorizontalEntity.getOprtType(), (String)"\u64cd\u4f5c\u7b26\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuthHorizontalEntity.getParamType(), (String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DataViewFieldEntity field = dataViewAuthHorizontalEntity.getField();
        Validate.notNull((Object)field, (String)"\u66f4\u65b0\u6a2a\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u6743\u9650\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((dataViewAuthHorizontalEntity.getOprtType() == null || dataViewAuthHorizontalEntity.getOprtType().length() < 32 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u7b26\u7c7b\u578b,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewAuthHorizontalEntity.getParamType() == null || dataViewAuthHorizontalEntity.getParamType().length() < 64 ? 1 : 0) != 0, (String)"\u53c2\u6570\u7c7b\u578b,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewAuthHorizontalEntity.getParamKey() == null || dataViewAuthHorizontalEntity.getParamKey().length() < 64 ? 1 : 0) != 0, (String)"\u9884\u5236\u503c\u6807\u8bc6,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public DataViewAuthHorizontalEntity findDetailsByFieldAndDataView(String field, String dataViewId) {
        if (StringUtils.isBlank((CharSequence)field) || StringUtils.isBlank((CharSequence)dataViewId)) {
            return null;
        }
        return this.dataViewAuthHorizontalRepository.findDetailsByFieldAndDataView(field, dataViewId);
    }

    @Override
    public Set<DataViewAuthHorizontalEntity> findDetailsByDataViewCode(String dataView) {
        if (StringUtils.isBlank((CharSequence)dataView)) {
            return Sets.newHashSet();
        }
        Set<DataViewAuthHorizontalEntity> auths = this.dataViewAuthHorizontalRepository.findDetailsByDataViewCode(dataView);
        Collection<DataViewAuthHorizontalEntity> collection = this.nebulaToolkitService.copyCollectionByWhiteList(auths, DataViewAuthHorizontalEntity.class, DataViewAuthHorizontalEntity.class, LinkedHashSet.class, ArrayList.class, "field", "dataView", "authRelations", "authRelations.authHorizontal", "authRelations.relation");
        this.loadRelation(collection);
        return (Set)collection;
    }

    private void loadRelation(Collection<DataViewAuthHorizontalEntity> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return;
        }
        for (DataViewAuthHorizontalEntity horizontal : collection) {
            Set<DataViewAuthHorizontalRelationEntity> authRelations = horizontal.getAuthRelations();
            if (CollectionUtils.isEmpty(authRelations)) continue;
            for (DataViewAuthHorizontalRelationEntity authRelation : authRelations) {
                UuidEntity relation = this.getRelation(horizontal, authRelation);
                authRelation.setRelation(relation);
            }
        }
    }

    private UuidEntity getRelation(DataViewAuthHorizontalEntity horizontal, DataViewAuthHorizontalRelationEntity authRelation) {
        if (StringUtils.isBlank((CharSequence)authRelation.getAuthRelationIds())) {
            return null;
        }
        UuidEntity relation = null;
        switch (horizontal.getAuthType()) {
            case 1: {
                UserVo user = this.userService.findByAccount(authRelation.getAuthRelationIds());
                if (user == null) break;
                relation = this.nebulaToolkitService.copyObjectByWhiteList(user, UserEntity.class, HashSet.class, ArrayList.class, new String[0]);
                break;
            }
            case 2: {
                RoleVo role = this.roleService.findByCode(authRelation.getAuthRelationIds());
                if (role == null) break;
                relation = this.nebulaToolkitService.copyObjectByWhiteList(role, RoleEntity.class, HashSet.class, ArrayList.class, new String[0]);
                break;
            }
            case 3: {
                PositionVo position = this.positionService.findByCode(authRelation.getAuthRelationIds());
                if (position == null) break;
                relation = this.nebulaToolkitService.copyObjectByWhiteList(position, PositionEntity.class, HashSet.class, ArrayList.class, new String[0]);
                break;
            }
            case 4: {
                UserGroupVo userGroup = this.userGroupService.findByGroupName(authRelation.getAuthRelationIds());
                if (userGroup == null) break;
                relation = this.nebulaToolkitService.copyObjectByWhiteList(userGroup, UserGroupEntity.class, HashSet.class, ArrayList.class, new String[0]);
                break;
            }
            case 5: {
                OrganizationVo organization = this.organizationService.findByCode(authRelation.getAuthRelationIds());
                if (organization == null) break;
                relation = this.nebulaToolkitService.copyObjectByWhiteList(organization, OrganizationEntity.class, HashSet.class, ArrayList.class, new String[0]);
                break;
            }
        }
        return relation;
    }

    @Override
    public Set<DataViewAuthHorizontalEntity> findDetailsByDataViewIds(String[] dataViewIds) {
        if (dataViewIds == null || dataViewIds.length == 0) {
            return Sets.newHashSet();
        }
        Set<DataViewAuthHorizontalEntity> auths = this.dataViewAuthHorizontalRepository.findDetailsByDataViewIds(dataViewIds);
        Collection<DataViewAuthHorizontalEntity> collection = this.nebulaToolkitService.copyCollectionByWhiteList(auths, DataViewAuthHorizontalEntity.class, DataViewAuthHorizontalEntity.class, HashSet.class, ArrayList.class, "field", "dataView", "authRelations", "authRelations.authHorizontal");
        return (Set)collection;
    }

    @Override
    public DataViewAuthHorizontalEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewAuthHorizontalRepository.findDetailsById(id);
    }

    @Override
    public DataViewAuthHorizontalEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.dataViewAuthHorizontalRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataViewAuthHorizontalRepository.findById(id);
        op.ifPresent(dataViewAuthHorizontalEntity -> this.dataViewAuthHorizontalRepository.delete(dataViewAuthHorizontalEntity));
    }

    @Override
    @Transactional
    public void deleteByDateView(DataViewEntity dataViewEntity) {
        Validate.notNull((Object)dataViewEntity, (String)"\u6570\u636e\u89c6\u56fe\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getCode(), (String)"\u6570\u636e\u89c6\u56fe\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Set<DataViewAuthHorizontalEntity> hors = this.dataViewAuthHorizontalRepository.findDetailsByDataViewCode(dataViewEntity.getCode());
        if (!CollectionUtils.isEmpty(hors)) {
            for (DataViewAuthHorizontalEntity v : hors) {
                this.dataViewAuthHorizontalRelationService.deleteByAuthHorizontal(v.getId());
            }
            this.dataViewAuthHorizontalRepository.deleteByDataView(dataViewEntity.getId());
        }
    }
}

