/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.common.enums.DataSourceTypeEnum;
import com.bizunited.platform.core.common.utils.ChineseCharUtil;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthInterceptorEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.entity.DataViewGroupEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.core.repository.dataview.DataViewRepository;
import com.bizunited.platform.core.repository.dataview.analysis.AbstractSqlAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.MysqlAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.OracleSqlAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLAuthVerticalAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLPresetValueAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SqlAnalysis;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.core.service.dataview.DataSourceService;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalService;
import com.bizunited.platform.core.service.dataview.DataViewAuthInterceptorService;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalService;
import com.bizunited.platform.core.service.dataview.DataViewFieldService;
import com.bizunited.platform.core.service.dataview.DataViewFilterService;
import com.bizunited.platform.core.service.dataview.DataViewGroupService;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.dataview.DataViewSystemService;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import com.bizunited.platform.core.vo.dataview.DataviewExportExcelFieldVo;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewEntityServiceImpl")
public class DataViewServiceImpl
implements DataViewService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewServiceImpl.class);
    private static final String ERROR_MESS_SQL = "\u539f\u59cbSQL\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Integer TIME_OUT = 10;
    private static final int DEFAULT_COLUMN_WIDTH = 5000;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DataSourceProperties dataSourceProperties;
    @Autowired
    private DataViewRepository dataViewEntityRepository;
    @Autowired
    private DataViewFieldService dataViewFieldService;
    @Autowired
    private DataViewFilterService dataViewFilterService;
    @Autowired
    private DataViewSystemService dataViewSystemService;
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private DataViewGroupService dataViewGroupService;
    @Autowired
    private DataViewAuthHorizontalService dataViewAuthHorizontalService;
    @Autowired
    private DataViewAuthVerticalService dataViewAuthVerticalService;
    @Lazy
    @Autowired
    private DataViewAuthInterceptorService dataViewAuthInterceptorService;
    @Autowired
    private SQLPresetValueAnalysis sqlPresetValueAnalysis;
    private DataViewService proxySelf;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @PostConstruct
    public void setProxySelf() {
        this.proxySelf = (DataViewService)this.applicationContext.getBean(DataViewService.class);
    }

    @Override
    public void createValidation(DataViewEntity dataViewEntity) {
        Validate.notNull((Object)dataViewEntity, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataViewEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dataViewEntity.setId(null);
        Validate.notBlank((CharSequence)dataViewEntity.getCode(), (String)"\u6570\u636e\u89c6\u56fe\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DataViewEntity currentEntity = this.dataViewEntityRepository.findByCode(dataViewEntity.getCode());
        Validate.isTrue((null == currentEntity ? 1 : 0) != 0, (String)"\u8be5CODE\u89c6\u56fe\u5df2\u5b58\u5728\uff0c\u8bf7\u6539\u53d8\u7f16\u7801\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getName(), (String)"\u89c6\u56fe\u4e2d\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!ChineseCharUtil.hasChinese(dataViewEntity.getCode()) ? 1 : 0) != 0, (String)"\u89c6\u56fe\u7f16\u7801\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getSourceSql(), (String)ERROR_MESS_SQL, (Object[])new Object[0]);
        Validate.notNull((Object)dataViewEntity.getTstatus(), (String)"\u89c6\u56fe\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getCode() == null || dataViewEntity.getCode().length() < 64 ? 1 : 0) != 0, (String)"\u6570\u636e\u89c6\u56fe\u7f16\u53f7,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getName() == null || dataViewEntity.getName().length() < 64 ? 1 : 0) != 0, (String)"\u89c6\u56fe\u4e2d\u6587\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getSourceSql() == null || dataViewEntity.getSourceSql().length() < 4096 ? 1 : 0) != 0, (String)"\u539f\u59cbSQL,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(4096)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public DataViewEntity create(DataViewEntity dataViewEntity, boolean ignoreValidate) {
        DataSourceEntity dataSource;
        if (!ignoreValidate) {
            this.createValidation(dataViewEntity);
        }
        if ((dataSource = dataViewEntity.getDataSource()) != null && StringUtils.isNotBlank((CharSequence)dataSource.getId())) {
            DataSourceEntity currentDataSource = this.dataSourceService.findById(dataSource.getId());
            Validate.notNull((Object)currentDataSource, (String)"\u672a\u627e\u5230\u8be5\u6570\u636e\u6e90!", (Object[])new Object[0]);
        }
        DataViewGroupEntity dataViewGroup = dataViewEntity.getDataViewGroup();
        Validate.notNull((Object)dataViewGroup, (String)"\u89c6\u56fe\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewGroup.getId(), (String)"\u89c6\u56fe\u6240\u9009\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.dataViewEntityRepository.save(dataViewEntity);
        Set<DataViewFieldEntity> fields = dataViewEntity.getFields();
        this.dataViewFieldService.create(fields, dataViewEntity);
        Set<DataViewSystemEntity> systemFilters = dataViewEntity.getSystemFilters();
        this.dataViewSystemService.create(systemFilters, dataViewEntity);
        Set<DataViewFilterEntity> filters = dataViewEntity.getFilters();
        this.dataViewFilterService.create(filters, fields, dataViewEntity);
        dataViewEntity.setFields(fields);
        dataViewEntity.setFilters(filters);
        dataViewEntity.setSystemFilters(systemFilters);
        return dataViewEntity;
    }

    @Override
    @Transactional
    public DataViewEntity update(DataViewEntity dataViewEntity) {
        Set<String> needDeleteSystemFilterKeys;
        Set<DataViewSystemEntity> systemFilters;
        Set<String> needDeleteFilterKeys;
        Set<DataViewFilterEntity> filters;
        Set<String> needDeleteFieldKeys;
        this.updateValidation(dataViewEntity);
        String currentId = dataViewEntity.getId();
        Optional op = this.dataViewEntityRepository.findById(currentId);
        DataViewEntity currentDataViewEntity = op.orElse(null);
        Validate.notNull((Object)currentDataViewEntity, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        currentDataViewEntity.setCode(dataViewEntity.getCode());
        currentDataViewEntity.setName(dataViewEntity.getName());
        currentDataViewEntity.setSourceSql(dataViewEntity.getSourceSql());
        currentDataViewEntity.setTstatus(dataViewEntity.getTstatus());
        DataSourceEntity currentDataSourceEntity = currentDataViewEntity.getDataSource();
        DataSourceEntity dataSource = dataViewEntity.getDataSource();
        Validate.isTrue((currentDataSourceEntity == null && dataSource == null || currentDataSourceEntity != null && dataSource != null ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u6570\u636e\u89c6\u56fe\u6570\u636e\u6e90\u4e0e\u539f\u6709\u7684\u6570\u636e\u6e90\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\uff01\uff01", (Object[])new Object[0]);
        if (dataSource != null) {
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)dataSource.getId(), (CharSequence)currentDataSourceEntity.getId()), (String)"\u4f20\u5165\u7684\u6570\u636e\u89c6\u56fe\u6570\u636e\u6e90\u4e0e\u539f\u6709\u7684\u6570\u636e\u6e90\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\uff01\uff01", (Object[])new Object[0]);
        }
        DataViewGroupEntity dataViewGroup = dataViewEntity.getDataViewGroup();
        Validate.notNull((Object)dataViewGroup, (String)"\u89c6\u56fe\u6240\u9009\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewGroup.getId(), (String)"\u89c6\u56fe\u6240\u9009\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.dataViewAuthHorizontalService.deleteByDateView(dataViewEntity);
        Set<DataViewFieldEntity> fields = dataViewEntity.getFields();
        Validate.isTrue((!CollectionUtils.isEmpty(fields) ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u89c6\u56fe\u7ed3\u6784\u7684\u8f93\u51fa\u5b57\u6bb5\u4fe1\u606f\u96c6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        fields.forEach(e -> {
            if (StringUtils.isNotBlank((CharSequence)e.getId())) {
                this.dataViewFieldService.updateValidation((DataViewFieldEntity)e);
            } else {
                this.dataViewFieldService.createValidation((DataViewFieldEntity)e);
            }
        });
        Set<Object> dbFields = new LinkedHashSet();
        if (!CollectionUtils.isEmpty(currentDataViewEntity.getFields())) {
            dbFields = currentDataViewEntity.getFields();
        }
        if (!CollectionUtils.isEmpty(needDeleteFieldKeys = this.nebulaToolkitService.collectionDiffent(dbFields, fields, UuidEntity::getId))) {
            needDeleteFieldKeys.forEach(e -> {
                this.dataViewFilterService.deleteByField((String)e);
                this.dataViewAuthVerticalService.deleteByDataView(dataViewEntity);
                this.dataViewFieldService.deleteById((String)e);
            });
        }
        if ((filters = dataViewEntity.getFilters()) == null) {
            filters = new LinkedHashSet<DataViewFilterEntity>();
        } else {
            filters.forEach(e -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{e.getId()})) {
                    this.dataViewFilterService.updateValidation((DataViewFilterEntity)e);
                } else {
                    this.dataViewFilterService.createValidation((DataViewFilterEntity)e);
                }
            });
        }
        Set<DataViewFilterEntity> dbFilters = currentDataViewEntity.getFilters();
        if (CollectionUtils.isEmpty(dbFilters)) {
            dbFilters = new LinkedHashSet<DataViewFilterEntity>();
        }
        if (!CollectionUtils.isEmpty(needDeleteFilterKeys = this.nebulaToolkitService.collectionDiffent(dbFilters, filters, UuidEntity::getId))) {
            needDeleteFilterKeys.forEach(e -> this.dataViewFilterService.deleteById((String)e));
        }
        if (!CollectionUtils.isEmpty(systemFilters = dataViewEntity.getSystemFilters())) {
            systemFilters.forEach(e -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{e.getId()})) {
                    this.dataViewSystemService.updateValidation((DataViewSystemEntity)e);
                } else {
                    this.dataViewSystemService.createValidation((DataViewSystemEntity)e);
                }
            });
        } else {
            systemFilters = new LinkedHashSet<DataViewSystemEntity>();
        }
        Set<DataViewSystemEntity> dbSystemFilters = currentDataViewEntity.getSystemFilters();
        if (CollectionUtils.isEmpty(dbSystemFilters)) {
            dbSystemFilters = new LinkedHashSet<DataViewSystemEntity>();
        }
        if (!CollectionUtils.isEmpty(needDeleteSystemFilterKeys = this.nebulaToolkitService.collectionDiffent(dbSystemFilters, systemFilters, UuidEntity::getId))) {
            needDeleteSystemFilterKeys.forEach(e -> this.dataViewSystemService.deleteById((String)e));
        }
        for (DataViewFieldEntity fieldEntity : fields) {
            fieldEntity.setDataView(currentDataViewEntity);
            if (StringUtils.isBlank((CharSequence)fieldEntity.getId())) {
                this.dataViewFieldService.create(fieldEntity, true);
                continue;
            }
            this.dataViewFieldService.update(fieldEntity);
        }
        filters.forEach(e -> {
            e.setDataView(currentDataViewEntity);
            Optional<DataViewFieldEntity> optional = fields.stream().filter(x -> StringUtils.equals((CharSequence)e.getField().getFieldName(), (CharSequence)x.getFieldName())).findFirst();
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u5b57\u6bb5\u4fe1\u606f\u4e0e\u7b5b\u9009\u4fe1\u606f\u76f8\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            e.setField(optional.get());
            if (StringUtils.isBlank((CharSequence)e.getId())) {
                this.dataViewFilterService.create((DataViewFilterEntity)e, true);
            } else {
                this.dataViewFilterService.update((DataViewFilterEntity)e);
            }
        });
        for (DataViewSystemEntity systemFilterEntity : systemFilters) {
            systemFilterEntity.setDataView(currentDataViewEntity);
            if (StringUtils.isBlank((CharSequence)systemFilterEntity.getId())) {
                this.dataViewSystemService.create(systemFilterEntity, true);
                continue;
            }
            this.dataViewSystemService.update(systemFilterEntity);
        }
        currentDataViewEntity.setDataSource(dataSource);
        currentDataViewEntity.setDataViewGroup(dataViewGroup);
        currentDataViewEntity.setFields(fields);
        currentDataViewEntity.setFilters(filters);
        currentDataViewEntity.setSystemFilters(systemFilters);
        this.dataViewEntityRepository.save(currentDataViewEntity);
        return currentDataViewEntity;
    }

    @Override
    public void updateValidation(DataViewEntity dataViewEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)dataViewEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getCode(), (String)"\u6570\u636e\u89c6\u56fe\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getName(), (String)"\u89c6\u56fe\u4e2d\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getSourceSql(), (String)ERROR_MESS_SQL, (Object[])new Object[0]);
        Validate.notNull((Object)dataViewEntity.getTstatus(), (String)"\u89c6\u56fe\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getCode() == null || dataViewEntity.getCode().length() < 64 ? 1 : 0) != 0, (String)"\u6570\u636e\u89c6\u56fe\u7f16\u53f7,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getName() == null || dataViewEntity.getName().length() < 64 ? 1 : 0) != 0, (String)"\u89c6\u56fe\u4e2d\u6587\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getSourceSql() == null || dataViewEntity.getSourceSql().length() < 4096 ? 1 : 0) != 0, (String)"\u539f\u59cbSQL,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(4096)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataViewEntityRepository.findById(id);
        op.ifPresent(dataViewEntity -> this.dataViewEntityRepository.delete(dataViewEntity));
    }

    @Override
    @Async(value="dynamicExecutor")
    public Future<?> executeTop1(String dataSourceCode, DataViewEntity dataView, InvokeParams invokeParams, Principal principal) {
        AsyncResult future;
        try {
            SqlAnalysis sqlAnalysis = this.dataViewLogic(dataView, dataSourceCode, principal, invokeParams, null);
            JSONArray jsonArr = this.dataViewEntityRepository.executeSQLTop1(dataSourceCode, sqlAnalysis);
            future = new AsyncResult((Object)jsonArr);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            future = new AsyncResult((Object)e);
        }
        return future;
    }

    @Override
    public JSONArray executeTop1(DataViewEntity dataView, InvokeParams invokeParams, Principal principal) {
        SqlAnalysis sqlAnalysis = this.dataViewLogic(dataView, null, principal, invokeParams, (Pageable)PageRequest.of((int)0, (int)1));
        return this.dataViewEntityRepository.executeSQLTop1(sqlAnalysis);
    }

    @Override
    @Async(value="dynamicExecutor")
    public Future<?> execute(String dataSourceCode, DataViewEntity dataView, InvokeParams invokeParams, Principal principal) {
        AsyncResult future;
        try {
            SqlAnalysis sqlAnalysis = this.dataViewLogic(dataView, dataSourceCode, principal, invokeParams, null);
            JSONArray jsonArr = this.dataViewEntityRepository.executeSQL(dataSourceCode, sqlAnalysis, dataView);
            future = new AsyncResult((Object)jsonArr);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            future = new AsyncResult((Object)e);
        }
        return future;
    }

    @Override
    @Async(value="dynamicExecutor")
    public Future<?> execute(String dataSourceCode, DataViewEntity dataView, InvokeParams invokeParams, Pageable pageable, Principal principal) {
        AsyncResult future;
        try {
            SqlAnalysis sqlAnalysis = this.dataViewLogic(dataView, dataSourceCode, principal, invokeParams, pageable);
            Page page = this.dataViewEntityRepository.executeSQLPageAble(dataSourceCode, sqlAnalysis, pageable);
            future = new AsyncResult((Object)page);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            future = new AsyncResult((Object)e);
        }
        return future;
    }

    @Override
    public Page<JSONObject> execute(DataViewEntity dataView, InvokeParams invokeParams, Pageable pageable, Principal principal) {
        SqlAnalysis sqlAnalysis = this.dataViewLogic(dataView, null, principal, invokeParams, pageable);
        return this.dataViewEntityRepository.executeSQLPageAble(sqlAnalysis);
    }

    @Override
    public JSONArray execute(DataViewEntity dataView, InvokeParams invokeParams, Principal principal) {
        SqlAnalysis sqlAnalysis = this.dataViewLogic(dataView, null, principal, invokeParams, null);
        return this.dataViewEntityRepository.executeSQL(sqlAnalysis);
    }

    @Override
    public Set<String> findFieldsByDataViewCode(String dataViewCode, Principal principal) {
        DataViewEntity dataView = this.dataViewEntityRepository.findByCode(dataViewCode);
        Validate.notNull((Object)dataView, (String)"\u6ca1\u6709\u67e5\u5230\u6307\u5b9a\u7684\u6570\u636e\u89c6\u56fe\u4fe1\u606f", (Object[])new Object[0]);
        Set<DataViewAuthVerticalEntity> auths = this.dataViewAuthVerticalService.findDetailsByDataViewCode(dataViewCode);
        Map<Integer, Object> verticalPresets = this.sqlPresetValueAnalysis.authVerticalPresetValues(auths, principal);
        return SQLAuthVerticalAnalysis.buildFields(auths, verticalPresets);
    }

    @Override
    public byte[] exportExcel(String dataSourceCode, DataViewEntity dataView, InvokeParams inputParams, Principal principal, List<DataviewExportExcelFieldVo> excelFields) {
        Workbook workbook;
        JSONArray jsonArray;
        if (CollectionUtils.isEmpty(excelFields)) {
            return new byte[0];
        }
        if (StringUtils.isNotBlank((CharSequence)dataSourceCode)) {
            Future<?> future = this.proxySelf.execute(dataSourceCode, dataView, inputParams, principal);
            try {
                Object result = future.get(TIME_OUT.intValue(), TimeUnit.SECONDS);
                jsonArray = (JSONArray)result;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new IllegalArgumentException("\u67e5\u8be2\u6570\u636e\u9519\u8bef", e);
            }
        } else {
            jsonArray = this.execute(dataView, inputParams, principal);
        }
        if ((workbook = this.buildWorkbook(jsonArray, excelFields)) == null) {
            return new byte[0];
        }
        byte[] bytes = new byte[]{};
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            workbook.write((OutputStream)os);
            bytes = os.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return bytes;
    }

    private Workbook buildWorkbook(JSONArray jsonArray, List<DataviewExportExcelFieldVo> excelFields) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        List<DataviewExportExcelFieldVo> sortedExcelFields = excelFields.stream().sorted(Comparator.comparing(DataviewExportExcelFieldVo::getSortIndex)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)jsonArray)) {
            this.initTitle(sheet, sortedExcelFields);
            return workbook;
        }
        this.initColumnWidth(sheet, jsonArray.size());
        this.initTitle(sheet, sortedExcelFields);
        this.initRows(sheet, jsonArray, sortedExcelFields);
        return workbook;
    }

    private void initRows(Sheet sheet, JSONArray jsonArray, List<DataviewExportExcelFieldVo> fields) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Row row = sheet.createRow(i + 1);
            this.initRow(row, jsonObject, fields);
        }
    }

    private void initRow(Row row, JSONObject jsonObject, List<DataviewExportExcelFieldVo> fields) {
        for (int i = 0; i < fields.size(); ++i) {
            DataviewExportExcelFieldVo field = fields.get(i);
            Cell cell = row.createCell(i);
            this.setCellValue(cell, jsonObject, field);
        }
    }

    private String getCellDictKey(Map<String, String> dicts, Object obj) {
        String[] values = obj.toString().split(",");
        ArrayList<String> keys = new ArrayList<String>();
        Map vDicts = dicts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (a, b) -> b, () -> new HashMap(16)));
        for (String value : values) {
            String key = (String)vDicts.get(value);
            if (key == null) {
                keys.add(value);
                continue;
            }
            keys.add(key);
        }
        return StringUtils.join(keys, (String)"\u3001");
    }

    private void setCellValue(Cell cell, JSONObject jsonObject, DataviewExportExcelFieldVo field) {
        Object obj = jsonObject.get((Object)field.getFieldName());
        if (obj == null) {
            cell.setCellValue("");
            return;
        }
        Map<String, String> dicts = field.getDicts();
        if (dicts != null && dicts.size() > 0) {
            String key = this.getCellDictKey(dicts, obj);
            cell.setCellValue(key);
            return;
        }
        if (obj instanceof Integer) {
            cell.setCellValue((double)((Integer)obj).intValue());
        } else if (obj instanceof Double) {
            cell.setCellValue(((Double)obj).doubleValue());
        } else if (obj instanceof Float) {
            cell.setCellValue((double)((Float)obj).floatValue());
        } else if (obj instanceof String) {
            cell.setCellValue((String)obj);
        } else if (obj instanceof Date) {
            String format = DEFAULT_DATE_FORMAT;
            if (StringUtils.isNotBlank((CharSequence)field.getFormat())) {
                format = field.getFormat();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            cell.setCellValue(dateFormat.format((Date)obj));
        } else if (obj instanceof Long) {
            Long data = (Long)obj;
            if (Objects.equals("java.sql.Timestamp", field.getFieldType()) || Objects.equals("java.util.Date", field.getFieldType())) {
                String format = DEFAULT_DATE_FORMAT;
                if (StringUtils.isNotBlank((CharSequence)field.getFormat())) {
                    format = field.getFormat();
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                cell.setCellValue(dateFormat.format(data));
            } else {
                cell.setCellValue((double)((Long)obj).longValue());
            }
        } else if (obj instanceof Boolean) {
            cell.setCellValue(((Boolean)obj).booleanValue());
        } else if (obj instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)obj).toString());
        } else if (obj instanceof Byte) {
            cell.setCellValue((double)((Byte)obj).byteValue());
        } else if (obj instanceof Short) {
            cell.setCellValue((double)((Short)obj).shortValue());
        } else {
            cell.setCellValue(obj.toString());
        }
    }

    private void initColumnWidth(Sheet sheet, int columnCount) {
        for (int i = 0; i < columnCount; ++i) {
            sheet.setColumnWidth(i, 5000);
        }
    }

    private void initTitle(Sheet sheet, List<DataviewExportExcelFieldVo> fields) {
        Row row = sheet.createRow(0);
        for (int i = 0; i < fields.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(fields.get(i).getDisplayName());
        }
    }

    private SqlAnalysis dataViewLogic(DataViewEntity dataViewParam, String dataSourceCode, Principal principal, InvokeParams invokeParams, Pageable pageable) {
        AbstractSqlAnalysis sqlAnalysis;
        String dataSourceType;
        DataViewEntity dataView;
        Validate.notNull((Object)dataViewParam, (String)"\u4f20\u5165\u7684\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dataSourceCode)) {
            dataView = this.validateMainInfo(dataViewParam.getCode());
            DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.valueOfDriver(this.dataSourceProperties.getDriverClassName());
            Validate.notNull((Object)((Object)dataSourceTypeEnum), (String)String.format("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u9a71\u52a8\u7c7b\uff1a%s", this.dataSourceProperties.getDriverClassName()), (Object[])new Object[0]);
            dataSourceType = dataSourceTypeEnum.getDatabase();
        } else {
            dataView = this.validateThirdInfo(dataSourceCode, dataViewParam.getCode());
            DataSourceEntity dataSource = this.dataSourceService.findDetailsByCode(dataSourceCode);
            Validate.notNull((Object)dataSource, (String)"\u6839\u636e\u4f20\u5165\u7684code\u503c\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            dataSourceType = dataSource.getType();
        }
        Validate.notBlank((CharSequence)dataSourceType, (String)"\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)dataView, (String)"\u6839\u636e\u4f20\u5165\u7684\u89c6\u56feId\uff0c\u672a\u80fd\u67e5\u8be2\u5230\u89c6\u56fe\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<DataViewAuthHorizontalEntity> authHorizontals = this.dataViewAuthHorizontalService.findDetailsByDataViewCode(dataView.getCode());
        Set<DataViewAuthVerticalEntity> authVerticals = this.dataViewAuthVerticalService.findDetailsByDataViewCode(dataView.getCode());
        DataViewAuthInterceptorEntity interceptor = this.dataViewAuthInterceptorService.findByDataView(dataView.getCode());
        Map<String, Object> sysPresets = this.sqlPresetValueAnalysis.systemPresetValues(dataView.getSystemFilters(), principal);
        Map<Integer, Object> verticalPresets = this.sqlPresetValueAnalysis.authVerticalPresetValues(authVerticals, principal);
        Map<String, Object> authHorizontalPresets = this.sqlPresetValueAnalysis.authHorizontalPresetValues(authHorizontals, principal);
        Set<DataViewFieldEntity> allFileds = dataView.getFields();
        if (DataSourceTypeEnum.MYSQL.getDatabase().equalsIgnoreCase(dataSourceType)) {
            sqlAnalysis = new MysqlAnalysis(dataView, dataView.getFilters(), dataView.getSystemFilters(), authHorizontals, authVerticals, invokeParams, pageable, allFileds, interceptor);
        } else if (DataSourceTypeEnum.ORACLE.getDatabase().equalsIgnoreCase(dataSourceType)) {
            sqlAnalysis = new OracleSqlAnalysis(dataView, dataView.getFilters(), dataView.getSystemFilters(), authHorizontals, authVerticals, invokeParams, pageable, allFileds, interceptor);
        } else {
            throw new UnsupportedOperationException(String.format("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90:%s", dataSourceType));
        }
        sqlAnalysis.setPresets(sysPresets, authHorizontalPresets, verticalPresets);
        return sqlAnalysis;
    }

    @Override
    public DataViewEntity executeResource(String dataSourceCode, DataViewEntity dataView) {
        this.checkSQL(dataView);
        return this.dataViewEntityRepository.executeResource(dataSourceCode, dataView);
    }

    @Override
    public DataViewEntity executeResource(DataViewEntity dataView) {
        this.checkSQL(dataView);
        DataViewEntity dataViewEntity = this.dataViewEntityRepository.executeResource(dataView);
        if (dataViewEntity.getFilters() == null) {
            dataViewEntity.setFilters(Sets.newHashSet());
        }
        return dataViewEntity;
    }

    private void checkSQL(DataViewEntity dataView) {
        String[] notAllowed = new String[]{"delete", "insert", "drop", "create", "alter", ";"};
        List<String> notAllowedList = Arrays.asList(notAllowed);
        Validate.notNull((Object)dataView, (String)"\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataView.getSourceSql(), (String)ERROR_MESS_SQL, (Object[])new Object[0]);
        String sql = dataView.getSourceSql();
        List<String> words = Arrays.asList(StringUtils.split((String)sql, (String)" "));
        if (!CollectionUtils.isEmpty(words)) {
            Validate.isTrue((boolean)"select".equals(StringUtils.lowerCase((String)words.get(0))), (String)"\u67e5\u8be2\u8bed\u53e5\u53ea\u5141\u8bb8\u4ee5'select'\u8d77\u59cb\u7684\u67e5\u8be2\u8bed\u53e5", (Object[])new Object[0]);
            words.forEach(o -> Validate.isTrue((!notAllowedList.contains(o) ? 1 : 0) != 0, (String)String.format("\u8bed\u53e5\u4e2d\u4e0d\u80fd\u542b\u6709\u5b57\u7b26%s", o), (Object[])new Object[0]));
            Validate.isTrue((!words.get(words.size() - 1).contains(";") ? 1 : 0) != 0, (String)"\u6700\u540e\u4e00\u4e2a\u8bcd\u540e\u4e0d\u80fd\u63a5\u5206\u53f7", (Object[])new Object[0]);
        }
    }

    private DataViewEntity validateThirdInfo(String dataSourceCode, String dataViewCode) {
        DataSourceEntity dataSourceEntity = this.dataSourceService.findDetailsByCode(dataSourceCode);
        Validate.notNull((Object)dataSourceEntity, (String)"\u6839\u636e\u4f20\u5165\u7684code\u503c\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((dataSourceEntity.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u6570\u636e\u6e90\u72b6\u6001\u662f\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewCode, (String)"\u4f20\u5165\u7684\u89c6\u56fe\u4fe1\u606fcode\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        DataViewEntity dataViewEntity = this.dataViewEntityRepository.findDetailsByCode(dataViewCode);
        Validate.notNull((Object)dataViewEntity, (String)"\u6839\u636e\u89c6\u56fecode\u4fe1\u606f\u672a\u80fd\u83b7\u53d6\u5230\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u89c6\u56fe\u72b6\u6001\u662f\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewEntity.getDataSource(), (String)"\u5f53\u524d\u6570\u636e\u89c6\u56fe\u4fe1\u606f\u6709\u8bef\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)dataSourceCode, (CharSequence)dataViewEntity.getDataSource().getCode()), (String)"\u4f20\u5165\u7684\u6570\u636e\u6e90code\u503c%s\u4e0e\u5f53\u524d\u6570\u636e\u89c6\u56fe\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return dataViewEntity;
    }

    private DataViewEntity validateMainInfo(String dataViewCode) {
        Validate.notBlank((CharSequence)dataViewCode, (String)"\u4f20\u5165\u7684\u89c6\u56fe\u4fe1\u606fcode\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        DataViewEntity dataViewEntity = this.dataViewEntityRepository.findByCode(dataViewCode);
        Validate.notNull((Object)dataViewEntity, (String)"\u6839\u636e\u89c6\u56fecode\u4fe1\u606f\u672a\u80fd\u83b7\u53d6\u5230\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u89c6\u56fe\u72b6\u6001\u662f\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getDataSource() == null ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u6570\u636e\u89c6\u56fe\u4e0d\u662f\u4e3b\u6570\u636e\u6e90\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return dataViewEntity;
    }

    @Override
    public JSONArray findByDataSourceCode(String dataSourceCode) {
        List<Object[]> jsonList = StringUtils.isBlank((CharSequence)dataSourceCode) ? this.dataViewEntityRepository.findByDataSourceCode() : this.dataViewEntityRepository.findByDataSourceCode(dataSourceCode);
        JSONArray jsonViewArr = new JSONArray();
        if (!CollectionUtils.isEmpty(jsonList)) {
            jsonList.forEach(e -> {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)e[0].toString());
                jsonObject.put("code", (Object)e[1].toString());
                jsonObject.put("title", (Object)e[2].toString());
                jsonObject.put("datasourcegroup", (Object)e[3].toString());
                jsonObject.put("outCount", (Object)(e[4] == null ? 0 : ((BigInteger)e[4]).intValue()));
                jsonObject.put("displayCount", (Object)(e[5] == null ? 0 : ((BigInteger)e[5]).intValue()));
                jsonViewArr.add((Object)jsonObject);
            });
        }
        JSONArray groupArr = new JSONArray();
        List<DataViewGroupEntity> groupList = this.dataViewGroupService.findByDataSourceCode(dataSourceCode);
        Validate.notNull(groupList, (String)"\u6839\u636e\u6570\u636e\u6e90code\u503c\u672a\u80fd\u83b7\u53d6\u5230\u89c6\u56fe\u5206\u7ec4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        groupList.forEach(e -> {
            JSONObject jsonObject = new JSONObject();
            JSONArray viewArr = new JSONArray();
            jsonObject.put("id", (Object)e.getId());
            jsonObject.put("title", (Object)e.getGroupName());
            jsonObject.put("targetTable", (Object)e.getTargetTable());
            if (!jsonViewArr.isEmpty()) {
                jsonViewArr.stream().filter(view -> StringUtils.equals((CharSequence)e.getId(), (CharSequence)((JSONObject)view).getString("datasourcegroup"))).forEach(arg_0 -> ((JSONArray)viewArr).add(arg_0));
            }
            jsonObject.put("children", (Object)viewArr);
            groupArr.add((Object)jsonObject);
        });
        return groupArr;
    }

    @Override
    public JSONArray findByViewAndDataKey(DataViewEntity dataViewEntity, InvokeParams invokeParams, Principal principal, String primaryKey, JSONArray primaryValue) {
        Validate.notBlank((CharSequence)primaryKey, (String)"\u4f20\u5165\u7684\u89c6\u56feprimaryKey\u552f\u4e00\u6027\u952e\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        if (primaryValue == null) {
            return null;
        }
        Validate.notNull((Object)dataViewEntity, (String)"\u4f20\u5165\u7684\u89c6\u56fe\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getCode(), (String)"\u6839\u636e\u4f20\u5165\u7684\u89c6\u56fe\u53c2\u6570\uff0c\u672a\u80fd\u83b7\u53d6\u89c6\u56feCODE\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        DataViewEntity currrentDataView = this.dataViewEntityRepository.findByCode(dataViewEntity.getCode());
        Validate.notNull((Object)currrentDataView, (String)"\u6839\u636e\u89c6\u56feCODE\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String sql = currrentDataView.getSourceSql();
        Validate.notBlank((CharSequence)sql, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u89c6\u56feSQL\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Map<String, Object> sysPresets = null;
        Set<DataViewSystemEntity> systemEntities = currrentDataView.getSystemFilters();
        if (CollectionUtils.isEmpty(systemEntities)) {
            sysPresets = this.sqlPresetValueAnalysis.systemPresetValues(systemEntities, principal);
        }
        return this.dataViewEntityRepository.executeSQLEcho(currrentDataView, invokeParams, sysPresets, primaryKey, primaryValue);
    }

    @Override
    public List<DataViewEntity> findByDataSource(String dataSourceId) {
        if (StringUtils.isBlank((CharSequence)dataSourceId)) {
            return Collections.emptyList();
        }
        return this.dataViewEntityRepository.findByDataSource(dataSourceId);
    }

    @Override
    public List<DataViewEntity> findByDataViewGroup(String dataViewGroupId) {
        if (StringUtils.isBlank((CharSequence)dataViewGroupId)) {
            return Collections.emptyList();
        }
        return this.dataViewEntityRepository.findByDataViewGroup(dataViewGroupId);
    }

    @Override
    public DataViewEntity findByFields(String fieldsId) {
        if (StringUtils.isBlank((CharSequence)fieldsId)) {
            return null;
        }
        return this.dataViewEntityRepository.findByFields(fieldsId);
    }

    @Override
    public DataViewEntity findByFilters(String filtersId) {
        if (StringUtils.isBlank((CharSequence)filtersId)) {
            return null;
        }
        return this.dataViewEntityRepository.findByFilters(filtersId);
    }

    @Override
    public DataViewEntity findBySystemFilters(String systemFiltersId) {
        if (StringUtils.isBlank((CharSequence)systemFiltersId)) {
            return null;
        }
        return this.dataViewEntityRepository.findBySystemFilters(systemFiltersId);
    }

    @Override
    public DataViewEntity findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.dataViewEntityRepository.findDetailsByCode(code);
    }

    @Override
    public DataViewEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.dataViewEntityRepository.findByCode(code);
    }

    @Override
    public Set<DataViewEntity> findDetailsByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return Sets.newHashSet();
        }
        return this.dataViewEntityRepository.findDetailsByIds(ids);
    }

    @Override
    public DataViewEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.dataViewEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public int countByIds(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return 0;
        }
        return this.dataViewEntityRepository.countByIds(ids);
    }
}

