/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.image;

import com.bizunited.platform.core.service.image.ImageHandler;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ZoomImageHandler
extends ImageHandler {
    private float ratio = -1.0f;
    private int destWith;
    private int destHeight;

    ZoomImageHandler(ImageHandler nextHandler, float ratio) {
        super(nextHandler);
        this.ratio = ratio;
    }

    ZoomImageHandler(ImageHandler nextHandler, int destWith, int destHeight) {
        super(nextHandler);
        this.destWith = destWith;
        this.destHeight = destHeight;
    }

    @Override
    public BufferedImage dispose(BufferedImage srcImage) {
        float localRatio;
        int localDestHeight;
        int localDestWith;
        int sourceWith = srcImage.getWidth();
        int sourceHeight = srcImage.getHeight();
        if (this.ratio != -1.0f) {
            localDestWith = Math.round((float)sourceWith * this.ratio);
            localDestHeight = Math.round((float)sourceHeight * this.ratio);
        } else if (sourceWith <= this.destWith || sourceHeight <= this.destHeight) {
            localDestHeight = sourceHeight;
            localDestWith = sourceWith;
        } else if (sourceWith > sourceHeight) {
            localRatio = new BigDecimal(this.destHeight).divide(new BigDecimal(sourceHeight), 2, RoundingMode.HALF_UP).floatValue();
            localDestHeight = (int)((float)sourceHeight * localRatio);
            localDestWith = (int)((float)sourceWith * localRatio);
        } else {
            localRatio = new BigDecimal(this.destWith).divide(new BigDecimal(sourceWith), 2, RoundingMode.HALF_UP).floatValue();
            localDestHeight = (int)((float)sourceHeight * localRatio);
            localDestWith = (int)((float)sourceWith * localRatio);
        }
        Image destImage = srcImage.getScaledInstance(localDestWith, localDestHeight, 2);
        BufferedImage outputImage = new BufferedImage(localDestWith, localDestHeight, 1);
        Graphics graphics = outputImage.getGraphics();
        graphics.drawImage(destImage, 0, 0, null);
        graphics.dispose();
        BufferedImage nextResults = this.doNextHandler(outputImage);
        if (nextResults == null) {
            return outputImage;
        }
        return nextResults;
    }
}

