/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.core.entity.DictCategoryEntity;
import com.bizunited.platform.core.entity.DictEntity;
import com.bizunited.platform.core.entity.DictItemEntity;
import com.bizunited.platform.core.repository.DictItemRepository;
import com.bizunited.platform.core.repository.DictRepository;
import com.bizunited.platform.core.service.DictCategoryService;
import com.bizunited.platform.core.service.DictItemService;
import com.bizunited.platform.core.service.DictService;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="dictServiceImpl")
public class DictServiceImpl
implements DictService {
    private static final String ERROR_CODE_MESS = "\u67e5\u8be2\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String ERROR_MESS = "\u672a\u627e\u5230\u8be5\u7f16\u7801\u5339\u914d\u5b57\u5178\uff01";
    @Autowired
    private DictRepository dictRepository;
    @Autowired
    private DictItemRepository dictItemRepository;
    @Autowired
    private DictCategoryService dictCategoryService;
    @Autowired
    private DictItemService dictItemService;

    @Override
    public List<DictEntity> findAll() {
        return this.dictRepository.findAll();
    }

    @Override
    public List<DictEntity> findByStatus(Boolean dictStatus) {
        return this.dictRepository.findByDictStatus(dictStatus);
    }

    @Override
    public Page<DictEntity> findByConditions(String dictCode, String dictTitle, String dictType, Boolean dictStatus, Pageable pageable) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)dictCode)) {
            conditions.put("dictCode", dictCode);
        }
        if (StringUtils.isNotBlank((CharSequence)dictTitle)) {
            conditions.put("dictTitle", dictTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)dictType)) {
            conditions.put("dictType", dictType);
        }
        if (dictStatus != null) {
            conditions.put("dictStatus", dictStatus);
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        return this.dictRepository.queryPage(pageable, conditions);
    }

    @Override
    public Set<DictEntity> findDetailsByIds(String[] dictIds) {
        if (dictIds == null || dictIds.length == 0) {
            return Sets.newHashSet();
        }
        return this.dictRepository.findDetailsByIds(dictIds);
    }

    @Override
    public int countByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return 0;
        }
        return this.dictRepository.countByIds(ids);
    }

    @Override
    @Transactional
    public DictEntity create(DictEntity dictEntity, String categoryId) {
        this.validEntity(dictEntity, categoryId);
        DictCategoryEntity categoryEntity = this.dictCategoryService.findById(categoryId);
        DictEntity existDict = this.dictRepository.findByDictCode(dictEntity.getDictCode());
        Validate.isTrue((null == existDict ? 1 : 0) != 0, (String)"\u8be5\u7f16\u7801\u5df2\u6709\u91cd\u590d\uff01", (Object[])new Object[0]);
        dictEntity.setItemNum(0);
        dictEntity.setDictStatus(true);
        dictEntity.setCategory(categoryEntity);
        dictEntity.setCreateTime(new Date());
        dictEntity.setModifyTime(new Date());
        DictEntity dict = (DictEntity)this.dictRepository.saveAndFlush(dictEntity);
        Set<DictItemEntity> dictItems = dictEntity.getDictItemEntities();
        this.dictItemService.save(dictEntity.getDictCode(), dictItems);
        return dict;
    }

    @Override
    @Transactional
    public DictEntity update(DictEntity dictEntity, String categoryId) {
        this.validEntity(dictEntity, categoryId);
        DictCategoryEntity categoryEntity = this.dictCategoryService.findById(categoryId);
        Optional op = this.dictRepository.findById(dictEntity.getId());
        DictEntity existDict = op.orElse(null);
        Validate.notNull((Object)existDict, (String)"\u8be5\u5b57\u5178\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)existDict, (String)"\u672a\u627e\u5230\u6539\u4fee\u6539\u5b57\u5178", (Object[])new Object[0]);
        existDict.setDescription(dictEntity.getDescription());
        existDict.setDictType(dictEntity.getDictType());
        existDict.setDictTitle(dictEntity.getDictTitle());
        existDict.setCategory(categoryEntity);
        existDict.setModifyTime(new Date());
        Set<DictItemEntity> dictItems = dictEntity.getDictItemEntities();
        this.dictItemService.save(dictEntity.getDictCode(), dictItems);
        return (DictEntity)this.dictRepository.saveAndFlush(existDict);
    }

    @Override
    @Transactional
    public DictEntity upgrade(String newDictCode, String dictCode) {
        Validate.notBlank((CharSequence)dictCode, (String)ERROR_CODE_MESS, (Object[])new Object[0]);
        DictEntity dictEntity = this.dictRepository.findByDictCode(dictCode);
        Validate.notNull((Object)dictEntity, (String)ERROR_MESS, (Object[])new Object[0]);
        DictEntity newDict = new DictEntity();
        newDict.setDictCode(newDictCode);
        newDict.setDictTitle(dictEntity.getDictTitle());
        newDict.setItemNum(dictEntity.getItemNum());
        newDict.setDescription(dictEntity.getDescription());
        newDict.setDictType(dictEntity.getDictType());
        newDict.setDictStatus(false);
        newDict.setDictItemEntities(new HashSet<DictItemEntity>());
        newDict.setCategory(dictEntity.getCategory());
        newDict = (DictEntity)this.dictRepository.saveAndFlush(newDict);
        HashSet<DictItemEntity> newItems = new HashSet<DictItemEntity>();
        for (DictItemEntity item : dictEntity.getDictItemEntities()) {
            DictItemEntity newItem = new DictItemEntity();
            newItem.setDictSort(item.getDictSort());
            newItem.setDictKey(item.getDictKey());
            newItem.setDictValue(item.getDictValue());
            newItem.setDictEntity(newDict);
            newItems.add(newItem);
        }
        this.dictItemRepository.saveAll(newItems);
        return newDict;
    }

    @Override
    @Transactional
    public DictEntity onshelf(String dictCode) {
        Validate.notBlank((CharSequence)dictCode, (String)ERROR_CODE_MESS, (Object[])new Object[0]);
        DictEntity dictEntity = this.dictRepository.findByDictCode(dictCode);
        Validate.notNull((Object)dictEntity, (String)ERROR_MESS, (Object[])new Object[0]);
        dictEntity.setDictStatus(true);
        return (DictEntity)this.dictRepository.saveAndFlush(dictEntity);
    }

    @Override
    @Transactional
    public void delete(String dictCode) {
        Validate.notBlank((CharSequence)dictCode, (String)ERROR_CODE_MESS, (Object[])new Object[0]);
        DictEntity dictEntity = this.dictRepository.findByDictCode(dictCode);
        Validate.notNull((Object)dictEntity, (String)ERROR_MESS, (Object[])new Object[0]);
        Validate.isTrue((dictEntity.getDictStatus() == false ? 1 : 0) != 0, (String)"\u5df2\u4e0a\u67b6\u7684\u5b57\u5178\u65e0\u6cd5\u5220\u9664\uff01", (Object[])new Object[0]);
        Set<DictItemEntity> dictItemEntities = dictEntity.getDictItemEntities();
        this.dictItemRepository.deleteAll(dictItemEntities);
        this.dictRepository.delete(dictEntity);
    }

    @Override
    public DictEntity findByDictCode(String dictCode) {
        if (StringUtils.isBlank((CharSequence)dictCode)) {
            return null;
        }
        return this.dictRepository.findByDictCode(dictCode);
    }

    private void validEntity(DictEntity dictEntity, String categoryId) {
        Validate.notNull((Object)dictEntity, (String)"\u8f93\u5165\u5b57\u5178\u4e0d\u53ef\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictEntity.getDictCode(), (String)"dict code \u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictEntity.getDictTitle(), (String)"dict title \u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)categoryId, (String)"\u5b57\u5178\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DictCategoryEntity categoryEntity = this.dictCategoryService.findById(categoryId);
        Validate.notNull((Object)categoryEntity, (String)"\u672a\u67e5\u8be2\u5230\u5b57\u5178\u5206\u7ec4", (Object[])new Object[0]);
    }
}

