/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.common.utils.ChineseCharUtil;
import com.bizunited.platform.core.entity.RemoteServiceAddressEntity;
import com.bizunited.platform.core.repository.RemoteServiceAddressRepository;
import com.bizunited.platform.core.service.RemoteServiceAddressService;
import com.bizunited.platform.core.service.RemoteServiceService;
import com.google.common.collect.Sets;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service(value="RemoteServiceAddressServiceImpl")
public class RemoteServiceAddressServiceImpl
implements RemoteServiceAddressService {
    private static final String REQUEST_METHOD = "RequestMethod";
    private static final String INTERFACE = "Interface";
    private static final String HEAD = "Head";
    private static final String REQUEST_PARAMS = "RequestParams";
    private static final String REQUEST_BODY = "RequestBody";
    private static final String ADDRESS_E_ERROR = "\u5165\u53c2\u8fdc\u7a0b\u670d\u52a1\u5b9e\u4f53JSON\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ADDRESS_P_ERROR = "\u5165\u53c2\u8fdc\u7a0b\u670d\u52a1\u53c2\u6570JSON\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ADDRESS_C_ERROR = "\u53c2\u6570\u6267\u884c\u8f6c\u5316\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01";
    private static final String ADDRESS_R_ERROR = "\u4f20\u5165\u8fdc\u7aef\u8c03\u7528\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01";
    @Autowired
    private RemoteServiceAddressRepository remoteServiceAddressRepository;
    @Autowired
    private RemoteServiceService remoteServiceService;

    @Override
    public Page<RemoteServiceAddressEntity> findByConditions(String code, String alias, Pageable pageable) {
        Validate.notNull((Object)pageable, (String)"\u67e5\u8be2\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        HashMap<String, String> conditions = new HashMap<String, String>();
        if (!StringUtils.isBlank((CharSequence)code)) {
            conditions.put("code", code);
        }
        if (!StringUtils.isBlank((CharSequence)alias)) {
            conditions.put("alias", alias);
        }
        return this.remoteServiceAddressRepository.findByConditions(pageable, conditions);
    }

    @Override
    public void valid(String entityJson, String testJsonStr) {
        Validate.notBlank((CharSequence)entityJson, (String)ADDRESS_E_ERROR, (Object[])new Object[0]);
        this.validJson(entityJson, testJsonStr);
    }

    private RemoteServiceAddressEntity validJson(String entityJson, String jsonStr) {
        JSONObject testJson;
        RemoteServiceAddressEntity entity;
        Validate.notBlank((CharSequence)jsonStr, (String)ADDRESS_P_ERROR, (Object[])new Object[0]);
        try {
            entity = (RemoteServiceAddressEntity)JSON.parseObject((String)entityJson, RemoteServiceAddressEntity.class);
            testJson = JSON.parseObject((String)jsonStr);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(ADDRESS_C_ERROR, e);
        }
        this.validEntity(entity, true);
        this.validConnection(entity, testJson);
        return entity;
    }

    @Override
    @Transactional
    public RemoteServiceAddressEntity create(String entityJson, String testJsonStr) {
        Validate.notBlank((CharSequence)entityJson, (String)ADDRESS_E_ERROR, (Object[])new Object[0]);
        RemoteServiceAddressEntity entity = this.validJson(entityJson, testJsonStr);
        entity.setCreateDate(new Date());
        entity.setAddressStatus(2);
        return (RemoteServiceAddressEntity)this.remoteServiceAddressRepository.save(entity);
    }

    @Override
    @Transactional
    public RemoteServiceAddressEntity create(RemoteServiceAddressEntity remoteServiceAddressEntity) {
        this.validEntity(remoteServiceAddressEntity, true);
        return (RemoteServiceAddressEntity)this.remoteServiceAddressRepository.save(remoteServiceAddressEntity);
    }

    @Override
    @Transactional
    public RemoteServiceAddressEntity update(String entityJson, String testJsonStr) {
        JSONObject testJson;
        RemoteServiceAddressEntity entity;
        Validate.notBlank((CharSequence)entityJson, (String)ADDRESS_E_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)testJsonStr, (String)ADDRESS_P_ERROR, (Object[])new Object[0]);
        try {
            entity = (RemoteServiceAddressEntity)JSON.parseObject((String)entityJson, RemoteServiceAddressEntity.class);
            testJson = JSON.parseObject((String)testJsonStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ADDRESS_C_ERROR, e);
        }
        this.validEntity(entity, false);
        this.validConnection(entity, testJson);
        Optional op = this.remoteServiceAddressRepository.findById(entity.getId());
        RemoteServiceAddressEntity existEntity = op.orElse(null);
        Validate.notNull((Object)existEntity, (String)"\u672a\u80fd\u67e5\u8be2\u5230\u8fdc\u7a0b\u670d\u52a1\u4fe1\u606f!!", (Object[])new Object[0]);
        existEntity.setProtocolType(entity.getProtocolType());
        existEntity.setConnectionType(entity.getConnectionType());
        existEntity.setAddress(entity.getAddress());
        existEntity.setAddressDesc(entity.getAddressDesc());
        return (RemoteServiceAddressEntity)this.remoteServiceAddressRepository.save(existEntity);
    }

    @Override
    @Transactional
    public RemoteServiceAddressEntity enable(String addressId) {
        Validate.notBlank((CharSequence)addressId, (String)"\u4f20\u5165\u8fdc\u7aef\u8c03\u7528\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional op = this.remoteServiceAddressRepository.findById(addressId);
        RemoteServiceAddressEntity existEntity = op.orElse(null);
        Validate.notNull((Object)existEntity, (String)ADDRESS_R_ERROR, (Object[])new Object[0]);
        Validate.isTrue((existEntity.getAddressStatus() == 2 ? 1 : 0) != 0, (String)"\u542f\u7528\u7684\u8fdc\u7aef\u8c03\u7528\u6e90\u72b6\u6001\u5fc5\u987b\u4e3a\u672a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        existEntity.setAddressStatus(1);
        return (RemoteServiceAddressEntity)this.remoteServiceAddressRepository.save(existEntity);
    }

    @Override
    @Transactional
    public RemoteServiceAddressEntity disable(String addressId) {
        Validate.notBlank((CharSequence)addressId, (String)"\u4f20\u5165\u8fdc\u7aef\u8c03\u7528\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional op = this.remoteServiceAddressRepository.findById(addressId);
        RemoteServiceAddressEntity existEntity = op.orElse(null);
        Validate.notNull((Object)existEntity, (String)ADDRESS_R_ERROR, (Object[])new Object[0]);
        Validate.isTrue((existEntity.getAddressStatus() == 1 ? 1 : 0) != 0, (String)"\u7981\u7528\u7684\u8fdc\u7aef\u8c03\u7528\u6e90\u72b6\u6001\u5fc5\u987b\u4e3a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        existEntity.setAddressStatus(0);
        this.remoteServiceService.updateRemoteService(addressId, 0);
        return (RemoteServiceAddressEntity)this.remoteServiceAddressRepository.save(existEntity);
    }

    @Override
    public RemoteServiceAddressEntity findByCode(String code) {
        return this.remoteServiceAddressRepository.findByCode(code);
    }

    private void validEntity(RemoteServiceAddressEntity entity, Boolean isCreate) {
        Validate.notNull((Object)entity, (String)"\u4f20\u5165\u8fdc\u7aef\u5730\u5740\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getCode(), (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getAlias(), (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((!ChineseCharUtil.hasChinese(entity.getAlias()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u8fdc\u7aef\u6570\u636e\u6e90\u522b\u540d\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff01", (Object[])new Object[0]);
        Validate.isTrue((!ChineseCharUtil.hasChinese(entity.getCode()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u8fdc\u7aef\u6570\u636e\u6e90\u7f16\u7801\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getProtocolType(), (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u534f\u8bae\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getConnectionType(), (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u8fde\u63a5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getAddress(), (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((!entity.getAddress().endsWith("/") ? 1 : 0) != 0, (String)"\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4ee5 / \u53f7\u7ed3\u5c3e\uff0c\u8bf7\u79fb\u9664\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getAddressStatus(), (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        if (Boolean.TRUE.equals(isCreate)) {
            RemoteServiceAddressEntity existCodes = this.remoteServiceAddressRepository.findByCode(entity.getCode());
            RemoteServiceAddressEntity existAliases = this.remoteServiceAddressRepository.findByAlias(entity.getAlias());
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u65b0\u589e\u7684\u8fdc\u7aef\u8c03\u7528\u6e90ID\u5fc5\u987b\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((null == existAliases ? 1 : 0) != 0, (String)"\u65b0\u589e\u8fdc\u7aef\u6570\u636e\u6e90\u522b\u540d\u91cd\u590d\uff0c\u8bf7\u66f4\u6362\u522b\u540d\uff01", (Object[])new Object[0]);
            Validate.isTrue((null == existCodes ? 1 : 0) != 0, (String)"\u65b0\u589e\u8fdc\u7aef\u6570\u636e\u6e90\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u66f4\u6362\u7f16\u7801\uff01", (Object[])new Object[0]);
        } else {
            Validate.notBlank((CharSequence)entity.getId(), (String)"\u4fee\u6539\u7684\u8fdc\u7aef\u8c03\u7528\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Optional op = this.remoteServiceAddressRepository.findById(entity.getId());
            RemoteServiceAddressEntity existEntity = op.orElse(null);
            Validate.notNull((Object)existEntity, (String)ADDRESS_R_ERROR, (Object[])new Object[0]);
            Validate.isTrue((existEntity.getAddressStatus() == 2 ? 1 : 0) != 0, (String)"\u53ea\u80fd\u5bf9\u672a\u542f\u7528\u72b6\u6001\u7684\u8fdc\u7a0b\u8c03\u7528\u6e90\u505a\u4fee\u6539\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)existEntity.getCode().equals(entity.getCode()), (String)"\u4fee\u6539\u65f6\u4e0d\u80fd\u4fee\u6539\u8fdc\u7aef\u8c03\u7528\u6e90\u7f16\u53f7\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)existEntity.getAlias().equals(entity.getAlias()), (String)"\u4fee\u6539\u65f6\u4e0d\u80fd\u4fee\u6539\u8fdc\u7aef\u8c03\u7528\u6e90\u522b\u540d\uff01", (Object[])new Object[0]);
        }
    }

    private void validConnection(RemoteServiceAddressEntity entity, JSONObject testJson) {
        Validate.notNull((Object)testJson, (String)"\u6d4b\u8bd5\u63a5\u53e3\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)testJson.getString(REQUEST_METHOD), (String)"\u6d4b\u8bd5\u63a5\u53e3\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)testJson.getString(INTERFACE))) {
            Validate.isTrue((boolean)testJson.getString(INTERFACE).startsWith("/"), (String)"\u63a5\u53e3\u5730\u5740\u82e5\u4e0d\u4e3a\u7a7a\uff0c\u5fc5\u987b\u4ee5/\u53f7\u5f00\u59cb", (Object[])new Object[0]);
        }
        Client.Default defaultClient = new Client.Default(null, null);
        String method = testJson.getString(REQUEST_METHOD);
        String url = StringUtils.isEmpty((CharSequence)testJson.getString(INTERFACE)) ? entity.getAddress() : entity.getAddress() + testJson.getString(INTERFACE);
        HashMap headers = new HashMap();
        if (null != testJson.getJSONObject(HEAD)) {
            JSONObject heads = testJson.getJSONObject(HEAD);
            heads.keySet().forEach(o -> {
                Collection cfr_ignored_0 = headers.put(o, Sets.newHashSet((Object[])new String[]{heads.getString(o)}));
            });
        }
        if (null != testJson.getJSONObject(REQUEST_PARAMS)) {
            JSONObject requestParams = testJson.getJSONObject(REQUEST_PARAMS);
            HashSet<String> paramSet = new HashSet<String>();
            for (String key : requestParams.keySet()) {
                paramSet.add(String.format("%s=%s", key, requestParams.getString(key)));
            }
            String paraUrl = String.format("?%s", StringUtils.join(paramSet, (String)"&"));
            url = url.concat(paraUrl);
        }
        byte[] body = new byte[]{};
        JSONObject bodyJson = testJson.getJSONObject(REQUEST_BODY);
        if (null != bodyJson) {
            String bodyStr = bodyJson.toJSONString();
            body = bodyStr.getBytes(StandardCharsets.UTF_8);
        }
        Request.Options options = new Request.Options(18000, 18000);
        Request.HttpMethod httpMethod = Request.HttpMethod.valueOf((String)method);
        Request request = Request.create((Request.HttpMethod)httpMethod, (String)url, headers, (byte[])body, (Charset)Charset.defaultCharset());
        try {
            Response response = defaultClient.execute(request, options);
            Validate.isTrue((response.status() == HttpStatus.OK.value() ? 1 : 0) != 0, (String)String.format("\u8fde\u63a5\u5931\u8d25\uff0c\u8fd4\u56de\u7f16\u7801\uff1a%s,\u539f\u56e0\uff1a%s", response.status(), response.reason()), (Object[])new Object[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

