/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.security;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.common.enums.NormalStatusEnum;
import com.bizunited.platform.core.entity.CompetenceEntity;
import com.bizunited.platform.core.entity.RoleEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.repository.CompetenceRepository;
import com.bizunited.platform.core.repository.RoleRepository;
import com.bizunited.platform.core.repository.UserRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.rbac.server.service.CompetenceService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.CompetenceVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class CompetenceServiceImpl
implements CompetenceService {
    @Autowired
    private CompetenceRepository competenceRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleService roleService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Value(value="${rbac.ignoreMethodCheckRoles}")
    private String[] ignoreMethodCheckRoles;
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    private static final String MESS_RESOURCE = "resource";

    @Transactional
    public CompetenceVo create(CompetenceVo comp) {
        this.validCompetence(comp);
        comp.setId(null);
        comp.setMethods(comp.getMethods().toUpperCase());
        comp.setTstatus(NormalStatusEnum.ENABLE.getStatus());
        comp.setCreateDate(new Date());
        comp.setModifyDate(new Date());
        if (comp.getSortIndex() == null) {
            comp.setSortIndex(Integer.valueOf(100));
        }
        if (comp.getViewItem().equals(NormalStatusEnum.ENABLE.getStatus())) {
            long count = this.competenceRepository.countByCommentAndViewItem(comp.getComment(), comp.getViewItem());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u529f\u80fd\u5907\u6ce8\u540d\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u529f\u80fd\u540d!!", (Object[])new Object[0]);
        }
        CompetenceEntity competenceEntity = this.nebulaToolkitService.copyObjectByWhiteList(comp, CompetenceEntity.class, HashSet.class, ArrayList.class, "parent");
        this.competenceRepository.save(competenceEntity);
        comp.setId(competenceEntity.getId());
        return comp;
    }

    @Transactional
    public List<CompetenceVo> createAll(List<CompetenceVo> comps) {
        Validate.isTrue((comps != null && !comps.isEmpty() ? 1 : 0) != 0, (String)"\u6279\u91cf\u6dfb\u52a0\u529f\u80fd\u65f6\uff0c\u5fc5\u987b\u8fdb\u884c\u6279\u91cf\u4f20\u53c2", (Object[])new Object[0]);
        for (CompetenceVo competenceVo : comps) {
            this.create(competenceVo);
        }
        return comps;
    }

    @Transactional
    public CompetenceVo update(CompetenceVo comp) {
        Validate.notNull((Object)comp, (String)"\u5fc5\u987b\u4f20\u5165\u9700\u8981\u4fee\u6539\u7684\u529f\u80fd\u4fe1\u606f!!", (Object[])new Object[0]);
        String compId = comp.getId();
        Validate.notBlank((CharSequence)compId, (String)"\u9519\u8bef\u7684\u529f\u80fd\u4fe1\u606f\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validCompetence(comp);
        Optional op = this.competenceRepository.findById(compId);
        Validate.isTrue((boolean)op.isPresent(), (String)"id\u4e3a%s\u7684\u529f\u80fd\u5bf9\u8c61\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{compId});
        CompetenceEntity currentComp = (CompetenceEntity)op.get();
        if (comp.getViewItem().equals(NormalStatusEnum.ENABLE.getStatus())) {
            long count = this.competenceRepository.countByCommentAndViewItemExceptId(currentComp.getId(), comp.getComment(), comp.getViewItem());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u529f\u80fd\u5907\u6ce8\u540d\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u529f\u80fd\u540d!!", (Object[])new Object[0]);
        }
        currentComp.setResource(comp.getResource());
        currentComp.setMethods(comp.getMethods());
        currentComp.setComment(comp.getComment());
        if (comp.getSortIndex() == null) {
            currentComp.setSortIndex(100);
        } else {
            currentComp.setSortIndex(comp.getSortIndex());
        }
        currentComp.setIcon(comp.getIcon());
        currentComp.setModifyDate(new Date());
        currentComp.setMethods(currentComp.getMethods().toUpperCase());
        this.competenceRepository.saveAndFlush(currentComp);
        return comp;
    }

    private void validCompetence(CompetenceVo comp) {
        Validate.notNull((Object)comp, (String)"\u529f\u80fd\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String resource = comp.getResource();
        Validate.notNull((Object)resource, (String)"\u529f\u80fdURL\u4e32\u4e0d\u80fd\u4e3a\u7a7a! \u5982\u679c\u6ca1\u6709\u529f\u80fd\u7684url\uff0c\u8bf7\u4f20\u9012\u7a7a\u5b57\u7b26\u4e32!", (Object[])new Object[0]);
        String method = comp.getMethods();
        Validate.notBlank((CharSequence)method, (String)"\u65b9\u6cd5\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String comment = comp.getComment();
        Validate.notBlank((CharSequence)comment, (String)"\u529f\u80fd\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)comp.getViewItem(), (String)"\u529f\u80fd\u9879\u662f\u5426\u663e\u793a\u5728\u83dc\u5355\u6811\u4e2d\u5fc5\u4f20", (Object[])new Object[0]);
    }

    @Transactional
    public CompetenceVo updateStatus(String id, Boolean flag) {
        if (StringUtils.isEmpty((CharSequence)id) || flag == null) {
            throw new IllegalArgumentException("updateStatus\u64cd\u4f5c\u65f6\u53c2\u6570\u9519\u8bef\uff01");
        }
        CompetenceEntity competence = this.recursiveUpdateStatus(id, flag);
        return this.nebulaToolkitService.copyObjectByWhiteList(competence, CompetenceVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private CompetenceEntity recursiveUpdateStatus(String parentCompetenceId, Boolean flag) {
        Optional op = this.competenceRepository.findById(parentCompetenceId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        CompetenceEntity competenceEntity = (CompetenceEntity)op.get();
        if (Boolean.TRUE.equals(flag)) {
            competenceEntity.setTstatus(1);
        } else {
            competenceEntity.setTstatus(0);
        }
        competenceEntity.setModifyDate(new Date());
        this.competenceRepository.save(competenceEntity);
        List<CompetenceEntity> childList = this.competenceRepository.findByParentId(parentCompetenceId);
        for (int index = 0; childList != null && index < childList.size(); ++index) {
            this.recursiveUpdateStatus(childList.get(index).getId(), flag);
        }
        return competenceEntity;
    }

    @Transactional
    public void bindCompetence(String roleId, String[] competenceIds) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u7f16\u53f7!!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((competenceIds != null && competenceIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u529f\u80fd\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String competenceId : competenceIds) {
            Optional opCompetence = this.competenceRepository.findById(competenceId);
            Validate.isTrue((boolean)opCompetence.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceId});
            int count = this.competenceRepository.countByRoleIdAndCompetenceId(roleId, competenceId);
            if (count != 0) continue;
            this.competenceRepository.bindCompetence(roleId, competenceId);
        }
    }

    @Transactional
    public void unbindCompetence(String roleId, String[] competenceIds) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u7f16\u53f7!!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((competenceIds != null && competenceIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u529f\u80fd\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String competenceId : competenceIds) {
            Optional optional = this.competenceRepository.findById(competenceId);
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceId});
            this.competenceRepository.unbindCompetence(roleId, competenceId);
        }
    }

    @Transactional
    public void deleteById(String competenceId) {
        Validate.notBlank((CharSequence)competenceId, (String)"\u5220\u9664\u529f\u80fd\u65f6\uff0c\u6307\u5b9a\u7684\u529f\u80fd\u7f16\u53f7\u5fc5\u987b\u4f20\u9012!!", (Object[])new Object[0]);
        Optional op = this.competenceRepository.findById(competenceId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u529f\u80fd\u7f16\u53f7\u7684\u529f\u80fd\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570!!", (Object[])new Object[0]);
        CompetenceEntity currentCompetence = (CompetenceEntity)op.get();
        Set<RoleEntity> roles = currentCompetence.getRoles();
        Validate.isTrue((roles == null || roles.isEmpty() ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u529f\u80fd\u5df2\u7ecf\u7ed1\u5b9a\u89d2\u8272\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664!!", (Object[])new Object[0]);
        List<CompetenceEntity> childs = this.competenceRepository.findByParentId(competenceId);
        Validate.isTrue((childs == null || childs.isEmpty() ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u529f\u80fd\u5b58\u5728\u5b50\u7ea7\u529f\u80fd\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664!!", (Object[])new Object[0]);
        this.competenceRepository.delete(currentCompetence);
    }

    public JSONArray findByViewItem(Boolean viewItem) {
        if (viewItem == null) {
            return null;
        }
        List<CompetenceEntity> dbResults = null;
        dbResults = Boolean.TRUE.equals(viewItem) ? this.competenceRepository.findByViewItem(1) : this.competenceRepository.findByViewItem(0);
        if (dbResults == null || dbResults.isEmpty()) {
            return null;
        }
        return this.buildParent(dbResults);
    }

    public JSONArray findByViewItemAndStatus(Boolean viewItem, Integer tstatus) {
        if (viewItem == null || tstatus == null) {
            return null;
        }
        List<CompetenceEntity> dbResults = null;
        dbResults = Boolean.TRUE.equals(viewItem) ? this.competenceRepository.findByViewItemAndStatus(1, tstatus) : this.competenceRepository.findByViewItemAndStatus(0, tstatus);
        if (dbResults == null || dbResults.isEmpty()) {
            return null;
        }
        return this.buildParent(dbResults);
    }

    private JSONArray buildParent(List<CompetenceEntity> dbResults) {
        JSONArray jsonResults = new JSONArray();
        for (CompetenceEntity competenceItem : dbResults) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("comment", (Object)competenceItem.getComment());
            jsonObject.put(MESS_RESOURCE, (Object)competenceItem.getResource());
            jsonObject.put("createDate", (Object)competenceItem.getCreateDate());
            jsonObject.put("id", (Object)competenceItem.getId());
            jsonObject.put("methods", (Object)competenceItem.getMethods());
            jsonObject.put("modifyDate", (Object)competenceItem.getModifyDate());
            jsonObject.put("sortIndex", (Object)competenceItem.getSortIndex());
            jsonObject.put("tstatus", (Object)competenceItem.getTstatus());
            jsonObject.put("viewItem", (Object)competenceItem.getViewItem());
            jsonObject.put("extractUri", (Object)competenceItem.getExtractUri());
            jsonObject.put("icon", (Object)competenceItem.getIcon());
            jsonObject.put("tag", (Object)competenceItem.getTag());
            CompetenceEntity parent = competenceItem.getParent();
            if (parent != null) {
                JSONObject parentObject = new JSONObject();
                parentObject.put("id", (Object)parent.getId());
                jsonObject.put("parent", (Object)parentObject);
            } else {
                jsonObject.put("parent", null);
            }
            jsonResults.add((Object)jsonObject);
        }
        return jsonResults;
    }

    public JSONArray findByViewItemAndRoleNamesAndStatus(Boolean viewItem, String[] roleNames, Integer status) {
        Validate.isTrue((roleNames != null && roleNames.length > 0 ? 1 : 0) != 0, (String)"\u8981\u8fdb\u884c\u5224\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Sets.SetView intersections = Sets.intersection((Set)Sets.newHashSet((Object[])this.ignoreMethodCheckRoles), (Set)Sets.newHashSet((Object[])roleNames));
        List<CompetenceEntity> competences = null;
        if (!CollectionUtils.isEmpty((Collection)intersections)) {
            competences = status != null ? this.competenceRepository.findByViewItemAndStatus(Boolean.TRUE.equals(viewItem) ? 1 : 0, status) : this.competenceRepository.findByViewItem(Boolean.TRUE.equals(viewItem) ? 1 : 0);
            return this.buildParent(competences);
        }
        competences = status != null ? this.competenceRepository.findByViewItemAndRoleNamesAndStatus(Boolean.TRUE.equals(viewItem) ? 1 : 0, roleNames, status) : this.competenceRepository.findByViewItemAndRoleNames(Boolean.TRUE.equals(viewItem) ? 1 : 0, roleNames);
        if (CollectionUtils.isEmpty(competences)) {
            return new JSONArray();
        }
        return this.buildParent(competences);
    }

    public List<CompetenceVo> findByResource(String resource, Integer tstatus) {
        if (StringUtils.isBlank((CharSequence)resource)) {
            return Lists.newArrayList();
        }
        List<CompetenceEntity> currentCompetences = null;
        currentCompetences = tstatus != null ? this.competenceRepository.findByResourceAndTstatus(resource, tstatus) : this.competenceRepository.findByResource(resource);
        Collection<CompetenceVo> competenceVos = this.nebulaToolkitService.copyCollectionByWhiteList(currentCompetences, CompetenceEntity.class, CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newLinkedList(competenceVos);
    }

    public JSONArray findByUrlResource(String[] resources, Principal userPrincipal) {
        UserEntity currentUser = this.userRepository.findByAccount(userPrincipal.getName());
        JSONArray allCompetences = new JSONArray();
        Validate.isTrue((resources != null && resources.length > 0 ? 1 : 0) != 0, (String)"\u81f3\u5c11\u9700\u8981\u6307\u5b9a\u4e00\u4e2aresources\u53c2\u6570\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)currentUser, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        List roles = this.roleService.findAllByUserId(currentUser.getId(), Integer.valueOf(0));
        Validate.isTrue((roles != null && !roles.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u4efb\u4f55\u89d2\u8272\u5c5e\u6027\u4fe1\u5fc3\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<String> roleNames = roles.stream().map(RoleVo::getRoleName).collect(Collectors.toSet());
        HashSet ignoreRoles = Sets.newHashSet((Object[])this.ignoreMethodCheckRoles);
        JSONArray results = new JSONArray();
        if (ignoreRoles != null && !Sets.intersection(roleNames, (Set)ignoreRoles).isEmpty()) {
            for (String resource : resources) {
                JSONObject node = new JSONObject();
                node.put(MESS_RESOURCE, (Object)resource);
                node.put("flag", (Object)true);
                results.add((Object)node);
            }
            return results;
        }
        JSONArray noViewItemCompetences = this.findByViewItemAndRoleNamesAndStatus(false, roleNames.toArray(new String[0]), null);
        JSONArray viewItemCompetences = this.findByViewItemAndRoleNamesAndStatus(true, roleNames.toArray(new String[0]), null);
        if (noViewItemCompetences != null) {
            allCompetences.addAll((Collection)noViewItemCompetences);
        }
        if (viewItemCompetences != null) {
            allCompetences.addAll((Collection)viewItemCompetences);
        }
        if (CollectionUtils.isEmpty((Collection)allCompetences)) {
            for (String resource : resources) {
                JSONObject node = new JSONObject();
                node.put(MESS_RESOURCE, (Object)resource);
                node.put("flag", (Object)false);
                results.add((Object)node);
            }
            return results;
        }
        PathMatcher pathMatcher = this.requestMappingHandlerMapping.getPathMatcher();
        LinkedHashMap<String, Boolean> resourceMapping = new LinkedHashMap<String, Boolean>();
        for (String resource : resources) {
            boolean matcher = false;
            for (int index = 0; index < allCompetences.size(); ++index) {
                JSONObject competenceItem = allCompetences.getJSONObject(index);
                Integer extractUri = competenceItem.getInteger("extractUri");
                Integer tstatus = competenceItem.getInteger("tstatus");
                String currentResource = competenceItem.getString(MESS_RESOURCE);
                if (tstatus != 1) continue;
                if (extractUri == 1) {
                    try {
                        Map pathMatcherMapping = pathMatcher.extractUriTemplateVariables(currentResource, resource);
                        if (pathMatcherMapping == null) continue;
                        matcher = true;
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (extractUri != 0 || !StringUtils.equals((CharSequence)currentResource, (CharSequence)resource)) continue;
                matcher = true;
                break;
            }
            resourceMapping.put(resource, matcher);
        }
        Set keys = resourceMapping.keySet();
        for (String resource : keys) {
            JSONObject node = new JSONObject();
            node.put(MESS_RESOURCE, (Object)resource);
            node.put("flag", resourceMapping.get(resource));
            results.add((Object)node);
        }
        return results;
    }

    public Page<CompetenceVo> findByConditions(String comment, Pageable pageable) {
        HashMap<String, String> conditions = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)comment)) {
            conditions.put("comment", comment);
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        Page competenceEntityPage = this.competenceRepository.queryPage(pageable, conditions);
        List competenceEntitys = competenceEntityPage.getContent();
        PageImpl competenceVoPage = null;
        if (!CollectionUtils.isEmpty((Collection)competenceEntitys)) {
            Collection<CompetenceVo> competenceVos = this.nebulaToolkitService.copyCollectionByWhiteList(competenceEntitys, CompetenceEntity.class, CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            competenceVoPage = new PageImpl(new ArrayList<CompetenceVo>(competenceVos), pageable, competenceEntityPage.getTotalElements());
        } else {
            competenceVoPage = new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return competenceVoPage;
    }

    public CompetenceVo findById(String competenceId) {
        if (StringUtils.isBlank((CharSequence)competenceId)) {
            return null;
        }
        Optional op = this.competenceRepository.findById(competenceId);
        if (!op.isPresent()) {
            return null;
        }
        return this.nebulaToolkitService.copyObjectByWhiteList(op.get(), CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<CompetenceVo> findAll() {
        List competences = this.competenceRepository.findAll();
        if (competences == null || competences.isEmpty()) {
            return Lists.newArrayList();
        }
        Collection<CompetenceVo> competenceVos = this.nebulaToolkitService.copyCollectionByWhiteList(competences, CompetenceEntity.class, CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList(competenceVos);
    }
}

