/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseCode;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DictCategoryEntity;
import com.bizunited.platform.core.entity.DictEntity;
import com.bizunited.platform.core.entity.DictItemEntity;
import com.bizunited.platform.core.service.DictCategoryService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/dictCategories"})
public class DictCategoryController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictCategoryController.class);
    @Autowired
    private DictCategoryService dictCategoryService;

    @ApiOperation(value="\u521b\u5efa\u5b57\u5178\u5206\u7c7b")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@ApiParam(name="\u5b57\u5178\u5206\u7c7b\u4fe1\u606f") @RequestBody DictCategoryEntity dictCategoryEntity, @RequestParam(name="parentId") @ApiParam(name="parentId", value="\u7236\u7ea7\u5b57\u5178ID") String parentId) {
        LOGGER.debug("\u521b\u5efa\u5b57\u5178\u5206\u7c7b\uff1a{}", (Object)JSON.toJSONString((Object)dictCategoryEntity));
        try {
            DictCategoryEntity entity = this.dictCategoryService.create(dictCategoryEntity, parentId);
            return this.buildHttpResultW(entity, "");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u5b57\u5178\u5206\u7c7b")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel update(@ApiParam(name="\u5b57\u5178\u5206\u7c7b\u4fe1\u606f") @RequestBody DictCategoryEntity dictCategoryEntity) {
        LOGGER.debug("\u4fee\u6539\u5b57\u5178\u5206\u7c7b\uff1a{}", (Object)JSON.toJSONString((Object)dictCategoryEntity));
        try {
            DictCategoryEntity entity = this.dictCategoryService.update(dictCategoryEntity);
            return this.buildHttpResultW(entity, "");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8bbe\u7f6e\u5b57\u5178\u5206\u7c7b\u5c42\u7ea7")
    @RequestMapping(value={"/bind"}, method={RequestMethod.POST})
    public ResponseModel bind(@RequestParam(name="childId") @ApiParam(name="childId", value="\u5b50\u7ea7\u5b57\u5178ID") String childId, @RequestParam(name="parentId") @ApiParam(name="parentId", value="\u7236\u7ea7\u5b57\u5178ID") String parentId) {
        try {
            this.dictCategoryService.bind(childId, parentId);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5b57\u5178\u4e1a\u52a1\u7f16\u53f7code\u8fdb\u884c\u67e5\u8be2\uff0c\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f")
    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    public ResponseModel findByCode(@RequestParam(value="code") @ApiParam(name="code", value="\u4e1a\u52a1\u7f16\u53f7code\u5728\u5168\u7cfb\u7edf\u552f\u4e00") String code) {
        try {
            DictCategoryEntity current = this.dictCategoryService.findByCode(code);
            return this.buildHttpResultW(current, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u5206\u7c7b")
    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResponseModel findAll() {
        try {
            Set<DictCategoryEntity> entities = this.dictCategoryService.findAll();
            ArrayList<DictCategoryEntity> entitiesList = new ArrayList<DictCategoryEntity>();
            entitiesList.addAll(entities);
            this.filterDictCate(entitiesList);
            ResponseModel responseModel = new ResponseModel();
            responseModel.setTimestamp(System.currentTimeMillis());
            responseModel.setData(entitiesList);
            responseModel.setSuccess(true);
            responseModel.setResponseCode(ResponseCode.E0);
            return responseModel;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    private void filterDictCate(List<DictCategoryEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        for (DictCategoryEntity entity : entities) {
            entity.setParentCategory(null);
            entity.setCreateUser(null);
            entity.setModifyUser(null);
            Set<DictEntity> dicts = entity.getDicts();
            if (!CollectionUtils.isEmpty(dicts)) {
                for (DictEntity dict : dicts) {
                    dict.setCategory(null);
                    if (CollectionUtils.isEmpty(dict.getDictItemEntities())) continue;
                    for (DictItemEntity item : dict.getDictItemEntities()) {
                        item.setDictEntity(null);
                    }
                }
            }
            Set<DictCategoryEntity> child = entity.getChildCategory();
            ArrayList<DictCategoryEntity> childList = new ArrayList<DictCategoryEntity>();
            childList.addAll(child);
            if (CollectionUtils.isEmpty(child)) continue;
            this.filterDictCate(childList);
        }
    }
}

