/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DictItemEntity;
import com.bizunited.platform.core.service.DictItemService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/dictItems"})
public class DictItemController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictItemController.class);
    @Autowired
    private DictItemService dictItemService;

    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7f16\u7801\u67e5\u8be2\u6240\u6709\u5b50\u9879")
    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    public ResponseModel findByCode(@RequestParam(name="dictCode") @ApiParam(name="dictCode", value="\u6307\u5b9a\u7684\u5b57\u5178\u7f16\u7801") String dictCode) {
        try {
            return this.buildHttpResultW(this.dictItemService.findItemsByCode(dictCode), new String[]{""});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4e3a\u5b57\u5178\u7c7b \u4fee\u6539/\u6dfb\u52a0/\u5220\u9664 \u660e\u7ec6\u9879")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseModel update(@RequestParam(name="dictCode") @ApiParam(name="dictCode", value="\u5b57\u5178\u7f16\u7801") String dictCode, @ApiParam(name="\u5b57\u5178\u660e\u7ec6\u4fe1\u606f") @RequestBody List<DictItemEntity> items) {
        LOGGER.debug("\u5f85\u65b0\u589e/\u4fee\u6539\u7684\u5b57\u5178\u7f16\u7801\uff1a{},\u5b57\u5178\u4fe1\u606f\uff1a{}", (Object)dictCode, (Object)JSON.toJSONString(items));
        try {
            return this.buildHttpResultW(this.dictItemService.updateItems(dictCode, items), new String[]{""});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

