/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.OrdinaryFileEntity;
import com.bizunited.platform.core.entity.SystemThemeEntity;
import com.bizunited.platform.core.service.SystemThemeService;
import com.bizunited.platform.rbac.server.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="SystemThemeController")
@RestController
@RequestMapping(value={"/v1/nebula/theme"})
public class SystemThemeController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemThemeController.class);
    private static final String LOCK_THEME = "theme";
    @Autowired
    private SystemThemeService systemThemeService;
    @Autowired
    private RedisMutexService redisMutexService;

    @ApiOperation(value="\u7cfb\u7edf\u4e3b\u9898\u7ba1\u7406\u65f6\uff0c\u4e0a\u4f20logo\u5e76\u4fdd\u5b58(\u66f4\u65b0)\u4e3b\u9898")
    @RequestMapping(value={"/uploadLogo"}, method={RequestMethod.POST})
    public ResponseModel uploadLogo(@RequestParam(value="file") @ApiParam(name="file", value="\u6587\u4ef6\u5185\u5bb9") MultipartFile file) {
        try {
            Principal opUser = this.getPrincipal();
            OrdinaryFileEntity theme = this.systemThemeService.uploadLogo(file, opUser);
            return this.buildHttpResultW(theme, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u7cfb\u7edf\u4e3b\u9898\u7ba1\u7406\u65f6\uff0c\u4fdd\u5b58(\u66f4\u65b0)\u4e3b\u9898")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel save(@RequestBody @ApiParam(name="jsonTheme", value="\u7cfb\u7edf\u4e3b\u9898json\u683c\u5f0f\u6570\u636e") JSONObject jsonTheme) {
        try {
            this.redisMutexService.lock(LOCK_THEME);
            Principal opUser = this.getPrincipal();
            SystemThemeEntity theme = this.systemThemeService.save(jsonTheme, opUser);
            ResponseModel responseModel = this.buildHttpResultW(theme, new String[0]);
            return responseModel;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ResponseModel responseModel = this.buildHttpResultForException(e);
            return responseModel;
        }
        finally {
            this.redisMutexService.unlock(LOCK_THEME);
        }
    }

    @ApiOperation(value="\u7cfb\u7edf\u4e3b\u9898\u7ba1\u7406\u65f6\uff0c\u6839\u636e\u7528\u6237\u4fe1\u606f\uff0c\u52a0\u8f7d\u4e3b\u9898")
    @RequestMapping(value={"/findTheme"}, method={RequestMethod.GET})
    public ResponseModel findTheme() {
        try {
            JSONObject theme = this.systemThemeService.findTheme();
            return this.buildHttpResultW(theme, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

