/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.common.PlatformContext;
import com.bizunited.platform.core.common.enums.ClassTypeEnum;
import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import com.bizunited.platform.core.common.utils.ParamsAnalysisUtil;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthInterceptorEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.interceptor.DataViewAuthInterceptor;
import com.bizunited.platform.core.repository.dataview.analysis.Constants;
import com.bizunited.platform.core.repository.dataview.analysis.SQLAuthHorizontalAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLAuthVerticalAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLConditionFilterAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLOrderbyAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLSystemParamAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SqlAnalysis;
import com.bizunited.platform.core.service.dataview.model.SQLParamModel;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

public abstract class AbstractSqlAnalysis
implements SqlAnalysis {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSqlAnalysis.class);
    protected static final String ERROR_SQL = "SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570";
    protected static final String ERROR_INTERCEPTOR_IMPLEMENTS = "\u6743\u9650\u62e6\u622a\u5668\u7c7b\u5fc5\u987b\u5b9e\u73b0\u63a5\u53e3\uff1acom.bizunited.platform.core.interceptor.DataViewAuthInterceptor";
    protected Set<DataViewFieldEntity> allFileds;
    protected Pageable pageable;
    protected DataViewEntity dataView;
    protected Set<DataViewFilterEntity> filters;
    protected Set<DataViewSystemEntity> systemParams;
    protected Set<DataViewAuthHorizontalEntity> authHorizontals;
    protected Set<DataViewAuthVerticalEntity> authVerticals;
    protected DataViewAuthInterceptorEntity dataViewAuthInterceptor;
    protected InvokeParams params;
    protected Map<SQLCorrelationEnum, Object> result;

    @Override
    public void analysis() {
        SQLAuthVerticalAnalysis.buildSQLAuthVertical(this.authVerticals, this.dataView.getSourceSql(), this.result, this.allFileds);
        String sql = this.result.get((Object)SQLCorrelationEnum.RESULT_SQL).toString();
        SQLSystemParamAnalysis.buildSystemParamAnalysis(this.systemParams, this.params, this.result, sql);
        SQLConditionFilterAnalysis.buildSQLConditions(this.filters, this.result, this.params, this);
        SQLAuthHorizontalAnalysis.buildSQLAuthHorizoncal(this.authHorizontals, this.result);
        SQLOrderbyAnalysis.buildSQLConditionsOrderBy(this.filters, this.params, this.result);
        this.interceptor();
    }

    abstract String concatSql(String ... var1);

    public AbstractSqlAnalysis(DataViewEntity dataView, Set<DataViewFilterEntity> filters, Set<DataViewSystemEntity> systemParams, Set<DataViewAuthHorizontalEntity> authHorizontals, Set<DataViewAuthVerticalEntity> authVerticals, InvokeParams params, Pageable pageable, Set<DataViewFieldEntity> allFileds, DataViewAuthInterceptorEntity dataViewAuthInterceptor) {
        this.dataView = dataView;
        this.filters = filters;
        this.systemParams = systemParams;
        this.authHorizontals = authHorizontals;
        this.authVerticals = authVerticals;
        this.allFileds = allFileds;
        this.params = params;
        this.pageable = pageable;
        this.dataViewAuthInterceptor = dataViewAuthInterceptor;
        this.initResultMap();
    }

    private void initResultMap() {
        this.result = new HashMap<SQLCorrelationEnum, Object>();
        this.result.put(SQLCorrelationEnum.RESULT_SQL, "");
        this.result.put(SQLCorrelationEnum.CONDITION_VALUES, new LinkedHashSet(4));
        this.result.put(SQLCorrelationEnum.SYSTEM_PARAM_VALUES, new LinkedHashSet(4));
        this.result.put(SQLCorrelationEnum.AUTH_HORIZONTAL_VALUES, new LinkedHashSet(4));
        this.result.put(SQLCorrelationEnum.AUTH_VERTICAL_VALUES, new LinkedHashSet(4));
        this.result.put(SQLCorrelationEnum.COUNTER, 1);
    }

    @Override
    public Map<SQLCorrelationEnum, Object> getResult() {
        return this.result;
    }

    @Override
    public Pageable getPageable() {
        return this.pageable;
    }

    @Override
    public void setPresets(Map<String, Object> systems, Map<String, Object> authHorzontals, Map<Integer, Object> verticalPresets) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(systems)) {
            values.putAll(systems);
        }
        if (!CollectionUtils.isEmpty(authHorzontals)) {
            values.putAll(authHorzontals);
        }
        if (!CollectionUtils.isEmpty(verticalPresets)) {
            this.result.put(SQLCorrelationEnum.VERTICAL_PRESETS, verticalPresets);
        }
        this.result.put(SQLCorrelationEnum.PRESETS, values);
    }

    @Override
    public void processSQLParams(Object object) {
        Validate.notNull((Object)object, (String)"\u4f20\u5165\u7684Query\u6216PreparedStatement\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        LinkedHashSet systemPart = (LinkedHashSet)this.result.get((Object)SQLCorrelationEnum.SYSTEM_PARAM_VALUES);
        LinkedHashSet conditionPart = (LinkedHashSet)this.result.get((Object)SQLCorrelationEnum.CONDITION_VALUES);
        LinkedHashSet authHorizontalPart = (LinkedHashSet)this.result.get((Object)SQLCorrelationEnum.AUTH_HORIZONTAL_VALUES);
        if (!CollectionUtils.isEmpty((Collection)systemPart)) {
            this.setSQLParams(object, systemPart);
        }
        if (!CollectionUtils.isEmpty((Collection)conditionPart)) {
            this.setSQLParams(object, conditionPart);
        }
        if (!CollectionUtils.isEmpty((Collection)authHorizontalPart)) {
            this.setSQLParams(object, authHorizontalPart);
        }
    }

    protected void setSQLParams(Object obj, Set<SQLParamModel> params) {
        Validate.notEmpty(params, (String)"\u5f53\u524d\u4f20\u9012\u7684SQL\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)obj, (String)"JPA Query\u6216PrepareStatement\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (SQLParamModel model : params) {
            Validate.notNull((Object)model, (String)"\u5f53\u524d\u4f20\u9012\u7684SQL\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Object value = this.transData(model);
            Validate.notNull((Object)value, (String)"\u8f6c\u6362\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (obj instanceof Query) {
                AbstractSqlAnalysis.matchJPAParamType((Query)obj, value, model);
                continue;
            }
            if (obj instanceof PreparedStatement) {
                AbstractSqlAnalysis.matchPreparedStatementParamType((PreparedStatement)obj, value, model);
                continue;
            }
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u5bf9\u8c61\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!");
        }
    }

    protected Object transData(SQLParamModel model) {
        Validate.notNull((Object)model, (String)"SQL\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)model.getTransferType(), (String)"\u53c2\u6570\u4f20\u9012\u7c7b\u578b\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        switch (model.getTransferType()) {
            case 1: 
            case 2: {
                return ParamsAnalysisUtil.doTrans(model.getValue(), model.getMappingType());
            }
            case 3: {
                return ParamsAnalysisUtil.doTrans(model.getValue(), model.getMappingType());
            }
        }
        throw new IllegalArgumentException("\u672a\u77e5\u7684\u53c2\u6570\u4f20\u9012\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5!!");
    }

    public static void matchJPAParamType(Query query, Object value, SQLParamModel model) {
        Validate.notNull((Object)query, (String)"\u4f20\u5165query\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)value, (String)"\u4f20\u5165\u6570\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)model, (String)"\u5339\u914dJPA\u65b9\u5f0f\u89e3\u6790\u65f6\uff0c\u4f20\u5165SQL\u53c2\u6570\u6570\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Class<?> clz = value.getClass();
        String className = clz.getName();
        Validate.isTrue((boolean)Constants.ALL_SUPPORT_CLASS.contains(className), (String)(ERROR_SQL + model.getParamName() + "\u6709\u8bef!!\u672a\u77e5\u7684\u7c7b\u578b!!"), (Object[])new Object[0]);
        try {
            AbstractSqlAnalysis.matchJPAParamTypeAnalysis(query, value, model, className);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ERROR_SQL + model.getParamName() + "\u6709\u8bef!!\u672a\u77e5\u7684\u7c7b\u578b!!");
        }
    }

    protected static void matchJPAParamTypeAnalysis(Query query, Object value, SQLParamModel model, String className) {
        switch (className) {
            case "java.lang.String": {
                query.setParameter(model.getIndex().intValue(), (Object)value.toString());
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                query.setParameter(model.getIndex().intValue(), (Object)((Number)value).intValue());
                break;
            }
            case "double": 
            case "java.lang.Double": {
                query.setParameter(model.getIndex().intValue(), (Object)((Number)value).doubleValue());
                break;
            }
            case "float": 
            case "java.lang.Float": {
                query.setParameter(model.getIndex().intValue(), (Object)Float.valueOf(((Number)value).floatValue()));
                break;
            }
            case "long": 
            case "java.lang.Long": {
                query.setParameter(model.getIndex().intValue(), (Object)((Number)value).longValue());
                break;
            }
            case "short": 
            case "java.lang.Short": {
                query.setParameter(model.getIndex().intValue(), (Object)((Number)value).shortValue());
                break;
            }
            case "byte": 
            case "java.lang.Byte": {
                query.setParameter(model.getIndex().intValue(), (Object)((Number)value).byteValue());
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                query.setParameter(model.getIndex().intValue(), value);
                break;
            }
            case "char": 
            case "java.lang.Character": {
                query.setParameter(model.getIndex().intValue(), (Object)value.toString());
                break;
            }
            case "java.util.Date": {
                query.setParameter(model.getIndex().intValue(), value);
                break;
            }
            case "java.math.BigDecimal": {
                query.setParameter(model.getIndex().intValue(), value);
                break;
            }
            default: {
                query.setParameter(model.getIndex().intValue(), value);
            }
        }
    }

    public static void matchPreparedStatementParamType(PreparedStatement st, Object value, SQLParamModel model) {
        Validate.notNull((Object)st, (String)"\u4f20\u5165PreparedStatement\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)value, (String)"\u4f20\u5165\u6570\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)model, (String)"\u5339\u914dPreparedStatement\u65b9\u5f0f\u89e3\u6790\u65f6\uff0c\u4f20\u5165SQL\u53c2\u6570\u6570\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Class<?> clz = value.getClass();
        String className = clz.getName();
        Validate.isTrue((boolean)Sets.newHashSet(Constants.ALL_SUPPORT_CLASS).contains(className), (String)(ERROR_SQL + model.getParamName() + "\u6709\u8bef!!\u672a\u77e5\u7684\u7c7b\u578b!!"), (Object[])new Object[0]);
        try {
            AbstractSqlAnalysis.matchPreparedStatementParamTypeAnalysis(st, value, model, className);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(ERROR_SQL + model.getParamName() + "\u6709\u8bef!!\u672a\u77e5\u7684\u7c7b\u578b!!");
        }
    }

    protected static void matchPreparedStatementParamTypeAnalysis(PreparedStatement st, Object value, SQLParamModel model, String className) throws SQLException {
        switch (className) {
            case "java.lang.String": {
                st.setString(model.getIndex(), value.toString());
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                st.setInt(model.getIndex(), ((Number)value).intValue());
                break;
            }
            case "double": 
            case "java.lang.Double": {
                st.setDouble(model.getIndex(), ((Number)value).doubleValue());
                break;
            }
            case "float": 
            case "java.lang.Float": {
                st.setFloat(model.getIndex(), ((Number)value).floatValue());
                break;
            }
            case "long": 
            case "java.lang.Long": {
                st.setLong(model.getIndex(), ((Number)value).longValue());
                break;
            }
            case "short": 
            case "java.lang.Short": {
                st.setShort(model.getIndex(), ((Number)value).shortValue());
                break;
            }
            case "byte": 
            case "java.lang.Byte": {
                st.setByte(model.getIndex(), ((Number)value).byteValue());
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                st.setBoolean(model.getIndex(), (Boolean)value);
                break;
            }
            case "char": 
            case "java.lang.Character": {
                st.setString(model.getIndex(), value.toString());
                break;
            }
            case "java.util.Date": {
                st.setDate(model.getIndex(), (Date)value);
                break;
            }
            case "java.math.BigDecimal": {
                st.setBigDecimal(model.getIndex(), (BigDecimal)value);
                break;
            }
        }
    }

    protected void interceptor() {
        DataViewAuthInterceptor interceptor = this.getInterceptor();
        if (interceptor == null) {
            return;
        }
        interceptor.intercept(this);
    }

    protected DataViewAuthInterceptor getInterceptor() {
        if (this.dataViewAuthInterceptor == null) {
            return null;
        }
        String interceptorClass = this.dataViewAuthInterceptor.getInterceptor();
        if (StringUtils.isBlank((CharSequence)interceptorClass)) {
            return null;
        }
        Integer classType = this.dataViewAuthInterceptor.getClassType();
        if (ClassTypeEnum.CLASS_PATH.getType().equals(classType)) {
            try {
                Class<?> clazz = Class.forName(interceptorClass);
                Validate.isTrue((boolean)DataViewAuthInterceptor.class.isAssignableFrom(clazz), (String)ERROR_INTERCEPTOR_IMPLEMENTS, (Object[])new Object[0]);
                return (DataViewAuthInterceptor)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(String.format("\u672a\u627e\u5230java\u7c7b\uff1a%s", interceptorClass));
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(String.format("\u5b9e\u4f8b\u5316\u7c7b\u9519\u8bef\uff1a%s", interceptorClass));
            }
        }
        if (ClassTypeEnum.BEAN_NAME.getType().equals(classType)) {
            ApplicationContext applicationContext = PlatformContext.getApplicationContext();
            Validate.isTrue((boolean)applicationContext.containsBean(interceptorClass), (String)"ioc\u5bb9\u5668\u4e2d\u672a\u53d1\u73b0bean\uff1a%s", (Object[])new Object[]{interceptorClass});
            Object bean = applicationContext.getBean(interceptorClass);
            Validate.isTrue((boolean)DataViewAuthInterceptor.class.isAssignableFrom(bean.getClass()), (String)ERROR_INTERCEPTOR_IMPLEMENTS, (Object[])new Object[0]);
            return (DataViewAuthInterceptor)bean;
        }
        throw new IllegalArgumentException(String.format("\u4e0d\u652f\u6301\u7684\u62e6\u622a\u5668\u7c7b\u578b:%s", classType));
    }
}

