/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.init;

import com.bizunited.platform.core.entity.CompetenceEntity;
import com.bizunited.platform.core.repository.CompetenceRepository;
import com.bizunited.platform.core.service.init.InitProcessService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import springfox.documentation.spring.web.ControllerNamingUtils;

@Component(value="frameworkEndpointProcess")
public class FrameworkEndpointInitProcess
implements InitProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrameworkEndpointInitProcess.class);
    @Autowired
    private RequestMappingHandlerMapping frameworkEndpointHandler;
    @Autowired
    private CompetenceRepository competenceRepository;

    @Override
    public int sort() {
        return 2;
    }

    @Override
    public boolean doProcess() {
        return true;
    }

    @Override
    @Transactional
    public void init() {
        this.initFrameworkEndpoint();
    }

    private List<String> getTags(HandlerMethod handlerMethod) {
        Class clazz = handlerMethod.getBeanType();
        Api api = clazz.getAnnotation(Api.class);
        if (api == null) {
            return Lists.newArrayList();
        }
        String[] controllerTags = api.tags();
        return Arrays.stream(controllerTags).filter(tag -> StringUtils.isNotBlank((CharSequence)tag)).collect(Collectors.toList());
    }

    private String getTag(HandlerMethod handlerMethod) {
        List<String> tags = this.getTags(handlerMethod);
        String tag = CollectionUtils.isEmpty(tags) ? ControllerNamingUtils.controllerNameAsGroup((HandlerMethod)handlerMethod) : tags.get(0);
        return tag;
    }

    private void initFrameworkEndpoint() {
        List newCompetences;
        LOGGER.info("\u6b63\u5728\u68c0\u6d4b\u548c\u8c03\u6574requestMapping\u548c\u6570\u636e\u5e93\u4e2dCompetence\u7684\u5bf9\u5e94\u5173\u7cfb======");
        Map pathMapping = this.frameworkEndpointHandler.getHandlerMethods();
        HashSet currentRequstUrls = Sets.newHashSet();
        Set requestMappings = pathMapping.keySet();
        HashMap urlCommentMapping = Maps.newHashMap();
        HashMap urlTags = new HashMap(128);
        for (RequestMappingInfo requestMappingInfo : requestMappings) {
            String comment;
            ApiOperation apiOperation;
            HandlerMethod handlerMethod = (HandlerMethod)pathMapping.get(requestMappingInfo);
            String tag = this.getTag(handlerMethod);
            Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
            Set patterns = requestMappingInfo.getPatternsCondition().getPatterns();
            String[] methodValues = requestMethods.stream().map(Object::toString).collect(Collectors.toList()).toArray(new String[0]);
            if (methodValues != null && methodValues.length > 0) {
                patterns.forEach(item -> {
                    currentRequstUrls.add(item + "+" + StringUtils.join((Object[])methodValues, (String)"|"));
                    urlTags.put(item, tag);
                });
            }
            if (handlerMethod == null || (apiOperation = (ApiOperation)handlerMethod.getMethodAnnotation(ApiOperation.class)) == null || !StringUtils.isNotBlank((CharSequence)(comment = apiOperation.value()))) continue;
            patterns.forEach(item -> urlCommentMapping.put(item, comment));
        }
        List dbCompetenes = this.competenceRepository.findAll();
        Set<Object> dbRequstUrls = null;
        dbRequstUrls = dbCompetenes != null ? dbCompetenes.stream().map(item -> item.getResource() + "+" + item.getMethods()).collect(Collectors.toSet()) : Sets.newHashSet();
        Sets.SetView difference = Sets.difference((Set)currentRequstUrls, (Set)dbRequstUrls);
        Pattern pattern = Pattern.compile("\\{[\\w]+\\}");
        if (difference != null && (newCompetences = difference.stream().map(item -> {
            String[] urlAndMethod = item.split("\\+");
            String url = urlAndMethod[0];
            String method = urlAndMethod[1];
            CompetenceEntity currentCompetence = new CompetenceEntity();
            String comment = (String)urlCommentMapping.get(url);
            if (StringUtils.isNotBlank((CharSequence)comment)) {
                currentCompetence.setComment(comment);
            } else {
                currentCompetence.setComment(url);
            }
            currentCompetence.setMethods(method);
            currentCompetence.setResource(url);
            currentCompetence.setSortIndex(100);
            currentCompetence.setViewItem(0);
            currentCompetence.setTag((String)urlTags.get(url));
            if (pattern.matcher(url).find()) {
                currentCompetence.setExtractUri(1);
            } else {
                currentCompetence.setExtractUri(0);
            }
            return currentCompetence;
        }).collect(Collectors.toList())) != null && !newCompetences.isEmpty()) {
            this.competenceRepository.saveAll(newCompetences);
            this.competenceRepository.flush();
        }
        if (dbCompetenes != null) {
            for (CompetenceEntity dbCompetene : dbCompetenes) {
                String resource = dbCompetene.getResource();
                if (!StringUtils.isNotBlank((CharSequence)resource)) continue;
                String comment = (String)urlCommentMapping.get(resource);
                String tag = (String)urlTags.get(resource);
                boolean update = false;
                if (StringUtils.isBlank((CharSequence)dbCompetene.getTag())) {
                    dbCompetene.setTag(tag);
                    update = true;
                }
                if (StringUtils.isNotBlank((CharSequence)comment) && !comment.equals(resource)) {
                    dbCompetene.setComment(comment);
                    update = true;
                }
                if (!update) continue;
                this.competenceRepository.save(dbCompetene);
            }
        }
    }
}

