/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.core.entity.DictEntity;
import com.bizunited.platform.core.entity.DictItemEntity;
import com.bizunited.platform.core.repository.DictItemRepository;
import com.bizunited.platform.core.repository.DictRepository;
import com.bizunited.platform.core.service.DictItemService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DictItemServiceImpl")
public class DictItemServiceImpl
implements DictItemService {
    private static final String ERROR_MESS = "\u5b57\u5178\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    @Autowired
    private DictRepository dictRepository;
    @Autowired
    private DictItemRepository dictItemRepository;

    @Override
    public List<DictItemEntity> findItemsByCode(String dictCode) {
        DictEntity dictEntity = this.dictRepository.findByDictCode(dictCode);
        if (dictEntity == null) {
            return Lists.newArrayList();
        }
        return this.dictItemRepository.findByDictEntityOrderByDictSort(dictEntity);
    }

    @Override
    @Transactional
    public List<DictItemEntity> updateItems(String dictCode, List<DictItemEntity> items) {
        Validate.notBlank((CharSequence)dictCode, (String)"\u67e5\u8be2\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DictEntity dictEntity = this.dictRepository.findByDictCode(dictCode);
        Validate.notNull((Object)dictEntity, (String)"\u672a\u627e\u5230\u8be5\u7f16\u7801\u5339\u914d\u5b57\u5178\uff01", (Object[])new Object[0]);
        Validate.isTrue((dictEntity.getDictStatus() == false ? 1 : 0) != 0, (String)"\u8be5\u5b57\u5178\u5df2\u7ecf\u4e0a\u67b6\uff0c\u65e0\u6cd5\u518d\u4fee\u6539\u660e\u7ec6\u9879", (Object[])new Object[0]);
        if (items == null) {
            items = new ArrayList<DictItemEntity>();
        } else {
            for (DictItemEntity item : items) {
                Validate.notBlank((CharSequence)item.getDictKey(), (String)"\u586b\u5199\u7684\u4e2d\u6587\u5b57\u6bb5\u4e0d\u5408\u89c4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)item.getDictValue(), (String)"\u586b\u5199\u7684\u503c\u5b57\u6bb5\u4e0d\u5408\u89c4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            }
            List keys = items.stream().map(DictItemEntity::getDictKey).distinct().collect(Collectors.toList());
            List values = items.stream().map(DictItemEntity::getDictValue).distinct().collect(Collectors.toList());
            Boolean hasSame = keys.size() < items.size() || values.size() < items.size();
            Validate.isTrue((hasSame == false ? 1 : 0) != 0, (String)"\u5305\u542b\u91cd\u590d\u7684key\u6216\u8005value!", (Object[])new Object[0]);
        }
        List<DictItemEntity> oldItems = this.dictItemRepository.findByDictEntity(dictEntity);
        dictEntity.setItemNum(items.size());
        dictEntity.setDictItemEntities(null);
        this.dictRepository.saveAndFlush(dictEntity);
        this.dictItemRepository.deleteAll(oldItems);
        this.dictItemRepository.flush();
        items.stream().forEach(o -> {
            o.setId(null);
            o.setDictSort(null == o.getDictSort() ? 1 : o.getDictSort());
            o.setDictEntity(dictEntity);
            o.setCreateTime(null == o.getCreateTime() ? new Date() : o.getCreateTime());
        });
        this.dictItemRepository.saveAll(items);
        return items;
    }

    @Override
    @Transactional
    public DictItemEntity enable(String dictItemId) {
        Validate.notBlank((CharSequence)dictItemId, (String)ERROR_MESS, (Object[])new Object[0]);
        DictItemEntity dictItemEntity = this.dictItemRepository.findDetailById(dictItemId);
        Validate.notNull((Object)dictItemEntity, (String)ERROR_MESS, (Object[])new Object[0]);
        dictItemEntity.setDictItemStatus(true);
        return (DictItemEntity)this.dictItemRepository.save(dictItemEntity);
    }

    @Override
    @Transactional
    public DictItemEntity disable(String dictItemId) {
        Validate.notBlank((CharSequence)dictItemId, (String)ERROR_MESS, (Object[])new Object[0]);
        DictItemEntity dictItemEntity = this.dictItemRepository.findDetailById(dictItemId);
        Validate.notNull((Object)dictItemEntity, (String)ERROR_MESS, (Object[])new Object[0]);
        dictItemEntity.setDictItemStatus(false);
        return (DictItemEntity)this.dictItemRepository.save(dictItemEntity);
    }
}

