/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.scheduler.handle;

import com.bizunited.platform.core.entity.DynamicTaskSchedulerEntity;
import com.bizunited.platform.core.entity.DynamicTaskSchedulerLogEntity;
import com.bizunited.platform.core.service.DynamicTaskSchedulerLogService;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import java.util.Date;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dynamicTaskInvokeLogHandle")
public class DynamicTaskInvokeLogHandle
implements InvokeResponseHandle {
    @Autowired
    private DynamicTaskSchedulerLogService dynamicTaskSchedulerLogService;

    @Override
    public boolean handleException(InvokeProxyContext context) {
        return true;
    }

    @Override
    public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
        Object currentTaskValue = context.getChainParam("currentTask");
        Validate.notNull((Object)currentTaskValue, (String)"\u5728\u8fdb\u884c\u52a8\u6001\u4efb\u52a1\u6267\u884c\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684taskCode", (Object[])new Object[0]);
        DynamicTaskSchedulerEntity currentTask = (DynamicTaskSchedulerEntity)currentTaskValue;
        String taskCode = currentTask.getTaskCode();
        Validate.notBlank((CharSequence)taskCode, (String)"\u5728\u8fdb\u884c\u52a8\u6001\u4efb\u52a1\u6267\u884c\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684taskCode", (Object[])new Object[0]);
        Date startTime = (Date)context.getChainParam("_timerRecord");
        Validate.notNull((Object)startTime, (String)"\u672a\u53d1\u73b0\u8c03\u7528\u7684\u5f00\u59cb\u65f6\u95f4!!", (Object[])new Object[0]);
        Date endTime = new Date();
        DynamicTaskSchedulerLogEntity log = new DynamicTaskSchedulerLogEntity();
        log.setDynamicTaskScheduler(currentTask);
        log.setEndTime(endTime);
        log.setStartTime(startTime);
        log.setSuccess(!context.isException());
        if (context.isException()) {
            log.setErrorContents(context.getErrMsg());
        }
        this.dynamicTaskSchedulerLogService.create(log);
        chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
    }
}

