/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.configuration;

import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceThreadFactory;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceThreadPoolExecutor;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
public class DynamicDataSourceExecutorConfig {
    @Autowired
    private DynamicDataSourceManager dynamicDataSourceManager;

    @Bean(value={"dynamicExecutor"})
    public Executor getcExecutor() {
        int corePoolSize = 2;
        int maximumPoolSize = 10;
        int keepAliveTime = 120;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(100);
        DynamicDataSourceThreadFactory threadFactory = new DynamicDataSourceThreadFactory(this.dynamicDataSourceManager);
        ThreadPoolExecutor.AbortPolicy rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
        return new DynamicDataSourceThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, timeUnit, workQueue, threadFactory, rejectedExecutionHandler);
    }
}

