/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.configuration;

import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.saturn.context.SaturnContext;
import com.bizunited.platform.saturn.context.service.PersistentServiceFactory;
import com.bizunited.platform.saturn.context.service.simple.SimplePersistentServiceFactory;
import com.bizunited.platform.saturn.engine.SaturnEngine;
import com.bizunited.platform.saturn.scan.ClassScanner;
import com.bizunited.platform.saturn.scan.SimpleClassScanner;
import javax.servlet.MultipartConfigElement;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.unit.DataSize;

@Configuration
public class NebulaToolkitConfig {
    @Value(value="${nebula.scanPackages}")
    private String[] nebulaScanPackages;
    @Value(value="${nebula.file.maxFileSize}")
    private Integer maxFileSize = 1;

    @Bean(value={"nebulaToolkitService"})
    public NebulaToolkitService getNebulaToolkitService() {
        return new NebulaToolkitService();
    }

    @Bean
    public SaturnContext getSaturnContext() {
        String[] rootScanPackages = this.nebulaScanPackages;
        SimplePersistentServiceFactory persistentServiceFactory = new SimplePersistentServiceFactory();
        SaturnEngine.Builder builder = new SaturnEngine.Builder();
        SaturnEngine saturnEngine = builder.onlyScan(Boolean.valueOf(true)).setRootScanPackages(rootScanPackages).addClassScanners((ClassScanner)new SimpleClassScanner()).setPersistentServiceFactory((PersistentServiceFactory)persistentServiceFactory).build();
        try {
            saturnEngine.eve();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u521d\u59cb\u5316saturn\u9aa8\u67b6\u914d\u7f6e\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5!!");
        }
        return saturnEngine.getSaturnContext();
    }

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize(DataSize.ofMegabytes((long)this.maxFileSize.longValue()));
        factory.setMaxRequestSize(DataSize.ofMegabytes((long)((long)this.maxFileSize.intValue() * 5L)));
        return factory.createMultipartConfig();
    }
}

