/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DynamicTaskSchedulerLogEntity;
import com.bizunited.platform.core.service.DynamicTaskSchedulerLogService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/dynamicTaskLogs"})
public class DynamicTaskSchedulerLogController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTaskSchedulerLogController.class);
    @Autowired
    private DynamicTaskSchedulerLogService dynamicTaskSchedulerLogService;

    @ApiOperation(value="\u6309\u7167\u5173\u8054\u7684 \u5bf9\u5e94\u7684\u52a8\u6001\u65e5\u5fd7\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @GetMapping(value={"/findDetailsByDynamicTaskScheduler"})
    public ResponseModel findDetailsByDynamicTaskScheduler(@RequestParam(value="dynamicTaskScheduler") @ApiParam(value="\u5173\u8054\u7684 \u5bf9\u5e94\u7684\u52a8\u6001\u65e5\u5fd7") String dynamicTaskScheduler) {
        try {
            Set<DynamicTaskSchedulerLogEntity> result = this.dynamicTaskSchedulerLogService.findDetailsByDynamicTaskScheduler(dynamicTaskScheduler);
            return this.buildHttpResultW(result, new String[]{"dynamicTaskScheduler"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u4e3b\u952e\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @GetMapping(value={"/findDetailsById"})
    public ResponseModel findDetailsById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e") String id) {
        try {
            DynamicTaskSchedulerLogEntity result = this.dynamicTaskSchedulerLogService.findDetailsById(id);
            return this.buildHttpResultW(result, "dynamicTaskScheduler");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8be5\u65b9\u6cd5\u7528\u4e8e\u6309\u7167\u5206\u9875\u6807\u51c6\uff0c\u5bf9\u52a8\u6001\u4efb\u52a1\u65e5\u5fd7\u5217\u8868\u8fdb\u884c\u67e5\u8be2\uff0c\u5e76\u6309\u7167\u5f00\u59cb\u6267\u884c\u65f6\u95f4\u8fdb\u884c\u5012\u5e8f\u6392\u5217")
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@PageableDefault(value=50) @ApiParam(name="pageable", value="\u5206\u9875\u53c2\u6570\uff0c\u5f53\u6307\u5b9apage\u65f6\u4e3a\u67e5\u8be2\u5f53\u524d\u9875\u7801\uff08\u9875\u7801\u4ece0\u5f00\u59cb\uff09\uff1b\u5f53\u6307\u5b9asize\u65f6\uff0c\u4e3a\u6307\u5b9a\u6bcf\u9875\u5927\u5c0f\uff0c\u9ed8\u8ba4\u4e3a50") Pageable pageable, @RequestParam(name="taskId", required=true) @ApiParam(name="taskId", value="\u4efb\u52a1ID\u7f16\u53f7\uff08\u5fc5\u987b\u4f20\u5165\uff09", required=true) String taskId, @RequestParam(name="success", required=false) @ApiParam(name="success", value="\u662f\u5426\u6267\u884c\u6210\u529f", required=false) Boolean success, @RequestParam(name="logtime", required=false) @ApiParam(name="logtime", value="\u6267\u884c\u65e5\u5fd7\u7684\u5f00\u59cb\u6267\u884c\u65f6\u95f4", required=false) String logtime) {
        try {
            Page<DynamicTaskSchedulerLogEntity> results = this.dynamicTaskSchedulerLogService.findByConditions(pageable, taskId, success, logtime);
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }
}

