/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.MigrateConfigAnalysisEntity;
import com.bizunited.platform.core.entity.MigrateImportEntity;
import com.bizunited.platform.core.service.migrate.MigrateImportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="MigrateImportController")
@RestController
@RequestMapping(value={"/v1/nebula/migrationsImport"})
public class MigrateImportController
extends BaseController {
    @Autowired
    private MigrateImportService migrateImportService;
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrateImportController.class);

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u4e0a\u4f20\u8bb0\u5f55")
    @RequestMapping(value={"/findByCondition"}, method={RequestMethod.GET})
    public ResponseModel findByCondition(@ApiParam(name="\u7f16\u53f7") @RequestParam(name="code") String code, @ApiParam(name="\u672c\u6b21\u4efb\u52a1\u662f\u5426\u6700\u7ec8\u6267\u884c") @RequestParam(name="executed") Boolean executed, Pageable pageable) {
        try {
            HashMap<String, Object> conditions = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)code)) {
                conditions.put("code", code);
            }
            if (null != executed) {
                conditions.put("executed", executed);
            }
            if (null != pageable) {
                pageable = PageRequest.of((int)0, (int)50);
            }
            Page<MigrateImportEntity> result = this.migrateImportService.findByCondition(conditions, pageable);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u8fc1\u5165\u7684\u57fa\u7840\u914d\u7f6e\uff0c\u67e5\u8be2\u5386\u53f2\u5206\u6790\u8bb0\u5f55")
    @RequestMapping(value={"/findConfigAnalysisByImport"}, method={RequestMethod.GET})
    public ResponseModel findConfigAnalysisByImport(@RequestParam(name="migrateImportId") @ApiParam(name="migrateImportId", value="\u8fc1\u5165\u6587\u4ef6ID") String migrateImportId) {
        try {
            Set<MigrateConfigAnalysisEntity> entities = this.migrateImportService.findConfigAnalysisByImport(migrateImportId);
            return this.buildHttpResultW(entities, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4e0a\u4f20\u8fc1\u5165\u6587\u4ef6")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public ResponseModel upload(@RequestParam(name="code") @ApiParam(name="code", value="\u8fc1\u5165\u6587\u4ef6\u7f16\u7801") String code, @RequestParam(name="migrateDesc") @ApiParam(name="migrateDesc", value="\u8fc1\u5165\u6587\u4ef6\u63cf\u8ff0") String migrateDesc, @RequestParam(name="file", required=true) @ApiParam(required=true, name="file", value="\u8fc1\u5165\u6587\u4ef6\u5bf9\u8c61") MultipartFile file, Principal currentUser) {
        try {
            MigrateImportEntity entity = this.migrateImportService.upload(code, migrateDesc, currentUser, file);
            return this.buildHttpResultW(entity, "creator", "executor");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5206\u6790\u4e0a\u4f20\u7684\u57fa\u7840\u4fe1\u606f\uff0c\u8fd4\u56de\u5206\u6790\u7ed3\u679c")
    @RequestMapping(value={"/analysisConfig"}, method={RequestMethod.POST})
    public ResponseModel analysisConfig(@RequestParam(name="migrateImportId") @ApiParam(name="migrateImportId", value="\u8fc1\u5165\u6587\u4ef6\u7f16\u7801") String migrateImportId, Principal currentUser) {
        try {
            MigrateConfigAnalysisEntity entity = this.migrateImportService.analysisConfig(migrateImportId, currentUser);
            return this.buildHttpResultW(entity, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6267\u884c\u8fc1\u79fb\u4e0a\u4f20\u7684\u8fc1\u79fb\u6587\u4ef6")
    @RequestMapping(value={"/execute"}, method={RequestMethod.POST})
    public ResponseModel execute(@RequestParam(name="migrateImportId") @ApiParam(name="migrateImportId", value="\u8fc1\u5165\u6587\u4ef6\u7f16\u7801") String migrateImportId, Principal currentUser) {
        try {
            MigrateImportEntity entity = this.migrateImportService.execute(migrateImportId, currentUser);
            return this.buildHttpResultW(entity, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

