/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseCode;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.service.NebulaStaticPersistentService;
import com.bizunited.platform.saturn.model.PersistentClass;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/static"})
public class NebulaStaticPersistentController
extends BaseController {
    @Autowired
    private NebulaStaticPersistentService nebulaStaticPersistentService;
    private static final Logger LOGGER = LoggerFactory.getLogger(NebulaStaticPersistentController.class);

    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edf\u4e2d\u76ee\u524d\u6240\u6709\u53ef\u7528\u7684\u9759\u6001\u6a21\u578b\u4fe1\u606f\uff0c\u4f46\u662f\u53ea\u5305\u62ec\u9759\u6001\u6a21\u578b\u672c\u8eab\u7684\u63cf\u8ff0\uff0c\u4e0d\u5305\u62ec\u6a21\u578b\u7684\u4e00\u822c\u5c5e\u6027\u63cf\u8ff0\u548c\u5173\u8054\u5c5e\u6027\u63cf\u8ff0")
    @RequestMapping(value={"/findAllPersistentClasses"}, method={RequestMethod.GET})
    public ResponseModel findAllPersistentClasses() {
        try {
            List<PersistentClass> results = this.nebulaStaticPersistentService.findAllPersistentClasses();
            return this.buildResponse(results);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    private ResponseModel buildResponse(List<PersistentClass> results) {
        ResponseModel responseModel = new ResponseModel();
        responseModel.setData(results);
        responseModel.setResponseCode(ResponseCode.E0);
        responseModel.setSuccess(true);
        responseModel.setTimestamp(new Date().getTime());
        return responseModel;
    }

    @ApiOperation(value="\u5f53\u524d\u63a5\u53e3\u7528\u4e8e\u67e5\u8be2\u7cfb\u7edf\u4e2d\u76ee\u524d\u6240\u6709\u53ef\u7528\u7684\u4e3b\u9759\u6001\u6a21\u578b\u4fe1\u606f\uff0c\u4f46\u662f\u53ea\u5305\u62ec\u9759\u6001\u6a21\u578b\u672c\u8eab\u7684\u63cf\u8ff0\uff0c\u4e0d\u5305\u62ec\u6a21\u578b\u7684\u4e00\u822c\u5c5e\u6027\u63cf\u8ff0\u548c\u5173\u8054\u5c5e\u6027\u63cf\u8ff0")
    @RequestMapping(value={"/findAllMainPersistentClasses"}, method={RequestMethod.GET})
    public ResponseModel findAllMainPersistentClasses() {
        try {
            List<PersistentClass> results = this.nebulaStaticPersistentService.findAllMainPersistentClasses();
            return this.buildResponse(results);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u6307\u5b9a\u7684\u9759\u6001\u6a21\u578b\u5b8c\u6574\u7c7b\u540d\uff0c\u83b7\u5f97\u8fd9\u4e2a\u9759\u6001\u6a21\u578b\u5728Saturn\u626b\u63cf\u7ec4\u4ef6\u4e2d\u7684\u4e00\u822c\u5c5e\u6027\u3001\u5173\u8054\u5c5e\u6027\u3001\u81ea\u5b9a\u4e49\u67e5\u8be2\u7b49\u4fe1\u606f")
    @RequestMapping(value={"/findByPersistentClass"}, method={RequestMethod.GET})
    public ResponseModel findByPersistentClass(@ApiParam(name="className", value="\u6307\u5b9a\u7684\u9759\u6001\u6a21\u578b\u5b8c\u6574\u7c7b\u540d") @RequestParam(value="className") String className) {
        try {
            PersistentClass result = this.nebulaStaticPersistentService.findByPersistentClass(className);
            ResponseModel responseModel = new ResponseModel();
            responseModel.setData(result);
            responseModel.setResponseCode(ResponseCode.E0);
            responseModel.setSuccess(true);
            responseModel.setTimestamp(new Date().getTime());
            return responseModel;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

