/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller.dataview;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import com.bizunited.platform.core.service.dataview.DataSourceService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/dataSources"})
public class DataSourceController
extends BaseController {
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private DynamicDataSourceManager dynamicDataSourceManager;

    @ApiOperation(value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efadataSourceEntity\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9dataSourceEntity\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684dataSourceEntityJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09")
    @PostMapping(value={""})
    public ResponseModel create(@RequestBody @ApiParam(name="dataSource", value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efadataSourceEntity\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9dataSourceEntity\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684dataSourceEntityJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09") DataSourceEntity dataSource) {
        try {
            DataSourceEntity currentDataSource = this.dynamicDataSourceManager.create(dataSource);
            return this.buildHttpResultW(currentDataSource, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u66f4\u65b0\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u66f4\u65b0\u8fc7\u7a0b\u53ea\u4f1a\u66f4\u65b0\u5728\u6a21\u578b\u5c42\u88ab\u6807\u8bb0\u4e3a\u4e86updateable\u7684\u5c5e\u6027\uff0c\u5305\u62ec\u4e00\u822c\u5c5e\u6027\u3001ManyToOne\u548cOneToOne\u6027\u8d28\u7684\u5173\u8054\u5c5e\u6027\uff0c\u800cManyToMany\u3001OneToMany\u7684\u5173\u8054\u5c5e\u6027\uff0c\u867d\u7136\u4e5f\u4f1a\u4f20\u5165\uff0c\u4f46\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5728Service\u5c42\u5b8c\u5584\u5176\u66f4\u65b0\u8fc7\u7a0b\u6ce8\u610f\uff1a\u4fee\u6539\u64cd\u4f5c\u4f20\u5165\u7684dataSourceEntityJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u9a8c\u8bc1\u8fd9\u4e2a\u4e3b\u952e\u503c\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09")
    @PutMapping(value={""})
    public ResponseModel update(@RequestBody @ApiParam(name="dataSource", value="\u76f8\u5173\u7684\u66f4\u65b0\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u66f4\u65b0\u8fc7\u7a0b\u53ea\u4f1a\u66f4\u65b0\u5728\u6a21\u578b\u5c42\u88ab\u6807\u8bb0\u4e3a\u4e86updateable\u7684\u5c5e\u6027\uff0c\u5305\u62ec\u4e00\u822c\u5c5e\u6027\u3001ManyToOne\u548cOneToOne\u6027\u8d28\u7684\u5173\u8054\u5c5e\u6027\uff0c\u800cManyToMany\u3001OneToMany\u7684\u5173\u8054\u5c5e\u6027\uff0c\u867d\u7136\u4e5f\u4f1a\u4f20\u5165\uff0c\u4f46\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5728Service\u5c42\u5b8c\u5584\u5176\u66f4\u65b0\u8fc7\u7a0b\u6ce8\u610f\uff1a\u4fee\u6539\u64cd\u4f5c\u4f20\u5165\u7684dataSourceEntityJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u9a8c\u8bc1\u8fd9\u4e2a\u4e3b\u952e\u503c\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09") DataSourceEntity dataSource) {
        try {
            DataSourceEntity currentDataSource = this.dynamicDataSourceManager.update(dataSource);
            return this.buildHttpResultW(currentDataSource, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6307\u5b9a\u7684\u6570\u636e\u6e90\u72b6\u6001---(\u542f\u7528\u3001\u7981\u7528)")
    @RequestMapping(value={"/updateStatus/{dataSourceCode}"}, method={RequestMethod.PATCH})
    public ResponseModel updateStatus(@PathVariable(value="dataSourceCode") String dataSourceCode, @ApiParam(name="tstatus", value="1\uff1a\u542f\uff1b0\u548c\u5176\u5b83\u503c\u4e3a\u7981\u7528") @RequestParam(value="tstatus") Integer tstatus) {
        try {
            if (tstatus == 1) {
                this.dynamicDataSourceManager.enable(dataSourceCode);
            } else {
                this.dynamicDataSourceManager.disable(dataSourceCode);
            }
            return this.buildHttpResult();
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5220\u9664\u4e00\u4e2a\u6570\u636e\u6e90\uff0c\u65e0\u8bba\u8fd9\u4e2a\u6570\u636e\u6e90\u7684\u72b6\u6001\u5982\u4f55\u3001\u662f\u5426\u6b63\u5728\u5de5\u4f5c")
    @RequestMapping(value={"/{dataSourceCode}"}, method={RequestMethod.DELETE})
    public ResponseModel delete(@PathVariable(value="dataSourceCode") String dataSourceCode) {
        try {
            this.dynamicDataSourceManager.delete(dataSourceCode);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u68c0\u67e5\u6307\u5b9a\u7684\u6570\u636e\u6e90\u662f\u5426\u53ef\u7528\u3002\u68c0\u67e5\u65b9\u5f0f\u5c31\u662f\u7528dataSource\u5bf9\u8c61\u63cf\u8ff0\u7684\u4fe1\u606f\u57fa\u4e8e\u6700\u539f\u59cb\u7684java jdbc\u8fde\u63a5\u8fdb\u884c\u64cd\u4f5c\u3002 \u5982\u679c\u5f53\u524d\u8fde\u63a5\u6210\u529f\uff0c\u5219\u6d4b\u8bd5\u6210\u529f\u3002", notes="\u5982\u679c\u8fde\u63a5\u8fc7\u7a0b\u51fa\u73b0\u95ee\u9898\uff0c\u5219\u629b\u51fa\u8fd0\u884c\u65f6\u5f02\u5e38")
    @PostMapping(value={"/validate"})
    public ResponseModel validate(@RequestBody @ApiParam(name="dataSource", value="\u6570\u636e\u6e90\u5bf9\u8c61\u63cf\u8ff0") DataSourceEntity dataSource) {
        try {
            this.dynamicDataSourceManager.check(dataSource);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6570\u636e\u6e90\u7f16\u53f7\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsByCode"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByCode(@RequestParam(value="code") @ApiParam(value="\u6570\u636e\u6e90\u7f16\u53f7") String code) {
        try {
            DataSourceEntity dataSource = this.dataSourceService.findDetailsByCode(code);
            return this.buildHttpResultW(dataSource, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u627e\u5f53\u524d\u8bb0\u5f55\u7684\u6240\u6709\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u4fe1\u606f")
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public ResponseModel findAll() {
        try {
            List<DataSourceEntity> dataSources = this.dataSourceService.findAll();
            return this.buildHttpResultW(dataSources, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }
}

