/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller.dataview;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataViewAuthInterceptorEntity;
import com.bizunited.platform.core.service.dataview.DataViewAuthInterceptorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6570\u636e\u89c6\u56fe\u6743\u9650\u62e6\u622a\u5668\u63a7\u5236\u5668"})
@RequestMapping(value={"/v1/nebula/dataViewAuthInterceptors"})
public class DataViewAuthInterceptorController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewAuthInterceptorController.class);
    @Autowired
    private DataViewAuthInterceptorService dataViewAuthInterceptorService;

    @PostMapping(value={""})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u89c6\u56fe\u6743\u9650\u62e6\u622a\u5668")
    public ResponseModel create(@RequestBody DataViewAuthInterceptorEntity interceptor) {
        try {
            DataViewAuthInterceptorEntity interceptorEntity = this.dataViewAuthInterceptorService.create(interceptor);
            return this.buildHttpResultW(interceptorEntity, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={""})
    @ApiOperation(value="\u66f4\u65b0\u6570\u636e\u89c6\u56fe\u6743\u9650\u62e6\u622a\u5668")
    public ResponseModel update(@RequestBody DataViewAuthInterceptorEntity interceptor) {
        try {
            DataViewAuthInterceptorEntity interceptorEntity = this.dataViewAuthInterceptorService.update(interceptor);
            return this.buildHttpResultW(interceptorEntity, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByDataView"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u89c6\u56fe\u67e5\u8be2\u6743\u9650\u62e6\u622a\u5668")
    public ResponseModel findByDataView(@RequestParam @ApiParam(value="\u6570\u636e\u89c6\u56fe\u7f16\u7801", required=true) String dataViewCode) {
        try {
            DataViewAuthInterceptorEntity interceptor = this.dataViewAuthInterceptorService.findByDataView(dataViewCode);
            return this.buildHttpResultW(interceptor, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

