/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.OrganizationEntity;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="OrganizationRepository")
public interface OrganizationRepository
extends JpaRepository<OrganizationEntity, String>,
JpaSpecificationExecutor<OrganizationEntity> {
    @Modifying
    @Query(value="update engine_org set parent_id = :parentOrgId where id = :currentOrgId", nativeQuery=true)
    public void bindParent(@Param(value="currentOrgId") String var1, @Param(value="parentOrgId") String var2);

    @Modifying
    @Query(value="update engine_org set parent_id = null where id = :currentOrgId", nativeQuery=true)
    public void unbindParent(@Param(value="currentOrgId") String var1);

    @Modifying
    @Query(value="insert into engine_org_user_mapping (org_id , user_id) values (:currentOrgId , :userId)", nativeQuery=true)
    public void bindUsers(@Param(value="currentOrgId") String var1, @Param(value="userId") String var2);

    @Modifying
    @Query(value="delete from engine_org_user_mapping where user_id = :userId", nativeQuery=true)
    public void unbindUser(@Param(value="userId") String var1);

    @Modifying
    @Query(value="delete from engine_org_user_mapping where user_id = :userId and org_id = :currentOrgId", nativeQuery=true)
    public void unbindUser(@Param(value="currentOrgId") String var1, @Param(value="userId") String var2);

    @Modifying
    @Query(value="insert into engine_org_role_mapping (org_id , role_id) values (:currentOrgId , :roleId)", nativeQuery=true)
    public void bindRole(@Param(value="currentOrgId") String var1, @Param(value="roleId") String var2);

    @Modifying
    @Query(value="delete from engine_org_role_mapping where role_id = :roleId", nativeQuery=true)
    public void unbindRole(@Param(value="roleId") String var1);

    @Modifying
    @Query(value="delete from engine_org_role_mapping where role_id = :roleId and org_id = :currentOrgId", nativeQuery=true)
    public void unbindRole(@Param(value="currentOrgId") String var1, @Param(value="roleId") String var2);

    @Query(value="select distinct org from OrganizationEntity org where org.parent is null order by org.sortIndex")
    public List<OrganizationEntity> findByNullParent();

    @Query(value="from OrganizationEntity org where org.parent.id = :parentId order by org.sortIndex")
    public List<OrganizationEntity> findByParent(@Param(value="parentId") String var1);

    @Query(value="from OrganizationEntity org where org.parent is null and org.tstatus = :status order by org.sortIndex")
    public List<OrganizationEntity> findByNullParentAndStatus(@Param(value="status") Integer var1);

    @Query(value="from OrganizationEntity org where org.parent.id = :parentId and org.tstatus = :status order by org.sortIndex")
    public List<OrganizationEntity> findByParentAndStatus(@Param(value="parentId") String var1, @Param(value="status") Integer var2);

    @Query(value="from OrganizationEntity org left join fetch org.parent pp where org.orgName = :orgName")
    public List<OrganizationEntity> findByOrgName(@Param(value="orgName") String var1);

    @Query(value="from OrganizationEntity org  where org.code = :code")
    public OrganizationEntity findByCode(@Param(value="code") String var1);

    @Query(value="select distinct org from OrganizationEntity org left join fetch org.parent left join fetch org.child left join fetch org.roles left join fetch org.users left join fetch org.positions where org.id = :id")
    public OrganizationEntity findDetailsById(@Param(value="id") String var1);

    @Query(value="select distinct org from OrganizationEntity org left join fetch org.users u  left join fetch org.roles r  where u.id = :userId order by org.sortIndex")
    public Set<OrganizationEntity> findByUserId(@Param(value="userId") String var1);

    @Query(value="SELECT COUNT(*) FROM engine_org_role_mapping WHERE org_id = :currentOrgId AND role_id = :roleId", nativeQuery=true)
    public long countByOrgAndRoleId(@Param(value="currentOrgId") String var1, @Param(value="roleId") String var2);

    @Query(value="SELECT COUNT(*) FROM engine_org_user_mapping WHERE org_id = :currentOrgId AND user_id = :userId", nativeQuery=true)
    public long countByOrgIdAndUserId(@Param(value="currentOrgId") String var1, @Param(value="userId") String var2);

    @Query(value="select org from OrganizationEntity org where org.tstatus = 1")
    public List<OrganizationEntity> findAllByStatus();

    @Query(value="from OrganizationEntity org left join fetch org.parent order by org.createTime desc ")
    public List<OrganizationEntity> findAll();

    @Query(value="from OrganizationEntity m where m.id in :ids")
    public Set<OrganizationEntity> findByIds(@Param(value="ids") List<String> var1);

    @Query(value="from OrganizationEntity m where m.parent=null order by m.createTime desc")
    public List<OrganizationEntity> findRootOrg();

    @Query(value="from OrganizationEntity org where orgName like CONCAT(CONCAT('%',:orgName),'%')")
    public Set<OrganizationEntity> findByOrgNameLike(@Param(value="orgName") String var1);

    @Query(value="SELECT COUNT(*) FROM engine_org_user_mapping WHERE user_id = :userId", nativeQuery=true)
    public long countOrganizationByUserId(@Param(value="userId") String var1);

    @Query(value="SELECT COUNT(*) FROM engine_org_user_mapping WHERE org_id = :currentOrgId", nativeQuery=true)
    public long countUserByOrgId(@Param(value="currentOrgId") String var1);

    @Query(value="SELECT COUNT(*) FROM engine_org_role_mapping WHERE role_id = :roleId", nativeQuery=true)
    public long countOrganizationByRoleId(@Param(value="roleId") String var1);

    @Query(value="SELECT COUNT(*) FROM engine_org_role_mapping WHERE org_id = :currentOrgId", nativeQuery=true)
    public long countRoleByOrgId(@Param(value="currentOrgId") String var1);

    @Query(value="select o from OrganizationEntity o inner join o.child c where c.id = :childId")
    public OrganizationEntity findByChildId(@Param(value="childId") String var1);
}

